﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sagemaker/model/OnlineStoreSecurityConfig.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SageMaker
{
namespace Model
{

OnlineStoreSecurityConfig::OnlineStoreSecurityConfig() : 
    m_kmsKeyIdHasBeenSet(false)
{
}

OnlineStoreSecurityConfig::OnlineStoreSecurityConfig(JsonView jsonValue) : 
    m_kmsKeyIdHasBeenSet(false)
{
  *this = jsonValue;
}

OnlineStoreSecurityConfig& OnlineStoreSecurityConfig::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("KmsKeyId"))
  {
    m_kmsKeyId = jsonValue.GetString("KmsKeyId");

    m_kmsKeyIdHasBeenSet = true;
  }

  return *this;
}

JsonValue OnlineStoreSecurityConfig::Jsonize() const
{
  JsonValue payload;

  if(m_kmsKeyIdHasBeenSet)
  {
   payload.WithString("KmsKeyId", m_kmsKeyId);

  }

  return payload;
}

} // namespace Model
} // namespace SageMaker
} // namespace Aws
