﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/client/AWSError.h>
#include <aws/nimble/NimbleStudioErrorMarshaller.h>
#include <aws/nimble/NimbleStudioErrors.h>

using namespace Aws::Client;
using namespace Aws::NimbleStudio;

AWSError<CoreErrors> NimbleStudioErrorMarshaller::FindErrorByName(const char* errorName) const
{
  AWSError<CoreErrors> error = NimbleStudioErrorMapper::GetErrorForName(errorName);
  if(error.GetErrorType() != CoreErrors::UNKNOWN)
  {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}