﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/memorydb/model/ListAllowedNodeTypeUpdatesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::MemoryDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ListAllowedNodeTypeUpdatesRequest::ListAllowedNodeTypeUpdatesRequest() : 
    m_clusterNameHasBeenSet(false)
{
}

Aws::String ListAllowedNodeTypeUpdatesRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_clusterNameHasBeenSet)
  {
   payload.WithString("ClusterName", m_clusterName);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListAllowedNodeTypeUpdatesRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonMemoryDB.ListAllowedNodeTypeUpdates"));
  return headers;

}




