﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/account/model/GetAlternateContactResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::Account::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetAlternateContactResult::GetAlternateContactResult()
{
}

GetAlternateContactResult::GetAlternateContactResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

GetAlternateContactResult& GetAlternateContactResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("AlternateContact"))
  {
    m_alternateContact = jsonValue.GetObject("AlternateContact");

  }



  return *this;
}
