#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
/*
 * IncrementalBackup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Arena.h"
#include "flow/Platform.h"
#include "flow/Trace.h"
#include "flow/serialize.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct IncrementalBackupWorkload : TestWorkload {
	static constexpr auto NAME = "IncrementalBackup";

	Standalone<StringRef> backupDir;
	Standalone<StringRef> tag;
	FileBackupAgent backupAgent;
	bool submitOnly;
	bool restoreOnly;
	bool waitForBackup;
	int waitRetries;
	bool stopBackup;
	bool checkBeginVersion;
	bool clearBackupAgentKeys;
	Standalone<StringRef> blobManifestUrl;
	Optional<std::string> encryptionKeyFileName;

	IncrementalBackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupDir = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
		tag = getOption(options, "tag"_sr, "default"_sr);
		submitOnly = getOption(options, "submitOnly"_sr, false);
		restoreOnly = getOption(options, "restoreOnly"_sr, false);
		waitForBackup = getOption(options, "waitForBackup"_sr, false);
		waitRetries = getOption(options, "waitRetries"_sr, -1);
		stopBackup = getOption(options, "stopBackup"_sr, false);
		checkBeginVersion = getOption(options, "checkBeginVersion"_sr, false);
		clearBackupAgentKeys = getOption(options, "clearBackupAgentKeys"_sr, false);
		blobManifestUrl = getOption(options, "blobManifestUrl"_sr, ""_sr);

		if (restoreOnly) {
			// During restore, the encryption key file depends on whether the backup was encrypted or not.
			std::string temp_encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
			if (fileExists(temp_encryptionKeyFileName)) {
				encryptionKeyFileName = temp_encryptionKeyFileName;
			}
		} else if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId) {
			return Void();
		}
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId) {
			return true;
		}
		return _check(cx, this);
	}

																#line 96 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _checkActor>
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActorState {
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self)
															#line 111 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->waitForBackup)
															#line 126 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 98 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->backupAgent.changePause(cx, false);
															#line 98 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->stopBackup)
															#line 165 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			try {
															#line 163 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				TraceEvent("IBackupDiscontinueBackup").log();
															#line 164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_10 = self->backupAgent.discontinueBackup(cx, self->tag);
															#line 164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 174 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1when1(__when_expr_10.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 11;
															#line 164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 10, Void >*>(static_cast<_checkActor*>(this)));
															#line 179 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 103 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 207 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 103 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 224 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 111 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 308 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 105 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(v, tr.getReadVersion());
															#line 105 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 327 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 332 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 369 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 374 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries = 0;
															#line 140 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 565 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupWaitContainer").log();
															#line 114 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 114 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 114 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 590 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 118 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 614 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 618 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 622 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 123 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 630 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 635 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 118 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 651 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 655 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 659 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 123 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 667 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 672 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont2(int loopDepth) 
	{
															#line 134 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<bool> __when_expr_5 = backupContainer->exists();
															#line 134 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 763 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 134 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, bool >*>(static_cast<_checkActor*>(this)));
															#line 768 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(int loopDepth) 
	{
															#line 126 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (containers.size())
															#line 779 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 130 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			backupContainer = IBackupContainer::openContainer(containers.front(), {}, restoreEncryptionKeyFileName);
															#line 783 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 793 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont7(int loopDepth) 
	{
															#line 135 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (e)
															#line 872 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(5.0);
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 880 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 885 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool const& __e,int loopDepth) 
	{
															#line 134 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		e = __e;
															#line 894 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 141 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries++;
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_7 = backupContainer->describeBackup(true);
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1077 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, BackupDescription >*>(static_cast<_checkActor*>(this)));
															#line 1082 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupVersionGate") .detail("MaxLogEndVersion", desc.maxLogEnd.present() ? desc.maxLogEnd.get() : invalidVersion) .detail("ContiguousLogEndVersion", desc.contiguousLogEnd.present() ? desc.contiguousLogEnd.get() : invalidVersion) .detail("TargetVersion", v);
															#line 149 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 1106 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(5.0);
															#line 150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 9;
															#line 150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 8, Void >*>(static_cast<_checkActor*>(this)));
															#line 1117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		desc = __desc;
															#line 1131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4loopBody1cont2(int loopDepth) 
	{
															#line 153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (desc.contiguousLogEnd.get() >= v)
															#line 1210 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->waitRetries != -1 && tries > self->waitRetries)
															#line 1216 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 158 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(5.0);
															#line 158 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1224 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 158 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Void >*>(static_cast<_checkActor*>(this)));
															#line 1229 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _checkActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont4loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _checkActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 172 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1412 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupDiscontinueBackupException").error(e);
															#line 167 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1433 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 168 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1437 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _checkActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version v;
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction tr;
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<std::string> restoreEncryptionKeyFileName;
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 134 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	bool e;
															#line 139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	int tries;
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	BackupDescription desc;
															#line 1571 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Void >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, std::vector<std::string> >, public ActorCallback< _checkActor, 5, bool >, public ActorCallback< _checkActor, 6, Void >, public ActorCallback< _checkActor, 7, BackupDescription >, public ActorCallback< _checkActor, 8, Void >, public ActorCallback< _checkActor, 9, Void >, public ActorCallback< _checkActor, 10, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1576 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8843203551520526592UL, 1856459361582865664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Void >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, std::vector<std::string> >;
friend struct ActorCallback< _checkActor, 5, bool >;
friend struct ActorCallback< _checkActor, 6, Void >;
friend struct ActorCallback< _checkActor, 7, BackupDescription >;
friend struct ActorCallback< _checkActor, 8, Void >;
friend struct ActorCallback< _checkActor, 9, Void >;
friend struct ActorCallback< _checkActor, 10, Void >;
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 1603 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, BackupDescription >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _checkActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _checkActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _checkActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 94 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1645 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
}

#line 174 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

																#line 1650 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _startActor>
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActorState {
															#line 1656 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self),
															#line 176 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   backupRanges()
															#line 1667 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1684 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 1689 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		addDefaultBackupRanges(backupRanges);
															#line 180 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->submitOnly)
															#line 1714 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 181 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->encryptionKeyFileName.present())
															#line 1718 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 182 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 182 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1724 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1729 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		config = __config;
															#line 1748 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->restoreOnly)
															#line 1827 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 212 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->clearBackupAgentKeys)
															#line 1831 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 213 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				clearTr = Transaction(cx);
															#line 215 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				;
															#line 1837 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = a_body1cont2loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 185 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupSubmitAttempt").log();
															#line 1856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		try {
															#line 187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			Optional<std::string> blobManifestUrl;
															#line 188 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (!self->blobManifestUrl.empty())
															#line 1862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				blobManifestUrl = self->blobManifestUrl.toString();
															#line 1866 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
															#line 191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->backupAgent.submitBackup(cx, self->backupDir, {}, 0, 1e8, self->tag.toString(), backupRanges, true, StopWhenDone::False, UsePartitionedLog::False, IncrementalBackupOnly::True, self->encryptionKeyFileName);
															#line 191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 1872 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1877 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 209 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupSubmitSuccess").log();
															#line 1979 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSubmitError").error(e);
															#line 205 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 1991 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 206 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1995 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 331 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2111 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 228 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 229 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = invalidVersion;
															#line 230 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 230 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 230 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2136 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 217 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 218 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 219 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.clear(fileBackupPrefixRange);
															#line 220 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = clearTr.commit();
															#line 220 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2167 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 220 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2172 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = clearTr.onError(e);
															#line 223 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2209 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 223 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2214 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 234 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 2405 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 2409 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 238 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2413 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 239 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 240 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 241 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2421 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = a_body1cont11cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreEncryptionKeyFileName = Optional<std::string>();
															#line 234 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->encryptionKeyFileName.present() && fileExists(self->encryptionKeyFileName.get()))
															#line 2437 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			restoreEncryptionKeyFileName = self->encryptionKeyFileName.get();
															#line 2441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 238 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2445 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 239 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 240 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 241 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2453 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = a_body1cont11cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 267 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersAttempt").log();
															#line 268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_9 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2546 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<std::string> >*>(static_cast<_startActor*>(this)));
															#line 2551 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4(int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1(int loopDepth) 
	{
		try {
															#line 243 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 244 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_6 = tr->get(writeRecoveryKey);
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2580 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeysError").error(e);
															#line 260 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() == error_code_key_not_found)
															#line 2622 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 261 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2626 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
															#line 263 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 263 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2632 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 263 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2637 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2(int loopDepth) 
	{
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = tr->get(snapshotEndVersionKey);
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2654 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2659 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Optional<Value> const& __writeFlag,int loopDepth) 
	{
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		writeFlag = __writeFlag;
															#line 2668 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Optional<Value> && __writeFlag,int loopDepth) 
	{
		writeFlag = std::move(__writeFlag);
		loopDepth = a_body1cont11cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont1loopBody1cont3(int loopDepth) 
	{
															#line 247 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckSpecialKeys") .detail("WriteRecoveryValue", writeFlag.present() ? writeFlag.get().toString() : "N/A") .detail("EndVersionValue", versionValue.present() ? versionValue.get().toString() : "N/A");
															#line 250 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!versionValue.present())
															#line 2749 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckSpecialKeysFailure").log();
															#line 253 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			return a_body1cont11cont1loopBody1Catch1(key_not_found(), loopDepth);
															#line 2755 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 255 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(versionValue.get(), Unversioned());
															#line 256 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckBeginVersion").detail("Version", beginVersion);
															#line 2761 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		return a_body1cont11cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Optional<Value> const& __versionValue,int loopDepth) 
	{
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		versionValue = __versionValue;
															#line 2770 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Optional<Value> && __versionValue,int loopDepth) 
	{
		versionValue = std::move(__versionValue);
		loopDepth = a_body1cont11cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont5(int loopDepth) 
	{
															#line 270 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 273 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupURL = Key(containers.front());
															#line 275 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 276 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 277 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		for( auto r : backupRanges ) {
															#line 278 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (config.tenantMode != TenantMode::REQUIRED || !r.intersects(getSystemBackupRanges()))
															#line 2946 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 279 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				restoreRange.push_back_deep(restoreRange.arena(), r);
															#line 2950 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			else
			{
															#line 281 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef normalKeyRange = r & normalKeys;
															#line 282 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef systemKeyRange = r & systemKeys;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!normalKeyRange.empty())
															#line 2960 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				{
															#line 284 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					restoreRange.push_back_deep(restoreRange.arena(), normalKeyRange);
															#line 2964 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				}
															#line 286 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!systemKeyRange.empty())
															#line 2968 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				{
															#line 287 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 2972 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				}
			}
		}
															#line 291 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!systemRestoreRange.empty())
															#line 2978 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 292 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSystemRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 293 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_10 = success(self->backupAgent.restore(cx, cx, "system_restore"_sr, backupURL, {}, systemRestoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion, restoreEncryptionKeyFileName));
															#line 293 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2986 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 293 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2991 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 3005 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont11cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont6(int loopDepth) 
	{
															#line 311 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 312 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_11 = success(self->backupAgent.restore(cx, cx, Key(self->tag.toString()), backupURL, {}, restoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion, restoreEncryptionKeyFileName));
															#line 312 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3088 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont6when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 312 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 3093 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont13(Void const& _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3189 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13(Void && _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3198 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 176 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	DatabaseConfiguration config;
															#line 213 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction clearTr;
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 228 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 229 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version beginVersion;
															#line 233 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<std::string> restoreEncryptionKeyFileName;
															#line 240 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> writeFlag;
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> versionValue;
															#line 268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 273 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Key backupURL;
															#line 275 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRange;
															#line 276 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRange;
															#line 3310 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Optional<Value> >, public ActorCallback< _startActor, 7, Optional<Value> >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, std::vector<std::string> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3315 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13419981697307586560UL, 6708058828133565952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Optional<Value> >;
friend struct ActorCallback< _startActor, 7, Optional<Value> >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, std::vector<std::string> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 3343 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3386 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
}

#line 333 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<IncrementalBackupWorkload> IncrementalBackupWorkloadFactory;
