#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
/*
 * DDTxnProcessor.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/DDTxnProcessor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

static void updateServersAndCompleteSources(std::set<UID>& servers,
                                            std::vector<UID>& completeSources,
                                            int shard,
                                            const std::vector<UID>& src) {
	servers.insert(src.begin(), src.end());
	if (shard == 0) {
		completeSources = src;
	} else {
		for (int i = 0; i < completeSources.size(); i++) {
			if (std::find(src.begin(), src.end(), completeSources[i]) == src.end()) {
				swapAndPop(&completeSources, i--);
			}
		}
	}
}

class DDTxnProcessorImpl {
	friend class DDTxnProcessor;

																#line 50 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getServerListAndProcessClasses()
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetServerListAndProcessClassesActor>
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetServerListAndProcessClassesActorState {
															#line 56 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetServerListAndProcessClassesActorState(Database const& cx) 
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 49 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx),
															#line 50 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   res()
															#line 67 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~GetServerListAndProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 82 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 52 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 53 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 54 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 116 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 56 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(res.servers, NativeAPI::getServerListAndProcessClasses(&tr));
															#line 56 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*>(static_cast<GetServerListAndProcessClassesActor*>(this)));
															#line 127 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 60 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 151 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*>(static_cast<GetServerListAndProcessClassesActor*>(this)));
															#line 156 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.readVersion = tr.getReadVersion().get();
															#line 58 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetServerListAndProcessClassesActor*>(this)->SAV<ServerWorkerInfos>::futures) { (void)(res); this->~GetServerListAndProcessClassesActorState(); static_cast<GetServerListAndProcessClassesActor*>(this)->destroy(); return 0; }
															#line 173 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetServerListAndProcessClassesActor*>(this)->SAV< ServerWorkerInfos >::value()) ServerWorkerInfos(std::move(res)); // state_var_RVO
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.readVersion = tr.getReadVersion().get();
															#line 58 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetServerListAndProcessClassesActor*>(this)->SAV<ServerWorkerInfos>::futures) { (void)(res); this->~GetServerListAndProcessClassesActorState(); static_cast<GetServerListAndProcessClassesActor*>(this)->destroy(); return 0; }
															#line 187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetServerListAndProcessClassesActor*>(this)->SAV< ServerWorkerInfos >::value()) ServerWorkerInfos(std::move(res)); // state_var_RVO
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerListAndProcessClassesActor*>(this)->ActorCallback< GetServerListAndProcessClassesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerListAndProcessClassesActor*>(this)->ActorCallback< GetServerListAndProcessClassesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 49 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 50 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ServerWorkerInfos res;
															#line 363 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getServerListAndProcessClasses()
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetServerListAndProcessClassesActor final : public Actor<ServerWorkerInfos>, public ActorCallback< GetServerListAndProcessClassesActor, 0, Void >, public ActorCallback< GetServerListAndProcessClassesActor, 1, Void >, public FastAllocated<GetServerListAndProcessClassesActor>, public GetServerListAndProcessClassesActorState<GetServerListAndProcessClassesActor> {
															#line 368 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetServerListAndProcessClassesActor>::operator new;
	using FastAllocated<GetServerListAndProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17167651847433790208UL, 17597518647619989504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ServerWorkerInfos>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetServerListAndProcessClassesActor, 0, Void >;
friend struct ActorCallback< GetServerListAndProcessClassesActor, 1, Void >;
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetServerListAndProcessClassesActor(Database const& cx) 
															#line 386 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<ServerWorkerInfos>(),
		   GetServerListAndProcessClassesActorState<GetServerListAndProcessClassesActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4960532463770230016UL, 4395093134379451392UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getServerListAndProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<ServerWorkerInfos> getServerListAndProcessClasses( Database const& cx ) {
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<ServerWorkerInfos>(new GetServerListAndProcessClassesActor(cx));
															#line 419 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 64 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// return {sourceServers, completeSources}
																#line 425 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getSourceServersForRange()
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetSourceServersForRangeActor>
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServersForRangeActorState {
															#line 431 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServersForRangeActorState(Database const& cx,KeyRangeRef const& keys) 
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys(keys),
															#line 67 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   servers(),
															#line 68 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   completeSources(),
															#line 69 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 446 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getSourceServersForRange", reinterpret_cast<unsigned long>(this));

	}
	~GetSourceServersForRangeActorState() 
	{
		fdb_probe_actor_destroy("getSourceServersForRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 461 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSourceServersForRangeActorState();
		static_cast<GetSourceServersForRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetSourceServersForRangeActor*>(this)->SAV<IDDTxnProcessor::SourceServers>::futures) { (void)(IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources }); this->~GetSourceServersForRangeActorState(); static_cast<GetSourceServersForRangeActor*>(this)->destroy(); return 0; }
															#line 484 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetSourceServersForRangeActor*>(this)->SAV< IDDTxnProcessor::SourceServers >::value()) IDDTxnProcessor::SourceServers(IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources });
		this->~GetSourceServersForRangeActorState();
		static_cast<GetSourceServersForRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		servers.clear();
															#line 73 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		completeSources.clear();
															#line 75 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 76 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 77 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 511 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 517 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 522 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 559 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 4;
															#line 112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 3, Void >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 564 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 80 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(lastLessOrEqual(keyServersKey(keys.begin)), firstGreaterOrEqual(keyServersKey(keys.end)), SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS);
															#line 81 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 588 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 597 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& keyServersEntries,int loopDepth) 
	{
															#line 85 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (keyServersEntries.size() < SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS)
															#line 676 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < keyServersEntries.size();shard++) {
															#line 87 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				std::vector<UID> src, dest;
															#line 88 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				decodeKeyServersValue(UIDtoTagMap, keyServersEntries[shard].value, src, dest);
															#line 89 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(src.size());
															#line 90 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				updateServersAndCompleteSources(servers, completeSources, shard, src);
															#line 688 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(servers.size() > 0);
															#line 692 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		else
		{
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 701 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 706 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && keyServersEntries,int loopDepth) 
	{
															#line 85 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (keyServersEntries.size() < SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS)
															#line 716 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < keyServersEntries.size();shard++) {
															#line 87 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				std::vector<UID> src, dest;
															#line 88 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				decodeKeyServersValue(UIDtoTagMap, keyServersEntries[shard].value, src, dest);
															#line 89 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(src.size());
															#line 90 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				updateServersAndCompleteSources(servers, completeSources, shard, src);
															#line 728 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(servers.size() > 0);
															#line 732 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		else
		{
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 741 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 746 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& keyServersEntries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(keyServersEntries, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && keyServersEntries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(keyServersEntries), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7(RangeResult const& serverList,int loopDepth) 
	{
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto s = serverList.begin();s != serverList.end();++s) {
															#line 105 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			servers.insert(decodeServerListValue(s->value).id());
															#line 841 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 107 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(servers.size() > 0);
															#line 845 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(RangeResult && serverList,int loopDepth) 
	{
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto s = serverList.begin();s != serverList.end();++s) {
															#line 105 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			servers.insert(decodeServerListValue(s->value).id());
															#line 858 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 107 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(servers.size() > 0);
															#line 862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef keys;
															#line 67 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::set<UID> servers;
															#line 68 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> completeSources;
															#line 69 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1041 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getSourceServersForRange()
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServersForRangeActor final : public Actor<IDDTxnProcessor::SourceServers>, public ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 3, Void >, public FastAllocated<GetSourceServersForRangeActor>, public GetSourceServersForRangeActorState<GetSourceServersForRangeActor> {
															#line 1046 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetSourceServersForRangeActor>::operator new;
	using FastAllocated<GetSourceServersForRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1333260734218935296UL, 864354057476075520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<IDDTxnProcessor::SourceServers>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 3, Void >;
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServersForRangeActor(Database const& cx,KeyRangeRef const& keys) 
															#line 1066 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<IDDTxnProcessor::SourceServers>(),
		   GetSourceServersForRangeActorState<GetSourceServersForRangeActor>(cx, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7022398268476599552UL, 5262681254722997504UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSourceServersForRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<IDDTxnProcessor::SourceServers> getSourceServersForRange( Database const& cx, KeyRangeRef const& keys ) {
															#line 66 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<IDDTxnProcessor::SourceServers>(new GetSourceServersForRangeActor(cx, keys));
															#line 1101 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 118 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 1106 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getSourceServerInterfacesForRange()
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetSourceServerInterfacesForRangeActor>
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServerInterfacesForRangeActorState {
															#line 1112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServerInterfacesForRangeActorState(Database const& cx,KeyRangeRef const& range) 
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   range(range),
															#line 122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   res(),
															#line 123 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 1125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this));

	}
	~GetSourceServerInterfacesForRangeActorState() 
	{
		fdb_probe_actor_destroy("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 126 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 128 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 1146 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSourceServerInterfacesForRangeActorState();
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetSourceServerInterfacesForRangeActor*>(this)->SAV<std::vector<IDDTxnProcessor::DDRangeLocations>>::futures) { (void)(res); this->~GetSourceServerInterfacesForRangeActorState(); static_cast<GetSourceServerInterfacesForRangeActor*>(this)->destroy(); return 0; }
															#line 1169 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetSourceServerInterfacesForRangeActor*>(this)->SAV< std::vector<IDDTxnProcessor::DDRangeLocations> >::value()) std::vector<IDDTxnProcessor::DDRangeLocations>(std::move(res)); // state_var_RVO
		this->~GetSourceServerInterfacesForRangeActorState();
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.clear();
															#line 1188 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, range, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1194 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1199 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 168 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevWarnAlways, "GetSourceServerInterfacesError").errorUnsuppressed(e).detail("Range", range);
															#line 169 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 169 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1238 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 4;
															#line 169 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1243 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!shards.empty());
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1262 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1267 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __shards,int loopDepth) 
	{
															#line 131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		shards = __shards;
															#line 1276 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __shards,int loopDepth) 
	{
		shards = std::move(__shards);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 141 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		i = 0;
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		i = 0;
															#line 1359 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 1368 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!(i < shards.size() - 1))
															#line 1460 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		src = std::vector<UID>();
															#line 144 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> dest;
															#line 145 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 146 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 148 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 149 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < src.size();++j) {
															#line 150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(src[j])));
															#line 1478 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_2 = getAll(serverListEntries);
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1484 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1489 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		IDDTxnProcessor::DDRangeLocations current(KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 154 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < serverListValues.size();++j) {
															#line 155 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!serverListValues[j].present())
															#line 1515 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevWarnAlways, "GetSourceServerInterfacesMissing") .detail("StorageServer", src[j]) .detail("Range", KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 1519 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 161 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[j].get());
															#line 162 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			current.servers[ssi.locality.describeDcId()].push_back(ssi);
															#line 1526 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.push_back(current);
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		++i;
															#line 1532 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		IDDTxnProcessor::DDRangeLocations current(KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 154 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < serverListValues.size();++j) {
															#line 155 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!serverListValues[j].present())
															#line 1545 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevWarnAlways, "GetSourceServerInterfacesMissing") .detail("StorageServer", src[j]) .detail("Range", KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 1549 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 161 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[j].get());
															#line 162 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			current.servers[ssi.locality.describeDcId()].push_back(ssi);
															#line 1556 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.push_back(current);
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		++i;
															#line 1562 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef range;
															#line 122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<IDDTxnProcessor::DDRangeLocations> res;
															#line 123 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 131 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult shards;
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 141 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int i;
															#line 143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> src;
															#line 1745 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getSourceServerInterfacesForRange()
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServerInterfacesForRangeActor final : public Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>, public ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >, public FastAllocated<GetSourceServerInterfacesForRangeActor>, public GetSourceServerInterfacesForRangeActorState<GetSourceServerInterfacesForRangeActor> {
															#line 1750 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetSourceServerInterfacesForRangeActor>::operator new;
	using FastAllocated<GetSourceServerInterfacesForRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6365751527597968640UL, 10720114698781469952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >;
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServerInterfacesForRangeActor(Database const& cx,KeyRangeRef const& range) 
															#line 1770 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>(),
		   GetSourceServerInterfacesForRangeActorState<GetSourceServerInterfacesForRangeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12691934073115157248UL, 5954822088203531776UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSourceServerInterfacesForRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<std::vector<IDDTxnProcessor::DDRangeLocations>> getSourceServerInterfacesForRange( Database const& cx, KeyRangeRef const& range ) {
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<std::vector<IDDTxnProcessor::DDRangeLocations>>(new GetSourceServerInterfacesForRangeActor(cx, range));
															#line 1805 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// set the system key space
																#line 1811 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via updateReplicaKeys()
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class UpdateReplicaKeysActor>
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class UpdateReplicaKeysActorState {
															#line 1817 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UpdateReplicaKeysActorState(Database const& cx,std::vector<Optional<Key>> const& primaryDcId,std::vector<Optional<Key>> const& remoteDcIds,DatabaseConfiguration const& configuration) 
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   primaryDcId(primaryDcId),
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   remoteDcIds(remoteDcIds),
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   configuration(configuration),
															#line 181 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 1832 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("updateReplicaKeys", reinterpret_cast<unsigned long>(this));

	}
	~UpdateReplicaKeysActorState() 
	{
		fdb_probe_actor_destroy("updateReplicaKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 1847 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateReplicaKeysActorState();
		static_cast<UpdateReplicaKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<UpdateReplicaKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateReplicaKeysActorState(); static_cast<UpdateReplicaKeysActor*>(this)->destroy(); return 0; }
															#line 1870 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<UpdateReplicaKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateReplicaKeysActorState();
		static_cast<UpdateReplicaKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 184 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 185 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(datacenterReplicasKeys, CLIENT_KNOBS->TOO_MANY);
															#line 187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1896 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 1;
															#line 187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1901 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 205 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 205 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1938 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 3;
															#line 205 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 2, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1943 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& replicaKeys,int loopDepth) 
	{
															#line 189 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& kv : replicaKeys ) {
															#line 190 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dcId = decodeDatacenterReplicasKey(kv.key);
															#line 191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto replicas = decodeDatacenterReplicasValue(kv.value);
															#line 192 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if ((primaryDcId.size() && primaryDcId.at(0) == dcId) || (remoteDcIds.size() && remoteDcIds.at(0) == dcId && configuration.usableRegions > 1))
															#line 1964 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (replicas > configuration.storageTeamSize)
															#line 1968 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					tr.set(kv.key, datacenterReplicasValue(configuration.storageTeamSize));
															#line 1972 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
			else
			{
															#line 198 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tr.clear(kv.key);
															#line 1979 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1986 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 1, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1991 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && replicaKeys,int loopDepth) 
	{
															#line 189 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& kv : replicaKeys ) {
															#line 190 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dcId = decodeDatacenterReplicasKey(kv.key);
															#line 191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto replicas = decodeDatacenterReplicasValue(kv.value);
															#line 192 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if ((primaryDcId.size() && primaryDcId.at(0) == dcId) || (remoteDcIds.size() && remoteDcIds.at(0) == dcId && configuration.usableRegions > 1))
															#line 2006 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (replicas > configuration.storageTeamSize)
															#line 2010 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					tr.set(kv.key, datacenterReplicasValue(configuration.storageTeamSize));
															#line 2014 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
			else
			{
															#line 198 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tr.clear(kv.key);
															#line 2021 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2028 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 1, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 2033 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& replicaKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(replicaKeys, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && replicaKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(replicaKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> primaryDcId;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> remoteDcIds;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DatabaseConfiguration configuration;
															#line 181 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 2297 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via updateReplicaKeys()
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class UpdateReplicaKeysActor final : public Actor<Void>, public ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >, public ActorCallback< UpdateReplicaKeysActor, 1, Void >, public ActorCallback< UpdateReplicaKeysActor, 2, Void >, public FastAllocated<UpdateReplicaKeysActor>, public UpdateReplicaKeysActorState<UpdateReplicaKeysActor> {
															#line 2302 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<UpdateReplicaKeysActor>::operator new;
	using FastAllocated<UpdateReplicaKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6904861061963507712UL, 4309289676969400320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >;
friend struct ActorCallback< UpdateReplicaKeysActor, 1, Void >;
friend struct ActorCallback< UpdateReplicaKeysActor, 2, Void >;
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UpdateReplicaKeysActor(Database const& cx,std::vector<Optional<Key>> const& primaryDcId,std::vector<Optional<Key>> const& remoteDcIds,DatabaseConfiguration const& configuration) 
															#line 2321 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateReplicaKeysActorState<UpdateReplicaKeysActor>(cx, primaryDcId, remoteDcIds, configuration),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12167027471290647296UL, 8900329054216317952UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateReplicaKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> updateReplicaKeys( Database const& cx, std::vector<Optional<Key>> const& primaryDcId, std::vector<Optional<Key>> const& remoteDcIds, DatabaseConfiguration const& configuration ) {
															#line 177 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new UpdateReplicaKeysActor(cx, primaryDcId, remoteDcIds, configuration));
															#line 2355 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 210 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 2360 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via tryUpdateReplicasKeyForDc()
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class TryUpdateReplicasKeyForDcActor>
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class TryUpdateReplicasKeyForDcActorState {
															#line 2366 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TryUpdateReplicasKeyForDcActorState(Database const& cx,Optional<Key> const& dcId,int const& storageTeamSize) 
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   dcId(dcId),
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   storageTeamSize(storageTeamSize),
															#line 212 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 2379 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this));

	}
	~TryUpdateReplicasKeyForDcActorState() 
	{
		fdb_probe_actor_destroy("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 2394 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 215 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2426 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 218 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(datacenterReplicasKeyFor(dcId));
															#line 218 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2432 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2437 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 231 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2461 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 3;
															#line 231 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2466 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 219 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		oldReplicas = val.present() ? decodeDatacenterReplicasValue(val.get()) : 0;
															#line 220 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas == storageTeamSize)
															#line 2483 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2487 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
			this->~TryUpdateReplicasKeyForDcActorState();
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas < storageTeamSize)
															#line 2495 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.set(rebootWhenDurableKey, StringRef());
															#line 2499 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 226 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.set(datacenterReplicasKeyFor(dcId), datacenterReplicasValue(storageTeamSize));
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2507 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2512 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 219 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		oldReplicas = val.present() ? decodeDatacenterReplicasValue(val.get()) : 0;
															#line 220 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas == storageTeamSize)
															#line 2523 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2527 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
			this->~TryUpdateReplicasKeyForDcActorState();
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas < storageTeamSize)
															#line 2535 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.set(rebootWhenDurableKey, StringRef());
															#line 2539 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 226 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.set(datacenterReplicasKeyFor(dcId), datacenterReplicasValue(storageTeamSize));
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2547 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2552 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2636 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2648 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Optional<Key> dcId;
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int storageTeamSize;
															#line 212 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 219 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int oldReplicas;
															#line 2828 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via tryUpdateReplicasKeyForDc()
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class TryUpdateReplicasKeyForDcActor final : public Actor<int>, public ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >, public ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >, public ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >, public FastAllocated<TryUpdateReplicasKeyForDcActor>, public TryUpdateReplicasKeyForDcActorState<TryUpdateReplicasKeyForDcActor> {
															#line 2833 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<TryUpdateReplicasKeyForDcActor>::operator new;
	using FastAllocated<TryUpdateReplicasKeyForDcActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1014378201565588224UL, 14973114894366501632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >;
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >;
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >;
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TryUpdateReplicasKeyForDcActor(Database const& cx,Optional<Key> const& dcId,int const& storageTeamSize) 
															#line 2852 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<int>(),
		   TryUpdateReplicasKeyForDcActorState<TryUpdateReplicasKeyForDcActor>(cx, dcId, storageTeamSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14015056509346087168UL, 12566327531761134080UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryUpdateReplicasKeyForDc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<int> tryUpdateReplicasKeyForDc( Database const& cx, Optional<Key> const& dcId, int const& storageTeamSize ) {
															#line 211 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<int>(new TryUpdateReplicasKeyForDcActor(cx, dcId, storageTeamSize));
															#line 2886 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 235 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 2891 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getHealthyZone()
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetHealthyZoneActor>
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetHealthyZoneActorState {
															#line 2897 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetHealthyZoneActorState(Database const& cx,UID const& distributorId) 
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   distributorId(distributorId),
															#line 243 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx),
															#line 244 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   maxRetries(SERVER_KNOBS->DD_HEALTHY_ZONE_READ_RETRY_COUNT),
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   healthyZoneRead(false),
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   healthyZoneVal(),
															#line 247 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   i(0)
															#line 2916 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	~GetHealthyZoneActorState() 
	{
		fdb_probe_actor_destroy("getHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 248 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 2931 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetHealthyZoneActorState();
		static_cast<GetHealthyZoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (healthyZoneRead)
															#line 2954 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (healthyZoneVal.present())
															#line 2958 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto p = decodeHealthyZoneValue(healthyZoneVal.get());
															#line 265 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (p.second > tr.getReadVersion().get() || p.first == ignoreSSFailuresZoneString)
															#line 2964 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 266 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (!static_cast<GetHealthyZoneActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>(p.first)); this->~GetHealthyZoneActorState(); static_cast<GetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 2968 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					new (&static_cast<GetHealthyZoneActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>(p.first));
					this->~GetHealthyZoneActorState();
					static_cast<GetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		else
		{
															#line 270 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "ReadHealthyZone", distributorId) .detail("MaxRetries", maxRetries) .detail("AdditionalInfo", "Maintenance mode settings (if any) will be ignored until the next" " cluster restart or change to maintenance mode settings." " Warning: Data distribution may happen for storage servers in maintenance zones that" " appear to be down. Data distributor/cluster restart can be used to reattempt to read" " the maintenance mode settings.");
															#line 2980 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 279 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetHealthyZoneActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>()); this->~GetHealthyZoneActorState(); static_cast<GetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 2984 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetHealthyZoneActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>());
		this->~GetHealthyZoneActorState();
		static_cast<GetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!(i < maxRetries))
															#line 3003 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 250 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 251 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 252 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 253 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(healthyZoneKey);
															#line 253 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3018 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetHealthyZoneActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >*>(static_cast<GetHealthyZoneActor*>(this)));
															#line 3023 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		i++;
															#line 3051 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 258 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("ReadHealthyZone", distributorId).error(e);
															#line 259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3065 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetHealthyZoneActor, 1, Void >*>(static_cast<GetHealthyZoneActor*>(this)));
															#line 3070 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> const& _hz,int loopDepth) 
	{
															#line 254 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		healthyZoneVal = _hz;
															#line 255 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		healthyZoneRead = true;
															#line 3087 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && _hz,int loopDepth) 
	{
															#line 254 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		healthyZoneVal = _hz;
															#line 255 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		healthyZoneRead = true;
															#line 3098 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& _hz,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_hz, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && _hz,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_hz), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<GetHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<GetHealthyZoneActor*>(this)->ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<GetHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<GetHealthyZoneActor*>(this)->ActorCallback< GetHealthyZoneActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetHealthyZoneActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetHealthyZoneActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetHealthyZoneActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UID distributorId;
															#line 243 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 244 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int maxRetries;
															#line 245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	bool healthyZoneRead;
															#line 246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Optional<Value> healthyZoneVal;
															#line 247 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int i;
															#line 3279 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getHealthyZone()
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetHealthyZoneActor final : public Actor<Optional<Key>>, public ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >, public ActorCallback< GetHealthyZoneActor, 1, Void >, public FastAllocated<GetHealthyZoneActor>, public GetHealthyZoneActorState<GetHealthyZoneActor> {
															#line 3284 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetHealthyZoneActor>::operator new;
	using FastAllocated<GetHealthyZoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5974908246040985856UL, 10671982160309820416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Key>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >;
friend struct ActorCallback< GetHealthyZoneActor, 1, Void >;
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetHealthyZoneActor(Database const& cx,UID const& distributorId) 
															#line 3302 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Optional<Key>>(),
		   GetHealthyZoneActorState<GetHealthyZoneActor>(cx, distributorId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getHealthyZone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15400406738426983424UL, 8400761432502400768UL);
		ActorExecutionContextHelper __helper(static_cast<GetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getHealthyZone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getHealthyZone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetHealthyZoneActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetHealthyZoneActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Optional<Key>> getHealthyZone( Database const& cx, UID const& distributorId ) {
															#line 236 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Optional<Key>>(new GetHealthyZoneActor(cx, distributorId));
															#line 3335 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 281 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// Read keyservers, return unique set of teams
																#line 3341 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getInitialDataDistribution()
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetInitialDataDistributionActor>
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetInitialDataDistributionActorState {
															#line 3347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetInitialDataDistributionActorState(Database const& cx,UID const& distributorId,MoveKeysLock const& moveKeysLock,std::vector<Optional<Key>> const& remoteDcIds,const DDEnabledState* const& ddEnabledState,SkipDDModeCheck const& skipDDModeCheck) 
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   distributorId(distributorId),
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   moveKeysLock(moveKeysLock),
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   remoteDcIds(remoteDcIds),
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   skipDDModeCheck(skipDDModeCheck),
															#line 290 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   result(makeReference<InitialDataDistribution>()),
															#line 291 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   beginKey(allKeys.begin),
															#line 293 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   succeeded(),
															#line 295 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 3372 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	~GetInitialDataDistributionActorState() 
	{
		fdb_probe_actor_destroy("getInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (ddLargeTeamEnabled())
															#line 3387 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 298 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(result->userRangeConfig, DDConfiguration().userRangeConfig().getSnapshot( SystemDBWriteLockedNow(cx.getReference()), allKeys.begin, allKeys.end));
															#line 298 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3393 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 0, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3398 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetInitialDataDistributionActorState();
		static_cast<GetInitialDataDistributionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 302 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		server_dc = std::map<UID, Optional<Key>>();
															#line 303 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		team_cache = std::map<std::vector<UID>, std::pair<std::vector<UID>, std::vector<UID>>>();
															#line 304 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tss_servers = std::vector<std::pair<StorageServerInterface, ProcessClass>>();
															#line 305 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		numDataMoves = 0;
															#line 307 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_1 = getHealthyZone(cx, distributorId);
															#line 307 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3436 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 2;
															#line 307 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<Key> const& healthyZone,int loopDepth) 
	{
															#line 308 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->initHealthyZoneValue = healthyZone;
															#line 310 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		CODE_PROBE((bool)skipDDModeCheck, "DD Mode won't prevent read initial data distribution.");
															#line 313 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 3541 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Key> && healthyZone,int loopDepth) 
	{
															#line 308 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->initHealthyZoneValue = healthyZone;
															#line 310 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		CODE_PROBE((bool)skipDDModeCheck, "DD Mode won't prevent read initial data distribution.");
															#line 313 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 3554 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Key> const& healthyZone,int loopDepth) 
	{
		loopDepth = a_body1cont3(healthyZone, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Key> && healthyZone,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(healthyZone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 432 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 3638 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 314 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		numDataMoves = 0;
															#line 315 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		server_dc.clear();
															#line 316 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->allServers.clear();
															#line 317 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->dataMoveMap = KeyRangeMap<std::shared_ptr<DataMove>>(std::make_shared<DataMove>());
															#line 318 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->auditStates.clear();
															#line 319 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tss_servers.clear();
															#line 320 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		team_cache.clear();
															#line 321 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = false;
															#line 3668 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 323 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 324 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 325 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 326 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->mode = 1;
															#line 327 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataDistributionModeKey);
															#line 327 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3682 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 3;
															#line 327 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3687 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 423 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("GetInitialTeamsRetry", distributorId).error(e);
															#line 424 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 424 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3726 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 8;
															#line 424 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 7, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3731 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> const& mode,int loopDepth) 
	{
															#line 328 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 3746 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 329 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 330 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->mode;
															#line 3752 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 332 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if ((!skipDDModeCheck && !result->mode) || !ddEnabledState->isEnabled())
															#line 3756 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "GetInitialDataDistribution_DisabledDD").log();
															#line 335 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 3762 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
			this->~GetInitialDataDistributionActorState();
			static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 338 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkLoadMode = 0;
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(bulkLoadModeKey);
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3774 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 4;
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3779 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> && mode,int loopDepth) 
	{
															#line 328 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 3788 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 329 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 330 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->mode;
															#line 3794 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 332 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if ((!skipDDModeCheck && !result->mode) || !ddEnabledState->isEnabled())
															#line 3798 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "GetInitialDataDistribution_DisabledDD").log();
															#line 335 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 3804 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
			this->~GetInitialDataDistributionActorState();
			static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 338 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkLoadMode = 0;
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(bulkLoadModeKey);
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3816 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 4;
															#line 339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3821 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(mode, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont3(Optional<Value> const& bulkLoadMode,int loopDepth) 
	{
															#line 340 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkLoadMode.present())
															#line 3905 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 341 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkLoadMode.get(), Unversioned());
															#line 342 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkLoadMode;
															#line 3911 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 344 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkLoadEngineInitMode").detail("Mode", result->bulkLoadMode);
															#line 346 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkDumpMode = 0;
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(bulkDumpModeKey);
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3921 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 5;
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3926 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Optional<Value> && bulkLoadMode,int loopDepth) 
	{
															#line 340 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkLoadMode.present())
															#line 3935 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 341 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkLoadMode.get(), Unversioned());
															#line 342 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkLoadMode;
															#line 3941 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 344 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkLoadEngineInitMode").detail("Mode", result->bulkLoadMode);
															#line 346 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkDumpMode = 0;
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(bulkDumpModeKey);
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3951 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 5;
															#line 347 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3956 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Optional<Value> const& bulkLoadMode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(bulkLoadMode, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Optional<Value> && bulkLoadMode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(bulkLoadMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont6(Optional<Value> const& bulkDumpMode,int loopDepth) 
	{
															#line 348 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkDumpMode.present())
															#line 4040 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 349 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkDumpMode.get(), Unversioned());
															#line 350 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkDumpMode;
															#line 4046 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 352 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkDumpInitMode").detail("Mode", result->bulkDumpMode);
															#line 354 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		workers = getWorkers(&tr);
															#line 355 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		serverList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(workers) && success(serverList);
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4058 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 6;
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 5, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4063 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6(Optional<Value> && bulkDumpMode,int loopDepth) 
	{
															#line 348 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkDumpMode.present())
															#line 4072 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 349 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkDumpMode.get(), Unversioned());
															#line 350 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkDumpMode;
															#line 4078 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 352 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkDumpInitMode").detail("Mode", result->bulkDumpMode);
															#line 354 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		workers = getWorkers(&tr);
															#line 355 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		serverList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(workers) && success(serverList);
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4090 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 6;
															#line 356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 5, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4095 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Optional<Value> const& bulkDumpMode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont6(bulkDumpMode, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Optional<Value> && bulkDumpMode,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont6(std::move(bulkDumpMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 357 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.get().more && serverList.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 359 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, ProcessData> id_data;
															#line 360 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < workers.get().size();i++) {
															#line 361 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			id_data[workers.get()[i].locality.processId()] = workers.get()[i];
															#line 4185 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 363 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < serverList.get().size();i++) {
															#line 364 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ssi = decodeServerListValue(serverList.get()[i].value);
															#line 365 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!ssi.isTss())
															#line 4193 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 366 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->allServers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 367 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				server_dc[ssi.id()] = ssi.locality.dcId();
															#line 4199 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 369 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tss_servers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 4205 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr.getRange(dataMoveKeys, CLIENT_KNOBS->TOO_MANY);
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4212 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 7;
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4217 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 357 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.get().more && serverList.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 359 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, ProcessData> id_data;
															#line 360 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < workers.get().size();i++) {
															#line 361 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			id_data[workers.get()[i].locality.processId()] = workers.get()[i];
															#line 4232 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 363 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < serverList.get().size();i++) {
															#line 364 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ssi = decodeServerListValue(serverList.get()[i].value);
															#line 365 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!ssi.isTss())
															#line 4240 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 366 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->allServers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 367 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				server_dc[ssi.id()] = ssi.locality.dcId();
															#line 4246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 369 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tss_servers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 4252 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr.getRange(dataMoveKeys, CLIENT_KNOBS->TOO_MANY);
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 7;
															#line 373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4264 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont10(RangeResult const& dms,int loopDepth) 
	{
															#line 374 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!dms.more && dms.size() < CLIENT_KNOBS->TOO_MANY);
															#line 376 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < dms.size();++i) {
															#line 377 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dataMove = std::make_shared<DataMove>(decodeDataMoveValue(dms[i].value), true);
															#line 378 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			const DataMoveMetaData& meta = dataMove->meta;
															#line 379 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (meta.ranges.empty())
															#line 4356 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 385 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(meta.getPhase() == DataMoveMetaData::Deleting);
															#line 386 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->toCleanDataMoveTombstone.push_back(meta.id);
															#line 4362 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 389 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(!meta.ranges.empty());
															#line 390 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.src ) {
															#line 391 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 392 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 393 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteSrc.push_back(id);
															#line 4377 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 395 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primarySrc.push_back(id);
															#line 4383 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 398 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.dest ) {
															#line 399 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 400 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4392 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 401 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteDest.push_back(id);
															#line 4396 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 403 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primaryDest.push_back(id);
															#line 4402 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 406 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primarySrc.begin(), dataMove->primarySrc.end());
															#line 407 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteSrc.begin(), dataMove->remoteSrc.end());
															#line 408 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primaryDest.begin(), dataMove->primaryDest.end());
															#line 409 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteDest.begin(), dataMove->remoteDest.end());
															#line 411 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ranges = result->dataMoveMap.intersectingRanges(meta.ranges.front());
															#line 412 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( auto& r : ranges ) {
															#line 413 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(!r.value()->valid);
															#line 4419 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 415 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->dataMoveMap.insert(meta.ranges.front(), std::move(dataMove));
															#line 416 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			++numDataMoves;
															#line 4425 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 419 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 4429 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10(RangeResult && dms,int loopDepth) 
	{
															#line 374 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!dms.more && dms.size() < CLIENT_KNOBS->TOO_MANY);
															#line 376 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < dms.size();++i) {
															#line 377 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dataMove = std::make_shared<DataMove>(decodeDataMoveValue(dms[i].value), true);
															#line 378 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			const DataMoveMetaData& meta = dataMove->meta;
															#line 379 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (meta.ranges.empty())
															#line 4446 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 385 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(meta.getPhase() == DataMoveMetaData::Deleting);
															#line 386 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->toCleanDataMoveTombstone.push_back(meta.id);
															#line 4452 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 389 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(!meta.ranges.empty());
															#line 390 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.src ) {
															#line 391 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 392 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4463 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 393 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteSrc.push_back(id);
															#line 4467 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 395 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primarySrc.push_back(id);
															#line 4473 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 398 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.dest ) {
															#line 399 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 400 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4482 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 401 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteDest.push_back(id);
															#line 4486 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 403 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primaryDest.push_back(id);
															#line 4492 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 406 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primarySrc.begin(), dataMove->primarySrc.end());
															#line 407 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteSrc.begin(), dataMove->remoteSrc.end());
															#line 408 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primaryDest.begin(), dataMove->primaryDest.end());
															#line 409 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteDest.begin(), dataMove->remoteDest.end());
															#line 411 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ranges = result->dataMoveMap.intersectingRanges(meta.ranges.front());
															#line 412 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( auto& r : ranges ) {
															#line 413 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(!r.value()->valid);
															#line 4509 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 415 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->dataMoveMap.insert(meta.ranges.front(), std::move(dataMove));
															#line 416 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			++numDataMoves;
															#line 4515 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 419 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 4519 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8when1(RangeResult const& dms,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10(dms, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8when1(RangeResult && dms,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10(std::move(dms), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 426 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 4603 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 426 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 4612 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 532 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->shards.push_back(DDShardInfo(allKeys.end));
															#line 534 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && numDataMoves > 0)
															#line 4698 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < result->shards.size() - 1;++shard) {
															#line 536 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				const DDShardInfo& iShard = result->shards[shard];
															#line 537 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				KeyRangeRef keys = KeyRangeRef(iShard.key, result->shards[shard + 1].key);
															#line 538 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->dataMoveMap[keys.begin]->validateShard(iShard, keys);
															#line 4708 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 543 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& it : tss_servers ) {
															#line 544 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->allServers.push_back(it);
															#line 4715 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 547 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 4719 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
		this->~GetInitialDataDistributionActorState();
		static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 432 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!(beginKey < allKeys.end))
															#line 4738 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 433 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		CODE_PROBE(beginKey > allKeys.begin, "Multi-transactional getInitialDataDistribution");
															#line 434 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 4746 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 528 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 4768 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 435 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = false;
															#line 4784 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 437 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 438 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 439 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 440 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_8 = checkMoveKeysLockReadOnly(&tr, moveKeysLock, ddEnabledState);
															#line 440 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4796 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont4loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont4loopBody1loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 9;
															#line 440 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 8, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4801 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 520 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("GetInitialTeamsKeyServersRetry", distributorId).error(e);
															#line 522 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 522 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4840 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 12;
															#line 522 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 11, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4845 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_9 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont4loopBody1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4loopBody1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 10;
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_9 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4878 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont4loopBody1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4loopBody1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 10;
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4883 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont4loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 442 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 443 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_10 = krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(beginKey, allKeys.end), SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 443 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4971 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont4loopBody1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont4loopBody1loopBody1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 11;
															#line 443 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4976 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 4985 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont4loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont4loopBody1loopBody1cont4(RangeResult const& keyServers,int loopDepth) 
	{
															#line 448 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 450 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> src, dest, last;
															#line 451 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 454 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;i++) {
															#line 455 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 456 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			DDShardInfo info(keyServers[i].key, srcId, destId);
															#line 457 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (remoteDcIds.size())
															#line 5076 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 458 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 459 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 5082 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 460 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					for( auto& id : src ) {
															#line 461 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						auto& dc = server_dc[id];
															#line 462 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 5090 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						{
															#line 463 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.remoteSrc.push_back(id);
															#line 5094 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
						else
						{
															#line 465 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.primarySrc.push_back(id);
															#line 5100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
					}
															#line 468 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(info.primarySrc);
															#line 469 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->remoteTeams.insert(info.remoteSrc);
															#line 470 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::make_pair(info.primarySrc, info.remoteSrc);
															#line 5109 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 472 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primarySrc = srcIter->second.first;
															#line 473 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.remoteSrc = srcIter->second.second;
															#line 5117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 475 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 5121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 476 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 477 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 478 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 5129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 479 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						for( auto& id : dest ) {
															#line 480 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							auto& dc = server_dc[id];
															#line 481 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 5137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							{
															#line 483 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.remoteDest.push_back(id);
															#line 5141 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
							else
							{
															#line 485 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.primaryDest.push_back(id);
															#line 5147 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
						}
															#line 488 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(info.primaryDest);
															#line 489 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->remoteTeams.insert(info.remoteDest);
															#line 490 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::make_pair(info.primaryDest, info.remoteDest);
															#line 5156 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
					else
					{
															#line 492 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.primaryDest = destIter->second.first;
															#line 493 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.remoteDest = destIter->second.second;
															#line 5164 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 497 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				info.primarySrc = src;
															#line 498 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 499 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 5176 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 500 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(src);
															#line 501 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 5182 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 503 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 5186 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 504 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 505 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primaryDest = dest;
															#line 506 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 507 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 5196 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 508 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(dest);
															#line 509 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 5202 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
															#line 513 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->shards.push_back(info);
															#line 5208 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 516 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GT(keyServers.size(), 0);
															#line 517 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		beginKey = keyServers.end()[-1].key;
															#line 5214 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont4(RangeResult && keyServers,int loopDepth) 
	{
															#line 448 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 450 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> src, dest, last;
															#line 451 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 454 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;i++) {
															#line 455 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 456 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			DDShardInfo info(keyServers[i].key, srcId, destId);
															#line 457 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (remoteDcIds.size())
															#line 5235 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 458 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 459 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 5241 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 460 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					for( auto& id : src ) {
															#line 461 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						auto& dc = server_dc[id];
															#line 462 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 5249 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						{
															#line 463 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.remoteSrc.push_back(id);
															#line 5253 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
						else
						{
															#line 465 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.primarySrc.push_back(id);
															#line 5259 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
					}
															#line 468 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(info.primarySrc);
															#line 469 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->remoteTeams.insert(info.remoteSrc);
															#line 470 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::make_pair(info.primarySrc, info.remoteSrc);
															#line 5268 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 472 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primarySrc = srcIter->second.first;
															#line 473 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.remoteSrc = srcIter->second.second;
															#line 5276 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 475 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 5280 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 476 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 477 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 478 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 5288 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 479 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						for( auto& id : dest ) {
															#line 480 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							auto& dc = server_dc[id];
															#line 481 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 5296 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							{
															#line 483 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.remoteDest.push_back(id);
															#line 5300 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
							else
							{
															#line 485 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.primaryDest.push_back(id);
															#line 5306 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
						}
															#line 488 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(info.primaryDest);
															#line 489 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->remoteTeams.insert(info.remoteDest);
															#line 490 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::make_pair(info.primaryDest, info.remoteDest);
															#line 5315 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
					else
					{
															#line 492 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.primaryDest = destIter->second.first;
															#line 493 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.remoteDest = destIter->second.second;
															#line 5323 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 497 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				info.primarySrc = src;
															#line 498 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 499 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 5335 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 500 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(src);
															#line 501 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 5341 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 503 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 5345 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 504 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 505 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primaryDest = dest;
															#line 506 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 507 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 5355 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 508 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(dest);
															#line 509 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 5361 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
															#line 513 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->shards.push_back(info);
															#line 5367 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 516 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GT(keyServers.size(), 0);
															#line 517 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		beginKey = keyServers.end()[-1].key;
															#line 5373 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont3when1(RangeResult const& keyServers,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont4(keyServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont3when1(RangeResult && keyServers,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont4(std::move(keyServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont4loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 523 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 5457 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 523 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 5466 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UID distributorId;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysLock moveKeysLock;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> remoteDcIds;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	SkipDDModeCheck skipDDModeCheck;
															#line 290 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<InitialDataDistribution> result;
															#line 291 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Key beginKey;
															#line 293 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	bool succeeded;
															#line 295 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 302 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, Optional<Key>> server_dc;
															#line 303 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<std::vector<UID>, std::pair<std::vector<UID>, std::vector<UID>>> team_cache;
															#line 304 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<std::pair<StorageServerInterface, ProcessClass>> tss_servers;
															#line 305 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int numDataMoves;
															#line 354 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<std::vector<ProcessData>> workers;
															#line 355 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<RangeResult> serverList;
															#line 441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 5580 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getInitialDataDistribution()
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetInitialDataDistributionActor final : public Actor<Reference<InitialDataDistribution>>, public ActorCallback< GetInitialDataDistributionActor, 0, Void >, public ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >, public ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 5, Void >, public ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 7, Void >, public ActorCallback< GetInitialDataDistributionActor, 8, Void >, public ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 11, Void >, public FastAllocated<GetInitialDataDistributionActor>, public GetInitialDataDistributionActorState<GetInitialDataDistributionActor> {
															#line 5585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetInitialDataDistributionActor>::operator new;
	using FastAllocated<GetInitialDataDistributionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7783321069648005120UL, 6624442511393950720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<InitialDataDistribution>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetInitialDataDistributionActor, 0, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 5, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 7, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 8, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 11, Void >;
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetInitialDataDistributionActor(Database const& cx,UID const& distributorId,MoveKeysLock const& moveKeysLock,std::vector<Optional<Key>> const& remoteDcIds,const DDEnabledState* const& ddEnabledState,SkipDDModeCheck const& skipDDModeCheck) 
															#line 5613 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Reference<InitialDataDistribution>>(),
		   GetInitialDataDistributionActorState<GetInitialDataDistributionActor>(cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10463857597529131008UL, 248268333580752640UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getInitialDataDistribution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 1, Optional<Key> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Reference<InitialDataDistribution>> getInitialDataDistribution( Database const& cx, UID const& distributorId, MoveKeysLock const& moveKeysLock, std::vector<Optional<Key>> const& remoteDcIds, const DDEnabledState* const& ddEnabledState, SkipDDModeCheck const& skipDDModeCheck ) {
															#line 283 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Reference<InitialDataDistribution>>(new GetInitialDataDistributionActor(cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck));
															#line 5656 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 549 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 5661 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitForDataDistributionEnabled()
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitForDataDistributionEnabledActor>
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForDataDistributionEnabledActorState {
															#line 5667 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForDataDistributionEnabledActorState(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 551 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 5678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	~WaitForDataDistributionEnabledActorState() 
	{
		fdb_probe_actor_destroy("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 552 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 5693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForDataDistributionEnabledActorState();
		static_cast<WaitForDataDistributionEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 553 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_ENABLED_CHECK_DELAY, TaskPriority::DataDistribution);
															#line 553 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5725 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 1;
															#line 553 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5730 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 556 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 557 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5743 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(dataDistributionModeKey);
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5749 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5754 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 556 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 557 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5773 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(dataDistributionModeKey);
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5779 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 560 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5784 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 580 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 580 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5883 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 3;
															#line 580 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5888 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> const& mode,int loopDepth) 
	{
															#line 561 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 5903 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 563 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5909 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForDataDistributionEnabledActorState();
			static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 565 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 5917 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 566 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 567 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 568 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 569 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "WaitForDDEnabled") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 572 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 5929 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 573 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 574 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5935 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitForDataDistributionEnabledActorState();
				static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 578 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 5944 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && mode,int loopDepth) 
	{
															#line 561 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 5953 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 563 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5959 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForDataDistributionEnabledActorState();
			static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 565 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 5967 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 566 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 567 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 568 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 569 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "WaitForDDEnabled") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 572 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 5979 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 573 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 574 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5985 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitForDataDistributionEnabledActorState();
				static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 578 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 5994 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 551 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 6180 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitForDataDistributionEnabled()
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForDataDistributionEnabledActor final : public Actor<Void>, public ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >, public ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >, public ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >, public FastAllocated<WaitForDataDistributionEnabledActor>, public WaitForDataDistributionEnabledActorState<WaitForDataDistributionEnabledActor> {
															#line 6185 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitForDataDistributionEnabledActor>::operator new;
	using FastAllocated<WaitForDataDistributionEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(228867328876331520UL, 17019334674448790272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >;
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >;
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >;
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForDataDistributionEnabledActor(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 6204 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForDataDistributionEnabledActorState<WaitForDataDistributionEnabledActor>(cx, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15564198525845133568UL, 7701605132217084160UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForDataDistributionEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitForDataDistributionEnabled( Database const& cx, const DDEnabledState* const& ddEnabledState ) {
															#line 550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitForDataDistributionEnabledActor(cx, ddEnabledState));
															#line 6238 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 584 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 6243 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via isDataDistributionEnabled()
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class IsDataDistributionEnabledActor>
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class IsDataDistributionEnabledActorState {
															#line 6249 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	IsDataDistributionEnabledActorState(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 586 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 6260 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	~IsDataDistributionEnabledActorState() 
	{
		fdb_probe_actor_destroy("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 587 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 6275 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 588 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 589 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 590 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 6309 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 593 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataDistributionModeKey);
															#line 593 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6315 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 1;
															#line 593 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6320 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 624 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 624 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6344 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 3;
															#line 624 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 2, Void >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6349 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& mode,int loopDepth) 
	{
															#line 594 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 6364 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 595 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6368 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 596 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 6376 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 597 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 598 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 599 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 600 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 6386 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 601 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 604 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6392 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
				this->~IsDataDistributionEnabledActorState();
				static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(moveKeysLockOwnerKey);
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6403 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6408 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && mode,int loopDepth) 
	{
															#line 594 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 6417 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 595 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6421 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 596 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 6429 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 597 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 598 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 599 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 600 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 6439 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 601 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 604 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6445 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
				this->~IsDataDistributionEnabledActorState();
				static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(moveKeysLockOwnerKey);
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6456 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 608 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6461 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 609 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 611 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ddEnabledState->isEnabled() && (currentOwner != dataDistributionModeLock))
															#line 6547 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 612 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 616 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6553 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 618 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, "IsDDEnabledFailed") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 622 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6563 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(false);
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && readVal,int loopDepth) 
	{
															#line 609 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 611 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ddEnabledState->isEnabled() && (currentOwner != dataDistributionModeLock))
															#line 6577 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 612 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 616 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6583 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 618 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, "IsDDEnabledFailed") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 622 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6593 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(false);
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 586 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 6769 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via isDataDistributionEnabled()
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class IsDataDistributionEnabledActor final : public Actor<bool>, public ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >, public ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >, public ActorCallback< IsDataDistributionEnabledActor, 2, Void >, public FastAllocated<IsDataDistributionEnabledActor>, public IsDataDistributionEnabledActorState<IsDataDistributionEnabledActor> {
															#line 6774 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<IsDataDistributionEnabledActor>::operator new;
	using FastAllocated<IsDataDistributionEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7406880644303085824UL, 6358168862153976832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >;
friend struct ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >;
friend struct ActorCallback< IsDataDistributionEnabledActor, 2, Void >;
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	IsDataDistributionEnabledActor(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 6793 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<bool>(),
		   IsDataDistributionEnabledActorState<IsDataDistributionEnabledActor>(cx, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10262884121966814464UL, 6357713925423661312UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isDataDistributionEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<bool> isDataDistributionEnabled( Database const& cx, const DDEnabledState* const& ddEnabledState ) {
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<bool>(new IsDataDistributionEnabledActor(cx, ddEnabledState));
															#line 6827 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 628 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 6832 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via pollMoveKeysLock()
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class PollMoveKeysLockActor>
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class PollMoveKeysLockActorState {
															#line 6838 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	PollMoveKeysLockActorState(Database const& cx,MoveKeysLock const& lock,const DDEnabledState* const& ddEnabledState) 
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   lock(lock),
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState)
															#line 6849 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("pollMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~PollMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("pollMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 630 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 6864 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PollMoveKeysLockActorState();
		static_cast<PollMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 631 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->MOVEKEYS_LOCK_POLLING_DELAY);
															#line 631 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6896 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 631 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 0, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 6901 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 632 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr = Transaction(cx);
															#line 633 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 6912 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 632 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr = Transaction(cx);
															#line 633 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 6923 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 634 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 635 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 636 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 7024 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 638 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLockReadOnly(&tr, lock, ddEnabledState);
															#line 638 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7030 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 638 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 1, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 7035 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 641 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 641 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7072 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 3;
															#line 641 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 2, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 7077 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysLock lock;
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 632 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 7270 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via pollMoveKeysLock()
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class PollMoveKeysLockActor final : public Actor<Void>, public ActorCallback< PollMoveKeysLockActor, 0, Void >, public ActorCallback< PollMoveKeysLockActor, 1, Void >, public ActorCallback< PollMoveKeysLockActor, 2, Void >, public FastAllocated<PollMoveKeysLockActor>, public PollMoveKeysLockActorState<PollMoveKeysLockActor> {
															#line 7275 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<PollMoveKeysLockActor>::operator new;
	using FastAllocated<PollMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7125112534864977664UL, 963899972757925376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PollMoveKeysLockActor, 0, Void >;
friend struct ActorCallback< PollMoveKeysLockActor, 1, Void >;
friend struct ActorCallback< PollMoveKeysLockActor, 2, Void >;
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	PollMoveKeysLockActor(Database const& cx,MoveKeysLock const& lock,const DDEnabledState* const& ddEnabledState) 
															#line 7294 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   PollMoveKeysLockActorState<PollMoveKeysLockActor>(cx, lock, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1354989846012357376UL, 3295455225436393472UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pollMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> pollMoveKeysLock( Database const& cx, MoveKeysLock const& lock, const DDEnabledState* const& ddEnabledState ) {
															#line 629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new PollMoveKeysLockActor(cx, lock, ddEnabledState));
															#line 7328 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 646 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 7333 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via readRebalanceDDIgnoreKey()
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class ReadRebalanceDDIgnoreKeyActor>
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class ReadRebalanceDDIgnoreKeyActorState {
															#line 7339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadRebalanceDDIgnoreKeyActorState(Database const& cx) 
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 648 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 7348 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this));

	}
	~ReadRebalanceDDIgnoreKeyActorState() 
	{
		fdb_probe_actor_destroy("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 649 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 7363 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 651 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 652 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 653 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 655 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(rebalanceDDIgnoreKey);
															#line 655 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7402 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 1;
															#line 655 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*>(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)));
															#line 7407 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 658 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 658 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7431 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 2;
															#line 658 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*>(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)));
															#line 7436 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res,int loopDepth) 
	{
															#line 656 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadRebalanceDDIgnoreKeyActorState(); static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->destroy(); return 0; }
															#line 7451 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(res);
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res,int loopDepth) 
	{
															#line 656 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadRebalanceDDIgnoreKeyActorState(); static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->destroy(); return 0; }
															#line 7463 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(res);
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 648 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 7637 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via readRebalanceDDIgnoreKey()
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class ReadRebalanceDDIgnoreKeyActor final : public Actor<Optional<Value>>, public ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >, public ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >, public FastAllocated<ReadRebalanceDDIgnoreKeyActor>, public ReadRebalanceDDIgnoreKeyActorState<ReadRebalanceDDIgnoreKeyActor> {
															#line 7642 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<ReadRebalanceDDIgnoreKeyActor>::operator new;
	using FastAllocated<ReadRebalanceDDIgnoreKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11682847562153528832UL, 14461237334667164928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >;
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadRebalanceDDIgnoreKeyActor(Database const& cx) 
															#line 7660 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   ReadRebalanceDDIgnoreKeyActorState<ReadRebalanceDDIgnoreKeyActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11304031174234803712UL, 14849188401685608704UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRebalanceDDIgnoreKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> readRebalanceDDIgnoreKey( Database const& cx ) {
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Optional<Value>>(new ReadRebalanceDDIgnoreKeyActor(cx));
															#line 7693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 662 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 7698 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitDDTeamInfoPrintSignal()
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitDDTeamInfoPrintSignalActor>
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitDDTeamInfoPrintSignalActorState {
															#line 7704 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitDDTeamInfoPrintSignalActorState(Database const& cx) 
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 664 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 7713 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this));

	}
	~WaitDDTeamInfoPrintSignalActorState() 
	{
		fdb_probe_actor_destroy("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 665 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 7728 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 667 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 668 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			watchFuture = tr.watch(triggerDDTeamInfoPrintKey);
															#line 669 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 669 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7765 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 1;
															#line 669 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7770 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 673 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 673 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7794 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 3;
															#line 673 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7799 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watchFuture;
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7816 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 2;
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7821 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watchFuture;
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7832 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 2;
															#line 670 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7837 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 671 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitDDTeamInfoPrintSignalActorState(); static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->destroy(); return 0; }
															#line 7921 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 671 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitDDTeamInfoPrintSignalActorState(); static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->destroy(); return 0; }
															#line 7933 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 664 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 668 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<Void> watchFuture;
															#line 8109 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitDDTeamInfoPrintSignal()
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitDDTeamInfoPrintSignalActor final : public Actor<Void>, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >, public FastAllocated<WaitDDTeamInfoPrintSignalActor>, public WaitDDTeamInfoPrintSignalActorState<WaitDDTeamInfoPrintSignalActor> {
															#line 8114 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitDDTeamInfoPrintSignalActor>::operator new;
	using FastAllocated<WaitDDTeamInfoPrintSignalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8577578491174248960UL, 14021380964975290112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >;
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >;
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >;
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitDDTeamInfoPrintSignalActor(Database const& cx) 
															#line 8133 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitDDTeamInfoPrintSignalActorState<WaitDDTeamInfoPrintSignalActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9369237719149148416UL, 5611890522281058048UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitDDTeamInfoPrintSignal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitDDTeamInfoPrintSignal( Database const& cx ) {
															#line 663 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitDDTeamInfoPrintSignalActor(cx));
															#line 8167 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 677 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 8172 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitForAllDataRemoved()
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitForAllDataRemovedActor>
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForAllDataRemovedActorState {
															#line 8178 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForAllDataRemovedActorState(Database const& cx,UID const& serverID,Version const& addedVersion,Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure) 
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   serverID(serverID),
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   addedVersion(addedVersion),
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   shardsAffectedByTeamFailure(shardsAffectedByTeamFailure),
															#line 683 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 8193 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this));

	}
	~WaitForAllDataRemovedActorState() 
	{
		fdb_probe_actor_destroy("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 684 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 8208 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForAllDataRemovedActorState();
		static_cast<WaitForAllDataRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 686 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 687 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 688 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 688 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8245 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 1;
															#line 688 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 0, Version >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8250 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 709 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 709 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8274 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 4;
															#line 709 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 3, Void >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8279 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& ver,int loopDepth) 
	{
															#line 692 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ver > addedVersion + SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 8294 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<bool> __when_expr_1 = canRemoveStorageServer(tr, serverID);
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8300 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 2;
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 1, bool >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8305 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && ver,int loopDepth) 
	{
															#line 692 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ver > addedVersion + SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 8319 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<bool> __when_expr_1 = canRemoveStorageServer(tr, serverID);
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8325 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 2;
															#line 693 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 1, bool >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8330 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 706 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->ALL_DATA_REMOVED_DELAY, TaskPriority::DataDistribution);
															#line 706 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8421 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 3;
															#line 706 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 2, Void >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8426 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool const& canRemove,int loopDepth) 
	{
															#line 694 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto shards = shardsAffectedByTeamFailure->getNumberOfShards(serverID);
															#line 695 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevVerbose, "WaitForAllDataRemoved") .detail("Server", serverID) .detail("CanRemove", canRemove) .detail("Shards", shards);
															#line 699 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GE(shards, 0);
															#line 700 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (canRemove && shards == 0)
															#line 8441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 701 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForAllDataRemovedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllDataRemovedActorState(); static_cast<WaitForAllDataRemovedActor*>(this)->destroy(); return 0; }
															#line 8445 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForAllDataRemovedActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllDataRemovedActorState();
			static_cast<WaitForAllDataRemovedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool && canRemove,int loopDepth) 
	{
															#line 694 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto shards = shardsAffectedByTeamFailure->getNumberOfShards(serverID);
															#line 695 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevVerbose, "WaitForAllDataRemoved") .detail("Server", serverID) .detail("CanRemove", canRemove) .detail("Shards", shards);
															#line 699 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GE(shards, 0);
															#line 700 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (canRemove && shards == 0)
															#line 8465 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 701 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForAllDataRemovedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllDataRemovedActorState(); static_cast<WaitForAllDataRemovedActor*>(this)->destroy(); return 0; }
															#line 8469 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForAllDataRemovedActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllDataRemovedActorState();
			static_cast<WaitForAllDataRemovedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool const& canRemove,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(canRemove, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool && canRemove,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(canRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr->reset();
															#line 8558 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr->reset();
															#line 8567 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UID serverID;
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Version addedVersion;
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure;
															#line 683 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 8757 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitForAllDataRemoved()
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForAllDataRemovedActor final : public Actor<Void>, public ActorCallback< WaitForAllDataRemovedActor, 0, Version >, public ActorCallback< WaitForAllDataRemovedActor, 1, bool >, public ActorCallback< WaitForAllDataRemovedActor, 2, Void >, public ActorCallback< WaitForAllDataRemovedActor, 3, Void >, public FastAllocated<WaitForAllDataRemovedActor>, public WaitForAllDataRemovedActorState<WaitForAllDataRemovedActor> {
															#line 8762 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitForAllDataRemovedActor>::operator new;
	using FastAllocated<WaitForAllDataRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3559868296242198528UL, 1731360509036507392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForAllDataRemovedActor, 0, Version >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 1, bool >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 2, Void >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 3, Void >;
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForAllDataRemovedActor(Database const& cx,UID const& serverID,Version const& addedVersion,Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure) 
															#line 8782 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForAllDataRemovedActorState<WaitForAllDataRemovedActor>(cx, serverID, addedVersion, shardsAffectedByTeamFailure),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4895686793057212672UL, 12269977046920561920UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForAllDataRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitForAllDataRemoved( Database const& cx, UID const& serverID, Version const& addedVersion, Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure ) {
															#line 678 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitForAllDataRemovedActor(cx, serverID, addedVersion, shardsAffectedByTeamFailure));
															#line 8817 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 713 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
};

Future<Void> DDTxnProcessor::waitForAllDataRemoved(
    const UID& serverID,
    const Version& addedVersion,
    Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure) const {
	return DDTxnProcessorImpl::waitForAllDataRemoved(cx, serverID, addedVersion, shardsAffectedByTeamFailure);
}

Future<IDDTxnProcessor::SourceServers> DDTxnProcessor::getSourceServersForRange(const KeyRangeRef range) {
	return DDTxnProcessorImpl::getSourceServersForRange(cx, range);
}

Future<std::vector<IDDTxnProcessor::DDRangeLocations>> DDTxnProcessor::getSourceServerInterfacesForRange(
    const KeyRangeRef range) {
	return DDTxnProcessorImpl::getSourceServerInterfacesForRange(cx, range);
}

Future<ServerWorkerInfos> DDTxnProcessor::getServerListAndProcessClasses() {
	return DDTxnProcessorImpl::getServerListAndProcessClasses(cx);
}

Future<MoveKeysLock> DDTxnProcessor::takeMoveKeysLock(const UID& ddId) const {
	return ::takeMoveKeysLock(cx, ddId);
}

Future<DatabaseConfiguration> DDTxnProcessor::getDatabaseConfiguration() const {
	return ::getDatabaseConfiguration(cx);
}

Future<Void> DDTxnProcessor::updateReplicaKeys(const std::vector<Optional<Key>>& primaryIds,
                                               const std::vector<Optional<Key>>& remoteIds,
                                               const DatabaseConfiguration& configuration) const {
	return DDTxnProcessorImpl::updateReplicaKeys(cx, primaryIds, remoteIds, configuration);
}

Future<Reference<InitialDataDistribution>> DDTxnProcessor::getInitialDataDistribution(
    const UID& distributorId,
    const MoveKeysLock& moveKeysLock,
    const std::vector<Optional<Key>>& remoteDcIds,
    const DDEnabledState* ddEnabledState,
    SkipDDModeCheck skipDDModeCheck) {
	return DDTxnProcessorImpl::getInitialDataDistribution(
	    cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck);
}

Future<Void> DDTxnProcessor::waitForDataDistributionEnabled(const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::waitForDataDistributionEnabled(cx, ddEnabledState);
}

Future<bool> DDTxnProcessor::isDataDistributionEnabled(const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::isDataDistributionEnabled(cx, ddEnabledState);
}

Future<Void> DDTxnProcessor::pollMoveKeysLock(const MoveKeysLock& lock, const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::pollMoveKeysLock(cx, lock, ddEnabledState);
}

Future<std::pair<Optional<StorageMetrics>, int>> DDTxnProcessor::waitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& min,
    const StorageMetrics& max,
    const StorageMetrics& permittedError,
    int shardLimit,
    int expectedShardCount) const {
	return cx->waitStorageMetrics(keys, min, max, permittedError, shardLimit, expectedShardCount);
}

Future<Standalone<VectorRef<KeyRef>>> DDTxnProcessor::splitStorageMetrics(const KeyRange& keys,
                                                                          const StorageMetrics& limit,
                                                                          const StorageMetrics& estimated,
                                                                          const Optional<int>& minSplitBytes) const {
	return cx->splitStorageMetrics(keys, limit, estimated, minSplitBytes);
}

Future<Standalone<VectorRef<ReadHotRangeWithMetrics>>> DDTxnProcessor::getReadHotRanges(const KeyRange& keys) const {
	return cx->getReadHotRanges(keys);
}

Future<HealthMetrics> DDTxnProcessor::getHealthMetrics(bool detailed) const {
	return cx->getHealthMetrics(detailed);
}

Future<Optional<Value>> DDTxnProcessor::readRebalanceDDIgnoreKey() const {
	return DDTxnProcessorImpl::readRebalanceDDIgnoreKey(cx);
}

Future<int> DDTxnProcessor::tryUpdateReplicasKeyForDc(const Optional<Key>& dcId, const int& storageTeamSize) const {
	return DDTxnProcessorImpl::tryUpdateReplicasKeyForDc(cx, dcId, storageTeamSize);
}

Future<Void> DDTxnProcessor::waitDDTeamInfoPrintSignal() const {
	return DDTxnProcessorImpl::waitDDTeamInfoPrintSignal(cx);
}

Future<std::vector<ProcessData>> DDTxnProcessor::getWorkers() const {
	return ::getWorkers(cx);
}

Future<Void> DDTxnProcessor::rawStartMovement(const MoveKeysParams& params,
                                              std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawStartMovement(cx, params, tssMapping);
}

Future<Void> DDTxnProcessor::rawFinishMovement(const MoveKeysParams& params,
                                               const std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawFinishMovement(cx, params, tssMapping);
}

struct DDMockTxnProcessorImpl {
	// return when all status become FETCHED
																#line 8932 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via checkFetchingState()
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class CheckFetchingStateActor>
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class CheckFetchingStateActorState {
															#line 8938 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	CheckFetchingStateActorState(DDMockTxnProcessor* const& self,std::vector<UID> const& ids,KeyRangeRef const& range) 
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : self(self),
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ids(ids),
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   range(range),
															#line 825 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("MockCheckFetchingState")
															#line 8951 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	~CheckFetchingStateActorState() 
	{
		fdb_probe_actor_destroy("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 826 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Range", range);
															#line 827 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 8968 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 841 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end()).log();
															#line 842 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<CheckFetchingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFetchingStateActorState(); static_cast<CheckFetchingStateActor*>(this)->destroy(); return 0; }
															#line 8993 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<CheckFetchingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 828 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(1.0, TaskPriority::FetchKeys);
															#line 828 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9014 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 1;
															#line 828 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 0, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 9019 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 829 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		bool done = true;
															#line 830 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : ids ) {
															#line 831 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = self->mgs->allServers.at(id);
															#line 832 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!server->allShardStatusIn(range, { MockShardStatus::FETCHED, MockShardStatus::COMPLETED }))
															#line 9047 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 833 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				done = false;
															#line 9051 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				break;
			}
		}
															#line 837 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (done)
															#line 9057 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 829 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		bool done = true;
															#line 830 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : ids ) {
															#line 831 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = self->mgs->allServers.at(id);
															#line 832 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!server->allShardStatusIn(range, { MockShardStatus::FETCHED, MockShardStatus::COMPLETED }))
															#line 9075 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 833 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				done = false;
															#line 9079 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				break;
			}
		}
															#line 837 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (done)
															#line 9085 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DDMockTxnProcessor* self;
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> ids;
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef range;
															#line 825 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 9176 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via checkFetchingState()
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class CheckFetchingStateActor final : public Actor<Void>, public ActorCallback< CheckFetchingStateActor, 0, Void >, public FastAllocated<CheckFetchingStateActor>, public CheckFetchingStateActorState<CheckFetchingStateActor> {
															#line 9181 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<CheckFetchingStateActor>::operator new;
	using FastAllocated<CheckFetchingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15157045919041914880UL, 743276882445894656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFetchingStateActor, 0, Void >;
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	CheckFetchingStateActor(DDMockTxnProcessor* const& self,std::vector<UID> const& ids,KeyRangeRef const& range) 
															#line 9198 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFetchingStateActorState<CheckFetchingStateActor>(self, ids, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13605890424979058688UL, 18070830385337103360UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFetchingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> checkFetchingState( DDMockTxnProcessor* const& self, std::vector<UID> const& ids, KeyRangeRef const& range ) {
															#line 824 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new CheckFetchingStateActor(self, ids, range));
															#line 9230 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 844 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	static Future<Void> rawCheckFetchingState(DDMockTxnProcessor* self, const MoveKeysParams& params) {
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA) {
			ASSERT(params.ranges.present());
			// TODO: make startMoveShards work with multiple ranges.
			ASSERT(params.ranges.get().size() == 1);
			return checkFetchingState(self, params.destinationTeam, params.ranges.get().at(0));
		}
		ASSERT(params.keys.present());
		return checkFetchingState(self, params.destinationTeam, params.keys.get());
	}

																#line 9246 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via moveKeys()
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class MoveKeysActor>
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class MoveKeysActorState {
															#line 9252 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysActorState(DDMockTxnProcessor* const& self,MoveKeysParams const& params) 
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : self(self),
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 857 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping()
															#line 9263 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("moveKeys", reinterpret_cast<unsigned long>(this));

	}
	~MoveKeysActorState() 
	{
		fdb_probe_actor_destroy("moveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 859 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(params.destinationTeam.begin(), params.destinationTeam.end());
															#line 860 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(params.healthyDestinations.begin(), params.healthyDestinations.end());
															#line 862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->rawStartMovement(params, tssMapping);
															#line 862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9284 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveKeysActor*>(this)->actor_wait_state = 1;
															#line 862 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 0, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9289 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 863 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(tssMapping.empty());
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = rawCheckFetchingState(self, params);
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9316 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 2;
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 1, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9321 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 863 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(tssMapping.empty());
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = rawCheckFetchingState(self, params);
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9334 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 2;
															#line 865 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 1, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9339 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->rawFinishMovement(params, tssMapping);
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9425 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 3;
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 2, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9430 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->rawFinishMovement(params, tssMapping);
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9441 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 3;
															#line 867 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 2, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9446 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 868 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!params.dataMovementComplete.isSet())
															#line 9530 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 869 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			params.dataMovementComplete.send(Void());
															#line 9534 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 870 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<MoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeysActorState(); static_cast<MoveKeysActor*>(this)->destroy(); return 0; }
															#line 9538 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<MoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 868 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!params.dataMovementComplete.isSet())
															#line 9550 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 869 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			params.dataMovementComplete.send(Void());
															#line 9554 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 870 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<MoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeysActorState(); static_cast<MoveKeysActor*>(this)->destroy(); return 0; }
															#line 9558 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<MoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DDMockTxnProcessor* self;
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 857 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 9647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via moveKeys()
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class MoveKeysActor final : public Actor<Void>, public ActorCallback< MoveKeysActor, 0, Void >, public ActorCallback< MoveKeysActor, 1, Void >, public ActorCallback< MoveKeysActor, 2, Void >, public FastAllocated<MoveKeysActor>, public MoveKeysActorState<MoveKeysActor> {
															#line 9652 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<MoveKeysActor>::operator new;
	using FastAllocated<MoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16691157780946204160UL, 13449715715942886656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveKeysActor, 0, Void >;
friend struct ActorCallback< MoveKeysActor, 1, Void >;
friend struct ActorCallback< MoveKeysActor, 2, Void >;
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysActor(DDMockTxnProcessor* const& self,MoveKeysParams const& params) 
															#line 9671 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   MoveKeysActorState<MoveKeysActor>(self, params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8336242837745545216UL, 15245897084024434688UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> moveKeys( DDMockTxnProcessor* const& self, MoveKeysParams const& params ) {
															#line 856 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new MoveKeysActor(self, params));
															#line 9705 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 872 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
};

Future<ServerWorkerInfos> DDMockTxnProcessor::getServerListAndProcessClasses() {
	ServerWorkerInfos res;
	for (auto& [_, mss] : mgs->allServers) {
		res.servers.emplace_back(mss->ssi, ProcessClass(ProcessClass::StorageClass, ProcessClass::DBSource));
	}
	// FIXME(xwang): possible generate version from time?
	res.readVersion = 0;
	return res;
}

std::pair<std::set<std::vector<UID>>, std::set<std::vector<UID>>> getAllTeamsInRegion(
    const std::vector<DDShardInfo>& shards) {
	std::set<std::vector<UID>> primary, remote;
	for (auto& info : shards) {
		if (!info.primarySrc.empty())
			primary.emplace(info.primarySrc);
		if (!info.primaryDest.empty())
			primary.emplace(info.primaryDest);
		if (!info.remoteSrc.empty())
			remote.emplace(info.remoteSrc);
		if (!info.remoteDest.empty())
			remote.emplace(info.remoteDest);
	}
	return { primary, remote };
}

inline void transformTeamsToServerIds(std::vector<ShardsAffectedByTeamFailure::Team>& teams,
                                      std::vector<UID>& primaryIds,
                                      std::vector<UID>& remoteIds) {
	std::set<UID> primary, remote;
	for (auto& team : teams) {
		team.primary ? primary.insert(team.servers.begin(), team.servers.end())
		             : remote.insert(team.servers.begin(), team.servers.end());
	}
	primaryIds = std::vector<UID>(primary.begin(), primary.end());
	remoteIds = std::vector<UID>(remote.begin(), remote.end());
}

// reconstruct DDShardInfos from shardMapping
std::vector<DDShardInfo> DDMockTxnProcessor::getDDShardInfos() const {
	std::vector<DDShardInfo> res;
	res.reserve(mgs->shardMapping->getNumberOfShards());
	auto allRange = mgs->shardMapping->getAllRanges();
	ASSERT(allRange.end().begin() == allKeys.end);
	for (auto it = allRange.begin(); it != allRange.end(); ++it) {
		// FIXME: now just use anonymousShardId
		KeyRangeRef curRange = it->range();
		DDShardInfo info(curRange.begin);

		auto teams = mgs->shardMapping->getTeamsForFirstShard(curRange);
		if (!teams.first.empty() && !teams.second.empty()) {
			CODE_PROBE(true, "Mock InitialDataDistribution In-Flight shard");
			info.hasDest = true;
			info.destId = anonymousShardId;
			info.srcId = anonymousShardId;
			transformTeamsToServerIds(teams.second, info.primarySrc, info.remoteSrc);
			transformTeamsToServerIds(teams.first, info.primaryDest, info.remoteDest);
		} else if (!teams.first.empty()) {
			CODE_PROBE(true, "Mock InitialDataDistribution Static shard");
			info.srcId = anonymousShardId;
			transformTeamsToServerIds(teams.first, info.primarySrc, info.remoteSrc);
		} else {
			ASSERT(false);
		}

		res.push_back(std::move(info));
	}
	res.emplace_back(allKeys.end);

	return res;
}

Future<Reference<InitialDataDistribution>> DDMockTxnProcessor::getInitialDataDistribution(
    const UID& distributorId,
    const MoveKeysLock& moveKeysLock,
    const std::vector<Optional<Key>>& remoteDcIds,
    const DDEnabledState* ddEnabledState,
    SkipDDModeCheck skipDDModeCheck) {

	// FIXME: now we just ignore ddEnabledState and moveKeysLock, will fix it in the future
	Reference<InitialDataDistribution> res = makeReference<InitialDataDistribution>();
	res->mode = 1;
	res->allServers = getServerListAndProcessClasses().get().servers;
	res->shards = getDDShardInfos();
	std::tie(res->primaryTeams, res->remoteTeams) = getAllTeamsInRegion(res->shards);
	return res;
}

Future<Void> DDMockTxnProcessor::removeKeysFromFailedServer(const UID& serverID,
                                                            const std::vector<UID>& teamForDroppedRange,
                                                            const MoveKeysLock& lock,
                                                            const DDEnabledState* ddEnabledState) const {

	// This function only takes effect when user exclude failed IP:PORT in the fdbcli. In the first version , the mock
	// class won’t support this.
	UNREACHABLE();
}

Future<Void> DDMockTxnProcessor::removeStorageServer(const UID& serverID,
                                                     const Optional<UID>& tssPairID,
                                                     const MoveKeysLock& lock,
                                                     const DDEnabledState* ddEnabledState) const {
	ASSERT(mgs->allShardsRemovedFromServer(serverID));
	mgs->allServers.erase(serverID);
	return Void();
}

void DDMockTxnProcessor::setupMockGlobalState(Reference<InitialDataDistribution> initData) {
	for (auto& [ssi, pInfo] : initData->allServers) {
		mgs->addStorageServer(ssi);
	}
	mgs->shardMapping->setCheckMode(ShardsAffectedByTeamFailure::CheckMode::ForceNoCheck);

	for (int i = 0; i < initData->shards.size() - 1; ++i) {
		// insert to keyServers
		auto& shardInfo = initData->shards[i];
		ASSERT(shardInfo.remoteSrc.empty() && shardInfo.remoteDest.empty());

		uint64_t shardBytes =
		    deterministicRandom()->randomInt(SERVER_KNOBS->MIN_SHARD_BYTES, SERVER_KNOBS->MAX_SHARD_BYTES);
		KeyRangeRef keys(shardInfo.key, initData->shards[i + 1].key);
		mgs->shardMapping->assignRangeToTeams(keys, { { shardInfo.primarySrc, true } });
		if (shardInfo.hasDest) {
			mgs->shardMapping->moveShard(keys, { { shardInfo.primaryDest, true } });
		}
		// insert to serverKeys
		for (auto& id : shardInfo.primarySrc) {
			mgs->allServers.at(id)->serverKeys.insert(keys, { MockShardStatus::COMPLETED, shardBytes });
		}
		for (auto& id : shardInfo.primaryDest) {
			mgs->allServers.at(id)->serverKeys.insert(keys, { MockShardStatus::INFLIGHT, shardBytes });
		}
	}

	mgs->shardMapping->setCheckMode(ShardsAffectedByTeamFailure::CheckMode::Normal);
}

Future<Void> DDMockTxnProcessor::moveKeys(const MoveKeysParams& params) {
	// Not support location metadata yet
	ASSERT(!SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	return DDMockTxnProcessorImpl::moveKeys(this, params);
}

// FIXME: finish implementation
Future<HealthMetrics> DDMockTxnProcessor::getHealthMetrics(bool detailed) const {
	return Future<HealthMetrics>();
}

Future<Standalone<VectorRef<KeyRef>>> DDMockTxnProcessor::splitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& limit,
    const StorageMetrics& estimated,
    const Optional<int>& minSplitBytes) const {
	return mgs->splitStorageMetrics(keys, limit, estimated, minSplitBytes);
}

Future<std::pair<Optional<StorageMetrics>, int>> DDMockTxnProcessor::waitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& min,
    const StorageMetrics& max,
    const StorageMetrics& permittedError,
    int shardLimit,
    int expectedShardCount) const {
	return mgs->waitStorageMetrics(keys, min, max, permittedError, shardLimit, expectedShardCount);
}

// FIXME: finish implementation
Future<std::vector<ProcessData>> DDMockTxnProcessor::getWorkers() const {
	return Future<std::vector<ProcessData>>();
}

															#line 9882 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
namespace {
// This generated class is to be used only via rawStartMovement()
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class RawStartMovementActor>
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawStartMovementActorState {
															#line 9889 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawStartMovementActorState(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : mgs(mgs),
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping(tssMapping),
															#line 1048 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("RelocateShard_MockStartMoveKeys"),
															#line 1049 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys()
															#line 9904 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("rawStartMovement", reinterpret_cast<unsigned long>(this));

	}
	~RawStartMovementActorState() 
	{
		fdb_probe_actor_destroy("rawStartMovement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1050 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 9919 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1051 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.present());
															#line 1053 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.get().size() == 1);
															#line 1054 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.ranges.get().at(0);
															#line 9927 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 1056 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.keys.present());
															#line 1057 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.keys.get();
															#line 9935 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 1059 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Keys", keys);
															#line 1060 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = params.startMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1060 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<RawStartMovementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9943 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RawStartMovementActor*>(this)->actor_wait_state = 1;
															#line 1060 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RawStartMovementActor, 0, Void >*>(static_cast<RawStartMovementActor*>(this)));
															#line 9948 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.startMoveKeysParallelismLock);
															#line 1063 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<ShardsAffectedByTeamFailure::Team> destTeams;
															#line 1064 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		destTeams.emplace_back(params.destinationTeam, true);
															#line 1067 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1069 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (intersectRanges.begin().range().contains(keys))
															#line 9979 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1070 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->defineShard(keys);
															#line 9983 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1073 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1074 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		fmt::print("Keys: {}; intersect: {} {}\n", keys.toString(), intersectRanges.begin().begin(), intersectRanges.end().begin());
															#line 1082 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		int totalRangeSize = 0;
															#line 1083 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto it = intersectRanges.begin();it != intersectRanges.end();++it) {
															#line 1084 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto teamPair = mgs->shardMapping->getTeamsFor(it->begin());
															#line 1085 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& srcTeams = teamPair.second.empty() ? teamPair.first : teamPair.second;
															#line 1086 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			totalRangeSize += mgs->getRangeSize(it->range());
															#line 1087 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->rawMoveShard(it->range(), srcTeams, destTeams);
															#line 10001 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1090 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1091 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = mgs->allServers.at(id);
															#line 1092 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::INFLIGHT);
															#line 1093 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->signalFetchKeys(keys, totalRangeSize);
															#line 10011 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1095 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1096 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawStartMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawStartMovementActorState(); static_cast<RawStartMovementActor*>(this)->destroy(); return 0; }
															#line 10017 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawStartMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.startMoveKeysParallelismLock);
															#line 1063 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<ShardsAffectedByTeamFailure::Team> destTeams;
															#line 1064 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		destTeams.emplace_back(params.destinationTeam, true);
															#line 1067 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1069 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (intersectRanges.begin().range().contains(keys))
															#line 10037 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1070 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->defineShard(keys);
															#line 10041 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1073 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1074 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		fmt::print("Keys: {}; intersect: {} {}\n", keys.toString(), intersectRanges.begin().begin(), intersectRanges.end().begin());
															#line 1082 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		int totalRangeSize = 0;
															#line 1083 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto it = intersectRanges.begin();it != intersectRanges.end();++it) {
															#line 1084 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto teamPair = mgs->shardMapping->getTeamsFor(it->begin());
															#line 1085 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& srcTeams = teamPair.second.empty() ? teamPair.first : teamPair.second;
															#line 1086 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			totalRangeSize += mgs->getRangeSize(it->range());
															#line 1087 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->rawMoveShard(it->range(), srcTeams, destTeams);
															#line 10059 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1090 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1091 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = mgs->allServers.at(id);
															#line 1092 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::INFLIGHT);
															#line 1093 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->signalFetchKeys(keys, totalRangeSize);
															#line 10069 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1095 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1096 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawStartMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawStartMovementActorState(); static_cast<RawStartMovementActor*>(this)->destroy(); return 0; }
															#line 10075 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawStartMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RawStartMovementActor*>(this)->actor_wait_state > 0) static_cast<RawStartMovementActor*>(this)->actor_wait_state = 0;
		static_cast<RawStartMovementActor*>(this)->ActorCallback< RawStartMovementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RawStartMovementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RawStartMovementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RawStartMovementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1048 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 1049 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRange keys;
															#line 1061 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	FlowLock::Releaser releaser;
															#line 10170 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via rawStartMovement()
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawStartMovementActor final : public Actor<Void>, public ActorCallback< RawStartMovementActor, 0, Void >, public FastAllocated<RawStartMovementActor>, public RawStartMovementActorState<RawStartMovementActor> {
															#line 10175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<RawStartMovementActor>::operator new;
	using FastAllocated<RawStartMovementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18109619889630115072UL, 8397153377106375936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RawStartMovementActor, 0, Void >;
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawStartMovementActor(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 10192 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   RawStartMovementActorState<RawStartMovementActor>(mgs, params, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11716611356202757888UL, 6335144292502135552UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rawStartMovement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RawStartMovementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] Future<Void> rawStartMovement( std::shared_ptr<MockGlobalState> const& mgs, MoveKeysParams const& params, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1045 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new RawStartMovementActor(mgs, params, tssMapping));
															#line 10225 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 1098 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

Future<Void> DDMockTxnProcessor::rawStartMovement(const MoveKeysParams& params,
                                                  std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawStartMovement(mgs, params, tssMapping);
}

															#line 10235 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
namespace {
// This generated class is to be used only via rawFinishMovement()
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class RawFinishMovementActor>
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawFinishMovementActorState {
															#line 10242 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawFinishMovementActorState(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : mgs(mgs),
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping(tssMapping),
															#line 1107 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("RelocateShard_MockFinishMoveKeys"),
															#line 1108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys()
															#line 10257 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("rawFinishMovement", reinterpret_cast<unsigned long>(this));

	}
	~RawFinishMovementActorState() 
	{
		fdb_probe_actor_destroy("rawFinishMovement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1109 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 10272 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1110 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.present());
															#line 1112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.get().size() == 1);
															#line 1113 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.ranges.get().at(0);
															#line 10280 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 1115 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.keys.present());
															#line 1116 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.keys.get();
															#line 10288 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 1119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Keys", keys);
															#line 1121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = params.finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<RawFinishMovementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10296 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RawFinishMovementActor*>(this)->actor_wait_state = 1;
															#line 1121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RawFinishMovementActor, 0, Void >*>(static_cast<RawFinishMovementActor*>(this)));
															#line 10301 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.finishMoveKeysParallelismLock);
															#line 1125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto [destTeams, srcTeams] = mgs->shardMapping->getTeamsForFirstShard(keys);
															#line 1127 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(destTeams.size(), 1);
															#line 1128 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (destTeams.front() != ShardsAffectedByTeamFailure::Team{ params.destinationTeam, true })
															#line 10330 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevError, "MockRawFinishMovementError") .detail("Reason", "InconsistentDestinations") .detail("ShardMappingDest", describe(destTeams.front().servers)) .detail("ParamDest", describe(params.destinationTeam));
															#line 1133 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(false);
															#line 10336 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1136 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto server = mgs->allServers.at(id);
															#line 1138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::COMPLETED);
															#line 1139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->coalesceCompletedRange(keys);
															#line 10346 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(srcTeams.size(), 1);
															#line 1144 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : srcTeams.front().servers ) {
															#line 1146 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!std::binary_search(params.destinationTeam.begin(), params.destinationTeam.end(), id))
															#line 10354 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1147 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				mgs->allServers.at(id)->removeShard(keys);
															#line 10358 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 1150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->finishMove(keys);
															#line 1151 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->defineShard(keys);
															#line 1152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawFinishMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawFinishMovementActorState(); static_cast<RawFinishMovementActor*>(this)->destroy(); return 0; }
															#line 10369 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawFinishMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.finishMoveKeysParallelismLock);
															#line 1125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto [destTeams, srcTeams] = mgs->shardMapping->getTeamsForFirstShard(keys);
															#line 1127 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(destTeams.size(), 1);
															#line 1128 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (destTeams.front() != ShardsAffectedByTeamFailure::Team{ params.destinationTeam, true })
															#line 10387 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevError, "MockRawFinishMovementError") .detail("Reason", "InconsistentDestinations") .detail("ShardMappingDest", describe(destTeams.front().servers)) .detail("ParamDest", describe(params.destinationTeam));
															#line 1133 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(false);
															#line 10393 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1136 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto server = mgs->allServers.at(id);
															#line 1138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::COMPLETED);
															#line 1139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->coalesceCompletedRange(keys);
															#line 10403 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(srcTeams.size(), 1);
															#line 1144 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : srcTeams.front().servers ) {
															#line 1146 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!std::binary_search(params.destinationTeam.begin(), params.destinationTeam.end(), id))
															#line 10411 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1147 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				mgs->allServers.at(id)->removeShard(keys);
															#line 10415 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 1150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->finishMove(keys);
															#line 1151 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->defineShard(keys);
															#line 1152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawFinishMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawFinishMovementActorState(); static_cast<RawFinishMovementActor*>(this)->destroy(); return 0; }
															#line 10426 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawFinishMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RawFinishMovementActor*>(this)->actor_wait_state > 0) static_cast<RawFinishMovementActor*>(this)->actor_wait_state = 0;
		static_cast<RawFinishMovementActor*>(this)->ActorCallback< RawFinishMovementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RawFinishMovementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RawFinishMovementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RawFinishMovementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1107 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 1108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRange keys;
															#line 1122 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	FlowLock::Releaser releaser;
															#line 10521 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via rawFinishMovement()
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawFinishMovementActor final : public Actor<Void>, public ActorCallback< RawFinishMovementActor, 0, Void >, public FastAllocated<RawFinishMovementActor>, public RawFinishMovementActorState<RawFinishMovementActor> {
															#line 10526 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<RawFinishMovementActor>::operator new;
	using FastAllocated<RawFinishMovementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11432110594865432064UL, 6098244670353948160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RawFinishMovementActor, 0, Void >;
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawFinishMovementActor(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 10543 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   RawFinishMovementActorState<RawFinishMovementActor>(mgs, params, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13532843008458784768UL, 10632593791075846656UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rawFinishMovement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RawFinishMovementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] Future<Void> rawFinishMovement( std::shared_ptr<MockGlobalState> const& mgs, MoveKeysParams const& params, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1104 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new RawFinishMovementActor(mgs, params, tssMapping));
															#line 10576 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 1155 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

Future<Void> DDMockTxnProcessor::rawFinishMovement(const MoveKeysParams& params,
                                                   const std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawFinishMovement(mgs, params, tssMapping);
}

Future<Optional<HealthMetrics::StorageStats>> DDTxnProcessor::getStorageStats(const UID& id,
                                                                              double maxStaleness) const {
	return cx->getStorageStats(id, maxStaleness);
}

Future<Optional<HealthMetrics::StorageStats>> DDMockTxnProcessor::getStorageStats(const UID& id,
                                                                                  double maxStaleness) const {
	auto it = mgs->allServers.find(id);
	if (it == mgs->allServers.end()) {
		return Optional<HealthMetrics::StorageStats>();
	}
	return Optional<HealthMetrics::StorageStats>(it->second->getStorageStats());
}

Future<DatabaseConfiguration> DDMockTxnProcessor::getDatabaseConfiguration() const {
	return mgs->configuration;
}

Future<IDDTxnProcessor::SourceServers> DDMockTxnProcessor::getSourceServersForRange(const KeyRangeRef keys) {
	std::set<UID> servers;
	std::vector<UID> completeSources;
	auto ranges = mgs->shardMapping->intersectingRanges(keys);
	int count = 0;
	for (auto it = ranges.begin(); it != ranges.end(); ++it, ++count) {
		auto sources = mgs->shardMapping->getSourceServerIdsFor(it->begin());
		ASSERT(!sources.empty());
		updateServersAndCompleteSources(servers, completeSources, count, sources);
	}
	ASSERT(!servers.empty());
	return IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources };
}

Future<Void> DDMockTxnProcessor::waitForAllDataRemoved(
    const UID& serverID,
    const Version& addedVersion,
    Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure) const {
	return checkUntil(
	    SERVER_KNOBS->ALL_DATA_REMOVED_DELAY,
	    [&, this]() -> bool {
		    return mgs->allShardsRemovedFromServer(serverID) &&
		           shardsAffectedByTeamFailure->getNumberOfShards(serverID) == 0;
	    },
	    TaskPriority::DataDistribution);
}
