﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/vpc-lattice/model/DeleteServiceNetworkResourceAssociationResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::VPCLattice::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DeleteServiceNetworkResourceAssociationResult::DeleteServiceNetworkResourceAssociationResult() : 
    m_status(ServiceNetworkResourceAssociationStatus::NOT_SET)
{
}

DeleteServiceNetworkResourceAssociationResult::DeleteServiceNetworkResourceAssociationResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
  : DeleteServiceNetworkResourceAssociationResult()
{
  *this = result;
}

DeleteServiceNetworkResourceAssociationResult& DeleteServiceNetworkResourceAssociationResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("arn"))
  {
    m_arn = jsonValue.GetString("arn");

  }

  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

  }

  if(jsonValue.ValueExists("status"))
  {
    m_status = ServiceNetworkResourceAssociationStatusMapper::GetServiceNetworkResourceAssociationStatusForName(jsonValue.GetString("status"));

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
