﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/vpc-lattice/model/CreateAccessLogSubscriptionRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::VPCLattice::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateAccessLogSubscriptionRequest::CreateAccessLogSubscriptionRequest() : 
    m_clientToken(Aws::Utils::UUID::PseudoRandomUUID()),
    m_clientTokenHasBeenSet(true),
    m_destinationArnHasBeenSet(false),
    m_resourceIdentifierHasBeenSet(false),
    m_serviceNetworkLogType(ServiceNetworkLogType::NOT_SET),
    m_serviceNetworkLogTypeHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

Aws::String CreateAccessLogSubscriptionRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_clientTokenHasBeenSet)
  {
   payload.WithString("clientToken", m_clientToken);

  }

  if(m_destinationArnHasBeenSet)
  {
   payload.WithString("destinationArn", m_destinationArn);

  }

  if(m_resourceIdentifierHasBeenSet)
  {
   payload.WithString("resourceIdentifier", m_resourceIdentifier);

  }

  if(m_serviceNetworkLogTypeHasBeenSet)
  {
   payload.WithString("serviceNetworkLogType", ServiceNetworkLogTypeMapper::GetNameForServiceNetworkLogType(m_serviceNetworkLogType));
  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("tags", std::move(tagsJsonMap));

  }

  return payload.View().WriteReadable();
}




