﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/AssetBundleImportJobDataSourceCredentialPair.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

AssetBundleImportJobDataSourceCredentialPair::AssetBundleImportJobDataSourceCredentialPair() : 
    m_usernameHasBeenSet(false),
    m_passwordHasBeenSet(false)
{
}

AssetBundleImportJobDataSourceCredentialPair::AssetBundleImportJobDataSourceCredentialPair(JsonView jsonValue)
  : AssetBundleImportJobDataSourceCredentialPair()
{
  *this = jsonValue;
}

AssetBundleImportJobDataSourceCredentialPair& AssetBundleImportJobDataSourceCredentialPair::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Username"))
  {
    m_username = jsonValue.GetString("Username");

    m_usernameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Password"))
  {
    m_password = jsonValue.GetString("Password");

    m_passwordHasBeenSet = true;
  }

  return *this;
}

JsonValue AssetBundleImportJobDataSourceCredentialPair::Jsonize() const
{
  JsonValue payload;

  if(m_usernameHasBeenSet)
  {
   payload.WithString("Username", m_username);

  }

  if(m_passwordHasBeenSet)
  {
   payload.WithString("Password", m_password);

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
