﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/medialive/model/AvailBlankingState.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaLive
  {
    namespace Model
    {
      namespace AvailBlankingStateMapper
      {

        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");
        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");


        AvailBlankingState GetAvailBlankingStateForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == DISABLED_HASH)
          {
            return AvailBlankingState::DISABLED;
          }
          else if (hashCode == ENABLED_HASH)
          {
            return AvailBlankingState::ENABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<AvailBlankingState>(hashCode);
          }

          return AvailBlankingState::NOT_SET;
        }

        Aws::String GetNameForAvailBlankingState(AvailBlankingState enumValue)
        {
          switch(enumValue)
          {
          case AvailBlankingState::NOT_SET:
            return {};
          case AvailBlankingState::DISABLED:
            return "DISABLED";
          case AvailBlankingState::ENABLED:
            return "ENABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace AvailBlankingStateMapper
    } // namespace Model
  } // namespace MediaLive
} // namespace Aws
