﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mailmanager/model/GetIngressPointRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

GetIngressPointRequest::GetIngressPointRequest() : 
    m_ingressPointIdHasBeenSet(false)
{
}

Aws::String GetIngressPointRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_ingressPointIdHasBeenSet)
  {
   payload.WithString("IngressPointId", m_ingressPointId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetIngressPointRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MailManagerSvc.GetIngressPoint"));
  return headers;

}




