﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mailmanager/model/DeliverToMailboxAction.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace MailManager
{
namespace Model
{

DeliverToMailboxAction::DeliverToMailboxAction() : 
    m_actionFailurePolicy(ActionFailurePolicy::NOT_SET),
    m_actionFailurePolicyHasBeenSet(false),
    m_mailboxArnHasBeenSet(false),
    m_roleArnHasBeenSet(false)
{
}

DeliverToMailboxAction::DeliverToMailboxAction(JsonView jsonValue)
  : DeliverToMailboxAction()
{
  *this = jsonValue;
}

DeliverToMailboxAction& DeliverToMailboxAction::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("ActionFailurePolicy"))
  {
    m_actionFailurePolicy = ActionFailurePolicyMapper::GetActionFailurePolicyForName(jsonValue.GetString("ActionFailurePolicy"));

    m_actionFailurePolicyHasBeenSet = true;
  }

  if(jsonValue.ValueExists("MailboxArn"))
  {
    m_mailboxArn = jsonValue.GetString("MailboxArn");

    m_mailboxArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("RoleArn"))
  {
    m_roleArn = jsonValue.GetString("RoleArn");

    m_roleArnHasBeenSet = true;
  }

  return *this;
}

JsonValue DeliverToMailboxAction::Jsonize() const
{
  JsonValue payload;

  if(m_actionFailurePolicyHasBeenSet)
  {
   payload.WithString("ActionFailurePolicy", ActionFailurePolicyMapper::GetNameForActionFailurePolicy(m_actionFailurePolicy));
  }

  if(m_mailboxArnHasBeenSet)
  {
   payload.WithString("MailboxArn", m_mailboxArn);

  }

  if(m_roleArnHasBeenSet)
  {
   payload.WithString("RoleArn", m_roleArn);

  }

  return payload;
}

} // namespace Model
} // namespace MailManager
} // namespace Aws
