﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/license-manager-user-subscriptions/model/CreateLicenseServerEndpointRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::LicenseManagerUserSubscriptions::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateLicenseServerEndpointRequest::CreateLicenseServerEndpointRequest() : 
    m_identityProviderArnHasBeenSet(false),
    m_licenseServerSettingsHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

Aws::String CreateLicenseServerEndpointRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_identityProviderArnHasBeenSet)
  {
   payload.WithString("IdentityProviderArn", m_identityProviderArn);

  }

  if(m_licenseServerSettingsHasBeenSet)
  {
   payload.WithObject("LicenseServerSettings", m_licenseServerSettings.Jsonize());

  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("Tags", std::move(tagsJsonMap));

  }

  return payload.View().WriteReadable();
}




