﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/kms/model/ListKeyRotationsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::KMS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListKeyRotationsResult::ListKeyRotationsResult() : 
    m_truncated(false)
{
}

ListKeyRotationsResult::ListKeyRotationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
  : ListKeyRotationsResult()
{
  *this = result;
}

ListKeyRotationsResult& ListKeyRotationsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("Rotations"))
  {
    Aws::Utils::Array<JsonView> rotationsJsonList = jsonValue.GetArray("Rotations");
    for(unsigned rotationsIndex = 0; rotationsIndex < rotationsJsonList.GetLength(); ++rotationsIndex)
    {
      m_rotations.push_back(rotationsJsonList[rotationsIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("NextMarker"))
  {
    m_nextMarker = jsonValue.GetString("NextMarker");

  }

  if(jsonValue.ValueExists("Truncated"))
  {
    m_truncated = jsonValue.GetBool("Truncated");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
