﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/iotfleetwise/model/CustomDecodingSignal.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace IoTFleetWise
{
namespace Model
{

CustomDecodingSignal::CustomDecodingSignal() : 
    m_idHasBeenSet(false)
{
}

CustomDecodingSignal::CustomDecodingSignal(JsonView jsonValue)
  : CustomDecodingSignal()
{
  *this = jsonValue;
}

CustomDecodingSignal& CustomDecodingSignal::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

    m_idHasBeenSet = true;
  }

  return *this;
}

JsonValue CustomDecodingSignal::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("id", m_id);

  }

  return payload;
}

} // namespace Model
} // namespace IoTFleetWise
} // namespace Aws
