﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/iot/model/AuthorizerStatus.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace IoT
  {
    namespace Model
    {
      namespace AuthorizerStatusMapper
      {

        static const int ACTIVE_HASH = HashingUtils::HashString("ACTIVE");
        static const int INACTIVE_HASH = HashingUtils::HashString("INACTIVE");


        AuthorizerStatus GetAuthorizerStatusForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ACTIVE_HASH)
          {
            return AuthorizerStatus::ACTIVE;
          }
          else if (hashCode == INACTIVE_HASH)
          {
            return AuthorizerStatus::INACTIVE;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<AuthorizerStatus>(hashCode);
          }

          return AuthorizerStatus::NOT_SET;
        }

        Aws::String GetNameForAuthorizerStatus(AuthorizerStatus enumValue)
        {
          switch(enumValue)
          {
          case AuthorizerStatus::NOT_SET:
            return {};
          case AuthorizerStatus::ACTIVE:
            return "ACTIVE";
          case AuthorizerStatus::INACTIVE:
            return "INACTIVE";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace AuthorizerStatusMapper
    } // namespace Model
  } // namespace IoT
} // namespace Aws
