﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/GrokClassifier.h>
#include <aws/glue/model/XMLClassifier.h>
#include <aws/glue/model/JsonClassifier.h>
#include <aws/glue/model/CsvClassifier.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{

  /**
   * <p>Classifiers are triggered during a crawl task. A classifier checks whether a
   * given file is in a format it can handle. If it is, the classifier creates a
   * schema in the form of a <code>StructType</code> object that matches that data
   * format.</p> <p>You can use the standard classifiers that Glue provides, or you
   * can write your own classifiers to best categorize your data sources and specify
   * the appropriate schemas to use for them. A classifier can be a <code>grok</code>
   * classifier, an <code>XML</code> classifier, a <code>JSON</code> classifier, or a
   * custom <code>CSV</code> classifier, as specified in one of the fields in the
   * <code>Classifier</code> object.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Classifier">AWS API
   * Reference</a></p>
   */
  class Classifier
  {
  public:
    AWS_GLUE_API Classifier();
    AWS_GLUE_API Classifier(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API Classifier& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A classifier that uses <code>grok</code>.</p>
     */
    inline const GrokClassifier& GetGrokClassifier() const{ return m_grokClassifier; }
    inline bool GrokClassifierHasBeenSet() const { return m_grokClassifierHasBeenSet; }
    inline void SetGrokClassifier(const GrokClassifier& value) { m_grokClassifierHasBeenSet = true; m_grokClassifier = value; }
    inline void SetGrokClassifier(GrokClassifier&& value) { m_grokClassifierHasBeenSet = true; m_grokClassifier = std::move(value); }
    inline Classifier& WithGrokClassifier(const GrokClassifier& value) { SetGrokClassifier(value); return *this;}
    inline Classifier& WithGrokClassifier(GrokClassifier&& value) { SetGrokClassifier(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A classifier for XML content.</p>
     */
    inline const XMLClassifier& GetXMLClassifier() const{ return m_xMLClassifier; }
    inline bool XMLClassifierHasBeenSet() const { return m_xMLClassifierHasBeenSet; }
    inline void SetXMLClassifier(const XMLClassifier& value) { m_xMLClassifierHasBeenSet = true; m_xMLClassifier = value; }
    inline void SetXMLClassifier(XMLClassifier&& value) { m_xMLClassifierHasBeenSet = true; m_xMLClassifier = std::move(value); }
    inline Classifier& WithXMLClassifier(const XMLClassifier& value) { SetXMLClassifier(value); return *this;}
    inline Classifier& WithXMLClassifier(XMLClassifier&& value) { SetXMLClassifier(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A classifier for JSON content.</p>
     */
    inline const JsonClassifier& GetJsonClassifier() const{ return m_jsonClassifier; }
    inline bool JsonClassifierHasBeenSet() const { return m_jsonClassifierHasBeenSet; }
    inline void SetJsonClassifier(const JsonClassifier& value) { m_jsonClassifierHasBeenSet = true; m_jsonClassifier = value; }
    inline void SetJsonClassifier(JsonClassifier&& value) { m_jsonClassifierHasBeenSet = true; m_jsonClassifier = std::move(value); }
    inline Classifier& WithJsonClassifier(const JsonClassifier& value) { SetJsonClassifier(value); return *this;}
    inline Classifier& WithJsonClassifier(JsonClassifier&& value) { SetJsonClassifier(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A classifier for comma-separated values (CSV).</p>
     */
    inline const CsvClassifier& GetCsvClassifier() const{ return m_csvClassifier; }
    inline bool CsvClassifierHasBeenSet() const { return m_csvClassifierHasBeenSet; }
    inline void SetCsvClassifier(const CsvClassifier& value) { m_csvClassifierHasBeenSet = true; m_csvClassifier = value; }
    inline void SetCsvClassifier(CsvClassifier&& value) { m_csvClassifierHasBeenSet = true; m_csvClassifier = std::move(value); }
    inline Classifier& WithCsvClassifier(const CsvClassifier& value) { SetCsvClassifier(value); return *this;}
    inline Classifier& WithCsvClassifier(CsvClassifier&& value) { SetCsvClassifier(std::move(value)); return *this;}
    ///@}
  private:

    GrokClassifier m_grokClassifier;
    bool m_grokClassifierHasBeenSet = false;

    XMLClassifier m_xMLClassifier;
    bool m_xMLClassifierHasBeenSet = false;

    JsonClassifier m_jsonClassifier;
    bool m_jsonClassifierHasBeenSet = false;

    CsvClassifier m_csvClassifier;
    bool m_csvClassifierHasBeenSet = false;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
