﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/fis/model/ReportConfigurationS3OutputInput.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace FIS
{
namespace Model
{

ReportConfigurationS3OutputInput::ReportConfigurationS3OutputInput() : 
    m_bucketNameHasBeenSet(false),
    m_prefixHasBeenSet(false)
{
}

ReportConfigurationS3OutputInput::ReportConfigurationS3OutputInput(JsonView jsonValue)
  : ReportConfigurationS3OutputInput()
{
  *this = jsonValue;
}

ReportConfigurationS3OutputInput& ReportConfigurationS3OutputInput::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("bucketName"))
  {
    m_bucketName = jsonValue.GetString("bucketName");

    m_bucketNameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("prefix"))
  {
    m_prefix = jsonValue.GetString("prefix");

    m_prefixHasBeenSet = true;
  }

  return *this;
}

JsonValue ReportConfigurationS3OutputInput::Jsonize() const
{
  JsonValue payload;

  if(m_bucketNameHasBeenSet)
  {
   payload.WithString("bucketName", m_bucketName);

  }

  if(m_prefixHasBeenSet)
  {
   payload.WithString("prefix", m_prefix);

  }

  return payload;
}

} // namespace Model
} // namespace FIS
} // namespace Aws
