﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/elasticloadbalancingv2/model/AdministrativeOverride.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws
{
namespace ElasticLoadBalancingv2
{
namespace Model
{

AdministrativeOverride::AdministrativeOverride() : 
    m_state(TargetAdministrativeOverrideStateEnum::NOT_SET),
    m_stateHasBeenSet(false),
    m_reason(TargetAdministrativeOverrideReasonEnum::NOT_SET),
    m_reasonHasBeenSet(false),
    m_descriptionHasBeenSet(false)
{
}

AdministrativeOverride::AdministrativeOverride(const XmlNode& xmlNode)
  : AdministrativeOverride()
{
  *this = xmlNode;
}

AdministrativeOverride& AdministrativeOverride::operator =(const XmlNode& xmlNode)
{
  XmlNode resultNode = xmlNode;

  if(!resultNode.IsNull())
  {
    XmlNode stateNode = resultNode.FirstChild("State");
    if(!stateNode.IsNull())
    {
      m_state = TargetAdministrativeOverrideStateEnumMapper::GetTargetAdministrativeOverrideStateEnumForName(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(stateNode.GetText()).c_str()).c_str());
      m_stateHasBeenSet = true;
    }
    XmlNode reasonNode = resultNode.FirstChild("Reason");
    if(!reasonNode.IsNull())
    {
      m_reason = TargetAdministrativeOverrideReasonEnumMapper::GetTargetAdministrativeOverrideReasonEnumForName(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(reasonNode.GetText()).c_str()).c_str());
      m_reasonHasBeenSet = true;
    }
    XmlNode descriptionNode = resultNode.FirstChild("Description");
    if(!descriptionNode.IsNull())
    {
      m_description = Aws::Utils::Xml::DecodeEscapedXmlText(descriptionNode.GetText());
      m_descriptionHasBeenSet = true;
    }
  }

  return *this;
}

void AdministrativeOverride::OutputToStream(Aws::OStream& oStream, const char* location, unsigned index, const char* locationValue) const
{
  if(m_stateHasBeenSet)
  {
      oStream << location << index << locationValue << ".State=" << TargetAdministrativeOverrideStateEnumMapper::GetNameForTargetAdministrativeOverrideStateEnum(m_state) << "&";
  }

  if(m_reasonHasBeenSet)
  {
      oStream << location << index << locationValue << ".Reason=" << TargetAdministrativeOverrideReasonEnumMapper::GetNameForTargetAdministrativeOverrideReasonEnum(m_reason) << "&";
  }

  if(m_descriptionHasBeenSet)
  {
      oStream << location << index << locationValue << ".Description=" << StringUtils::URLEncode(m_description.c_str()) << "&";
  }

}

void AdministrativeOverride::OutputToStream(Aws::OStream& oStream, const char* location) const
{
  if(m_stateHasBeenSet)
  {
      oStream << location << ".State=" << TargetAdministrativeOverrideStateEnumMapper::GetNameForTargetAdministrativeOverrideStateEnum(m_state) << "&";
  }
  if(m_reasonHasBeenSet)
  {
      oStream << location << ".Reason=" << TargetAdministrativeOverrideReasonEnumMapper::GetNameForTargetAdministrativeOverrideReasonEnum(m_reason) << "&";
  }
  if(m_descriptionHasBeenSet)
  {
      oStream << location << ".Description=" << StringUtils::URLEncode(m_description.c_str()) << "&";
  }
}

} // namespace Model
} // namespace ElasticLoadBalancingv2
} // namespace Aws
