﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/AgentHierarchyGroup.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Connect
{
namespace Model
{

AgentHierarchyGroup::AgentHierarchyGroup() : 
    m_arnHasBeenSet(false)
{
}

AgentHierarchyGroup::AgentHierarchyGroup(JsonView jsonValue)
  : AgentHierarchyGroup()
{
  *this = jsonValue;
}

AgentHierarchyGroup& AgentHierarchyGroup::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Arn"))
  {
    m_arn = jsonValue.GetString("Arn");

    m_arnHasBeenSet = true;
  }

  return *this;
}

JsonValue AgentHierarchyGroup::Jsonize() const
{
  JsonValue payload;

  if(m_arnHasBeenSet)
  {
   payload.WithString("Arn", m_arn);

  }

  return payload;
}

} // namespace Model
} // namespace Connect
} // namespace Aws
