package main

// Code generated by /home/ubuntu/go/bin/peg delocate.peg DO NOT EDIT.

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleAsmFile
	ruleStatement
	ruleGlobalDirective
	ruleDirective
	ruleDirectiveName
	ruleLocationDirective
	ruleZeroDirective
	ruleFileDirective
	ruleLocDirective
	ruleArgs
	ruleArg
	ruleQuotedArg
	ruleQuotedText
	ruleLabelContainingDirective
	ruleLabelContainingDirectiveName
	ruleSymbolArgs
	ruleSymbolArg
	ruleSymbolExpr
	ruleSymbolAtom
	ruleSymbolOperator
	ruleOpenParen
	ruleCloseParen
	ruleSymbolType
	ruleDot
	ruleTCMarker
	ruleEscapedChar
	ruleWS
	ruleComment
	ruleLabel
	ruleSymbolName
	ruleLocalSymbol
	ruleLocalLabel
	ruleLocalLabelRef
	ruleInstruction
	ruleInstructionName
	ruleInstructionArg
	ruleGOTLocation
	ruleGOTSymbolOffset
	ruleAVX512Token
	ruleTOCRefHigh
	ruleTOCRefLow
	ruleIndirectionIndicator
	ruleRegisterOrConstant
	ruleARMConstantTweak
	ruleARMRegister
	ruleARMVectorRegister
	ruleSVE2PredicateRegister
	ruleARMRegisterBoundary
	ruleMemoryRef
	ruleSymbolRef
	ruleLow12BitsSymbolRef
	ruleARMBaseIndexScale
	ruleARMGOTLow12
	ruleARMPostincrement
	ruleBaseIndexScale
	ruleOperator
	ruleOffsetOperator
	ruleOffset
	ruleSection
	ruleSegmentRegister
)

var rul3s = [...]string{
	"Unknown",
	"AsmFile",
	"Statement",
	"GlobalDirective",
	"Directive",
	"DirectiveName",
	"LocationDirective",
	"ZeroDirective",
	"FileDirective",
	"LocDirective",
	"Args",
	"Arg",
	"QuotedArg",
	"QuotedText",
	"LabelContainingDirective",
	"LabelContainingDirectiveName",
	"SymbolArgs",
	"SymbolArg",
	"SymbolExpr",
	"SymbolAtom",
	"SymbolOperator",
	"OpenParen",
	"CloseParen",
	"SymbolType",
	"Dot",
	"TCMarker",
	"EscapedChar",
	"WS",
	"Comment",
	"Label",
	"SymbolName",
	"LocalSymbol",
	"LocalLabel",
	"LocalLabelRef",
	"Instruction",
	"InstructionName",
	"InstructionArg",
	"GOTLocation",
	"GOTSymbolOffset",
	"AVX512Token",
	"TOCRefHigh",
	"TOCRefLow",
	"IndirectionIndicator",
	"RegisterOrConstant",
	"ARMConstantTweak",
	"ARMRegister",
	"ARMVectorRegister",
	"SVE2PredicateRegister",
	"ARMRegisterBoundary",
	"MemoryRef",
	"SymbolRef",
	"Low12BitsSymbolRef",
	"ARMBaseIndexScale",
	"ARMGOTLow12",
	"ARMPostincrement",
	"BaseIndexScale",
	"Operator",
	"OffsetOperator",
	"Offset",
	"Section",
	"SegmentRegister",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Asm struct {
	Buffer string
	buffer []rune
	rules  [61]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *Asm) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Asm) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Asm
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Asm) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Asm) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Asm) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func Pretty(pretty bool) func(*Asm) error {
	return func(p *Asm) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Asm) error {
	return func(p *Asm) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *Asm) Init(options ...func(*Asm) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 AsmFile <- <(Statement* !.)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if !_rules[ruleStatement]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position4, tokenIndex4 := position, tokenIndex
					if !matchDot() {
						goto l4
					}
					goto l0
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				add(ruleAsmFile, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Statement <- <(WS? (Label / ((GlobalDirective / LocationDirective / LabelContainingDirective / ZeroDirective / Instruction / Directive / Comment / ) WS? ((Comment? '\n') / ';'))))> */
		func() bool {
			position5, tokenIndex5 := position, tokenIndex
			{
				position6 := position
				{
					position7, tokenIndex7 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l7
					}
					goto l8
				l7:
					position, tokenIndex = position7, tokenIndex7
				}
			l8:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleLabel]() {
						goto l10
					}
					goto l9
				l10:
					position, tokenIndex = position9, tokenIndex9
					{
						position11, tokenIndex11 := position, tokenIndex
						if !_rules[ruleGlobalDirective]() {
							goto l12
						}
						goto l11
					l12:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLocationDirective]() {
							goto l13
						}
						goto l11
					l13:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLabelContainingDirective]() {
							goto l14
						}
						goto l11
					l14:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleZeroDirective]() {
							goto l15
						}
						goto l11
					l15:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleInstruction]() {
							goto l16
						}
						goto l11
					l16:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleDirective]() {
							goto l17
						}
						goto l11
					l17:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleComment]() {
							goto l18
						}
						goto l11
					l18:
						position, tokenIndex = position11, tokenIndex11
					}
				l11:
					{
						position19, tokenIndex19 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l19
						}
						goto l20
					l19:
						position, tokenIndex = position19, tokenIndex19
					}
				l20:
					{
						position21, tokenIndex21 := position, tokenIndex
						{
							position23, tokenIndex23 := position, tokenIndex
							if !_rules[ruleComment]() {
								goto l23
							}
							goto l24
						l23:
							position, tokenIndex = position23, tokenIndex23
						}
					l24:
						if buffer[position] != rune('\n') {
							goto l22
						}
						position++
						goto l21
					l22:
						position, tokenIndex = position21, tokenIndex21
						if buffer[position] != rune(';') {
							goto l5
						}
						position++
					}
				l21:
				}
			l9:
				add(ruleStatement, position6)
			}
			return true
		l5:
			position, tokenIndex = position5, tokenIndex5
			return false
		},
		/* 2 GlobalDirective <- <((('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('a' / 'A') ('l' / 'L')) / ('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('l' / 'L'))) WS SymbolName)> */
		func() bool {
			position25, tokenIndex25 := position, tokenIndex
			{
				position26 := position
				{
					position27, tokenIndex27 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l28
					}
					position++
					{
						position29, tokenIndex29 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l30
						}
						position++
						goto l29
					l30:
						position, tokenIndex = position29, tokenIndex29
						if buffer[position] != rune('G') {
							goto l28
						}
						position++
					}
				l29:
					{
						position31, tokenIndex31 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l32
						}
						position++
						goto l31
					l32:
						position, tokenIndex = position31, tokenIndex31
						if buffer[position] != rune('L') {
							goto l28
						}
						position++
					}
				l31:
					{
						position33, tokenIndex33 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l34
						}
						position++
						goto l33
					l34:
						position, tokenIndex = position33, tokenIndex33
						if buffer[position] != rune('O') {
							goto l28
						}
						position++
					}
				l33:
					{
						position35, tokenIndex35 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l36
						}
						position++
						goto l35
					l36:
						position, tokenIndex = position35, tokenIndex35
						if buffer[position] != rune('B') {
							goto l28
						}
						position++
					}
				l35:
					{
						position37, tokenIndex37 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l38
						}
						position++
						goto l37
					l38:
						position, tokenIndex = position37, tokenIndex37
						if buffer[position] != rune('A') {
							goto l28
						}
						position++
					}
				l37:
					{
						position39, tokenIndex39 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l40
						}
						position++
						goto l39
					l40:
						position, tokenIndex = position39, tokenIndex39
						if buffer[position] != rune('L') {
							goto l28
						}
						position++
					}
				l39:
					goto l27
				l28:
					position, tokenIndex = position27, tokenIndex27
					if buffer[position] != rune('.') {
						goto l25
					}
					position++
					{
						position41, tokenIndex41 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l42
						}
						position++
						goto l41
					l42:
						position, tokenIndex = position41, tokenIndex41
						if buffer[position] != rune('G') {
							goto l25
						}
						position++
					}
				l41:
					{
						position43, tokenIndex43 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l44
						}
						position++
						goto l43
					l44:
						position, tokenIndex = position43, tokenIndex43
						if buffer[position] != rune('L') {
							goto l25
						}
						position++
					}
				l43:
					{
						position45, tokenIndex45 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l46
						}
						position++
						goto l45
					l46:
						position, tokenIndex = position45, tokenIndex45
						if buffer[position] != rune('O') {
							goto l25
						}
						position++
					}
				l45:
					{
						position47, tokenIndex47 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l48
						}
						position++
						goto l47
					l48:
						position, tokenIndex = position47, tokenIndex47
						if buffer[position] != rune('B') {
							goto l25
						}
						position++
					}
				l47:
					{
						position49, tokenIndex49 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l50
						}
						position++
						goto l49
					l50:
						position, tokenIndex = position49, tokenIndex49
						if buffer[position] != rune('L') {
							goto l25
						}
						position++
					}
				l49:
				}
			l27:
				if !_rules[ruleWS]() {
					goto l25
				}
				if !_rules[ruleSymbolName]() {
					goto l25
				}
				add(ruleGlobalDirective, position26)
			}
			return true
		l25:
			position, tokenIndex = position25, tokenIndex25
			return false
		},
		/* 3 Directive <- <('.' DirectiveName (WS Args)?)> */
		func() bool {
			position51, tokenIndex51 := position, tokenIndex
			{
				position52 := position
				if buffer[position] != rune('.') {
					goto l51
				}
				position++
				if !_rules[ruleDirectiveName]() {
					goto l51
				}
				{
					position53, tokenIndex53 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l53
					}
					if !_rules[ruleArgs]() {
						goto l53
					}
					goto l54
				l53:
					position, tokenIndex = position53, tokenIndex53
				}
			l54:
				add(ruleDirective, position52)
			}
			return true
		l51:
			position, tokenIndex = position51, tokenIndex51
			return false
		},
		/* 4 DirectiveName <- <([a-z] / [A-Z] / ([0-9] / [0-9]) / '_')+> */
		func() bool {
			position55, tokenIndex55 := position, tokenIndex
			{
				position56 := position
				{
					position59, tokenIndex59 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l60
					}
					position++
					goto l59
				l60:
					position, tokenIndex = position59, tokenIndex59
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l61
					}
					position++
					goto l59
				l61:
					position, tokenIndex = position59, tokenIndex59
					{
						position63, tokenIndex63 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l64
						}
						position++
						goto l63
					l64:
						position, tokenIndex = position63, tokenIndex63
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l62
						}
						position++
					}
				l63:
					goto l59
				l62:
					position, tokenIndex = position59, tokenIndex59
					if buffer[position] != rune('_') {
						goto l55
					}
					position++
				}
			l59:
			l57:
				{
					position58, tokenIndex58 := position, tokenIndex
					{
						position65, tokenIndex65 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l66
						}
						position++
						goto l65
					l66:
						position, tokenIndex = position65, tokenIndex65
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l67
						}
						position++
						goto l65
					l67:
						position, tokenIndex = position65, tokenIndex65
						{
							position69, tokenIndex69 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l70
							}
							position++
							goto l69
						l70:
							position, tokenIndex = position69, tokenIndex69
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l68
							}
							position++
						}
					l69:
						goto l65
					l68:
						position, tokenIndex = position65, tokenIndex65
						if buffer[position] != rune('_') {
							goto l58
						}
						position++
					}
				l65:
					goto l57
				l58:
					position, tokenIndex = position58, tokenIndex58
				}
				add(ruleDirectiveName, position56)
			}
			return true
		l55:
			position, tokenIndex = position55, tokenIndex55
			return false
		},
		/* 5 LocationDirective <- <(FileDirective / LocDirective)> */
		func() bool {
			position71, tokenIndex71 := position, tokenIndex
			{
				position72 := position
				{
					position73, tokenIndex73 := position, tokenIndex
					if !_rules[ruleFileDirective]() {
						goto l74
					}
					goto l73
				l74:
					position, tokenIndex = position73, tokenIndex73
					if !_rules[ruleLocDirective]() {
						goto l71
					}
				}
			l73:
				add(ruleLocationDirective, position72)
			}
			return true
		l71:
			position, tokenIndex = position71, tokenIndex71
			return false
		},
		/* 6 ZeroDirective <- <('.' ('z' / 'Z') ('e' / 'E') ('r' / 'R') ('o' / 'O') WS (!('#' / '\n') .)+)> */
		func() bool {
			position75, tokenIndex75 := position, tokenIndex
			{
				position76 := position
				if buffer[position] != rune('.') {
					goto l75
				}
				position++
				{
					position77, tokenIndex77 := position, tokenIndex
					if buffer[position] != rune('z') {
						goto l78
					}
					position++
					goto l77
				l78:
					position, tokenIndex = position77, tokenIndex77
					if buffer[position] != rune('Z') {
						goto l75
					}
					position++
				}
			l77:
				{
					position79, tokenIndex79 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l80
					}
					position++
					goto l79
				l80:
					position, tokenIndex = position79, tokenIndex79
					if buffer[position] != rune('E') {
						goto l75
					}
					position++
				}
			l79:
				{
					position81, tokenIndex81 := position, tokenIndex
					if buffer[position] != rune('r') {
						goto l82
					}
					position++
					goto l81
				l82:
					position, tokenIndex = position81, tokenIndex81
					if buffer[position] != rune('R') {
						goto l75
					}
					position++
				}
			l81:
				{
					position83, tokenIndex83 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l84
					}
					position++
					goto l83
				l84:
					position, tokenIndex = position83, tokenIndex83
					if buffer[position] != rune('O') {
						goto l75
					}
					position++
				}
			l83:
				if !_rules[ruleWS]() {
					goto l75
				}
				{
					position87, tokenIndex87 := position, tokenIndex
					{
						position88, tokenIndex88 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l89
						}
						position++
						goto l88
					l89:
						position, tokenIndex = position88, tokenIndex88
						if buffer[position] != rune('\n') {
							goto l87
						}
						position++
					}
				l88:
					goto l75
				l87:
					position, tokenIndex = position87, tokenIndex87
				}
				if !matchDot() {
					goto l75
				}
			l85:
				{
					position86, tokenIndex86 := position, tokenIndex
					{
						position90, tokenIndex90 := position, tokenIndex
						{
							position91, tokenIndex91 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l92
							}
							position++
							goto l91
						l92:
							position, tokenIndex = position91, tokenIndex91
							if buffer[position] != rune('\n') {
								goto l90
							}
							position++
						}
					l91:
						goto l86
					l90:
						position, tokenIndex = position90, tokenIndex90
					}
					if !matchDot() {
						goto l86
					}
					goto l85
				l86:
					position, tokenIndex = position86, tokenIndex86
				}
				add(ruleZeroDirective, position76)
			}
			return true
		l75:
			position, tokenIndex = position75, tokenIndex75
			return false
		},
		/* 7 FileDirective <- <('.' ('f' / 'F') ('i' / 'I') ('l' / 'L') ('e' / 'E') WS (!('#' / '\n') .)+)> */
		func() bool {
			position93, tokenIndex93 := position, tokenIndex
			{
				position94 := position
				if buffer[position] != rune('.') {
					goto l93
				}
				position++
				{
					position95, tokenIndex95 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l96
					}
					position++
					goto l95
				l96:
					position, tokenIndex = position95, tokenIndex95
					if buffer[position] != rune('F') {
						goto l93
					}
					position++
				}
			l95:
				{
					position97, tokenIndex97 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l98
					}
					position++
					goto l97
				l98:
					position, tokenIndex = position97, tokenIndex97
					if buffer[position] != rune('I') {
						goto l93
					}
					position++
				}
			l97:
				{
					position99, tokenIndex99 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l100
					}
					position++
					goto l99
				l100:
					position, tokenIndex = position99, tokenIndex99
					if buffer[position] != rune('L') {
						goto l93
					}
					position++
				}
			l99:
				{
					position101, tokenIndex101 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l102
					}
					position++
					goto l101
				l102:
					position, tokenIndex = position101, tokenIndex101
					if buffer[position] != rune('E') {
						goto l93
					}
					position++
				}
			l101:
				if !_rules[ruleWS]() {
					goto l93
				}
				{
					position105, tokenIndex105 := position, tokenIndex
					{
						position106, tokenIndex106 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l107
						}
						position++
						goto l106
					l107:
						position, tokenIndex = position106, tokenIndex106
						if buffer[position] != rune('\n') {
							goto l105
						}
						position++
					}
				l106:
					goto l93
				l105:
					position, tokenIndex = position105, tokenIndex105
				}
				if !matchDot() {
					goto l93
				}
			l103:
				{
					position104, tokenIndex104 := position, tokenIndex
					{
						position108, tokenIndex108 := position, tokenIndex
						{
							position109, tokenIndex109 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l110
							}
							position++
							goto l109
						l110:
							position, tokenIndex = position109, tokenIndex109
							if buffer[position] != rune('\n') {
								goto l108
							}
							position++
						}
					l109:
						goto l104
					l108:
						position, tokenIndex = position108, tokenIndex108
					}
					if !matchDot() {
						goto l104
					}
					goto l103
				l104:
					position, tokenIndex = position104, tokenIndex104
				}
				add(ruleFileDirective, position94)
			}
			return true
		l93:
			position, tokenIndex = position93, tokenIndex93
			return false
		},
		/* 8 LocDirective <- <('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') WS (!('#' / '/' / '\n') .)+)> */
		func() bool {
			position111, tokenIndex111 := position, tokenIndex
			{
				position112 := position
				if buffer[position] != rune('.') {
					goto l111
				}
				position++
				{
					position113, tokenIndex113 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l114
					}
					position++
					goto l113
				l114:
					position, tokenIndex = position113, tokenIndex113
					if buffer[position] != rune('L') {
						goto l111
					}
					position++
				}
			l113:
				{
					position115, tokenIndex115 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l116
					}
					position++
					goto l115
				l116:
					position, tokenIndex = position115, tokenIndex115
					if buffer[position] != rune('O') {
						goto l111
					}
					position++
				}
			l115:
				{
					position117, tokenIndex117 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l118
					}
					position++
					goto l117
				l118:
					position, tokenIndex = position117, tokenIndex117
					if buffer[position] != rune('C') {
						goto l111
					}
					position++
				}
			l117:
				if !_rules[ruleWS]() {
					goto l111
				}
				{
					position121, tokenIndex121 := position, tokenIndex
					{
						position122, tokenIndex122 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l123
						}
						position++
						goto l122
					l123:
						position, tokenIndex = position122, tokenIndex122
						if buffer[position] != rune('/') {
							goto l124
						}
						position++
						goto l122
					l124:
						position, tokenIndex = position122, tokenIndex122
						if buffer[position] != rune('\n') {
							goto l121
						}
						position++
					}
				l122:
					goto l111
				l121:
					position, tokenIndex = position121, tokenIndex121
				}
				if !matchDot() {
					goto l111
				}
			l119:
				{
					position120, tokenIndex120 := position, tokenIndex
					{
						position125, tokenIndex125 := position, tokenIndex
						{
							position126, tokenIndex126 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l127
							}
							position++
							goto l126
						l127:
							position, tokenIndex = position126, tokenIndex126
							if buffer[position] != rune('/') {
								goto l128
							}
							position++
							goto l126
						l128:
							position, tokenIndex = position126, tokenIndex126
							if buffer[position] != rune('\n') {
								goto l125
							}
							position++
						}
					l126:
						goto l120
					l125:
						position, tokenIndex = position125, tokenIndex125
					}
					if !matchDot() {
						goto l120
					}
					goto l119
				l120:
					position, tokenIndex = position120, tokenIndex120
				}
				add(ruleLocDirective, position112)
			}
			return true
		l111:
			position, tokenIndex = position111, tokenIndex111
			return false
		},
		/* 9 Args <- <(Arg (WS? ',' WS? Arg)*)> */
		func() bool {
			position129, tokenIndex129 := position, tokenIndex
			{
				position130 := position
				if !_rules[ruleArg]() {
					goto l129
				}
			l131:
				{
					position132, tokenIndex132 := position, tokenIndex
					{
						position133, tokenIndex133 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l133
						}
						goto l134
					l133:
						position, tokenIndex = position133, tokenIndex133
					}
				l134:
					if buffer[position] != rune(',') {
						goto l132
					}
					position++
					{
						position135, tokenIndex135 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l135
						}
						goto l136
					l135:
						position, tokenIndex = position135, tokenIndex135
					}
				l136:
					if !_rules[ruleArg]() {
						goto l132
					}
					goto l131
				l132:
					position, tokenIndex = position132, tokenIndex132
				}
				add(ruleArgs, position130)
			}
			return true
		l129:
			position, tokenIndex = position129, tokenIndex129
			return false
		},
		/* 10 Arg <- <(QuotedArg / ([0-9] / [0-9] / ([a-z] / [A-Z]) / '%' / '+' / '-' / '*' / '_' / '@' / '.')*)> */
		func() bool {
			{
				position138 := position
				{
					position139, tokenIndex139 := position, tokenIndex
					if !_rules[ruleQuotedArg]() {
						goto l140
					}
					goto l139
				l140:
					position, tokenIndex = position139, tokenIndex139
				l141:
					{
						position142, tokenIndex142 := position, tokenIndex
						{
							position143, tokenIndex143 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l144
							}
							position++
							goto l143
						l144:
							position, tokenIndex = position143, tokenIndex143
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l145
							}
							position++
							goto l143
						l145:
							position, tokenIndex = position143, tokenIndex143
							{
								position147, tokenIndex147 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l148
								}
								position++
								goto l147
							l148:
								position, tokenIndex = position147, tokenIndex147
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l146
								}
								position++
							}
						l147:
							goto l143
						l146:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('%') {
								goto l149
							}
							position++
							goto l143
						l149:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('+') {
								goto l150
							}
							position++
							goto l143
						l150:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('-') {
								goto l151
							}
							position++
							goto l143
						l151:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('*') {
								goto l152
							}
							position++
							goto l143
						l152:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('_') {
								goto l153
							}
							position++
							goto l143
						l153:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('@') {
								goto l154
							}
							position++
							goto l143
						l154:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('.') {
								goto l142
							}
							position++
						}
					l143:
						goto l141
					l142:
						position, tokenIndex = position142, tokenIndex142
					}
				}
			l139:
				add(ruleArg, position138)
			}
			return true
		},
		/* 11 QuotedArg <- <('"' QuotedText '"')> */
		func() bool {
			position155, tokenIndex155 := position, tokenIndex
			{
				position156 := position
				if buffer[position] != rune('"') {
					goto l155
				}
				position++
				if !_rules[ruleQuotedText]() {
					goto l155
				}
				if buffer[position] != rune('"') {
					goto l155
				}
				position++
				add(ruleQuotedArg, position156)
			}
			return true
		l155:
			position, tokenIndex = position155, tokenIndex155
			return false
		},
		/* 12 QuotedText <- <(EscapedChar / (!'"' .))*> */
		func() bool {
			{
				position158 := position
			l159:
				{
					position160, tokenIndex160 := position, tokenIndex
					{
						position161, tokenIndex161 := position, tokenIndex
						if !_rules[ruleEscapedChar]() {
							goto l162
						}
						goto l161
					l162:
						position, tokenIndex = position161, tokenIndex161
						{
							position163, tokenIndex163 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l163
							}
							position++
							goto l160
						l163:
							position, tokenIndex = position163, tokenIndex163
						}
						if !matchDot() {
							goto l160
						}
					}
				l161:
					goto l159
				l160:
					position, tokenIndex = position160, tokenIndex160
				}
				add(ruleQuotedText, position158)
			}
			return true
		},
		/* 13 LabelContainingDirective <- <(LabelContainingDirectiveName WS SymbolArgs)> */
		func() bool {
			position164, tokenIndex164 := position, tokenIndex
			{
				position165 := position
				if !_rules[ruleLabelContainingDirectiveName]() {
					goto l164
				}
				if !_rules[ruleWS]() {
					goto l164
				}
				if !_rules[ruleSymbolArgs]() {
					goto l164
				}
				add(ruleLabelContainingDirective, position165)
			}
			return true
		l164:
			position, tokenIndex = position164, tokenIndex164
			return false
		},
		/* 14 LabelContainingDirectiveName <- <(('.' ('x' / 'X') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('h' / 'H') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('l' / 'L') ('o' / 'O') ('n' / 'N') ('g' / 'G')) / ('.' ('s' / 'S') ('e' / 'E') ('t' / 'T')) / ('.' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '8' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '4' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' ('q' / 'Q') ('u' / 'U') ('a' / 'A') ('d' / 'D')) / ('.' ('t' / 'T') ('c' / 'C')) / ('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') ('a' / 'A') ('l' / 'L') ('e' / 'E') ('n' / 'N') ('t' / 'T') ('r' / 'R') ('y' / 'Y')) / ('.' ('s' / 'S') ('i' / 'I') ('z' / 'Z') ('e' / 'E')) / ('.' ('t' / 'T') ('y' / 'Y') ('p' / 'P') ('e' / 'E')) / ('.' ('u' / 'U') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8') / ('.' ('s' / 'S') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8'))> */
		func() bool {
			position166, tokenIndex166 := position, tokenIndex
			{
				position167 := position
				{
					position168, tokenIndex168 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l169
					}
					position++
					{
						position170, tokenIndex170 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l171
						}
						position++
						goto l170
					l171:
						position, tokenIndex = position170, tokenIndex170
						if buffer[position] != rune('X') {
							goto l169
						}
						position++
					}
				l170:
					{
						position172, tokenIndex172 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l173
						}
						position++
						goto l172
					l173:
						position, tokenIndex = position172, tokenIndex172
						if buffer[position] != rune('W') {
							goto l169
						}
						position++
					}
				l172:
					{
						position174, tokenIndex174 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l175
						}
						position++
						goto l174
					l175:
						position, tokenIndex = position174, tokenIndex174
						if buffer[position] != rune('O') {
							goto l169
						}
						position++
					}
				l174:
					{
						position176, tokenIndex176 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l177
						}
						position++
						goto l176
					l177:
						position, tokenIndex = position176, tokenIndex176
						if buffer[position] != rune('R') {
							goto l169
						}
						position++
					}
				l176:
					{
						position178, tokenIndex178 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l179
						}
						position++
						goto l178
					l179:
						position, tokenIndex = position178, tokenIndex178
						if buffer[position] != rune('D') {
							goto l169
						}
						position++
					}
				l178:
					goto l168
				l169:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l180
					}
					position++
					{
						position181, tokenIndex181 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l182
						}
						position++
						goto l181
					l182:
						position, tokenIndex = position181, tokenIndex181
						if buffer[position] != rune('W') {
							goto l180
						}
						position++
					}
				l181:
					{
						position183, tokenIndex183 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l184
						}
						position++
						goto l183
					l184:
						position, tokenIndex = position183, tokenIndex183
						if buffer[position] != rune('O') {
							goto l180
						}
						position++
					}
				l183:
					{
						position185, tokenIndex185 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l186
						}
						position++
						goto l185
					l186:
						position, tokenIndex = position185, tokenIndex185
						if buffer[position] != rune('R') {
							goto l180
						}
						position++
					}
				l185:
					{
						position187, tokenIndex187 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l188
						}
						position++
						goto l187
					l188:
						position, tokenIndex = position187, tokenIndex187
						if buffer[position] != rune('D') {
							goto l180
						}
						position++
					}
				l187:
					goto l168
				l180:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l189
					}
					position++
					{
						position190, tokenIndex190 := position, tokenIndex
						if buffer[position] != rune('h') {
							goto l191
						}
						position++
						goto l190
					l191:
						position, tokenIndex = position190, tokenIndex190
						if buffer[position] != rune('H') {
							goto l189
						}
						position++
					}
				l190:
					{
						position192, tokenIndex192 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l193
						}
						position++
						goto l192
					l193:
						position, tokenIndex = position192, tokenIndex192
						if buffer[position] != rune('W') {
							goto l189
						}
						position++
					}
				l192:
					{
						position194, tokenIndex194 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l195
						}
						position++
						goto l194
					l195:
						position, tokenIndex = position194, tokenIndex194
						if buffer[position] != rune('O') {
							goto l189
						}
						position++
					}
				l194:
					{
						position196, tokenIndex196 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l197
						}
						position++
						goto l196
					l197:
						position, tokenIndex = position196, tokenIndex196
						if buffer[position] != rune('R') {
							goto l189
						}
						position++
					}
				l196:
					{
						position198, tokenIndex198 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l199
						}
						position++
						goto l198
					l199:
						position, tokenIndex = position198, tokenIndex198
						if buffer[position] != rune('D') {
							goto l189
						}
						position++
					}
				l198:
					goto l168
				l189:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l200
					}
					position++
					{
						position201, tokenIndex201 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l202
						}
						position++
						goto l201
					l202:
						position, tokenIndex = position201, tokenIndex201
						if buffer[position] != rune('L') {
							goto l200
						}
						position++
					}
				l201:
					{
						position203, tokenIndex203 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l204
						}
						position++
						goto l203
					l204:
						position, tokenIndex = position203, tokenIndex203
						if buffer[position] != rune('O') {
							goto l200
						}
						position++
					}
				l203:
					{
						position205, tokenIndex205 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l206
						}
						position++
						goto l205
					l206:
						position, tokenIndex = position205, tokenIndex205
						if buffer[position] != rune('N') {
							goto l200
						}
						position++
					}
				l205:
					{
						position207, tokenIndex207 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l208
						}
						position++
						goto l207
					l208:
						position, tokenIndex = position207, tokenIndex207
						if buffer[position] != rune('G') {
							goto l200
						}
						position++
					}
				l207:
					goto l168
				l200:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l209
					}
					position++
					{
						position210, tokenIndex210 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l211
						}
						position++
						goto l210
					l211:
						position, tokenIndex = position210, tokenIndex210
						if buffer[position] != rune('S') {
							goto l209
						}
						position++
					}
				l210:
					{
						position212, tokenIndex212 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l213
						}
						position++
						goto l212
					l213:
						position, tokenIndex = position212, tokenIndex212
						if buffer[position] != rune('E') {
							goto l209
						}
						position++
					}
				l212:
					{
						position214, tokenIndex214 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l215
						}
						position++
						goto l214
					l215:
						position, tokenIndex = position214, tokenIndex214
						if buffer[position] != rune('T') {
							goto l209
						}
						position++
					}
				l214:
					goto l168
				l209:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l216
					}
					position++
					{
						position217, tokenIndex217 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l218
						}
						position++
						goto l217
					l218:
						position, tokenIndex = position217, tokenIndex217
						if buffer[position] != rune('B') {
							goto l216
						}
						position++
					}
				l217:
					{
						position219, tokenIndex219 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l220
						}
						position++
						goto l219
					l220:
						position, tokenIndex = position219, tokenIndex219
						if buffer[position] != rune('Y') {
							goto l216
						}
						position++
					}
				l219:
					{
						position221, tokenIndex221 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l222
						}
						position++
						goto l221
					l222:
						position, tokenIndex = position221, tokenIndex221
						if buffer[position] != rune('T') {
							goto l216
						}
						position++
					}
				l221:
					{
						position223, tokenIndex223 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l224
						}
						position++
						goto l223
					l224:
						position, tokenIndex = position223, tokenIndex223
						if buffer[position] != rune('E') {
							goto l216
						}
						position++
					}
				l223:
					goto l168
				l216:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l225
					}
					position++
					if buffer[position] != rune('8') {
						goto l225
					}
					position++
					{
						position226, tokenIndex226 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l227
						}
						position++
						goto l226
					l227:
						position, tokenIndex = position226, tokenIndex226
						if buffer[position] != rune('B') {
							goto l225
						}
						position++
					}
				l226:
					{
						position228, tokenIndex228 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l229
						}
						position++
						goto l228
					l229:
						position, tokenIndex = position228, tokenIndex228
						if buffer[position] != rune('Y') {
							goto l225
						}
						position++
					}
				l228:
					{
						position230, tokenIndex230 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l231
						}
						position++
						goto l230
					l231:
						position, tokenIndex = position230, tokenIndex230
						if buffer[position] != rune('T') {
							goto l225
						}
						position++
					}
				l230:
					{
						position232, tokenIndex232 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l233
						}
						position++
						goto l232
					l233:
						position, tokenIndex = position232, tokenIndex232
						if buffer[position] != rune('E') {
							goto l225
						}
						position++
					}
				l232:
					goto l168
				l225:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l234
					}
					position++
					if buffer[position] != rune('4') {
						goto l234
					}
					position++
					{
						position235, tokenIndex235 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l236
						}
						position++
						goto l235
					l236:
						position, tokenIndex = position235, tokenIndex235
						if buffer[position] != rune('B') {
							goto l234
						}
						position++
					}
				l235:
					{
						position237, tokenIndex237 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l238
						}
						position++
						goto l237
					l238:
						position, tokenIndex = position237, tokenIndex237
						if buffer[position] != rune('Y') {
							goto l234
						}
						position++
					}
				l237:
					{
						position239, tokenIndex239 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l240
						}
						position++
						goto l239
					l240:
						position, tokenIndex = position239, tokenIndex239
						if buffer[position] != rune('T') {
							goto l234
						}
						position++
					}
				l239:
					{
						position241, tokenIndex241 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l242
						}
						position++
						goto l241
					l242:
						position, tokenIndex = position241, tokenIndex241
						if buffer[position] != rune('E') {
							goto l234
						}
						position++
					}
				l241:
					goto l168
				l234:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l243
					}
					position++
					{
						position244, tokenIndex244 := position, tokenIndex
						if buffer[position] != rune('q') {
							goto l245
						}
						position++
						goto l244
					l245:
						position, tokenIndex = position244, tokenIndex244
						if buffer[position] != rune('Q') {
							goto l243
						}
						position++
					}
				l244:
					{
						position246, tokenIndex246 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l247
						}
						position++
						goto l246
					l247:
						position, tokenIndex = position246, tokenIndex246
						if buffer[position] != rune('U') {
							goto l243
						}
						position++
					}
				l246:
					{
						position248, tokenIndex248 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l249
						}
						position++
						goto l248
					l249:
						position, tokenIndex = position248, tokenIndex248
						if buffer[position] != rune('A') {
							goto l243
						}
						position++
					}
				l248:
					{
						position250, tokenIndex250 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l251
						}
						position++
						goto l250
					l251:
						position, tokenIndex = position250, tokenIndex250
						if buffer[position] != rune('D') {
							goto l243
						}
						position++
					}
				l250:
					goto l168
				l243:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l252
					}
					position++
					{
						position253, tokenIndex253 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l254
						}
						position++
						goto l253
					l254:
						position, tokenIndex = position253, tokenIndex253
						if buffer[position] != rune('T') {
							goto l252
						}
						position++
					}
				l253:
					{
						position255, tokenIndex255 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l256
						}
						position++
						goto l255
					l256:
						position, tokenIndex = position255, tokenIndex255
						if buffer[position] != rune('C') {
							goto l252
						}
						position++
					}
				l255:
					goto l168
				l252:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l257
					}
					position++
					{
						position258, tokenIndex258 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l259
						}
						position++
						goto l258
					l259:
						position, tokenIndex = position258, tokenIndex258
						if buffer[position] != rune('L') {
							goto l257
						}
						position++
					}
				l258:
					{
						position260, tokenIndex260 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l261
						}
						position++
						goto l260
					l261:
						position, tokenIndex = position260, tokenIndex260
						if buffer[position] != rune('O') {
							goto l257
						}
						position++
					}
				l260:
					{
						position262, tokenIndex262 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l263
						}
						position++
						goto l262
					l263:
						position, tokenIndex = position262, tokenIndex262
						if buffer[position] != rune('C') {
							goto l257
						}
						position++
					}
				l262:
					{
						position264, tokenIndex264 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l265
						}
						position++
						goto l264
					l265:
						position, tokenIndex = position264, tokenIndex264
						if buffer[position] != rune('A') {
							goto l257
						}
						position++
					}
				l264:
					{
						position266, tokenIndex266 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l267
						}
						position++
						goto l266
					l267:
						position, tokenIndex = position266, tokenIndex266
						if buffer[position] != rune('L') {
							goto l257
						}
						position++
					}
				l266:
					{
						position268, tokenIndex268 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l269
						}
						position++
						goto l268
					l269:
						position, tokenIndex = position268, tokenIndex268
						if buffer[position] != rune('E') {
							goto l257
						}
						position++
					}
				l268:
					{
						position270, tokenIndex270 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l271
						}
						position++
						goto l270
					l271:
						position, tokenIndex = position270, tokenIndex270
						if buffer[position] != rune('N') {
							goto l257
						}
						position++
					}
				l270:
					{
						position272, tokenIndex272 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l273
						}
						position++
						goto l272
					l273:
						position, tokenIndex = position272, tokenIndex272
						if buffer[position] != rune('T') {
							goto l257
						}
						position++
					}
				l272:
					{
						position274, tokenIndex274 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l275
						}
						position++
						goto l274
					l275:
						position, tokenIndex = position274, tokenIndex274
						if buffer[position] != rune('R') {
							goto l257
						}
						position++
					}
				l274:
					{
						position276, tokenIndex276 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l277
						}
						position++
						goto l276
					l277:
						position, tokenIndex = position276, tokenIndex276
						if buffer[position] != rune('Y') {
							goto l257
						}
						position++
					}
				l276:
					goto l168
				l257:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l278
					}
					position++
					{
						position279, tokenIndex279 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l280
						}
						position++
						goto l279
					l280:
						position, tokenIndex = position279, tokenIndex279
						if buffer[position] != rune('S') {
							goto l278
						}
						position++
					}
				l279:
					{
						position281, tokenIndex281 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l282
						}
						position++
						goto l281
					l282:
						position, tokenIndex = position281, tokenIndex281
						if buffer[position] != rune('I') {
							goto l278
						}
						position++
					}
				l281:
					{
						position283, tokenIndex283 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l284
						}
						position++
						goto l283
					l284:
						position, tokenIndex = position283, tokenIndex283
						if buffer[position] != rune('Z') {
							goto l278
						}
						position++
					}
				l283:
					{
						position285, tokenIndex285 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l286
						}
						position++
						goto l285
					l286:
						position, tokenIndex = position285, tokenIndex285
						if buffer[position] != rune('E') {
							goto l278
						}
						position++
					}
				l285:
					goto l168
				l278:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l287
					}
					position++
					{
						position288, tokenIndex288 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l289
						}
						position++
						goto l288
					l289:
						position, tokenIndex = position288, tokenIndex288
						if buffer[position] != rune('T') {
							goto l287
						}
						position++
					}
				l288:
					{
						position290, tokenIndex290 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l291
						}
						position++
						goto l290
					l291:
						position, tokenIndex = position290, tokenIndex290
						if buffer[position] != rune('Y') {
							goto l287
						}
						position++
					}
				l290:
					{
						position292, tokenIndex292 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l293
						}
						position++
						goto l292
					l293:
						position, tokenIndex = position292, tokenIndex292
						if buffer[position] != rune('P') {
							goto l287
						}
						position++
					}
				l292:
					{
						position294, tokenIndex294 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l295
						}
						position++
						goto l294
					l295:
						position, tokenIndex = position294, tokenIndex294
						if buffer[position] != rune('E') {
							goto l287
						}
						position++
					}
				l294:
					goto l168
				l287:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l296
					}
					position++
					{
						position297, tokenIndex297 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l298
						}
						position++
						goto l297
					l298:
						position, tokenIndex = position297, tokenIndex297
						if buffer[position] != rune('U') {
							goto l296
						}
						position++
					}
				l297:
					{
						position299, tokenIndex299 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l300
						}
						position++
						goto l299
					l300:
						position, tokenIndex = position299, tokenIndex299
						if buffer[position] != rune('L') {
							goto l296
						}
						position++
					}
				l299:
					{
						position301, tokenIndex301 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l302
						}
						position++
						goto l301
					l302:
						position, tokenIndex = position301, tokenIndex301
						if buffer[position] != rune('E') {
							goto l296
						}
						position++
					}
				l301:
					{
						position303, tokenIndex303 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l304
						}
						position++
						goto l303
					l304:
						position, tokenIndex = position303, tokenIndex303
						if buffer[position] != rune('B') {
							goto l296
						}
						position++
					}
				l303:
					if buffer[position] != rune('1') {
						goto l296
					}
					position++
					if buffer[position] != rune('2') {
						goto l296
					}
					position++
					if buffer[position] != rune('8') {
						goto l296
					}
					position++
					goto l168
				l296:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l166
					}
					position++
					{
						position305, tokenIndex305 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l306
						}
						position++
						goto l305
					l306:
						position, tokenIndex = position305, tokenIndex305
						if buffer[position] != rune('S') {
							goto l166
						}
						position++
					}
				l305:
					{
						position307, tokenIndex307 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l308
						}
						position++
						goto l307
					l308:
						position, tokenIndex = position307, tokenIndex307
						if buffer[position] != rune('L') {
							goto l166
						}
						position++
					}
				l307:
					{
						position309, tokenIndex309 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l310
						}
						position++
						goto l309
					l310:
						position, tokenIndex = position309, tokenIndex309
						if buffer[position] != rune('E') {
							goto l166
						}
						position++
					}
				l309:
					{
						position311, tokenIndex311 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l312
						}
						position++
						goto l311
					l312:
						position, tokenIndex = position311, tokenIndex311
						if buffer[position] != rune('B') {
							goto l166
						}
						position++
					}
				l311:
					if buffer[position] != rune('1') {
						goto l166
					}
					position++
					if buffer[position] != rune('2') {
						goto l166
					}
					position++
					if buffer[position] != rune('8') {
						goto l166
					}
					position++
				}
			l168:
				add(ruleLabelContainingDirectiveName, position167)
			}
			return true
		l166:
			position, tokenIndex = position166, tokenIndex166
			return false
		},
		/* 15 SymbolArgs <- <(SymbolArg (WS? ',' WS? SymbolArg)*)> */
		func() bool {
			position313, tokenIndex313 := position, tokenIndex
			{
				position314 := position
				if !_rules[ruleSymbolArg]() {
					goto l313
				}
			l315:
				{
					position316, tokenIndex316 := position, tokenIndex
					{
						position317, tokenIndex317 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l317
						}
						goto l318
					l317:
						position, tokenIndex = position317, tokenIndex317
					}
				l318:
					if buffer[position] != rune(',') {
						goto l316
					}
					position++
					{
						position319, tokenIndex319 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l319
						}
						goto l320
					l319:
						position, tokenIndex = position319, tokenIndex319
					}
				l320:
					if !_rules[ruleSymbolArg]() {
						goto l316
					}
					goto l315
				l316:
					position, tokenIndex = position316, tokenIndex316
				}
				add(ruleSymbolArgs, position314)
			}
			return true
		l313:
			position, tokenIndex = position313, tokenIndex313
			return false
		},
		/* 16 SymbolArg <- <SymbolExpr> */
		func() bool {
			position321, tokenIndex321 := position, tokenIndex
			{
				position322 := position
				if !_rules[ruleSymbolExpr]() {
					goto l321
				}
				add(ruleSymbolArg, position322)
			}
			return true
		l321:
			position, tokenIndex = position321, tokenIndex321
			return false
		},
		/* 17 SymbolExpr <- <(SymbolAtom (WS? SymbolOperator WS? SymbolExpr)?)> */
		func() bool {
			position323, tokenIndex323 := position, tokenIndex
			{
				position324 := position
				if !_rules[ruleSymbolAtom]() {
					goto l323
				}
				{
					position325, tokenIndex325 := position, tokenIndex
					{
						position327, tokenIndex327 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l327
						}
						goto l328
					l327:
						position, tokenIndex = position327, tokenIndex327
					}
				l328:
					if !_rules[ruleSymbolOperator]() {
						goto l325
					}
					{
						position329, tokenIndex329 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l329
						}
						goto l330
					l329:
						position, tokenIndex = position329, tokenIndex329
					}
				l330:
					if !_rules[ruleSymbolExpr]() {
						goto l325
					}
					goto l326
				l325:
					position, tokenIndex = position325, tokenIndex325
				}
			l326:
				add(ruleSymbolExpr, position324)
			}
			return true
		l323:
			position, tokenIndex = position323, tokenIndex323
			return false
		},
		/* 18 SymbolAtom <- <(Offset / SymbolType / LocalLabelRef / (LocalSymbol TCMarker?) / (SymbolName Offset) / (SymbolName TCMarker?) / Dot / (OpenParen WS? SymbolExpr WS? CloseParen))> */
		func() bool {
			position331, tokenIndex331 := position, tokenIndex
			{
				position332 := position
				{
					position333, tokenIndex333 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l334
					}
					goto l333
				l334:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolType]() {
						goto l335
					}
					goto l333
				l335:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleLocalLabelRef]() {
						goto l336
					}
					goto l333
				l336:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleLocalSymbol]() {
						goto l337
					}
					{
						position338, tokenIndex338 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l338
						}
						goto l339
					l338:
						position, tokenIndex = position338, tokenIndex338
					}
				l339:
					goto l333
				l337:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolName]() {
						goto l340
					}
					if !_rules[ruleOffset]() {
						goto l340
					}
					goto l333
				l340:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolName]() {
						goto l341
					}
					{
						position342, tokenIndex342 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l342
						}
						goto l343
					l342:
						position, tokenIndex = position342, tokenIndex342
					}
				l343:
					goto l333
				l341:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleDot]() {
						goto l344
					}
					goto l333
				l344:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleOpenParen]() {
						goto l331
					}
					{
						position345, tokenIndex345 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l345
						}
						goto l346
					l345:
						position, tokenIndex = position345, tokenIndex345
					}
				l346:
					if !_rules[ruleSymbolExpr]() {
						goto l331
					}
					{
						position347, tokenIndex347 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l347
						}
						goto l348
					l347:
						position, tokenIndex = position347, tokenIndex347
					}
				l348:
					if !_rules[ruleCloseParen]() {
						goto l331
					}
				}
			l333:
				add(ruleSymbolAtom, position332)
			}
			return true
		l331:
			position, tokenIndex = position331, tokenIndex331
			return false
		},
		/* 19 SymbolOperator <- <('+' / '-' / '|' / ('<' '<') / ('>' '>'))> */
		func() bool {
			position349, tokenIndex349 := position, tokenIndex
			{
				position350 := position
				{
					position351, tokenIndex351 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l352
					}
					position++
					goto l351
				l352:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('-') {
						goto l353
					}
					position++
					goto l351
				l353:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('|') {
						goto l354
					}
					position++
					goto l351
				l354:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('<') {
						goto l355
					}
					position++
					if buffer[position] != rune('<') {
						goto l355
					}
					position++
					goto l351
				l355:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('>') {
						goto l349
					}
					position++
					if buffer[position] != rune('>') {
						goto l349
					}
					position++
				}
			l351:
				add(ruleSymbolOperator, position350)
			}
			return true
		l349:
			position, tokenIndex = position349, tokenIndex349
			return false
		},
		/* 20 OpenParen <- <'('> */
		func() bool {
			position356, tokenIndex356 := position, tokenIndex
			{
				position357 := position
				if buffer[position] != rune('(') {
					goto l356
				}
				position++
				add(ruleOpenParen, position357)
			}
			return true
		l356:
			position, tokenIndex = position356, tokenIndex356
			return false
		},
		/* 21 CloseParen <- <')'> */
		func() bool {
			position358, tokenIndex358 := position, tokenIndex
			{
				position359 := position
				if buffer[position] != rune(')') {
					goto l358
				}
				position++
				add(ruleCloseParen, position359)
			}
			return true
		l358:
			position, tokenIndex = position358, tokenIndex358
			return false
		},
		/* 22 SymbolType <- <(('@' / '%') (('f' 'u' 'n' 'c' 't' 'i' 'o' 'n') / ('o' 'b' 'j' 'e' 'c' 't')))> */
		func() bool {
			position360, tokenIndex360 := position, tokenIndex
			{
				position361 := position
				{
					position362, tokenIndex362 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l363
					}
					position++
					goto l362
				l363:
					position, tokenIndex = position362, tokenIndex362
					if buffer[position] != rune('%') {
						goto l360
					}
					position++
				}
			l362:
				{
					position364, tokenIndex364 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l365
					}
					position++
					if buffer[position] != rune('u') {
						goto l365
					}
					position++
					if buffer[position] != rune('n') {
						goto l365
					}
					position++
					if buffer[position] != rune('c') {
						goto l365
					}
					position++
					if buffer[position] != rune('t') {
						goto l365
					}
					position++
					if buffer[position] != rune('i') {
						goto l365
					}
					position++
					if buffer[position] != rune('o') {
						goto l365
					}
					position++
					if buffer[position] != rune('n') {
						goto l365
					}
					position++
					goto l364
				l365:
					position, tokenIndex = position364, tokenIndex364
					if buffer[position] != rune('o') {
						goto l360
					}
					position++
					if buffer[position] != rune('b') {
						goto l360
					}
					position++
					if buffer[position] != rune('j') {
						goto l360
					}
					position++
					if buffer[position] != rune('e') {
						goto l360
					}
					position++
					if buffer[position] != rune('c') {
						goto l360
					}
					position++
					if buffer[position] != rune('t') {
						goto l360
					}
					position++
				}
			l364:
				add(ruleSymbolType, position361)
			}
			return true
		l360:
			position, tokenIndex = position360, tokenIndex360
			return false
		},
		/* 23 Dot <- <'.'> */
		func() bool {
			position366, tokenIndex366 := position, tokenIndex
			{
				position367 := position
				if buffer[position] != rune('.') {
					goto l366
				}
				position++
				add(ruleDot, position367)
			}
			return true
		l366:
			position, tokenIndex = position366, tokenIndex366
			return false
		},
		/* 24 TCMarker <- <('[' 'T' 'C' ']')> */
		func() bool {
			position368, tokenIndex368 := position, tokenIndex
			{
				position369 := position
				if buffer[position] != rune('[') {
					goto l368
				}
				position++
				if buffer[position] != rune('T') {
					goto l368
				}
				position++
				if buffer[position] != rune('C') {
					goto l368
				}
				position++
				if buffer[position] != rune(']') {
					goto l368
				}
				position++
				add(ruleTCMarker, position369)
			}
			return true
		l368:
			position, tokenIndex = position368, tokenIndex368
			return false
		},
		/* 25 EscapedChar <- <('\\' .)> */
		func() bool {
			position370, tokenIndex370 := position, tokenIndex
			{
				position371 := position
				if buffer[position] != rune('\\') {
					goto l370
				}
				position++
				if !matchDot() {
					goto l370
				}
				add(ruleEscapedChar, position371)
			}
			return true
		l370:
			position, tokenIndex = position370, tokenIndex370
			return false
		},
		/* 26 WS <- <(' ' / '\t')+> */
		func() bool {
			position372, tokenIndex372 := position, tokenIndex
			{
				position373 := position
				{
					position376, tokenIndex376 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l377
					}
					position++
					goto l376
				l377:
					position, tokenIndex = position376, tokenIndex376
					if buffer[position] != rune('\t') {
						goto l372
					}
					position++
				}
			l376:
			l374:
				{
					position375, tokenIndex375 := position, tokenIndex
					{
						position378, tokenIndex378 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l379
						}
						position++
						goto l378
					l379:
						position, tokenIndex = position378, tokenIndex378
						if buffer[position] != rune('\t') {
							goto l375
						}
						position++
					}
				l378:
					goto l374
				l375:
					position, tokenIndex = position375, tokenIndex375
				}
				add(ruleWS, position373)
			}
			return true
		l372:
			position, tokenIndex = position372, tokenIndex372
			return false
		},
		/* 27 Comment <- <((('/' '/') / '#') (!'\n' .)*)> */
		func() bool {
			position380, tokenIndex380 := position, tokenIndex
			{
				position381 := position
				{
					position382, tokenIndex382 := position, tokenIndex
					if buffer[position] != rune('/') {
						goto l383
					}
					position++
					if buffer[position] != rune('/') {
						goto l383
					}
					position++
					goto l382
				l383:
					position, tokenIndex = position382, tokenIndex382
					if buffer[position] != rune('#') {
						goto l380
					}
					position++
				}
			l382:
			l384:
				{
					position385, tokenIndex385 := position, tokenIndex
					{
						position386, tokenIndex386 := position, tokenIndex
						if buffer[position] != rune('\n') {
							goto l386
						}
						position++
						goto l385
					l386:
						position, tokenIndex = position386, tokenIndex386
					}
					if !matchDot() {
						goto l385
					}
					goto l384
				l385:
					position, tokenIndex = position385, tokenIndex385
				}
				add(ruleComment, position381)
			}
			return true
		l380:
			position, tokenIndex = position380, tokenIndex380
			return false
		},
		/* 28 Label <- <((LocalSymbol / LocalLabel / SymbolName) ':')> */
		func() bool {
			position387, tokenIndex387 := position, tokenIndex
			{
				position388 := position
				{
					position389, tokenIndex389 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l390
					}
					goto l389
				l390:
					position, tokenIndex = position389, tokenIndex389
					if !_rules[ruleLocalLabel]() {
						goto l391
					}
					goto l389
				l391:
					position, tokenIndex = position389, tokenIndex389
					if !_rules[ruleSymbolName]() {
						goto l387
					}
				}
			l389:
				if buffer[position] != rune(':') {
					goto l387
				}
				position++
				add(ruleLabel, position388)
			}
			return true
		l387:
			position, tokenIndex = position387, tokenIndex387
			return false
		},
		/* 29 SymbolName <- <(([a-z] / [A-Z] / '.' / '_') ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]) / '$' / '_')*)> */
		func() bool {
			position392, tokenIndex392 := position, tokenIndex
			{
				position393 := position
				{
					position394, tokenIndex394 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l395
					}
					position++
					goto l394
				l395:
					position, tokenIndex = position394, tokenIndex394
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l396
					}
					position++
					goto l394
				l396:
					position, tokenIndex = position394, tokenIndex394
					if buffer[position] != rune('.') {
						goto l397
					}
					position++
					goto l394
				l397:
					position, tokenIndex = position394, tokenIndex394
					if buffer[position] != rune('_') {
						goto l392
					}
					position++
				}
			l394:
			l398:
				{
					position399, tokenIndex399 := position, tokenIndex
					{
						position400, tokenIndex400 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l401
						}
						position++
						goto l400
					l401:
						position, tokenIndex = position400, tokenIndex400
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l402
						}
						position++
						goto l400
					l402:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('.') {
							goto l403
						}
						position++
						goto l400
					l403:
						position, tokenIndex = position400, tokenIndex400
						{
							position405, tokenIndex405 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l406
							}
							position++
							goto l405
						l406:
							position, tokenIndex = position405, tokenIndex405
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l404
							}
							position++
						}
					l405:
						goto l400
					l404:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('$') {
							goto l407
						}
						position++
						goto l400
					l407:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('_') {
							goto l399
						}
						position++
					}
				l400:
					goto l398
				l399:
					position, tokenIndex = position399, tokenIndex399
				}
				add(ruleSymbolName, position393)
			}
			return true
		l392:
			position, tokenIndex = position392, tokenIndex392
			return false
		},
		/* 30 LocalSymbol <- <('.' 'L' ([a-z] / [A-Z] / ([a-z] / [A-Z]) / '.' / ([0-9] / [0-9]) / '$' / '_')+)> */
		func() bool {
			position408, tokenIndex408 := position, tokenIndex
			{
				position409 := position
				if buffer[position] != rune('.') {
					goto l408
				}
				position++
				if buffer[position] != rune('L') {
					goto l408
				}
				position++
				{
					position412, tokenIndex412 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l413
					}
					position++
					goto l412
				l413:
					position, tokenIndex = position412, tokenIndex412
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l414
					}
					position++
					goto l412
				l414:
					position, tokenIndex = position412, tokenIndex412
					{
						position416, tokenIndex416 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l417
						}
						position++
						goto l416
					l417:
						position, tokenIndex = position416, tokenIndex416
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l415
						}
						position++
					}
				l416:
					goto l412
				l415:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('.') {
						goto l418
					}
					position++
					goto l412
				l418:
					position, tokenIndex = position412, tokenIndex412
					{
						position420, tokenIndex420 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l421
						}
						position++
						goto l420
					l421:
						position, tokenIndex = position420, tokenIndex420
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l419
						}
						position++
					}
				l420:
					goto l412
				l419:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('$') {
						goto l422
					}
					position++
					goto l412
				l422:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('_') {
						goto l408
					}
					position++
				}
			l412:
			l410:
				{
					position411, tokenIndex411 := position, tokenIndex
					{
						position423, tokenIndex423 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l424
						}
						position++
						goto l423
					l424:
						position, tokenIndex = position423, tokenIndex423
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l425
						}
						position++
						goto l423
					l425:
						position, tokenIndex = position423, tokenIndex423
						{
							position427, tokenIndex427 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l428
							}
							position++
							goto l427
						l428:
							position, tokenIndex = position427, tokenIndex427
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l426
							}
							position++
						}
					l427:
						goto l423
					l426:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('.') {
							goto l429
						}
						position++
						goto l423
					l429:
						position, tokenIndex = position423, tokenIndex423
						{
							position431, tokenIndex431 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l432
							}
							position++
							goto l431
						l432:
							position, tokenIndex = position431, tokenIndex431
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l430
							}
							position++
						}
					l431:
						goto l423
					l430:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('$') {
							goto l433
						}
						position++
						goto l423
					l433:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('_') {
							goto l411
						}
						position++
					}
				l423:
					goto l410
				l411:
					position, tokenIndex = position411, tokenIndex411
				}
				add(ruleLocalSymbol, position409)
			}
			return true
		l408:
			position, tokenIndex = position408, tokenIndex408
			return false
		},
		/* 31 LocalLabel <- <([0-9] ([0-9] / '$')*)> */
		func() bool {
			position434, tokenIndex434 := position, tokenIndex
			{
				position435 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l434
				}
				position++
			l436:
				{
					position437, tokenIndex437 := position, tokenIndex
					{
						position438, tokenIndex438 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l439
						}
						position++
						goto l438
					l439:
						position, tokenIndex = position438, tokenIndex438
						if buffer[position] != rune('$') {
							goto l437
						}
						position++
					}
				l438:
					goto l436
				l437:
					position, tokenIndex = position437, tokenIndex437
				}
				add(ruleLocalLabel, position435)
			}
			return true
		l434:
			position, tokenIndex = position434, tokenIndex434
			return false
		},
		/* 32 LocalLabelRef <- <([0-9] ([0-9] / '$')* ('b' / 'f'))> */
		func() bool {
			position440, tokenIndex440 := position, tokenIndex
			{
				position441 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l440
				}
				position++
			l442:
				{
					position443, tokenIndex443 := position, tokenIndex
					{
						position444, tokenIndex444 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l445
						}
						position++
						goto l444
					l445:
						position, tokenIndex = position444, tokenIndex444
						if buffer[position] != rune('$') {
							goto l443
						}
						position++
					}
				l444:
					goto l442
				l443:
					position, tokenIndex = position443, tokenIndex443
				}
				{
					position446, tokenIndex446 := position, tokenIndex
					if buffer[position] != rune('b') {
						goto l447
					}
					position++
					goto l446
				l447:
					position, tokenIndex = position446, tokenIndex446
					if buffer[position] != rune('f') {
						goto l440
					}
					position++
				}
			l446:
				add(ruleLocalLabelRef, position441)
			}
			return true
		l440:
			position, tokenIndex = position440, tokenIndex440
			return false
		},
		/* 33 Instruction <- <(InstructionName (WS InstructionArg (WS? ','? WS? InstructionArg)*)?)> */
		func() bool {
			position448, tokenIndex448 := position, tokenIndex
			{
				position449 := position
				if !_rules[ruleInstructionName]() {
					goto l448
				}
				{
					position450, tokenIndex450 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l450
					}
					if !_rules[ruleInstructionArg]() {
						goto l450
					}
				l452:
					{
						position453, tokenIndex453 := position, tokenIndex
						{
							position454, tokenIndex454 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l454
							}
							goto l455
						l454:
							position, tokenIndex = position454, tokenIndex454
						}
					l455:
						{
							position456, tokenIndex456 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l456
							}
							position++
							goto l457
						l456:
							position, tokenIndex = position456, tokenIndex456
						}
					l457:
						{
							position458, tokenIndex458 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l458
							}
							goto l459
						l458:
							position, tokenIndex = position458, tokenIndex458
						}
					l459:
						if !_rules[ruleInstructionArg]() {
							goto l453
						}
						goto l452
					l453:
						position, tokenIndex = position453, tokenIndex453
					}
					goto l451
				l450:
					position, tokenIndex = position450, tokenIndex450
				}
			l451:
				add(ruleInstruction, position449)
			}
			return true
		l448:
			position, tokenIndex = position448, tokenIndex448
			return false
		},
		/* 34 InstructionName <- <(([a-z] / [A-Z]) ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]))* ('.' / '+' / '-')?)> */
		func() bool {
			position460, tokenIndex460 := position, tokenIndex
			{
				position461 := position
				{
					position462, tokenIndex462 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l463
					}
					position++
					goto l462
				l463:
					position, tokenIndex = position462, tokenIndex462
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l460
					}
					position++
				}
			l462:
			l464:
				{
					position465, tokenIndex465 := position, tokenIndex
					{
						position466, tokenIndex466 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l467
						}
						position++
						goto l466
					l467:
						position, tokenIndex = position466, tokenIndex466
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l468
						}
						position++
						goto l466
					l468:
						position, tokenIndex = position466, tokenIndex466
						if buffer[position] != rune('.') {
							goto l469
						}
						position++
						goto l466
					l469:
						position, tokenIndex = position466, tokenIndex466
						{
							position470, tokenIndex470 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l471
							}
							position++
							goto l470
						l471:
							position, tokenIndex = position470, tokenIndex470
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l465
							}
							position++
						}
					l470:
					}
				l466:
					goto l464
				l465:
					position, tokenIndex = position465, tokenIndex465
				}
				{
					position472, tokenIndex472 := position, tokenIndex
					{
						position474, tokenIndex474 := position, tokenIndex
						if buffer[position] != rune('.') {
							goto l475
						}
						position++
						goto l474
					l475:
						position, tokenIndex = position474, tokenIndex474
						if buffer[position] != rune('+') {
							goto l476
						}
						position++
						goto l474
					l476:
						position, tokenIndex = position474, tokenIndex474
						if buffer[position] != rune('-') {
							goto l472
						}
						position++
					}
				l474:
					goto l473
				l472:
					position, tokenIndex = position472, tokenIndex472
				}
			l473:
				add(ruleInstructionName, position461)
			}
			return true
		l460:
			position, tokenIndex = position460, tokenIndex460
			return false
		},
		/* 35 InstructionArg <- <(IndirectionIndicator? (ARMConstantTweak / RegisterOrConstant / LocalLabelRef / TOCRefHigh / TOCRefLow / GOTLocation / GOTSymbolOffset / MemoryRef / AVX512Token))> */
		func() bool {
			position477, tokenIndex477 := position, tokenIndex
			{
				position478 := position
				{
					position479, tokenIndex479 := position, tokenIndex
					if !_rules[ruleIndirectionIndicator]() {
						goto l479
					}
					goto l480
				l479:
					position, tokenIndex = position479, tokenIndex479
				}
			l480:
				{
					position481, tokenIndex481 := position, tokenIndex
					if !_rules[ruleARMConstantTweak]() {
						goto l482
					}
					goto l481
				l482:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleRegisterOrConstant]() {
						goto l483
					}
					goto l481
				l483:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleLocalLabelRef]() {
						goto l484
					}
					goto l481
				l484:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleTOCRefHigh]() {
						goto l485
					}
					goto l481
				l485:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleTOCRefLow]() {
						goto l486
					}
					goto l481
				l486:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleGOTLocation]() {
						goto l487
					}
					goto l481
				l487:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleGOTSymbolOffset]() {
						goto l488
					}
					goto l481
				l488:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleMemoryRef]() {
						goto l489
					}
					goto l481
				l489:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleAVX512Token]() {
						goto l477
					}
				}
			l481:
				add(ruleInstructionArg, position478)
			}
			return true
		l477:
			position, tokenIndex = position477, tokenIndex477
			return false
		},
		/* 36 GOTLocation <- <('$' '_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '-' LocalSymbol)> */
		func() bool {
			position490, tokenIndex490 := position, tokenIndex
			{
				position491 := position
				if buffer[position] != rune('$') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('G') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('O') {
					goto l490
				}
				position++
				if buffer[position] != rune('B') {
					goto l490
				}
				position++
				if buffer[position] != rune('A') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('O') {
					goto l490
				}
				position++
				if buffer[position] != rune('F') {
					goto l490
				}
				position++
				if buffer[position] != rune('F') {
					goto l490
				}
				position++
				if buffer[position] != rune('S') {
					goto l490
				}
				position++
				if buffer[position] != rune('E') {
					goto l490
				}
				position++
				if buffer[position] != rune('T') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('T') {
					goto l490
				}
				position++
				if buffer[position] != rune('A') {
					goto l490
				}
				position++
				if buffer[position] != rune('B') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('E') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('-') {
					goto l490
				}
				position++
				if !_rules[ruleLocalSymbol]() {
					goto l490
				}
				add(ruleGOTLocation, position491)
			}
			return true
		l490:
			position, tokenIndex = position490, tokenIndex490
			return false
		},
		/* 37 GOTSymbolOffset <- <(('$' SymbolName ('@' 'G' 'O' 'T') ('O' 'F' 'F')?) / (':' ('g' / 'G') ('o' / 'O') ('t' / 'T') ':' SymbolName))> */
		func() bool {
			position492, tokenIndex492 := position, tokenIndex
			{
				position493 := position
				{
					position494, tokenIndex494 := position, tokenIndex
					if buffer[position] != rune('$') {
						goto l495
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l495
					}
					if buffer[position] != rune('@') {
						goto l495
					}
					position++
					if buffer[position] != rune('G') {
						goto l495
					}
					position++
					if buffer[position] != rune('O') {
						goto l495
					}
					position++
					if buffer[position] != rune('T') {
						goto l495
					}
					position++
					{
						position496, tokenIndex496 := position, tokenIndex
						if buffer[position] != rune('O') {
							goto l496
						}
						position++
						if buffer[position] != rune('F') {
							goto l496
						}
						position++
						if buffer[position] != rune('F') {
							goto l496
						}
						position++
						goto l497
					l496:
						position, tokenIndex = position496, tokenIndex496
					}
				l497:
					goto l494
				l495:
					position, tokenIndex = position494, tokenIndex494
					if buffer[position] != rune(':') {
						goto l492
					}
					position++
					{
						position498, tokenIndex498 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l499
						}
						position++
						goto l498
					l499:
						position, tokenIndex = position498, tokenIndex498
						if buffer[position] != rune('G') {
							goto l492
						}
						position++
					}
				l498:
					{
						position500, tokenIndex500 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l501
						}
						position++
						goto l500
					l501:
						position, tokenIndex = position500, tokenIndex500
						if buffer[position] != rune('O') {
							goto l492
						}
						position++
					}
				l500:
					{
						position502, tokenIndex502 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l503
						}
						position++
						goto l502
					l503:
						position, tokenIndex = position502, tokenIndex502
						if buffer[position] != rune('T') {
							goto l492
						}
						position++
					}
				l502:
					if buffer[position] != rune(':') {
						goto l492
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l492
					}
				}
			l494:
				add(ruleGOTSymbolOffset, position493)
			}
			return true
		l492:
			position, tokenIndex = position492, tokenIndex492
			return false
		},
		/* 38 AVX512Token <- <(WS? '{' '%'? ([0-9] / [a-z])* '}')> */
		func() bool {
			position504, tokenIndex504 := position, tokenIndex
			{
				position505 := position
				{
					position506, tokenIndex506 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l506
					}
					goto l507
				l506:
					position, tokenIndex = position506, tokenIndex506
				}
			l507:
				if buffer[position] != rune('{') {
					goto l504
				}
				position++
				{
					position508, tokenIndex508 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l508
					}
					position++
					goto l509
				l508:
					position, tokenIndex = position508, tokenIndex508
				}
			l509:
			l510:
				{
					position511, tokenIndex511 := position, tokenIndex
					{
						position512, tokenIndex512 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l513
						}
						position++
						goto l512
					l513:
						position, tokenIndex = position512, tokenIndex512
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l511
						}
						position++
					}
				l512:
					goto l510
				l511:
					position, tokenIndex = position511, tokenIndex511
				}
				if buffer[position] != rune('}') {
					goto l504
				}
				position++
				add(ruleAVX512Token, position505)
			}
			return true
		l504:
			position, tokenIndex = position504, tokenIndex504
			return false
		},
		/* 39 TOCRefHigh <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('h' / 'H') ('a' / 'A')))> */
		func() bool {
			position514, tokenIndex514 := position, tokenIndex
			{
				position515 := position
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('T') {
					goto l514
				}
				position++
				if buffer[position] != rune('O') {
					goto l514
				}
				position++
				if buffer[position] != rune('C') {
					goto l514
				}
				position++
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('-') {
					goto l514
				}
				position++
				{
					position516, tokenIndex516 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l517
					}
					position++
					if buffer[position] != rune('b') {
						goto l517
					}
					position++
					goto l516
				l517:
					position, tokenIndex = position516, tokenIndex516
					if buffer[position] != rune('.') {
						goto l514
					}
					position++
					if buffer[position] != rune('L') {
						goto l514
					}
					position++
					{
						position520, tokenIndex520 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l521
						}
						position++
						goto l520
					l521:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l522
						}
						position++
						goto l520
					l522:
						position, tokenIndex = position520, tokenIndex520
						if buffer[position] != rune('_') {
							goto l523
						}
						position++
						goto l520
					l523:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l514
						}
						position++
					}
				l520:
				l518:
					{
						position519, tokenIndex519 := position, tokenIndex
						{
							position524, tokenIndex524 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l525
							}
							position++
							goto l524
						l525:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l526
							}
							position++
							goto l524
						l526:
							position, tokenIndex = position524, tokenIndex524
							if buffer[position] != rune('_') {
								goto l527
							}
							position++
							goto l524
						l527:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l519
							}
							position++
						}
					l524:
						goto l518
					l519:
						position, tokenIndex = position519, tokenIndex519
					}
				}
			l516:
				if buffer[position] != rune('@') {
					goto l514
				}
				position++
				{
					position528, tokenIndex528 := position, tokenIndex
					if buffer[position] != rune('h') {
						goto l529
					}
					position++
					goto l528
				l529:
					position, tokenIndex = position528, tokenIndex528
					if buffer[position] != rune('H') {
						goto l514
					}
					position++
				}
			l528:
				{
					position530, tokenIndex530 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l531
					}
					position++
					goto l530
				l531:
					position, tokenIndex = position530, tokenIndex530
					if buffer[position] != rune('A') {
						goto l514
					}
					position++
				}
			l530:
				add(ruleTOCRefHigh, position515)
			}
			return true
		l514:
			position, tokenIndex = position514, tokenIndex514
			return false
		},
		/* 40 TOCRefLow <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('l' / 'L')))> */
		func() bool {
			position532, tokenIndex532 := position, tokenIndex
			{
				position533 := position
				if buffer[position] != rune('.') {
					goto l532
				}
				position++
				if buffer[position] != rune('T') {
					goto l532
				}
				position++
				if buffer[position] != rune('O') {
					goto l532
				}
				position++
				if buffer[position] != rune('C') {
					goto l532
				}
				position++
				if buffer[position] != rune('.') {
					goto l532
				}
				position++
				if buffer[position] != rune('-') {
					goto l532
				}
				position++
				{
					position534, tokenIndex534 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l535
					}
					position++
					if buffer[position] != rune('b') {
						goto l535
					}
					position++
					goto l534
				l535:
					position, tokenIndex = position534, tokenIndex534
					if buffer[position] != rune('.') {
						goto l532
					}
					position++
					if buffer[position] != rune('L') {
						goto l532
					}
					position++
					{
						position538, tokenIndex538 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l539
						}
						position++
						goto l538
					l539:
						position, tokenIndex = position538, tokenIndex538
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l540
						}
						position++
						goto l538
					l540:
						position, tokenIndex = position538, tokenIndex538
						if buffer[position] != rune('_') {
							goto l541
						}
						position++
						goto l538
					l541:
						position, tokenIndex = position538, tokenIndex538
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l532
						}
						position++
					}
				l538:
				l536:
					{
						position537, tokenIndex537 := position, tokenIndex
						{
							position542, tokenIndex542 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l543
							}
							position++
							goto l542
						l543:
							position, tokenIndex = position542, tokenIndex542
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l544
							}
							position++
							goto l542
						l544:
							position, tokenIndex = position542, tokenIndex542
							if buffer[position] != rune('_') {
								goto l545
							}
							position++
							goto l542
						l545:
							position, tokenIndex = position542, tokenIndex542
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l537
							}
							position++
						}
					l542:
						goto l536
					l537:
						position, tokenIndex = position537, tokenIndex537
					}
				}
			l534:
				if buffer[position] != rune('@') {
					goto l532
				}
				position++
				{
					position546, tokenIndex546 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l547
					}
					position++
					goto l546
				l547:
					position, tokenIndex = position546, tokenIndex546
					if buffer[position] != rune('L') {
						goto l532
					}
					position++
				}
			l546:
				add(ruleTOCRefLow, position533)
			}
			return true
		l532:
			position, tokenIndex = position532, tokenIndex532
			return false
		},
		/* 41 IndirectionIndicator <- <'*'> */
		func() bool {
			position548, tokenIndex548 := position, tokenIndex
			{
				position549 := position
				if buffer[position] != rune('*') {
					goto l548
				}
				position++
				add(ruleIndirectionIndicator, position549)
			}
			return true
		l548:
			position, tokenIndex = position548, tokenIndex548
			return false
		},
		/* 42 RegisterOrConstant <- <((('%' ([a-z] / [A-Z]) ([a-z] / [A-Z] / ([0-9] / [0-9]))*) / ('$' [0-9]+ WS? '*' WS? '(' [0-9]+ WS? '-' WS? [0-9]+ ')') / ('$'? ((Offset Offset) / Offset)) / ('#' Offset ('*' [0-9]+ ('-' [0-9] [0-9]*)?)?) / ('#' '~'? '(' [0-9] WS? ('<' '<') WS? [0-9] [0-9]? ')') / (('#' / '$') '~'? ('0' 'x')? ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ('$' '(' '-' [0-9]+ ')') / ('#' '(' [0-9]+ ')') / ARMRegister) !('f' / 'b' / ':' / '(' / '+' / '-'))> */
		func() bool {
			position550, tokenIndex550 := position, tokenIndex
			{
				position551 := position
				{
					position552, tokenIndex552 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l553
					}
					position++
					{
						position554, tokenIndex554 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l555
						}
						position++
						goto l554
					l555:
						position, tokenIndex = position554, tokenIndex554
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l553
						}
						position++
					}
				l554:
				l556:
					{
						position557, tokenIndex557 := position, tokenIndex
						{
							position558, tokenIndex558 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l559
							}
							position++
							goto l558
						l559:
							position, tokenIndex = position558, tokenIndex558
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l560
							}
							position++
							goto l558
						l560:
							position, tokenIndex = position558, tokenIndex558
							{
								position561, tokenIndex561 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l562
								}
								position++
								goto l561
							l562:
								position, tokenIndex = position561, tokenIndex561
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l557
								}
								position++
							}
						l561:
						}
					l558:
						goto l556
					l557:
						position, tokenIndex = position557, tokenIndex557
					}
					goto l552
				l553:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('$') {
						goto l563
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l564:
					{
						position565, tokenIndex565 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l565
						}
						position++
						goto l564
					l565:
						position, tokenIndex = position565, tokenIndex565
					}
					{
						position566, tokenIndex566 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l566
						}
						goto l567
					l566:
						position, tokenIndex = position566, tokenIndex566
					}
				l567:
					if buffer[position] != rune('*') {
						goto l563
					}
					position++
					{
						position568, tokenIndex568 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l568
						}
						goto l569
					l568:
						position, tokenIndex = position568, tokenIndex568
					}
				l569:
					if buffer[position] != rune('(') {
						goto l563
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l570:
					{
						position571, tokenIndex571 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l571
						}
						position++
						goto l570
					l571:
						position, tokenIndex = position571, tokenIndex571
					}
					{
						position572, tokenIndex572 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l572
						}
						goto l573
					l572:
						position, tokenIndex = position572, tokenIndex572
					}
				l573:
					if buffer[position] != rune('-') {
						goto l563
					}
					position++
					{
						position574, tokenIndex574 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l574
						}
						goto l575
					l574:
						position, tokenIndex = position574, tokenIndex574
					}
				l575:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l576:
					{
						position577, tokenIndex577 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l577
						}
						position++
						goto l576
					l577:
						position, tokenIndex = position577, tokenIndex577
					}
					if buffer[position] != rune(')') {
						goto l563
					}
					position++
					goto l552
				l563:
					position, tokenIndex = position552, tokenIndex552
					{
						position579, tokenIndex579 := position, tokenIndex
						if buffer[position] != rune('$') {
							goto l579
						}
						position++
						goto l580
					l579:
						position, tokenIndex = position579, tokenIndex579
					}
				l580:
					{
						position581, tokenIndex581 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l582
						}
						if !_rules[ruleOffset]() {
							goto l582
						}
						goto l581
					l582:
						position, tokenIndex = position581, tokenIndex581
						if !_rules[ruleOffset]() {
							goto l578
						}
					}
				l581:
					goto l552
				l578:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('#') {
						goto l583
					}
					position++
					if !_rules[ruleOffset]() {
						goto l583
					}
					{
						position584, tokenIndex584 := position, tokenIndex
						if buffer[position] != rune('*') {
							goto l584
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l584
						}
						position++
					l586:
						{
							position587, tokenIndex587 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l587
							}
							position++
							goto l586
						l587:
							position, tokenIndex = position587, tokenIndex587
						}
						{
							position588, tokenIndex588 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l588
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l588
							}
							position++
						l590:
							{
								position591, tokenIndex591 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l591
								}
								position++
								goto l590
							l591:
								position, tokenIndex = position591, tokenIndex591
							}
							goto l589
						l588:
							position, tokenIndex = position588, tokenIndex588
						}
					l589:
						goto l585
					l584:
						position, tokenIndex = position584, tokenIndex584
					}
				l585:
					goto l552
				l583:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('#') {
						goto l592
					}
					position++
					{
						position593, tokenIndex593 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l593
						}
						position++
						goto l594
					l593:
						position, tokenIndex = position593, tokenIndex593
					}
				l594:
					if buffer[position] != rune('(') {
						goto l592
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l592
					}
					position++
					{
						position595, tokenIndex595 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l595
						}
						goto l596
					l595:
						position, tokenIndex = position595, tokenIndex595
					}
				l596:
					if buffer[position] != rune('<') {
						goto l592
					}
					position++
					if buffer[position] != rune('<') {
						goto l592
					}
					position++
					{
						position597, tokenIndex597 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l597
						}
						goto l598
					l597:
						position, tokenIndex = position597, tokenIndex597
					}
				l598:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l592
					}
					position++
					{
						position599, tokenIndex599 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l599
						}
						position++
						goto l600
					l599:
						position, tokenIndex = position599, tokenIndex599
					}
				l600:
					if buffer[position] != rune(')') {
						goto l592
					}
					position++
					goto l552
				l592:
					position, tokenIndex = position552, tokenIndex552
					{
						position602, tokenIndex602 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l603
						}
						position++
						goto l602
					l603:
						position, tokenIndex = position602, tokenIndex602
						if buffer[position] != rune('$') {
							goto l601
						}
						position++
					}
				l602:
					{
						position604, tokenIndex604 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l604
						}
						position++
						goto l605
					l604:
						position, tokenIndex = position604, tokenIndex604
					}
				l605:
					{
						position606, tokenIndex606 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l606
						}
						position++
						if buffer[position] != rune('x') {
							goto l606
						}
						position++
						goto l607
					l606:
						position, tokenIndex = position606, tokenIndex606
					}
				l607:
					{
						position610, tokenIndex610 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l611
						}
						position++
						goto l610
					l611:
						position, tokenIndex = position610, tokenIndex610
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l612
						}
						position++
						goto l610
					l612:
						position, tokenIndex = position610, tokenIndex610
						{
							position613, tokenIndex613 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l614
							}
							position++
							goto l613
						l614:
							position, tokenIndex = position613, tokenIndex613
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l601
							}
							position++
						}
					l613:
					}
				l610:
				l608:
					{
						position609, tokenIndex609 := position, tokenIndex
						{
							position615, tokenIndex615 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l616
							}
							position++
							goto l615
						l616:
							position, tokenIndex = position615, tokenIndex615
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l617
							}
							position++
							goto l615
						l617:
							position, tokenIndex = position615, tokenIndex615
							{
								position618, tokenIndex618 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l619
								}
								position++
								goto l618
							l619:
								position, tokenIndex = position618, tokenIndex618
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l609
								}
								position++
							}
						l618:
						}
					l615:
						goto l608
					l609:
						position, tokenIndex = position609, tokenIndex609
					}
					goto l552
				l601:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('$') {
						goto l620
					}
					position++
					if buffer[position] != rune('(') {
						goto l620
					}
					position++
					if buffer[position] != rune('-') {
						goto l620
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l620
					}
					position++
				l621:
					{
						position622, tokenIndex622 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l622
						}
						position++
						goto l621
					l622:
						position, tokenIndex = position622, tokenIndex622
					}
					if buffer[position] != rune(')') {
						goto l620
					}
					position++
					goto l552
				l620:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('#') {
						goto l623
					}
					position++
					if buffer[position] != rune('(') {
						goto l623
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l623
					}
					position++
				l624:
					{
						position625, tokenIndex625 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l625
						}
						position++
						goto l624
					l625:
						position, tokenIndex = position625, tokenIndex625
					}
					if buffer[position] != rune(')') {
						goto l623
					}
					position++
					goto l552
				l623:
					position, tokenIndex = position552, tokenIndex552
					if !_rules[ruleARMRegister]() {
						goto l550
					}
				}
			l552:
				{
					position626, tokenIndex626 := position, tokenIndex
					{
						position627, tokenIndex627 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l628
						}
						position++
						goto l627
					l628:
						position, tokenIndex = position627, tokenIndex627
						if buffer[position] != rune('b') {
							goto l629
						}
						position++
						goto l627
					l629:
						position, tokenIndex = position627, tokenIndex627
						if buffer[position] != rune(':') {
							goto l630
						}
						position++
						goto l627
					l630:
						position, tokenIndex = position627, tokenIndex627
						if buffer[position] != rune('(') {
							goto l631
						}
						position++
						goto l627
					l631:
						position, tokenIndex = position627, tokenIndex627
						if buffer[position] != rune('+') {
							goto l632
						}
						position++
						goto l627
					l632:
						position, tokenIndex = position627, tokenIndex627
						if buffer[position] != rune('-') {
							goto l626
						}
						position++
					}
				l627:
					goto l550
				l626:
					position, tokenIndex = position626, tokenIndex626
				}
				add(ruleRegisterOrConstant, position551)
			}
			return true
		l550:
			position, tokenIndex = position550, tokenIndex550
			return false
		},
		/* 43 ARMConstantTweak <- <((((('u' / 's') (('x' / 'X') ('t' / 'T')) ('x' / 'w' / 'h' / 'b')) / (('l' / 'L') ('s' / 'S') ('l' / 'L')) / (('l' / 'L') ('s' / 'S') ('r' / 'R')) / (('r' / 'R') ('o' / 'O') ('r' / 'R')) / (('a' / 'A') ('s' / 'S') ('r' / 'R'))) (WS '#'? Offset)?) / (('m' / 'M') ('u' / 'U') ('l' / 'L') ' ' ('v' / 'V') ('l' / 'L')))> */
		func() bool {
			position633, tokenIndex633 := position, tokenIndex
			{
				position634 := position
				{
					position635, tokenIndex635 := position, tokenIndex
					{
						position637, tokenIndex637 := position, tokenIndex
						{
							position639, tokenIndex639 := position, tokenIndex
							if buffer[position] != rune('u') {
								goto l640
							}
							position++
							goto l639
						l640:
							position, tokenIndex = position639, tokenIndex639
							if buffer[position] != rune('s') {
								goto l638
							}
							position++
						}
					l639:
						{
							position641, tokenIndex641 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l642
							}
							position++
							goto l641
						l642:
							position, tokenIndex = position641, tokenIndex641
							if buffer[position] != rune('X') {
								goto l638
							}
							position++
						}
					l641:
						{
							position643, tokenIndex643 := position, tokenIndex
							if buffer[position] != rune('t') {
								goto l644
							}
							position++
							goto l643
						l644:
							position, tokenIndex = position643, tokenIndex643
							if buffer[position] != rune('T') {
								goto l638
							}
							position++
						}
					l643:
						{
							position645, tokenIndex645 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l646
							}
							position++
							goto l645
						l646:
							position, tokenIndex = position645, tokenIndex645
							if buffer[position] != rune('w') {
								goto l647
							}
							position++
							goto l645
						l647:
							position, tokenIndex = position645, tokenIndex645
							if buffer[position] != rune('h') {
								goto l648
							}
							position++
							goto l645
						l648:
							position, tokenIndex = position645, tokenIndex645
							if buffer[position] != rune('b') {
								goto l638
							}
							position++
						}
					l645:
						goto l637
					l638:
						position, tokenIndex = position637, tokenIndex637
						{
							position650, tokenIndex650 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l651
							}
							position++
							goto l650
						l651:
							position, tokenIndex = position650, tokenIndex650
							if buffer[position] != rune('L') {
								goto l649
							}
							position++
						}
					l650:
						{
							position652, tokenIndex652 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l653
							}
							position++
							goto l652
						l653:
							position, tokenIndex = position652, tokenIndex652
							if buffer[position] != rune('S') {
								goto l649
							}
							position++
						}
					l652:
						{
							position654, tokenIndex654 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l655
							}
							position++
							goto l654
						l655:
							position, tokenIndex = position654, tokenIndex654
							if buffer[position] != rune('L') {
								goto l649
							}
							position++
						}
					l654:
						goto l637
					l649:
						position, tokenIndex = position637, tokenIndex637
						{
							position657, tokenIndex657 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l658
							}
							position++
							goto l657
						l658:
							position, tokenIndex = position657, tokenIndex657
							if buffer[position] != rune('L') {
								goto l656
							}
							position++
						}
					l657:
						{
							position659, tokenIndex659 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l660
							}
							position++
							goto l659
						l660:
							position, tokenIndex = position659, tokenIndex659
							if buffer[position] != rune('S') {
								goto l656
							}
							position++
						}
					l659:
						{
							position661, tokenIndex661 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l662
							}
							position++
							goto l661
						l662:
							position, tokenIndex = position661, tokenIndex661
							if buffer[position] != rune('R') {
								goto l656
							}
							position++
						}
					l661:
						goto l637
					l656:
						position, tokenIndex = position637, tokenIndex637
						{
							position664, tokenIndex664 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l665
							}
							position++
							goto l664
						l665:
							position, tokenIndex = position664, tokenIndex664
							if buffer[position] != rune('R') {
								goto l663
							}
							position++
						}
					l664:
						{
							position666, tokenIndex666 := position, tokenIndex
							if buffer[position] != rune('o') {
								goto l667
							}
							position++
							goto l666
						l667:
							position, tokenIndex = position666, tokenIndex666
							if buffer[position] != rune('O') {
								goto l663
							}
							position++
						}
					l666:
						{
							position668, tokenIndex668 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l669
							}
							position++
							goto l668
						l669:
							position, tokenIndex = position668, tokenIndex668
							if buffer[position] != rune('R') {
								goto l663
							}
							position++
						}
					l668:
						goto l637
					l663:
						position, tokenIndex = position637, tokenIndex637
						{
							position670, tokenIndex670 := position, tokenIndex
							if buffer[position] != rune('a') {
								goto l671
							}
							position++
							goto l670
						l671:
							position, tokenIndex = position670, tokenIndex670
							if buffer[position] != rune('A') {
								goto l636
							}
							position++
						}
					l670:
						{
							position672, tokenIndex672 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l673
							}
							position++
							goto l672
						l673:
							position, tokenIndex = position672, tokenIndex672
							if buffer[position] != rune('S') {
								goto l636
							}
							position++
						}
					l672:
						{
							position674, tokenIndex674 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l675
							}
							position++
							goto l674
						l675:
							position, tokenIndex = position674, tokenIndex674
							if buffer[position] != rune('R') {
								goto l636
							}
							position++
						}
					l674:
					}
				l637:
					{
						position676, tokenIndex676 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l676
						}
						{
							position678, tokenIndex678 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l678
							}
							position++
							goto l679
						l678:
							position, tokenIndex = position678, tokenIndex678
						}
					l679:
						if !_rules[ruleOffset]() {
							goto l676
						}
						goto l677
					l676:
						position, tokenIndex = position676, tokenIndex676
					}
				l677:
					goto l635
				l636:
					position, tokenIndex = position635, tokenIndex635
					{
						position680, tokenIndex680 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l681
						}
						position++
						goto l680
					l681:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('M') {
							goto l633
						}
						position++
					}
				l680:
					{
						position682, tokenIndex682 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l683
						}
						position++
						goto l682
					l683:
						position, tokenIndex = position682, tokenIndex682
						if buffer[position] != rune('U') {
							goto l633
						}
						position++
					}
				l682:
					{
						position684, tokenIndex684 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l685
						}
						position++
						goto l684
					l685:
						position, tokenIndex = position684, tokenIndex684
						if buffer[position] != rune('L') {
							goto l633
						}
						position++
					}
				l684:
					if buffer[position] != rune(' ') {
						goto l633
					}
					position++
					{
						position686, tokenIndex686 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l687
						}
						position++
						goto l686
					l687:
						position, tokenIndex = position686, tokenIndex686
						if buffer[position] != rune('V') {
							goto l633
						}
						position++
					}
				l686:
					{
						position688, tokenIndex688 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l689
						}
						position++
						goto l688
					l689:
						position, tokenIndex = position688, tokenIndex688
						if buffer[position] != rune('L') {
							goto l633
						}
						position++
					}
				l688:
				}
			l635:
				add(ruleARMConstantTweak, position634)
			}
			return true
		l633:
			position, tokenIndex = position633, tokenIndex633
			return false
		},
		/* 44 ARMRegister <- <((('s' / 'S') ('p' / 'P')) / (('x' / 'w' / 'd' / 'q' / 's' / 'h' / 'b') [0-9] [0-9]? !ARMRegisterBoundary) / (('x' / 'X') ('z' / 'Z') ('r' / 'R')) / (('w' / 'W') ('z' / 'Z') ('r' / 'R')) / (('n' / 'N') ('z' / 'Z') ('c' / 'C') ('v' / 'V')) / ARMVectorRegister / SVE2PredicateRegister / ('{' WS? ARMVectorRegister WS? ((',' / '-') WS? ARMVectorRegister)* WS? '}' ('[' [0-9] [0-9]? ']')?))> */
		func() bool {
			position690, tokenIndex690 := position, tokenIndex
			{
				position691 := position
				{
					position692, tokenIndex692 := position, tokenIndex
					{
						position694, tokenIndex694 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l695
						}
						position++
						goto l694
					l695:
						position, tokenIndex = position694, tokenIndex694
						if buffer[position] != rune('S') {
							goto l693
						}
						position++
					}
				l694:
					{
						position696, tokenIndex696 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l697
						}
						position++
						goto l696
					l697:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('P') {
							goto l693
						}
						position++
					}
				l696:
					goto l692
				l693:
					position, tokenIndex = position692, tokenIndex692
					{
						position699, tokenIndex699 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l700
						}
						position++
						goto l699
					l700:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('w') {
							goto l701
						}
						position++
						goto l699
					l701:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('d') {
							goto l702
						}
						position++
						goto l699
					l702:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('q') {
							goto l703
						}
						position++
						goto l699
					l703:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('s') {
							goto l704
						}
						position++
						goto l699
					l704:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('h') {
							goto l705
						}
						position++
						goto l699
					l705:
						position, tokenIndex = position699, tokenIndex699
						if buffer[position] != rune('b') {
							goto l698
						}
						position++
					}
				l699:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l698
					}
					position++
					{
						position706, tokenIndex706 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l706
						}
						position++
						goto l707
					l706:
						position, tokenIndex = position706, tokenIndex706
					}
				l707:
					{
						position708, tokenIndex708 := position, tokenIndex
						if !_rules[ruleARMRegisterBoundary]() {
							goto l708
						}
						goto l698
					l708:
						position, tokenIndex = position708, tokenIndex708
					}
					goto l692
				l698:
					position, tokenIndex = position692, tokenIndex692
					{
						position710, tokenIndex710 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l711
						}
						position++
						goto l710
					l711:
						position, tokenIndex = position710, tokenIndex710
						if buffer[position] != rune('X') {
							goto l709
						}
						position++
					}
				l710:
					{
						position712, tokenIndex712 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l713
						}
						position++
						goto l712
					l713:
						position, tokenIndex = position712, tokenIndex712
						if buffer[position] != rune('Z') {
							goto l709
						}
						position++
					}
				l712:
					{
						position714, tokenIndex714 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l715
						}
						position++
						goto l714
					l715:
						position, tokenIndex = position714, tokenIndex714
						if buffer[position] != rune('R') {
							goto l709
						}
						position++
					}
				l714:
					goto l692
				l709:
					position, tokenIndex = position692, tokenIndex692
					{
						position717, tokenIndex717 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l718
						}
						position++
						goto l717
					l718:
						position, tokenIndex = position717, tokenIndex717
						if buffer[position] != rune('W') {
							goto l716
						}
						position++
					}
				l717:
					{
						position719, tokenIndex719 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l720
						}
						position++
						goto l719
					l720:
						position, tokenIndex = position719, tokenIndex719
						if buffer[position] != rune('Z') {
							goto l716
						}
						position++
					}
				l719:
					{
						position721, tokenIndex721 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l722
						}
						position++
						goto l721
					l722:
						position, tokenIndex = position721, tokenIndex721
						if buffer[position] != rune('R') {
							goto l716
						}
						position++
					}
				l721:
					goto l692
				l716:
					position, tokenIndex = position692, tokenIndex692
					{
						position724, tokenIndex724 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l725
						}
						position++
						goto l724
					l725:
						position, tokenIndex = position724, tokenIndex724
						if buffer[position] != rune('N') {
							goto l723
						}
						position++
					}
				l724:
					{
						position726, tokenIndex726 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l727
						}
						position++
						goto l726
					l727:
						position, tokenIndex = position726, tokenIndex726
						if buffer[position] != rune('Z') {
							goto l723
						}
						position++
					}
				l726:
					{
						position728, tokenIndex728 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l729
						}
						position++
						goto l728
					l729:
						position, tokenIndex = position728, tokenIndex728
						if buffer[position] != rune('C') {
							goto l723
						}
						position++
					}
				l728:
					{
						position730, tokenIndex730 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l731
						}
						position++
						goto l730
					l731:
						position, tokenIndex = position730, tokenIndex730
						if buffer[position] != rune('V') {
							goto l723
						}
						position++
					}
				l730:
					goto l692
				l723:
					position, tokenIndex = position692, tokenIndex692
					if !_rules[ruleARMVectorRegister]() {
						goto l732
					}
					goto l692
				l732:
					position, tokenIndex = position692, tokenIndex692
					if !_rules[ruleSVE2PredicateRegister]() {
						goto l733
					}
					goto l692
				l733:
					position, tokenIndex = position692, tokenIndex692
					if buffer[position] != rune('{') {
						goto l690
					}
					position++
					{
						position734, tokenIndex734 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l734
						}
						goto l735
					l734:
						position, tokenIndex = position734, tokenIndex734
					}
				l735:
					if !_rules[ruleARMVectorRegister]() {
						goto l690
					}
					{
						position736, tokenIndex736 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l736
						}
						goto l737
					l736:
						position, tokenIndex = position736, tokenIndex736
					}
				l737:
				l738:
					{
						position739, tokenIndex739 := position, tokenIndex
						{
							position740, tokenIndex740 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l741
							}
							position++
							goto l740
						l741:
							position, tokenIndex = position740, tokenIndex740
							if buffer[position] != rune('-') {
								goto l739
							}
							position++
						}
					l740:
						{
							position742, tokenIndex742 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l742
							}
							goto l743
						l742:
							position, tokenIndex = position742, tokenIndex742
						}
					l743:
						if !_rules[ruleARMVectorRegister]() {
							goto l739
						}
						goto l738
					l739:
						position, tokenIndex = position739, tokenIndex739
					}
					{
						position744, tokenIndex744 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l744
						}
						goto l745
					l744:
						position, tokenIndex = position744, tokenIndex744
					}
				l745:
					if buffer[position] != rune('}') {
						goto l690
					}
					position++
					{
						position746, tokenIndex746 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l746
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l746
						}
						position++
						{
							position748, tokenIndex748 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l748
							}
							position++
							goto l749
						l748:
							position, tokenIndex = position748, tokenIndex748
						}
					l749:
						if buffer[position] != rune(']') {
							goto l746
						}
						position++
						goto l747
					l746:
						position, tokenIndex = position746, tokenIndex746
					}
				l747:
				}
			l692:
				add(ruleARMRegister, position691)
			}
			return true
		l690:
			position, tokenIndex = position690, tokenIndex690
			return false
		},
		/* 45 ARMVectorRegister <- <(('v' / 'z') [0-9] [0-9]? ('.' [0-9]* ('b' / 's' / 'd' / 'h' / 'q') ('[' [0-9] [0-9]? ']')?)?)> */
		func() bool {
			position750, tokenIndex750 := position, tokenIndex
			{
				position751 := position
				{
					position752, tokenIndex752 := position, tokenIndex
					if buffer[position] != rune('v') {
						goto l753
					}
					position++
					goto l752
				l753:
					position, tokenIndex = position752, tokenIndex752
					if buffer[position] != rune('z') {
						goto l750
					}
					position++
				}
			l752:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l750
				}
				position++
				{
					position754, tokenIndex754 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l754
					}
					position++
					goto l755
				l754:
					position, tokenIndex = position754, tokenIndex754
				}
			l755:
				{
					position756, tokenIndex756 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l756
					}
					position++
				l758:
					{
						position759, tokenIndex759 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l759
						}
						position++
						goto l758
					l759:
						position, tokenIndex = position759, tokenIndex759
					}
					{
						position760, tokenIndex760 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l761
						}
						position++
						goto l760
					l761:
						position, tokenIndex = position760, tokenIndex760
						if buffer[position] != rune('s') {
							goto l762
						}
						position++
						goto l760
					l762:
						position, tokenIndex = position760, tokenIndex760
						if buffer[position] != rune('d') {
							goto l763
						}
						position++
						goto l760
					l763:
						position, tokenIndex = position760, tokenIndex760
						if buffer[position] != rune('h') {
							goto l764
						}
						position++
						goto l760
					l764:
						position, tokenIndex = position760, tokenIndex760
						if buffer[position] != rune('q') {
							goto l756
						}
						position++
					}
				l760:
					{
						position765, tokenIndex765 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l765
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l765
						}
						position++
						{
							position767, tokenIndex767 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l767
							}
							position++
							goto l768
						l767:
							position, tokenIndex = position767, tokenIndex767
						}
					l768:
						if buffer[position] != rune(']') {
							goto l765
						}
						position++
						goto l766
					l765:
						position, tokenIndex = position765, tokenIndex765
					}
				l766:
					goto l757
				l756:
					position, tokenIndex = position756, tokenIndex756
				}
			l757:
				add(ruleARMVectorRegister, position751)
			}
			return true
		l750:
			position, tokenIndex = position750, tokenIndex750
			return false
		},
		/* 46 SVE2PredicateRegister <- <(('p' / 'P') [0-9] [0-9]? '/' ('m' / 'M' / 'z' / 'Z'))> */
		func() bool {
			position769, tokenIndex769 := position, tokenIndex
			{
				position770 := position
				{
					position771, tokenIndex771 := position, tokenIndex
					if buffer[position] != rune('p') {
						goto l772
					}
					position++
					goto l771
				l772:
					position, tokenIndex = position771, tokenIndex771
					if buffer[position] != rune('P') {
						goto l769
					}
					position++
				}
			l771:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l769
				}
				position++
				{
					position773, tokenIndex773 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l773
					}
					position++
					goto l774
				l773:
					position, tokenIndex = position773, tokenIndex773
				}
			l774:
				if buffer[position] != rune('/') {
					goto l769
				}
				position++
				{
					position775, tokenIndex775 := position, tokenIndex
					if buffer[position] != rune('m') {
						goto l776
					}
					position++
					goto l775
				l776:
					position, tokenIndex = position775, tokenIndex775
					if buffer[position] != rune('M') {
						goto l777
					}
					position++
					goto l775
				l777:
					position, tokenIndex = position775, tokenIndex775
					if buffer[position] != rune('z') {
						goto l778
					}
					position++
					goto l775
				l778:
					position, tokenIndex = position775, tokenIndex775
					if buffer[position] != rune('Z') {
						goto l769
					}
					position++
				}
			l775:
				add(ruleSVE2PredicateRegister, position770)
			}
			return true
		l769:
			position, tokenIndex = position769, tokenIndex769
			return false
		},
		/* 47 ARMRegisterBoundary <- <([a-z] / [A-Z] / [0-9] / '_')> */
		func() bool {
			position779, tokenIndex779 := position, tokenIndex
			{
				position780 := position
				{
					position781, tokenIndex781 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l782
					}
					position++
					goto l781
				l782:
					position, tokenIndex = position781, tokenIndex781
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l783
					}
					position++
					goto l781
				l783:
					position, tokenIndex = position781, tokenIndex781
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l784
					}
					position++
					goto l781
				l784:
					position, tokenIndex = position781, tokenIndex781
					if buffer[position] != rune('_') {
						goto l779
					}
					position++
				}
			l781:
				add(ruleARMRegisterBoundary, position780)
			}
			return true
		l779:
			position, tokenIndex = position779, tokenIndex779
			return false
		},
		/* 48 MemoryRef <- <((SymbolRef BaseIndexScale) / SymbolRef / Low12BitsSymbolRef / (Offset* BaseIndexScale) / (SegmentRegister Offset BaseIndexScale) / (SegmentRegister BaseIndexScale) / (SegmentRegister Offset) / ARMBaseIndexScale / BaseIndexScale)> */
		func() bool {
			position785, tokenIndex785 := position, tokenIndex
			{
				position786 := position
				{
					position787, tokenIndex787 := position, tokenIndex
					if !_rules[ruleSymbolRef]() {
						goto l788
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l788
					}
					goto l787
				l788:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleSymbolRef]() {
						goto l789
					}
					goto l787
				l789:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleLow12BitsSymbolRef]() {
						goto l790
					}
					goto l787
				l790:
					position, tokenIndex = position787, tokenIndex787
				l792:
					{
						position793, tokenIndex793 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l793
						}
						goto l792
					l793:
						position, tokenIndex = position793, tokenIndex793
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l791
					}
					goto l787
				l791:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleSegmentRegister]() {
						goto l794
					}
					if !_rules[ruleOffset]() {
						goto l794
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l794
					}
					goto l787
				l794:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleSegmentRegister]() {
						goto l795
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l795
					}
					goto l787
				l795:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleSegmentRegister]() {
						goto l796
					}
					if !_rules[ruleOffset]() {
						goto l796
					}
					goto l787
				l796:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleARMBaseIndexScale]() {
						goto l797
					}
					goto l787
				l797:
					position, tokenIndex = position787, tokenIndex787
					if !_rules[ruleBaseIndexScale]() {
						goto l785
					}
				}
			l787:
				add(ruleMemoryRef, position786)
			}
			return true
		l785:
			position, tokenIndex = position785, tokenIndex785
			return false
		},
		/* 49 SymbolRef <- <((Offset* '+')? (LocalSymbol / SymbolName) Offset* ('@' Section Offset*)?)> */
		func() bool {
			position798, tokenIndex798 := position, tokenIndex
			{
				position799 := position
				{
					position800, tokenIndex800 := position, tokenIndex
				l802:
					{
						position803, tokenIndex803 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l803
						}
						goto l802
					l803:
						position, tokenIndex = position803, tokenIndex803
					}
					if buffer[position] != rune('+') {
						goto l800
					}
					position++
					goto l801
				l800:
					position, tokenIndex = position800, tokenIndex800
				}
			l801:
				{
					position804, tokenIndex804 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l805
					}
					goto l804
				l805:
					position, tokenIndex = position804, tokenIndex804
					if !_rules[ruleSymbolName]() {
						goto l798
					}
				}
			l804:
			l806:
				{
					position807, tokenIndex807 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l807
					}
					goto l806
				l807:
					position, tokenIndex = position807, tokenIndex807
				}
				{
					position808, tokenIndex808 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l808
					}
					position++
					if !_rules[ruleSection]() {
						goto l808
					}
				l810:
					{
						position811, tokenIndex811 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l811
						}
						goto l810
					l811:
						position, tokenIndex = position811, tokenIndex811
					}
					goto l809
				l808:
					position, tokenIndex = position808, tokenIndex808
				}
			l809:
				add(ruleSymbolRef, position799)
			}
			return true
		l798:
			position, tokenIndex = position798, tokenIndex798
			return false
		},
		/* 50 Low12BitsSymbolRef <- <(':' ('l' / 'L') ('o' / 'O') '1' '2' ':' (LocalSymbol / SymbolName) Offset?)> */
		func() bool {
			position812, tokenIndex812 := position, tokenIndex
			{
				position813 := position
				if buffer[position] != rune(':') {
					goto l812
				}
				position++
				{
					position814, tokenIndex814 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l815
					}
					position++
					goto l814
				l815:
					position, tokenIndex = position814, tokenIndex814
					if buffer[position] != rune('L') {
						goto l812
					}
					position++
				}
			l814:
				{
					position816, tokenIndex816 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l817
					}
					position++
					goto l816
				l817:
					position, tokenIndex = position816, tokenIndex816
					if buffer[position] != rune('O') {
						goto l812
					}
					position++
				}
			l816:
				if buffer[position] != rune('1') {
					goto l812
				}
				position++
				if buffer[position] != rune('2') {
					goto l812
				}
				position++
				if buffer[position] != rune(':') {
					goto l812
				}
				position++
				{
					position818, tokenIndex818 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l819
					}
					goto l818
				l819:
					position, tokenIndex = position818, tokenIndex818
					if !_rules[ruleSymbolName]() {
						goto l812
					}
				}
			l818:
				{
					position820, tokenIndex820 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l820
					}
					goto l821
				l820:
					position, tokenIndex = position820, tokenIndex820
				}
			l821:
				add(ruleLow12BitsSymbolRef, position813)
			}
			return true
		l812:
			position, tokenIndex = position812, tokenIndex812
			return false
		},
		/* 51 ARMBaseIndexScale <- <('[' ARMRegister (',' WS? (('#'? Offset (('*' [0-9]+) / ('*' '(' [0-9]+ Operator [0-9]+ ')') / ('+' [0-9]+)*)?) / ('#'? ARMGOTLow12) / ('#'? Low12BitsSymbolRef) / ARMRegister) (',' WS? ARMConstantTweak)?)? ']' ARMPostincrement?)> */
		func() bool {
			position822, tokenIndex822 := position, tokenIndex
			{
				position823 := position
				if buffer[position] != rune('[') {
					goto l822
				}
				position++
				if !_rules[ruleARMRegister]() {
					goto l822
				}
				{
					position824, tokenIndex824 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l824
					}
					position++
					{
						position826, tokenIndex826 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l826
						}
						goto l827
					l826:
						position, tokenIndex = position826, tokenIndex826
					}
				l827:
					{
						position828, tokenIndex828 := position, tokenIndex
						{
							position830, tokenIndex830 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l830
							}
							position++
							goto l831
						l830:
							position, tokenIndex = position830, tokenIndex830
						}
					l831:
						if !_rules[ruleOffset]() {
							goto l829
						}
						{
							position832, tokenIndex832 := position, tokenIndex
							{
								position834, tokenIndex834 := position, tokenIndex
								if buffer[position] != rune('*') {
									goto l835
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l835
								}
								position++
							l836:
								{
									position837, tokenIndex837 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l837
									}
									position++
									goto l836
								l837:
									position, tokenIndex = position837, tokenIndex837
								}
								goto l834
							l835:
								position, tokenIndex = position834, tokenIndex834
								if buffer[position] != rune('*') {
									goto l838
								}
								position++
								if buffer[position] != rune('(') {
									goto l838
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l838
								}
								position++
							l839:
								{
									position840, tokenIndex840 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l840
									}
									position++
									goto l839
								l840:
									position, tokenIndex = position840, tokenIndex840
								}
								if !_rules[ruleOperator]() {
									goto l838
								}
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l838
								}
								position++
							l841:
								{
									position842, tokenIndex842 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l842
									}
									position++
									goto l841
								l842:
									position, tokenIndex = position842, tokenIndex842
								}
								if buffer[position] != rune(')') {
									goto l838
								}
								position++
								goto l834
							l838:
								position, tokenIndex = position834, tokenIndex834
							l843:
								{
									position844, tokenIndex844 := position, tokenIndex
									if buffer[position] != rune('+') {
										goto l844
									}
									position++
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l844
									}
									position++
								l845:
									{
										position846, tokenIndex846 := position, tokenIndex
										if c := buffer[position]; c < rune('0') || c > rune('9') {
											goto l846
										}
										position++
										goto l845
									l846:
										position, tokenIndex = position846, tokenIndex846
									}
									goto l843
								l844:
									position, tokenIndex = position844, tokenIndex844
								}
							}
						l834:
							goto l833

							position, tokenIndex = position832, tokenIndex832
						}
					l833:
						goto l828
					l829:
						position, tokenIndex = position828, tokenIndex828
						{
							position848, tokenIndex848 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l848
							}
							position++
							goto l849
						l848:
							position, tokenIndex = position848, tokenIndex848
						}
					l849:
						if !_rules[ruleARMGOTLow12]() {
							goto l847
						}
						goto l828
					l847:
						position, tokenIndex = position828, tokenIndex828
						{
							position851, tokenIndex851 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l851
							}
							position++
							goto l852
						l851:
							position, tokenIndex = position851, tokenIndex851
						}
					l852:
						if !_rules[ruleLow12BitsSymbolRef]() {
							goto l850
						}
						goto l828
					l850:
						position, tokenIndex = position828, tokenIndex828
						if !_rules[ruleARMRegister]() {
							goto l824
						}
					}
				l828:
					{
						position853, tokenIndex853 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l853
						}
						position++
						{
							position855, tokenIndex855 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l855
							}
							goto l856
						l855:
							position, tokenIndex = position855, tokenIndex855
						}
					l856:
						if !_rules[ruleARMConstantTweak]() {
							goto l853
						}
						goto l854
					l853:
						position, tokenIndex = position853, tokenIndex853
					}
				l854:
					goto l825
				l824:
					position, tokenIndex = position824, tokenIndex824
				}
			l825:
				if buffer[position] != rune(']') {
					goto l822
				}
				position++
				{
					position857, tokenIndex857 := position, tokenIndex
					if !_rules[ruleARMPostincrement]() {
						goto l857
					}
					goto l858
				l857:
					position, tokenIndex = position857, tokenIndex857
				}
			l858:
				add(ruleARMBaseIndexScale, position823)
			}
			return true
		l822:
			position, tokenIndex = position822, tokenIndex822
			return false
		},
		/* 52 ARMGOTLow12 <- <(':' ('g' / 'G') ('o' / 'O') ('t' / 'T') '_' ('l' / 'L') ('o' / 'O') '1' '2' ':' SymbolName)> */
		func() bool {
			position859, tokenIndex859 := position, tokenIndex
			{
				position860 := position
				if buffer[position] != rune(':') {
					goto l859
				}
				position++
				{
					position861, tokenIndex861 := position, tokenIndex
					if buffer[position] != rune('g') {
						goto l862
					}
					position++
					goto l861
				l862:
					position, tokenIndex = position861, tokenIndex861
					if buffer[position] != rune('G') {
						goto l859
					}
					position++
				}
			l861:
				{
					position863, tokenIndex863 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l864
					}
					position++
					goto l863
				l864:
					position, tokenIndex = position863, tokenIndex863
					if buffer[position] != rune('O') {
						goto l859
					}
					position++
				}
			l863:
				{
					position865, tokenIndex865 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l866
					}
					position++
					goto l865
				l866:
					position, tokenIndex = position865, tokenIndex865
					if buffer[position] != rune('T') {
						goto l859
					}
					position++
				}
			l865:
				if buffer[position] != rune('_') {
					goto l859
				}
				position++
				{
					position867, tokenIndex867 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l868
					}
					position++
					goto l867
				l868:
					position, tokenIndex = position867, tokenIndex867
					if buffer[position] != rune('L') {
						goto l859
					}
					position++
				}
			l867:
				{
					position869, tokenIndex869 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l870
					}
					position++
					goto l869
				l870:
					position, tokenIndex = position869, tokenIndex869
					if buffer[position] != rune('O') {
						goto l859
					}
					position++
				}
			l869:
				if buffer[position] != rune('1') {
					goto l859
				}
				position++
				if buffer[position] != rune('2') {
					goto l859
				}
				position++
				if buffer[position] != rune(':') {
					goto l859
				}
				position++
				if !_rules[ruleSymbolName]() {
					goto l859
				}
				add(ruleARMGOTLow12, position860)
			}
			return true
		l859:
			position, tokenIndex = position859, tokenIndex859
			return false
		},
		/* 53 ARMPostincrement <- <'!'> */
		func() bool {
			position871, tokenIndex871 := position, tokenIndex
			{
				position872 := position
				if buffer[position] != rune('!') {
					goto l871
				}
				position++
				add(ruleARMPostincrement, position872)
			}
			return true
		l871:
			position, tokenIndex = position871, tokenIndex871
			return false
		},
		/* 54 BaseIndexScale <- <('(' RegisterOrConstant? WS? (',' WS? RegisterOrConstant WS? (',' [0-9]+)?)? ')')> */
		func() bool {
			position873, tokenIndex873 := position, tokenIndex
			{
				position874 := position
				if buffer[position] != rune('(') {
					goto l873
				}
				position++
				{
					position875, tokenIndex875 := position, tokenIndex
					if !_rules[ruleRegisterOrConstant]() {
						goto l875
					}
					goto l876
				l875:
					position, tokenIndex = position875, tokenIndex875
				}
			l876:
				{
					position877, tokenIndex877 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l877
					}
					goto l878
				l877:
					position, tokenIndex = position877, tokenIndex877
				}
			l878:
				{
					position879, tokenIndex879 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l879
					}
					position++
					{
						position881, tokenIndex881 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l881
						}
						goto l882
					l881:
						position, tokenIndex = position881, tokenIndex881
					}
				l882:
					if !_rules[ruleRegisterOrConstant]() {
						goto l879
					}
					{
						position883, tokenIndex883 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l883
						}
						goto l884
					l883:
						position, tokenIndex = position883, tokenIndex883
					}
				l884:
					{
						position885, tokenIndex885 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l885
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l885
						}
						position++
					l887:
						{
							position888, tokenIndex888 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l888
							}
							position++
							goto l887
						l888:
							position, tokenIndex = position888, tokenIndex888
						}
						goto l886
					l885:
						position, tokenIndex = position885, tokenIndex885
					}
				l886:
					goto l880
				l879:
					position, tokenIndex = position879, tokenIndex879
				}
			l880:
				if buffer[position] != rune(')') {
					goto l873
				}
				position++
				add(ruleBaseIndexScale, position874)
			}
			return true
		l873:
			position, tokenIndex = position873, tokenIndex873
			return false
		},
		/* 55 Operator <- <('+' / '-')> */
		func() bool {
			position889, tokenIndex889 := position, tokenIndex
			{
				position890 := position
				{
					position891, tokenIndex891 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l892
					}
					position++
					goto l891
				l892:
					position, tokenIndex = position891, tokenIndex891
					if buffer[position] != rune('-') {
						goto l889
					}
					position++
				}
			l891:
				add(ruleOperator, position890)
			}
			return true
		l889:
			position, tokenIndex = position889, tokenIndex889
			return false
		},
		/* 56 OffsetOperator <- <('+' / '-' / '*')> */
		func() bool {
			position893, tokenIndex893 := position, tokenIndex
			{
				position894 := position
				{
					position895, tokenIndex895 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l896
					}
					position++
					goto l895
				l896:
					position, tokenIndex = position895, tokenIndex895
					if buffer[position] != rune('-') {
						goto l897
					}
					position++
					goto l895
				l897:
					position, tokenIndex = position895, tokenIndex895
					if buffer[position] != rune('*') {
						goto l893
					}
					position++
				}
			l895:
				add(ruleOffsetOperator, position894)
			}
			return true
		l893:
			position, tokenIndex = position893, tokenIndex893
			return false
		},
		/* 57 Offset <- <('+'? '-'? (('0' ('b' / 'B') ('0' / '1')+) / ('0' ('x' / 'X') ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ((([0-9]+ WS OffsetOperator [0-9]+) / ([0-9]+ (OffsetOperator '(' [0-9]+ OffsetOperator [0-9]+ ')')?) / ([0-9]+ (OffsetOperator [0-9]+ OffsetOperator [0-9]+)?) / ([0-9]+ (OffsetOperator [0-9]+)?) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ OffsetOperator [0-9]+) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ !'x') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ WS? OffsetOperator WS? [0-9]+ ')')) !([a-z] / [A-Z]))))> */
		func() bool {
			position898, tokenIndex898 := position, tokenIndex
			{
				position899 := position
				{
					position900, tokenIndex900 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l900
					}
					position++
					goto l901
				l900:
					position, tokenIndex = position900, tokenIndex900
				}
			l901:
				{
					position902, tokenIndex902 := position, tokenIndex
					if buffer[position] != rune('-') {
						goto l902
					}
					position++
					goto l903
				l902:
					position, tokenIndex = position902, tokenIndex902
				}
			l903:
				{
					position904, tokenIndex904 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l905
					}
					position++
					{
						position906, tokenIndex906 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l907
						}
						position++
						goto l906
					l907:
						position, tokenIndex = position906, tokenIndex906
						if buffer[position] != rune('B') {
							goto l905
						}
						position++
					}
				l906:
					{
						position910, tokenIndex910 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l911
						}
						position++
						goto l910
					l911:
						position, tokenIndex = position910, tokenIndex910
						if buffer[position] != rune('1') {
							goto l905
						}
						position++
					}
				l910:
				l908:
					{
						position909, tokenIndex909 := position, tokenIndex
						{
							position912, tokenIndex912 := position, tokenIndex
							if buffer[position] != rune('0') {
								goto l913
							}
							position++
							goto l912
						l913:
							position, tokenIndex = position912, tokenIndex912
							if buffer[position] != rune('1') {
								goto l909
							}
							position++
						}
					l912:
						goto l908
					l909:
						position, tokenIndex = position909, tokenIndex909
					}
					goto l904
				l905:
					position, tokenIndex = position904, tokenIndex904
					if buffer[position] != rune('0') {
						goto l914
					}
					position++
					{
						position915, tokenIndex915 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l916
						}
						position++
						goto l915
					l916:
						position, tokenIndex = position915, tokenIndex915
						if buffer[position] != rune('X') {
							goto l914
						}
						position++
					}
				l915:
					{
						position919, tokenIndex919 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l920
						}
						position++
						goto l919
					l920:
						position, tokenIndex = position919, tokenIndex919
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l921
						}
						position++
						goto l919
					l921:
						position, tokenIndex = position919, tokenIndex919
						{
							position922, tokenIndex922 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l923
							}
							position++
							goto l922
						l923:
							position, tokenIndex = position922, tokenIndex922
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l914
							}
							position++
						}
					l922:
					}
				l919:
				l917:
					{
						position918, tokenIndex918 := position, tokenIndex
						{
							position924, tokenIndex924 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l925
							}
							position++
							goto l924
						l925:
							position, tokenIndex = position924, tokenIndex924
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l926
							}
							position++
							goto l924
						l926:
							position, tokenIndex = position924, tokenIndex924
							{
								position927, tokenIndex927 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l928
								}
								position++
								goto l927
							l928:
								position, tokenIndex = position927, tokenIndex927
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l918
								}
								position++
							}
						l927:
						}
					l924:
						goto l917
					l918:
						position, tokenIndex = position918, tokenIndex918
					}
					goto l904
				l914:
					position, tokenIndex = position904, tokenIndex904
					{
						position929, tokenIndex929 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l930
						}
						position++
					l931:
						{
							position932, tokenIndex932 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l932
							}
							position++
							goto l931
						l932:
							position, tokenIndex = position932, tokenIndex932
						}
						if !_rules[ruleWS]() {
							goto l930
						}
						if !_rules[ruleOffsetOperator]() {
							goto l930
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l930
						}
						position++
					l933:
						{
							position934, tokenIndex934 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l934
							}
							position++
							goto l933
						l934:
							position, tokenIndex = position934, tokenIndex934
						}
						goto l929
					l930:
						position, tokenIndex = position929, tokenIndex929
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l935
						}
						position++
					l936:
						{
							position937, tokenIndex937 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l937
							}
							position++
							goto l936
						l937:
							position, tokenIndex = position937, tokenIndex937
						}
						{
							position938, tokenIndex938 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l938
							}
							if buffer[position] != rune('(') {
								goto l938
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l938
							}
							position++
						l940:
							{
								position941, tokenIndex941 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l941
								}
								position++
								goto l940
							l941:
								position, tokenIndex = position941, tokenIndex941
							}
							if !_rules[ruleOffsetOperator]() {
								goto l938
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l938
							}
							position++
						l942:
							{
								position943, tokenIndex943 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l943
								}
								position++
								goto l942
							l943:
								position, tokenIndex = position943, tokenIndex943
							}
							if buffer[position] != rune(')') {
								goto l938
							}
							position++
							goto l939
						l938:
							position, tokenIndex = position938, tokenIndex938
						}
					l939:
						goto l929
					l935:
						position, tokenIndex = position929, tokenIndex929
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l944
						}
						position++
					l945:
						{
							position946, tokenIndex946 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l946
							}
							position++
							goto l945
						l946:
							position, tokenIndex = position946, tokenIndex946
						}
						{
							position947, tokenIndex947 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l947
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l947
							}
							position++
						l949:
							{
								position950, tokenIndex950 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l950
								}
								position++
								goto l949
							l950:
								position, tokenIndex = position950, tokenIndex950
							}
							if !_rules[ruleOffsetOperator]() {
								goto l947
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l947
							}
							position++
						l951:
							{
								position952, tokenIndex952 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l952
								}
								position++
								goto l951
							l952:
								position, tokenIndex = position952, tokenIndex952
							}
							goto l948
						l947:
							position, tokenIndex = position947, tokenIndex947
						}
					l948:
						goto l929
					l944:
						position, tokenIndex = position929, tokenIndex929
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l953
						}
						position++
					l954:
						{
							position955, tokenIndex955 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l955
							}
							position++
							goto l954
						l955:
							position, tokenIndex = position955, tokenIndex955
						}
						{
							position956, tokenIndex956 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l956
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l956
							}
							position++
						l958:
							{
								position959, tokenIndex959 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l959
								}
								position++
								goto l958
							l959:
								position, tokenIndex = position959, tokenIndex959
							}
							goto l957
						l956:
							position, tokenIndex = position956, tokenIndex956
						}
					l957:
						goto l929
					l953:
						position, tokenIndex = position929, tokenIndex929
						if buffer[position] != rune('(') {
							goto l960
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l960
						}
						position++
					l961:
						{
							position962, tokenIndex962 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l962
							}
							position++
							goto l961
						l962:
							position, tokenIndex = position962, tokenIndex962
						}
						{
							position963, tokenIndex963 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l963
							}
							goto l964
						l963:
							position, tokenIndex = position963, tokenIndex963
						}
					l964:
						if !_rules[ruleOffsetOperator]() {
							goto l960
						}
						{
							position965, tokenIndex965 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l965
							}
							goto l966
						l965:
							position, tokenIndex = position965, tokenIndex965
						}
					l966:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l960
						}
						position++
					l967:
						{
							position968, tokenIndex968 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l968
							}
							position++
							goto l967
						l968:
							position, tokenIndex = position968, tokenIndex968
						}
						if buffer[position] != rune(')') {
							goto l960
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l960
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l960
						}
						position++
					l969:
						{
							position970, tokenIndex970 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l970
							}
							position++
							goto l969
						l970:
							position, tokenIndex = position970, tokenIndex970
						}
						if !_rules[ruleOffsetOperator]() {
							goto l960
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l960
						}
						position++
					l971:
						{
							position972, tokenIndex972 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l972
							}
							position++
							goto l971
						l972:
							position, tokenIndex = position972, tokenIndex972
						}
						goto l929
					l960:
						position, tokenIndex = position929, tokenIndex929
						if buffer[position] != rune('(') {
							goto l973
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l973
						}
						position++
					l974:
						{
							position975, tokenIndex975 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l975
							}
							position++
							goto l974
						l975:
							position, tokenIndex = position975, tokenIndex975
						}
						{
							position976, tokenIndex976 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l976
							}
							goto l977
						l976:
							position, tokenIndex = position976, tokenIndex976
						}
					l977:
						if !_rules[ruleOffsetOperator]() {
							goto l973
						}
						{
							position978, tokenIndex978 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l978
							}
							goto l979
						l978:
							position, tokenIndex = position978, tokenIndex978
						}
					l979:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l973
						}
						position++
					l980:
						{
							position981, tokenIndex981 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l981
							}
							position++
							goto l980
						l981:
							position, tokenIndex = position981, tokenIndex981
						}
						if buffer[position] != rune(')') {
							goto l973
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l973
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l973
						}
						position++
					l982:
						{
							position983, tokenIndex983 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l983
							}
							position++
							goto l982
						l983:
							position, tokenIndex = position983, tokenIndex983
						}
						{
							position984, tokenIndex984 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l984
							}
							position++
							goto l973
						l984:
							position, tokenIndex = position984, tokenIndex984
						}
						goto l929
					l973:
						position, tokenIndex = position929, tokenIndex929
						if buffer[position] != rune('(') {
							goto l985
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l985
						}
						position++
					l986:
						{
							position987, tokenIndex987 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l987
							}
							position++
							goto l986
						l987:
							position, tokenIndex = position987, tokenIndex987
						}
						{
							position988, tokenIndex988 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l988
							}
							goto l989
						l988:
							position, tokenIndex = position988, tokenIndex988
						}
					l989:
						if !_rules[ruleOffsetOperator]() {
							goto l985
						}
						{
							position990, tokenIndex990 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l990
							}
							goto l991
						l990:
							position, tokenIndex = position990, tokenIndex990
						}
					l991:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l985
						}
						position++
					l992:
						{
							position993, tokenIndex993 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l993
							}
							position++
							goto l992
						l993:
							position, tokenIndex = position993, tokenIndex993
						}
						if buffer[position] != rune(')') {
							goto l985
						}
						position++
						goto l929
					l985:
						position, tokenIndex = position929, tokenIndex929
						if buffer[position] != rune('(') {
							goto l898
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l898
						}
						position++
					l994:
						{
							position995, tokenIndex995 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l995
							}
							position++
							goto l994
						l995:
							position, tokenIndex = position995, tokenIndex995
						}
						{
							position996, tokenIndex996 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l996
							}
							goto l997
						l996:
							position, tokenIndex = position996, tokenIndex996
						}
					l997:
						if !_rules[ruleOffsetOperator]() {
							goto l898
						}
						{
							position998, tokenIndex998 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l998
							}
							goto l999
						l998:
							position, tokenIndex = position998, tokenIndex998
						}
					l999:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l898
						}
						position++
					l1000:
						{
							position1001, tokenIndex1001 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l1001
							}
							position++
							goto l1000
						l1001:
							position, tokenIndex = position1001, tokenIndex1001
						}
						{
							position1002, tokenIndex1002 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l1002
							}
							goto l1003
						l1002:
							position, tokenIndex = position1002, tokenIndex1002
						}
					l1003:
						if !_rules[ruleOffsetOperator]() {
							goto l898
						}
						{
							position1004, tokenIndex1004 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l1004
							}
							goto l1005
						l1004:
							position, tokenIndex = position1004, tokenIndex1004
						}
					l1005:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l898
						}
						position++
					l1006:
						{
							position1007, tokenIndex1007 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l1007
							}
							position++
							goto l1006
						l1007:
							position, tokenIndex = position1007, tokenIndex1007
						}
						if buffer[position] != rune(')') {
							goto l898
						}
						position++
					}
				l929:
					{
						position1008, tokenIndex1008 := position, tokenIndex
						{
							position1009, tokenIndex1009 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l1010
							}
							position++
							goto l1009
						l1010:
							position, tokenIndex = position1009, tokenIndex1009
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l1008
							}
							position++
						}
					l1009:
						goto l898
					l1008:
						position, tokenIndex = position1008, tokenIndex1008
					}
				}
			l904:
				add(ruleOffset, position899)
			}
			return true
		l898:
			position, tokenIndex = position898, tokenIndex898
			return false
		},
		/* 58 Section <- <([a-z] / [A-Z] / '@')+> */
		func() bool {
			position1011, tokenIndex1011 := position, tokenIndex
			{
				position1012 := position
				{
					position1015, tokenIndex1015 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l1016
					}
					position++
					goto l1015
				l1016:
					position, tokenIndex = position1015, tokenIndex1015
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l1017
					}
					position++
					goto l1015
				l1017:
					position, tokenIndex = position1015, tokenIndex1015
					if buffer[position] != rune('@') {
						goto l1011
					}
					position++
				}
			l1015:
			l1013:
				{
					position1014, tokenIndex1014 := position, tokenIndex
					{
						position1018, tokenIndex1018 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l1019
						}
						position++
						goto l1018
					l1019:
						position, tokenIndex = position1018, tokenIndex1018
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l1020
						}
						position++
						goto l1018
					l1020:
						position, tokenIndex = position1018, tokenIndex1018
						if buffer[position] != rune('@') {
							goto l1014
						}
						position++
					}
				l1018:
					goto l1013
				l1014:
					position, tokenIndex = position1014, tokenIndex1014
				}
				add(ruleSection, position1012)
			}
			return true
		l1011:
			position, tokenIndex = position1011, tokenIndex1011
			return false
		},
		/* 59 SegmentRegister <- <('%' ([c-g] / 's') ('s' ':'))> */
		func() bool {
			position1021, tokenIndex1021 := position, tokenIndex
			{
				position1022 := position
				if buffer[position] != rune('%') {
					goto l1021
				}
				position++
				{
					position1023, tokenIndex1023 := position, tokenIndex
					if c := buffer[position]; c < rune('c') || c > rune('g') {
						goto l1024
					}
					position++
					goto l1023
				l1024:
					position, tokenIndex = position1023, tokenIndex1023
					if buffer[position] != rune('s') {
						goto l1021
					}
					position++
				}
			l1023:
				if buffer[position] != rune('s') {
					goto l1021
				}
				position++
				if buffer[position] != rune(':') {
					goto l1021
				}
				position++
				add(ruleSegmentRegister, position1022)
			}
			return true
		l1021:
			position, tokenIndex = position1021, tokenIndex1021
			return false
		},
	}
	p.rules = _rules
	return nil
}
