#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
/*
 * MaintenanceCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>

#include "boost/lexical_cast.hpp"
#include "fmt/format.h"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBTypes.h"
#include "fdbclient/IClientApi.h"

#include "fdbclient/Knobs.h"
#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

// print zoneId under maintenance, only one is possible at the same time
															#line 42 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
// This generated class is to be used only via printHealthyZone()
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
template <class PrintHealthyZoneActor>
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class PrintHealthyZoneActorState {
															#line 48 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	PrintHealthyZoneActorState(Reference<IDatabase> const& db) 
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		 : db(db),
															#line 41 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 57 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	~PrintHealthyZoneActorState() 
	{
		fdb_probe_actor_destroy("printHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			;
															#line 72 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintHealthyZoneActorState();
		static_cast<PrintHealthyZoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 43 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		try {
															#line 47 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::maintenanceSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 49 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 49 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintHealthyZoneActor, 0, RangeResult >*>(static_cast<PrintHealthyZoneActor*>(this)));
															#line 115 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 63 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 63 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintHealthyZoneActor, 1, Void >*>(static_cast<PrintHealthyZoneActor*>(this)));
															#line 144 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 50 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 51 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 161 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 52 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			printf("Data distribution has been disabled for all storage server failures in this cluster and thus " "maintenance mode is not active.\n");
															#line 165 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		}
		else
		{
															#line 54 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!res.size() || boost::lexical_cast<double>(res[0].value.toString()) <= 0)
															#line 171 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 55 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				printf("No ongoing maintenance.\n");
															#line 175 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
			else
			{
															#line 57 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				std::string zoneId = res[0].key.removePrefix(fdb_cli::maintenanceSpecialKeyRange.begin).toString();
															#line 58 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				int64_t seconds = static_cast<int64_t>(boost::lexical_cast<double>(res[0].value.toString()));
															#line 59 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fmt::print("Maintenance for zone {0} will continue for {1} seconds.\n", zoneId, seconds);
															#line 185 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
		}
															#line 61 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<PrintHealthyZoneActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintHealthyZoneActorState(); static_cast<PrintHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 190 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<PrintHealthyZoneActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintHealthyZoneActorState();
		static_cast<PrintHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 50 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 51 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 204 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 52 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			printf("Data distribution has been disabled for all storage server failures in this cluster and thus " "maintenance mode is not active.\n");
															#line 208 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		}
		else
		{
															#line 54 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!res.size() || boost::lexical_cast<double>(res[0].value.toString()) <= 0)
															#line 214 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 55 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				printf("No ongoing maintenance.\n");
															#line 218 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
			else
			{
															#line 57 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				std::string zoneId = res[0].key.removePrefix(fdb_cli::maintenanceSpecialKeyRange.begin).toString();
															#line 58 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				int64_t seconds = static_cast<int64_t>(boost::lexical_cast<double>(res[0].value.toString()));
															#line 59 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fmt::print("Maintenance for zone {0} will continue for {1} seconds.\n", zoneId, seconds);
															#line 228 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
		}
															#line 61 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<PrintHealthyZoneActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintHealthyZoneActorState(); static_cast<PrintHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 233 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<PrintHealthyZoneActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintHealthyZoneActorState();
		static_cast<PrintHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<PrintHealthyZoneActor*>(this)->ActorCallback< PrintHealthyZoneActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintHealthyZoneActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintHealthyZoneActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintHealthyZoneActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<PrintHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<PrintHealthyZoneActor*>(this)->ActorCallback< PrintHealthyZoneActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintHealthyZoneActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintHealthyZoneActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintHealthyZoneActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 41 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 47 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 409 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
};
// This generated class is to be used only via printHealthyZone()
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class PrintHealthyZoneActor final : public Actor<Void>, public ActorCallback< PrintHealthyZoneActor, 0, RangeResult >, public ActorCallback< PrintHealthyZoneActor, 1, Void >, public FastAllocated<PrintHealthyZoneActor>, public PrintHealthyZoneActorState<PrintHealthyZoneActor> {
															#line 414 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
	using FastAllocated<PrintHealthyZoneActor>::operator new;
	using FastAllocated<PrintHealthyZoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4107902902312325632UL, 5873391741136238080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintHealthyZoneActor, 0, RangeResult >;
friend struct ActorCallback< PrintHealthyZoneActor, 1, Void >;
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	PrintHealthyZoneActor(Reference<IDatabase> const& db) 
															#line 432 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintHealthyZoneActorState<PrintHealthyZoneActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printHealthyZone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3507524340034560UL, 4848501524512482048UL);
		ActorExecutionContextHelper __helper(static_cast<PrintHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printHealthyZone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printHealthyZone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintHealthyZoneActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintHealthyZoneActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
[[nodiscard]] Future<Void> printHealthyZone( Reference<IDatabase> const& db ) {
															#line 40 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	return Future<Void>(new PrintHealthyZoneActor(db));
															#line 465 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
}

#line 67 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"

} // namespace

namespace fdb_cli {

const KeyRangeRef maintenanceSpecialKeyRange =
    KeyRangeRef("\xff\xff/management/maintenance/"_sr, "\xff\xff/management/maintenance0"_sr);
// The special key, if present, means data distribution is disabled for storage failures;
const KeyRef ignoreSSFailureSpecialKey = "\xff\xff/management/maintenance/IgnoreSSFailures"_sr;

// add a zone to maintenance and specify the maintenance duration
															#line 480 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
// This generated class is to be used only via setHealthyZone()
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
template <class SetHealthyZoneActor>
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class SetHealthyZoneActorState {
															#line 486 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	SetHealthyZoneActorState(Reference<IDatabase> const& db,StringRef const& zoneId,double const& seconds,bool const& printWarning) 
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		 : db(db),
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   zoneId(zoneId),
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   seconds(seconds),
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   printWarning(printWarning),
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 501 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("setHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	~SetHealthyZoneActorState() 
	{
		fdb_probe_actor_destroy("setHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			TraceEvent("SetHealthyZone").detail("Zone", zoneId).detail("DurationSeconds", seconds);
															#line 81 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			;
															#line 518 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetHealthyZoneActorState();
		static_cast<SetHealthyZoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 82 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 548 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		try {
															#line 85 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::maintenanceSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 87 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 87 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 556 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetHealthyZoneActor, 0, RangeResult >*>(static_cast<SetHealthyZoneActor*>(this)));
															#line 561 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 585 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetHealthyZoneActor, 2, Void >*>(static_cast<SetHealthyZoneActor*>(this)));
															#line 590 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 88 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 89 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 607 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 90 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (printWarning)
															#line 611 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 91 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fprintf(stderr, "ERROR: Maintenance mode cannot be used while data distribution is disabled for storage " "server failures. Use 'datadistribution on' to reenable data distribution.\n");
															#line 615 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
															#line 95 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!static_cast<SetHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetHealthyZoneActorState(); static_cast<SetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 619 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			new (&static_cast<SetHealthyZoneActor*>(this)->SAV< bool >::value()) bool(false);
			this->~SetHealthyZoneActorState();
			static_cast<SetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 97 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->set(fdb_cli::maintenanceSpecialKeyRange.begin.withSuffix(zoneId), boost::lexical_cast<std::string>(seconds));
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 631 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetHealthyZoneActor, 1, Void >*>(static_cast<SetHealthyZoneActor*>(this)));
															#line 636 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 88 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 89 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 647 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 90 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (printWarning)
															#line 651 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 91 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fprintf(stderr, "ERROR: Maintenance mode cannot be used while data distribution is disabled for storage " "server failures. Use 'datadistribution on' to reenable data distribution.\n");
															#line 655 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
															#line 95 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!static_cast<SetHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(false); this->~SetHealthyZoneActorState(); static_cast<SetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 659 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			new (&static_cast<SetHealthyZoneActor*>(this)->SAV< bool >::value()) bool(false);
			this->~SetHealthyZoneActorState();
			static_cast<SetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 97 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->set(fdb_cli::maintenanceSpecialKeyRange.begin.withSuffix(zoneId), boost::lexical_cast<std::string>(seconds));
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 671 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetHealthyZoneActor, 1, Void >*>(static_cast<SetHealthyZoneActor*>(this)));
															#line 676 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<SetHealthyZoneActor*>(this)->ActorCallback< SetHealthyZoneActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetHealthyZoneActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<SetHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SetHealthyZoneActorState(); static_cast<SetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 760 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<SetHealthyZoneActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SetHealthyZoneActorState();
		static_cast<SetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<SetHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(true); this->~SetHealthyZoneActorState(); static_cast<SetHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 772 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<SetHealthyZoneActor*>(this)->SAV< bool >::value()) bool(true);
		this->~SetHealthyZoneActorState();
		static_cast<SetHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<SetHealthyZoneActor*>(this)->ActorCallback< SetHealthyZoneActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetHealthyZoneActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<SetHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<SetHealthyZoneActor*>(this)->ActorCallback< SetHealthyZoneActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetHealthyZoneActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetHealthyZoneActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	StringRef zoneId;
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	double seconds;
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	bool printWarning;
															#line 79 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 85 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 954 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
};
// This generated class is to be used only via setHealthyZone()
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class SetHealthyZoneActor final : public Actor<bool>, public ActorCallback< SetHealthyZoneActor, 0, RangeResult >, public ActorCallback< SetHealthyZoneActor, 1, Void >, public ActorCallback< SetHealthyZoneActor, 2, Void >, public FastAllocated<SetHealthyZoneActor>, public SetHealthyZoneActorState<SetHealthyZoneActor> {
															#line 959 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
	using FastAllocated<SetHealthyZoneActor>::operator new;
	using FastAllocated<SetHealthyZoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12115479574068048128UL, 5715354151696415744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetHealthyZoneActor, 0, RangeResult >;
friend struct ActorCallback< SetHealthyZoneActor, 1, Void >;
friend struct ActorCallback< SetHealthyZoneActor, 2, Void >;
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	SetHealthyZoneActor(Reference<IDatabase> const& db,StringRef const& zoneId,double const& seconds,bool const& printWarning) 
															#line 978 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		 : Actor<bool>(),
		   SetHealthyZoneActorState<SetHealthyZoneActor>(db, zoneId, seconds, printWarning),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setHealthyZone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14961976220816392704UL, 7810201303269410048UL);
		ActorExecutionContextHelper __helper(static_cast<SetHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setHealthyZone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setHealthyZone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetHealthyZoneActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetHealthyZoneActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetHealthyZoneActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
[[nodiscard]] Future<bool> setHealthyZone( Reference<IDatabase> const& db, StringRef const& zoneId, double const& seconds, bool const& printWarning ) {
															#line 78 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	return Future<bool>(new SetHealthyZoneActor(db, zoneId, seconds, printWarning));
															#line 1012 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
}

#line 106 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"

// clear ongoing maintenance, let clearSSFailureZoneString = true to enable data distribution for storage
															#line 1018 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
// This generated class is to be used only via clearHealthyZone()
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
template <class ClearHealthyZoneActor>
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class ClearHealthyZoneActorState {
															#line 1024 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	ClearHealthyZoneActorState(Reference<IDatabase> const& db,bool const& printWarning,bool const& clearSSFailureZoneString) 
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		 : db(db),
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   printWarning(printWarning),
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   clearSSFailureZoneString(clearSSFailureZoneString),
															#line 109 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 1037 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("clearHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	~ClearHealthyZoneActorState() 
	{
		fdb_probe_actor_destroy("clearHealthyZone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			TraceEvent("ClearHealthyZone").detail("ClearSSFailureZoneString", clearSSFailureZoneString);
															#line 111 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			;
															#line 1054 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearHealthyZoneActorState();
		static_cast<ClearHealthyZoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1084 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		try {
															#line 115 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::maintenanceSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1092 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 1;
															#line 117 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearHealthyZoneActor, 0, RangeResult >*>(static_cast<ClearHealthyZoneActor*>(this)));
															#line 1097 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 132 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 132 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearHealthyZoneActor, 2, Void >*>(static_cast<ClearHealthyZoneActor*>(this)));
															#line 1126 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 118 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!clearSSFailureZoneString && res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 1143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 120 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (printWarning)
															#line 1147 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fprintf(stderr, "ERROR: Maintenance mode cannot be used while data distribution is disabled for storage " "server failures. Use 'datadistribution on' to reenable data distribution.\n");
															#line 1151 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
															#line 125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!static_cast<ClearHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClearHealthyZoneActorState(); static_cast<ClearHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 1155 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			new (&static_cast<ClearHealthyZoneActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ClearHealthyZoneActorState();
			static_cast<ClearHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 128 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->clear(fdb_cli::maintenanceSpecialKeyRange);
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1167 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearHealthyZoneActor, 1, Void >*>(static_cast<ClearHealthyZoneActor*>(this)));
															#line 1172 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 118 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		ASSERT(res.size() <= 1);
															#line 119 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!clearSSFailureZoneString && res.size() == 1 && res[0].key == fdb_cli::ignoreSSFailureSpecialKey)
															#line 1183 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		{
															#line 120 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (printWarning)
															#line 1187 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 121 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				fprintf(stderr, "ERROR: Maintenance mode cannot be used while data distribution is disabled for storage " "server failures. Use 'datadistribution on' to reenable data distribution.\n");
															#line 1191 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			}
															#line 125 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (!static_cast<ClearHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClearHealthyZoneActorState(); static_cast<ClearHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 1195 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			new (&static_cast<ClearHealthyZoneActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ClearHealthyZoneActorState();
			static_cast<ClearHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 128 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		tr->clear(fdb_cli::maintenanceSpecialKeyRange);
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1207 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearHealthyZoneActor, 1, Void >*>(static_cast<ClearHealthyZoneActor*>(this)));
															#line 1212 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<ClearHealthyZoneActor*>(this)->ActorCallback< ClearHealthyZoneActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearHealthyZoneActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<ClearHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClearHealthyZoneActorState(); static_cast<ClearHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 1296 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<ClearHealthyZoneActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClearHealthyZoneActorState();
		static_cast<ClearHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<ClearHealthyZoneActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClearHealthyZoneActorState(); static_cast<ClearHealthyZoneActor*>(this)->destroy(); return 0; }
															#line 1308 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<ClearHealthyZoneActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClearHealthyZoneActorState();
		static_cast<ClearHealthyZoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<ClearHealthyZoneActor*>(this)->ActorCallback< ClearHealthyZoneActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearHealthyZoneActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state > 0) static_cast<ClearHealthyZoneActor*>(this)->actor_wait_state = 0;
		static_cast<ClearHealthyZoneActor*>(this)->ActorCallback< ClearHealthyZoneActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearHealthyZoneActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearHealthyZoneActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	bool printWarning;
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	bool clearSSFailureZoneString;
															#line 109 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 115 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 1488 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
};
// This generated class is to be used only via clearHealthyZone()
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class ClearHealthyZoneActor final : public Actor<bool>, public ActorCallback< ClearHealthyZoneActor, 0, RangeResult >, public ActorCallback< ClearHealthyZoneActor, 1, Void >, public ActorCallback< ClearHealthyZoneActor, 2, Void >, public FastAllocated<ClearHealthyZoneActor>, public ClearHealthyZoneActorState<ClearHealthyZoneActor> {
															#line 1493 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
	using FastAllocated<ClearHealthyZoneActor>::operator new;
	using FastAllocated<ClearHealthyZoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13898288028814675200UL, 2429596344963565824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearHealthyZoneActor, 0, RangeResult >;
friend struct ActorCallback< ClearHealthyZoneActor, 1, Void >;
friend struct ActorCallback< ClearHealthyZoneActor, 2, Void >;
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	ClearHealthyZoneActor(Reference<IDatabase> const& db,bool const& printWarning,bool const& clearSSFailureZoneString) 
															#line 1512 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ClearHealthyZoneActorState<ClearHealthyZoneActor>(db, printWarning, clearSSFailureZoneString),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearHealthyZone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(868363240144782336UL, 16824621560516897536UL);
		ActorExecutionContextHelper __helper(static_cast<ClearHealthyZoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearHealthyZone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearHealthyZone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearHealthyZoneActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearHealthyZoneActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearHealthyZoneActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
[[nodiscard]] Future<bool> clearHealthyZone( Reference<IDatabase> const& db, bool const& printWarning, bool const& clearSSFailureZoneString ) {
															#line 108 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	return Future<bool>(new ClearHealthyZoneActor(db, printWarning, clearSSFailureZoneString));
															#line 1546 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
}

#line 136 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"

															#line 1551 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
// This generated class is to be used only via maintenanceCommandActor()
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
template <class MaintenanceCommandActorActor>
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class MaintenanceCommandActorActorState {
															#line 1557 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	MaintenanceCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		 : db(db),
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   tokens(tokens),
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		   result(true)
															#line 1568 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("maintenanceCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~MaintenanceCommandActorActorState() 
	{
		fdb_probe_actor_destroy("maintenanceCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 1583 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = printHealthyZone(db);
															#line 140 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1589 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaintenanceCommandActorActor, 0, Void >*>(static_cast<MaintenanceCommandActorActor*>(this)));
															#line 1594 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 141 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
				if (tokens.size() == 2 && tokencmp(tokens[1], "off"))
															#line 1601 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
				{
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
					StrictFuture<bool> __when_expr_1 = clearHealthyZone(db, true);
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
					if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1607 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MaintenanceCommandActorActor, 1, bool >*>(static_cast<MaintenanceCommandActorActor*>(this)));
															#line 1612 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 144 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
					if (tokens.size() == 4 && tokencmp(tokens[1], "on"))
															#line 1619 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
					{
															#line 145 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						double seconds;
															#line 146 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						int n = 0;
															#line 147 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						auto secondsStr = tokens[3].toString();
															#line 148 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						if (sscanf(secondsStr.c_str(), "%lf%n", &seconds, &n) != 1 || n != secondsStr.size())
															#line 1629 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
						{
															#line 149 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 150 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
							result = false;
															#line 1635 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
							loopDepth = a_body1cont7(loopDepth);
						}
						else
						{
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
							StrictFuture<bool> __when_expr_2 = setHealthyZone(db, tokens[2], seconds, true);
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
							if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1644 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
							if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
							static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
							__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MaintenanceCommandActorActor, 2, bool >*>(static_cast<MaintenanceCommandActorActor*>(this)));
															#line 1649 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
							loopDepth = 0;
						}
					}
					else
					{
															#line 156 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 157 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
						result = false;
															#line 1659 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
						loopDepth = a_body1cont6(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaintenanceCommandActorActorState();
		static_cast<MaintenanceCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 159 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		if (!static_cast<MaintenanceCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~MaintenanceCommandActorActorState(); static_cast<MaintenanceCommandActorActor*>(this)->destroy(); return 0; }
															#line 1685 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		new (&static_cast<MaintenanceCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~MaintenanceCommandActorActorState();
		static_cast<MaintenanceCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceCommandActorActor*>(this)->ActorCallback< MaintenanceCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaintenanceCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(bool const& clearResult,int loopDepth) 
	{
															#line 143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		result = clearResult;
															#line 1790 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(bool && clearResult,int loopDepth) 
	{
															#line 143 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		result = clearResult;
															#line 1799 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when2(bool const& clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(clearResult, loopDepth);

		return loopDepth;
	}
	int a_body1when2(bool && clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(clearResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceCommandActorActor*>(this)->ActorCallback< MaintenanceCommandActorActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MaintenanceCommandActorActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(bool const& setResult,int loopDepth) 
	{
															#line 153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		result = setResult;
															#line 1895 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(bool && setResult,int loopDepth) 
	{
															#line 153 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
		result = setResult;
															#line 1904 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when3(bool const& setResult,int loopDepth) 
	{
		loopDepth = a_body1cont9(setResult, loopDepth);

		return loopDepth;
	}
	int a_body1when3(bool && setResult,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(setResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceCommandActorActor*>(this)->ActorCallback< MaintenanceCommandActorActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MaintenanceCommandActorActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MaintenanceCommandActorActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 138 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	bool result;
															#line 1990 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
};
// This generated class is to be used only via maintenanceCommandActor()
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
class MaintenanceCommandActorActor final : public Actor<bool>, public ActorCallback< MaintenanceCommandActorActor, 0, Void >, public ActorCallback< MaintenanceCommandActorActor, 1, bool >, public ActorCallback< MaintenanceCommandActorActor, 2, bool >, public FastAllocated<MaintenanceCommandActorActor>, public MaintenanceCommandActorActorState<MaintenanceCommandActorActor> {
															#line 1995 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
public:
	using FastAllocated<MaintenanceCommandActorActor>::operator new;
	using FastAllocated<MaintenanceCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5382725582353298176UL, 10524068461665838080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaintenanceCommandActorActor, 0, Void >;
friend struct ActorCallback< MaintenanceCommandActorActor, 1, bool >;
friend struct ActorCallback< MaintenanceCommandActorActor, 2, bool >;
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	MaintenanceCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2014 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
		 : Actor<bool>(),
		   MaintenanceCommandActorActorState<MaintenanceCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1936517700953854720UL, 14259326642320916224UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maintenanceCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maintenanceCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaintenanceCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MaintenanceCommandActorActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MaintenanceCommandActorActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
[[nodiscard]] Future<bool> maintenanceCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 137 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"
	return Future<bool>(new MaintenanceCommandActorActor(db, tokens));
															#line 2048 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/build_output/fdbcli/MaintenanceCommand.actor.g.cpp"
}

#line 161 "/codebuild/output/src128066425/src/github.com/apple/foundationdb/fdbcli/MaintenanceCommand.actor.cpp"

CommandFactory maintenanceFactory(
    "maintenance",
    CommandHelp(
        "maintenance [on|off] [ZONEID] [SECONDS]",
        "mark a zone for maintenance",
        "Calling this command with `on' prevents data distribution from moving data away from the processes with the "
        "specified ZONEID. Data distribution will automatically be turned back on for ZONEID after the specified "
        "SECONDS have elapsed, or after a storage server with a different ZONEID fails. Only one ZONEID can be marked "
        "for maintenance. Calling this command with no arguments will display any ongoing maintenance. Calling this "
        "command with `off' will disable maintenance.\n"));
} // namespace fdb_cli
