﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>Contains information that OpenSearch Service derives based on the
   * <code>VPCOptions</code> for the domain.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsOpenSearchServiceDomainVpcOptionsDetails">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API AwsOpenSearchServiceDomainVpcOptionsDetails
  {
  public:
    AwsOpenSearchServiceDomainVpcOptionsDetails();
    AwsOpenSearchServiceDomainVpcOptionsDetails(Aws::Utils::Json::JsonView jsonValue);
    AwsOpenSearchServiceDomainVpcOptionsDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const{ return m_securityGroupIds; }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline void SetSecurityGroupIds(const Aws::Vector<Aws::String>& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = value; }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline void SetSecurityGroupIds(Aws::Vector<Aws::String>&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = std::move(value); }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& WithSecurityGroupIds(const Aws::Vector<Aws::String>& value) { SetSecurityGroupIds(value); return *this;}

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& WithSecurityGroupIds(Aws::Vector<Aws::String>&& value) { SetSecurityGroupIds(std::move(value)); return *this;}

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSecurityGroupIds(const Aws::String& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSecurityGroupIds(Aws::String&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(std::move(value)); return *this; }

    /**
     * <p>The list of security group IDs that are associated with the VPC endpoints for
     * the domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSecurityGroupIds(const char* value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }


    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSubnetIds() const{ return m_subnetIds; }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline bool SubnetIdsHasBeenSet() const { return m_subnetIdsHasBeenSet; }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline void SetSubnetIds(const Aws::Vector<Aws::String>& value) { m_subnetIdsHasBeenSet = true; m_subnetIds = value; }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline void SetSubnetIds(Aws::Vector<Aws::String>&& value) { m_subnetIdsHasBeenSet = true; m_subnetIds = std::move(value); }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& WithSubnetIds(const Aws::Vector<Aws::String>& value) { SetSubnetIds(value); return *this;}

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& WithSubnetIds(Aws::Vector<Aws::String>&& value) { SetSubnetIds(std::move(value)); return *this;}

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSubnetIds(const Aws::String& value) { m_subnetIdsHasBeenSet = true; m_subnetIds.push_back(value); return *this; }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSubnetIds(Aws::String&& value) { m_subnetIdsHasBeenSet = true; m_subnetIds.push_back(std::move(value)); return *this; }

    /**
     * <p>A list of subnet IDs that are associated with the VPC endpoints for the
     * domain.</p>
     */
    inline AwsOpenSearchServiceDomainVpcOptionsDetails& AddSubnetIds(const char* value) { m_subnetIdsHasBeenSet = true; m_subnetIds.push_back(value); return *this; }

  private:

    Aws::Vector<Aws::String> m_securityGroupIds;
    bool m_securityGroupIdsHasBeenSet;

    Aws::Vector<Aws::String> m_subnetIds;
    bool m_subnetIdsHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
