﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/workmail/model/DeletePersonalAccessTokenRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::WorkMail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DeletePersonalAccessTokenRequest::DeletePersonalAccessTokenRequest() : 
    m_organizationIdHasBeenSet(false),
    m_personalAccessTokenIdHasBeenSet(false)
{
}

Aws::String DeletePersonalAccessTokenRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_organizationIdHasBeenSet)
  {
   payload.WithString("OrganizationId", m_organizationId);

  }

  if(m_personalAccessTokenIdHasBeenSet)
  {
   payload.WithString("PersonalAccessTokenId", m_personalAccessTokenId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeletePersonalAccessTokenRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkMailService.DeletePersonalAccessToken"));
  return headers;

}




