﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/taxsettings/model/BatchPutTaxRegistrationRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::TaxSettings::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

BatchPutTaxRegistrationRequest::BatchPutTaxRegistrationRequest() : 
    m_accountIdsHasBeenSet(false),
    m_taxRegistrationEntryHasBeenSet(false)
{
}

Aws::String BatchPutTaxRegistrationRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_accountIdsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> accountIdsJsonList(m_accountIds.size());
   for(unsigned accountIdsIndex = 0; accountIdsIndex < accountIdsJsonList.GetLength(); ++accountIdsIndex)
   {
     accountIdsJsonList[accountIdsIndex].AsString(m_accountIds[accountIdsIndex]);
   }
   payload.WithArray("accountIds", std::move(accountIdsJsonList));

  }

  if(m_taxRegistrationEntryHasBeenSet)
  {
   payload.WithObject("taxRegistrationEntry", m_taxRegistrationEntry.Jsonize());

  }

  return payload.View().WriteReadable();
}




