﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sso-admin/model/AccountAssignmentForPrincipal.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{
  class ListAccountAssignmentsForPrincipalResult
  {
  public:
    AWS_SSOADMIN_API ListAccountAssignmentsForPrincipalResult();
    AWS_SSOADMIN_API ListAccountAssignmentsForPrincipalResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SSOADMIN_API ListAccountAssignmentsForPrincipalResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An array list of the account assignments for the principal.</p>
     */
    inline const Aws::Vector<AccountAssignmentForPrincipal>& GetAccountAssignments() const{ return m_accountAssignments; }
    inline void SetAccountAssignments(const Aws::Vector<AccountAssignmentForPrincipal>& value) { m_accountAssignments = value; }
    inline void SetAccountAssignments(Aws::Vector<AccountAssignmentForPrincipal>&& value) { m_accountAssignments = std::move(value); }
    inline ListAccountAssignmentsForPrincipalResult& WithAccountAssignments(const Aws::Vector<AccountAssignmentForPrincipal>& value) { SetAccountAssignments(value); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& WithAccountAssignments(Aws::Vector<AccountAssignmentForPrincipal>&& value) { SetAccountAssignments(std::move(value)); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& AddAccountAssignments(const AccountAssignmentForPrincipal& value) { m_accountAssignments.push_back(value); return *this; }
    inline ListAccountAssignmentsForPrincipalResult& AddAccountAssignments(AccountAssignmentForPrincipal&& value) { m_accountAssignments.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>If present, this value indicates that more output is available than is
     * included in the current response. Use this value in the <code>NextToken</code>
     * request parameter in a subsequent call to the operation to get the next part of
     * the output. You should repeat this until the <code>NextToken</code> response
     * element comes back as <code>null</code>. This indicates that this is the last
     * page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListAccountAssignmentsForPrincipalResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListAccountAssignmentsForPrincipalResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListAccountAssignmentsForPrincipalResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<AccountAssignmentForPrincipal> m_accountAssignments;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
