﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/resiliencehub/ResilienceHubRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace ResilienceHub
{
namespace Model
{

  /**
   */
  class RemoveDraftAppVersionResourceMappingsRequest : public ResilienceHubRequest
  {
  public:
    AWS_RESILIENCEHUB_API RemoveDraftAppVersionResourceMappingsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "RemoveDraftAppVersionResourceMappings"; }

    AWS_RESILIENCEHUB_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for
     * this ARN is:
     * arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General
     * Reference</i> guide.</p>
     */
    inline const Aws::String& GetAppArn() const{ return m_appArn; }
    inline bool AppArnHasBeenSet() const { return m_appArnHasBeenSet; }
    inline void SetAppArn(const Aws::String& value) { m_appArnHasBeenSet = true; m_appArn = value; }
    inline void SetAppArn(Aws::String&& value) { m_appArnHasBeenSet = true; m_appArn = std::move(value); }
    inline void SetAppArn(const char* value) { m_appArnHasBeenSet = true; m_appArn.assign(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithAppArn(const Aws::String& value) { SetAppArn(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithAppArn(Aws::String&& value) { SetAppArn(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithAppArn(const char* value) { SetAppArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The names of the registered applications you want to remove from the resource
     * mappings.</p>
     */
    inline const Aws::Vector<Aws::String>& GetAppRegistryAppNames() const{ return m_appRegistryAppNames; }
    inline bool AppRegistryAppNamesHasBeenSet() const { return m_appRegistryAppNamesHasBeenSet; }
    inline void SetAppRegistryAppNames(const Aws::Vector<Aws::String>& value) { m_appRegistryAppNamesHasBeenSet = true; m_appRegistryAppNames = value; }
    inline void SetAppRegistryAppNames(Aws::Vector<Aws::String>&& value) { m_appRegistryAppNamesHasBeenSet = true; m_appRegistryAppNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithAppRegistryAppNames(const Aws::Vector<Aws::String>& value) { SetAppRegistryAppNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithAppRegistryAppNames(Aws::Vector<Aws::String>&& value) { SetAppRegistryAppNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddAppRegistryAppNames(const Aws::String& value) { m_appRegistryAppNamesHasBeenSet = true; m_appRegistryAppNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddAppRegistryAppNames(Aws::String&& value) { m_appRegistryAppNamesHasBeenSet = true; m_appRegistryAppNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddAppRegistryAppNames(const char* value) { m_appRegistryAppNamesHasBeenSet = true; m_appRegistryAppNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The names of the Amazon Elastic Kubernetes Service clusters and namespaces
     * you want to remove from the resource mappings.</p>  <p>This parameter
     * accepts values in "eks-cluster/namespace" format.</p> 
     */
    inline const Aws::Vector<Aws::String>& GetEksSourceNames() const{ return m_eksSourceNames; }
    inline bool EksSourceNamesHasBeenSet() const { return m_eksSourceNamesHasBeenSet; }
    inline void SetEksSourceNames(const Aws::Vector<Aws::String>& value) { m_eksSourceNamesHasBeenSet = true; m_eksSourceNames = value; }
    inline void SetEksSourceNames(Aws::Vector<Aws::String>&& value) { m_eksSourceNamesHasBeenSet = true; m_eksSourceNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithEksSourceNames(const Aws::Vector<Aws::String>& value) { SetEksSourceNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithEksSourceNames(Aws::Vector<Aws::String>&& value) { SetEksSourceNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddEksSourceNames(const Aws::String& value) { m_eksSourceNamesHasBeenSet = true; m_eksSourceNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddEksSourceNames(Aws::String&& value) { m_eksSourceNamesHasBeenSet = true; m_eksSourceNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddEksSourceNames(const char* value) { m_eksSourceNamesHasBeenSet = true; m_eksSourceNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The names of the CloudFormation stacks you want to remove from the resource
     * mappings.</p>
     */
    inline const Aws::Vector<Aws::String>& GetLogicalStackNames() const{ return m_logicalStackNames; }
    inline bool LogicalStackNamesHasBeenSet() const { return m_logicalStackNamesHasBeenSet; }
    inline void SetLogicalStackNames(const Aws::Vector<Aws::String>& value) { m_logicalStackNamesHasBeenSet = true; m_logicalStackNames = value; }
    inline void SetLogicalStackNames(Aws::Vector<Aws::String>&& value) { m_logicalStackNamesHasBeenSet = true; m_logicalStackNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithLogicalStackNames(const Aws::Vector<Aws::String>& value) { SetLogicalStackNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithLogicalStackNames(Aws::Vector<Aws::String>&& value) { SetLogicalStackNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddLogicalStackNames(const Aws::String& value) { m_logicalStackNamesHasBeenSet = true; m_logicalStackNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddLogicalStackNames(Aws::String&& value) { m_logicalStackNamesHasBeenSet = true; m_logicalStackNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddLogicalStackNames(const char* value) { m_logicalStackNamesHasBeenSet = true; m_logicalStackNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The names of the resource groups you want to remove from the resource
     * mappings.</p>
     */
    inline const Aws::Vector<Aws::String>& GetResourceGroupNames() const{ return m_resourceGroupNames; }
    inline bool ResourceGroupNamesHasBeenSet() const { return m_resourceGroupNamesHasBeenSet; }
    inline void SetResourceGroupNames(const Aws::Vector<Aws::String>& value) { m_resourceGroupNamesHasBeenSet = true; m_resourceGroupNames = value; }
    inline void SetResourceGroupNames(Aws::Vector<Aws::String>&& value) { m_resourceGroupNamesHasBeenSet = true; m_resourceGroupNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithResourceGroupNames(const Aws::Vector<Aws::String>& value) { SetResourceGroupNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithResourceGroupNames(Aws::Vector<Aws::String>&& value) { SetResourceGroupNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceGroupNames(const Aws::String& value) { m_resourceGroupNamesHasBeenSet = true; m_resourceGroupNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceGroupNames(Aws::String&& value) { m_resourceGroupNamesHasBeenSet = true; m_resourceGroupNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceGroupNames(const char* value) { m_resourceGroupNamesHasBeenSet = true; m_resourceGroupNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The names of the resources you want to remove from the resource mappings.</p>
     */
    inline const Aws::Vector<Aws::String>& GetResourceNames() const{ return m_resourceNames; }
    inline bool ResourceNamesHasBeenSet() const { return m_resourceNamesHasBeenSet; }
    inline void SetResourceNames(const Aws::Vector<Aws::String>& value) { m_resourceNamesHasBeenSet = true; m_resourceNames = value; }
    inline void SetResourceNames(Aws::Vector<Aws::String>&& value) { m_resourceNamesHasBeenSet = true; m_resourceNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithResourceNames(const Aws::Vector<Aws::String>& value) { SetResourceNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithResourceNames(Aws::Vector<Aws::String>&& value) { SetResourceNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceNames(const Aws::String& value) { m_resourceNamesHasBeenSet = true; m_resourceNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceNames(Aws::String&& value) { m_resourceNamesHasBeenSet = true; m_resourceNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddResourceNames(const char* value) { m_resourceNamesHasBeenSet = true; m_resourceNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The names of the Terraform sources you want to remove from the resource
     * mappings.</p>
     */
    inline const Aws::Vector<Aws::String>& GetTerraformSourceNames() const{ return m_terraformSourceNames; }
    inline bool TerraformSourceNamesHasBeenSet() const { return m_terraformSourceNamesHasBeenSet; }
    inline void SetTerraformSourceNames(const Aws::Vector<Aws::String>& value) { m_terraformSourceNamesHasBeenSet = true; m_terraformSourceNames = value; }
    inline void SetTerraformSourceNames(Aws::Vector<Aws::String>&& value) { m_terraformSourceNamesHasBeenSet = true; m_terraformSourceNames = std::move(value); }
    inline RemoveDraftAppVersionResourceMappingsRequest& WithTerraformSourceNames(const Aws::Vector<Aws::String>& value) { SetTerraformSourceNames(value); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& WithTerraformSourceNames(Aws::Vector<Aws::String>&& value) { SetTerraformSourceNames(std::move(value)); return *this;}
    inline RemoveDraftAppVersionResourceMappingsRequest& AddTerraformSourceNames(const Aws::String& value) { m_terraformSourceNamesHasBeenSet = true; m_terraformSourceNames.push_back(value); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddTerraformSourceNames(Aws::String&& value) { m_terraformSourceNamesHasBeenSet = true; m_terraformSourceNames.push_back(std::move(value)); return *this; }
    inline RemoveDraftAppVersionResourceMappingsRequest& AddTerraformSourceNames(const char* value) { m_terraformSourceNamesHasBeenSet = true; m_terraformSourceNames.push_back(value); return *this; }
    ///@}
  private:

    Aws::String m_appArn;
    bool m_appArnHasBeenSet = false;

    Aws::Vector<Aws::String> m_appRegistryAppNames;
    bool m_appRegistryAppNamesHasBeenSet = false;

    Aws::Vector<Aws::String> m_eksSourceNames;
    bool m_eksSourceNamesHasBeenSet = false;

    Aws::Vector<Aws::String> m_logicalStackNames;
    bool m_logicalStackNamesHasBeenSet = false;

    Aws::Vector<Aws::String> m_resourceGroupNames;
    bool m_resourceGroupNamesHasBeenSet = false;

    Aws::Vector<Aws::String> m_resourceNames;
    bool m_resourceNamesHasBeenSet = false;

    Aws::Vector<Aws::String> m_terraformSourceNames;
    bool m_terraformSourceNamesHasBeenSet = false;
  };

} // namespace Model
} // namespace ResilienceHub
} // namespace Aws
