﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/DefaultFilterDropDownControlOptions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

DefaultFilterDropDownControlOptions::DefaultFilterDropDownControlOptions() : 
    m_displayOptionsHasBeenSet(false),
    m_type(SheetControlListType::NOT_SET),
    m_typeHasBeenSet(false),
    m_selectableValuesHasBeenSet(false),
    m_commitMode(CommitMode::NOT_SET),
    m_commitModeHasBeenSet(false)
{
}

DefaultFilterDropDownControlOptions::DefaultFilterDropDownControlOptions(JsonView jsonValue)
  : DefaultFilterDropDownControlOptions()
{
  *this = jsonValue;
}

DefaultFilterDropDownControlOptions& DefaultFilterDropDownControlOptions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("DisplayOptions"))
  {
    m_displayOptions = jsonValue.GetObject("DisplayOptions");

    m_displayOptionsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Type"))
  {
    m_type = SheetControlListTypeMapper::GetSheetControlListTypeForName(jsonValue.GetString("Type"));

    m_typeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("SelectableValues"))
  {
    m_selectableValues = jsonValue.GetObject("SelectableValues");

    m_selectableValuesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CommitMode"))
  {
    m_commitMode = CommitModeMapper::GetCommitModeForName(jsonValue.GetString("CommitMode"));

    m_commitModeHasBeenSet = true;
  }

  return *this;
}

JsonValue DefaultFilterDropDownControlOptions::Jsonize() const
{
  JsonValue payload;

  if(m_displayOptionsHasBeenSet)
  {
   payload.WithObject("DisplayOptions", m_displayOptions.Jsonize());

  }

  if(m_typeHasBeenSet)
  {
   payload.WithString("Type", SheetControlListTypeMapper::GetNameForSheetControlListType(m_type));
  }

  if(m_selectableValuesHasBeenSet)
  {
   payload.WithObject("SelectableValues", m_selectableValues.Jsonize());

  }

  if(m_commitModeHasBeenSet)
  {
   payload.WithString("CommitMode", CommitModeMapper::GetNameForCommitMode(m_commitMode));
  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
