﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/qconnect/QConnect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qconnect/model/ReferenceType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace QConnect
{
namespace Model
{

  /**
   * <p>Reference information about the content.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/qconnect-2020-10-19/ContentReference">AWS
   * API Reference</a></p>
   */
  class ContentReference
  {
  public:
    AWS_QCONNECT_API ContentReference();
    AWS_QCONNECT_API ContentReference(Aws::Utils::Json::JsonView jsonValue);
    AWS_QCONNECT_API ContentReference& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_QCONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the content.</p>
     */
    inline const Aws::String& GetContentArn() const{ return m_contentArn; }
    inline bool ContentArnHasBeenSet() const { return m_contentArnHasBeenSet; }
    inline void SetContentArn(const Aws::String& value) { m_contentArnHasBeenSet = true; m_contentArn = value; }
    inline void SetContentArn(Aws::String&& value) { m_contentArnHasBeenSet = true; m_contentArn = std::move(value); }
    inline void SetContentArn(const char* value) { m_contentArnHasBeenSet = true; m_contentArn.assign(value); }
    inline ContentReference& WithContentArn(const Aws::String& value) { SetContentArn(value); return *this;}
    inline ContentReference& WithContentArn(Aws::String&& value) { SetContentArn(std::move(value)); return *this;}
    inline ContentReference& WithContentArn(const char* value) { SetContentArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The identifier of the content.</p>
     */
    inline const Aws::String& GetContentId() const{ return m_contentId; }
    inline bool ContentIdHasBeenSet() const { return m_contentIdHasBeenSet; }
    inline void SetContentId(const Aws::String& value) { m_contentIdHasBeenSet = true; m_contentId = value; }
    inline void SetContentId(Aws::String&& value) { m_contentIdHasBeenSet = true; m_contentId = std::move(value); }
    inline void SetContentId(const char* value) { m_contentIdHasBeenSet = true; m_contentId.assign(value); }
    inline ContentReference& WithContentId(const Aws::String& value) { SetContentId(value); return *this;}
    inline ContentReference& WithContentId(Aws::String&& value) { SetContentId(std::move(value)); return *this;}
    inline ContentReference& WithContentId(const char* value) { SetContentId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
     */
    inline const Aws::String& GetKnowledgeBaseArn() const{ return m_knowledgeBaseArn; }
    inline bool KnowledgeBaseArnHasBeenSet() const { return m_knowledgeBaseArnHasBeenSet; }
    inline void SetKnowledgeBaseArn(const Aws::String& value) { m_knowledgeBaseArnHasBeenSet = true; m_knowledgeBaseArn = value; }
    inline void SetKnowledgeBaseArn(Aws::String&& value) { m_knowledgeBaseArnHasBeenSet = true; m_knowledgeBaseArn = std::move(value); }
    inline void SetKnowledgeBaseArn(const char* value) { m_knowledgeBaseArnHasBeenSet = true; m_knowledgeBaseArn.assign(value); }
    inline ContentReference& WithKnowledgeBaseArn(const Aws::String& value) { SetKnowledgeBaseArn(value); return *this;}
    inline ContentReference& WithKnowledgeBaseArn(Aws::String&& value) { SetKnowledgeBaseArn(std::move(value)); return *this;}
    inline ContentReference& WithKnowledgeBaseArn(const char* value) { SetKnowledgeBaseArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES
     * type knowledge base.</p>
     */
    inline const Aws::String& GetKnowledgeBaseId() const{ return m_knowledgeBaseId; }
    inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
    inline void SetKnowledgeBaseId(const Aws::String& value) { m_knowledgeBaseIdHasBeenSet = true; m_knowledgeBaseId = value; }
    inline void SetKnowledgeBaseId(Aws::String&& value) { m_knowledgeBaseIdHasBeenSet = true; m_knowledgeBaseId = std::move(value); }
    inline void SetKnowledgeBaseId(const char* value) { m_knowledgeBaseIdHasBeenSet = true; m_knowledgeBaseId.assign(value); }
    inline ContentReference& WithKnowledgeBaseId(const Aws::String& value) { SetKnowledgeBaseId(value); return *this;}
    inline ContentReference& WithKnowledgeBaseId(Aws::String&& value) { SetKnowledgeBaseId(std::move(value)); return *this;}
    inline ContentReference& WithKnowledgeBaseId(const char* value) { SetKnowledgeBaseId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of reference content.</p>
     */
    inline const ReferenceType& GetReferenceType() const{ return m_referenceType; }
    inline bool ReferenceTypeHasBeenSet() const { return m_referenceTypeHasBeenSet; }
    inline void SetReferenceType(const ReferenceType& value) { m_referenceTypeHasBeenSet = true; m_referenceType = value; }
    inline void SetReferenceType(ReferenceType&& value) { m_referenceTypeHasBeenSet = true; m_referenceType = std::move(value); }
    inline ContentReference& WithReferenceType(const ReferenceType& value) { SetReferenceType(value); return *this;}
    inline ContentReference& WithReferenceType(ReferenceType&& value) { SetReferenceType(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The web URL of the source content.</p>
     */
    inline const Aws::String& GetSourceURL() const{ return m_sourceURL; }
    inline bool SourceURLHasBeenSet() const { return m_sourceURLHasBeenSet; }
    inline void SetSourceURL(const Aws::String& value) { m_sourceURLHasBeenSet = true; m_sourceURL = value; }
    inline void SetSourceURL(Aws::String&& value) { m_sourceURLHasBeenSet = true; m_sourceURL = std::move(value); }
    inline void SetSourceURL(const char* value) { m_sourceURLHasBeenSet = true; m_sourceURL.assign(value); }
    inline ContentReference& WithSourceURL(const Aws::String& value) { SetSourceURL(value); return *this;}
    inline ContentReference& WithSourceURL(Aws::String&& value) { SetSourceURL(std::move(value)); return *this;}
    inline ContentReference& WithSourceURL(const char* value) { SetSourceURL(value); return *this;}
    ///@}
  private:

    Aws::String m_contentArn;
    bool m_contentArnHasBeenSet = false;

    Aws::String m_contentId;
    bool m_contentIdHasBeenSet = false;

    Aws::String m_knowledgeBaseArn;
    bool m_knowledgeBaseArnHasBeenSet = false;

    Aws::String m_knowledgeBaseId;
    bool m_knowledgeBaseIdHasBeenSet = false;

    ReferenceType m_referenceType;
    bool m_referenceTypeHasBeenSet = false;

    Aws::String m_sourceURL;
    bool m_sourceURLHasBeenSet = false;
  };

} // namespace Model
} // namespace QConnect
} // namespace Aws
