﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediapackagev2/model/HarvestedHlsManifest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace mediapackagev2
{
namespace Model
{

HarvestedHlsManifest::HarvestedHlsManifest() : 
    m_manifestNameHasBeenSet(false)
{
}

HarvestedHlsManifest::HarvestedHlsManifest(JsonView jsonValue)
  : HarvestedHlsManifest()
{
  *this = jsonValue;
}

HarvestedHlsManifest& HarvestedHlsManifest::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("ManifestName"))
  {
    m_manifestName = jsonValue.GetString("ManifestName");

    m_manifestNameHasBeenSet = true;
  }

  return *this;
}

JsonValue HarvestedHlsManifest::Jsonize() const
{
  JsonValue payload;

  if(m_manifestNameHasBeenSet)
  {
   payload.WithString("ManifestName", m_manifestName);

  }

  return payload;
}

} // namespace Model
} // namespace mediapackagev2
} // namespace Aws
