﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/kms/model/DeriveSharedSecretRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/HashingUtils.h>

#include <utility>

using namespace Aws::KMS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DeriveSharedSecretRequest::DeriveSharedSecretRequest() : 
    m_keyIdHasBeenSet(false),
    m_keyAgreementAlgorithm(KeyAgreementAlgorithmSpec::NOT_SET),
    m_keyAgreementAlgorithmHasBeenSet(false),
    m_publicKeyHasBeenSet(false),
    m_grantTokensHasBeenSet(false),
    m_dryRun(false),
    m_dryRunHasBeenSet(false),
    m_recipientHasBeenSet(false)
{
}

Aws::String DeriveSharedSecretRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_keyIdHasBeenSet)
  {
   payload.WithString("KeyId", m_keyId);

  }

  if(m_keyAgreementAlgorithmHasBeenSet)
  {
   payload.WithString("KeyAgreementAlgorithm", KeyAgreementAlgorithmSpecMapper::GetNameForKeyAgreementAlgorithmSpec(m_keyAgreementAlgorithm));
  }

  if(m_publicKeyHasBeenSet)
  {
   payload.WithString("PublicKey", HashingUtils::Base64Encode(m_publicKey));
  }

  if(m_grantTokensHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> grantTokensJsonList(m_grantTokens.size());
   for(unsigned grantTokensIndex = 0; grantTokensIndex < grantTokensJsonList.GetLength(); ++grantTokensIndex)
   {
     grantTokensJsonList[grantTokensIndex].AsString(m_grantTokens[grantTokensIndex]);
   }
   payload.WithArray("GrantTokens", std::move(grantTokensJsonList));

  }

  if(m_dryRunHasBeenSet)
  {
   payload.WithBool("DryRun", m_dryRun);

  }

  if(m_recipientHasBeenSet)
  {
   payload.WithObject("Recipient", m_recipient.Jsonize());

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeriveSharedSecretRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "TrentService.DeriveSharedSecret"));
  return headers;

}




