﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ivs-realtime/model/CreateIngestConfigurationRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ivsrealtime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CreateIngestConfigurationRequest::CreateIngestConfigurationRequest() : 
    m_nameHasBeenSet(false),
    m_stageArnHasBeenSet(false),
    m_userIdHasBeenSet(false),
    m_attributesHasBeenSet(false),
    m_ingestProtocol(IngestProtocol::NOT_SET),
    m_ingestProtocolHasBeenSet(false),
    m_insecureIngest(false),
    m_insecureIngestHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

Aws::String CreateIngestConfigurationRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_stageArnHasBeenSet)
  {
   payload.WithString("stageArn", m_stageArn);

  }

  if(m_userIdHasBeenSet)
  {
   payload.WithString("userId", m_userId);

  }

  if(m_attributesHasBeenSet)
  {
   JsonValue attributesJsonMap;
   for(auto& attributesItem : m_attributes)
   {
     attributesJsonMap.WithString(attributesItem.first, attributesItem.second);
   }
   payload.WithObject("attributes", std::move(attributesJsonMap));

  }

  if(m_ingestProtocolHasBeenSet)
  {
   payload.WithString("ingestProtocol", IngestProtocolMapper::GetNameForIngestProtocol(m_ingestProtocol));
  }

  if(m_insecureIngestHasBeenSet)
  {
   payload.WithBool("insecureIngest", m_insecureIngest);

  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("tags", std::move(tagsJsonMap));

  }

  return payload.View().WriteReadable();
}




