﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

MalwareProtectionPlanActions::MalwareProtectionPlanActions() : 
    m_taggingHasBeenSet(false)
{
}

MalwareProtectionPlanActions::MalwareProtectionPlanActions(JsonView jsonValue)
  : MalwareProtectionPlanActions()
{
  *this = jsonValue;
}

MalwareProtectionPlanActions& MalwareProtectionPlanActions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("tagging"))
  {
    m_tagging = jsonValue.GetObject("tagging");

    m_taggingHasBeenSet = true;
  }

  return *this;
}

JsonValue MalwareProtectionPlanActions::Jsonize() const
{
  JsonValue payload;

  if(m_taggingHasBeenSet)
  {
   payload.WithObject("tagging", m_tagging.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
