﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/MalwareProtectionPlanSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class ListMalwareProtectionPlansResult
  {
  public:
    AWS_GUARDDUTY_API ListMalwareProtectionPlansResult();
    AWS_GUARDDUTY_API ListMalwareProtectionPlansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GUARDDUTY_API ListMalwareProtectionPlansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of unique identifiers associated with each Malware Protection
     * plan.</p>
     */
    inline const Aws::Vector<MalwareProtectionPlanSummary>& GetMalwareProtectionPlans() const{ return m_malwareProtectionPlans; }
    inline void SetMalwareProtectionPlans(const Aws::Vector<MalwareProtectionPlanSummary>& value) { m_malwareProtectionPlans = value; }
    inline void SetMalwareProtectionPlans(Aws::Vector<MalwareProtectionPlanSummary>&& value) { m_malwareProtectionPlans = std::move(value); }
    inline ListMalwareProtectionPlansResult& WithMalwareProtectionPlans(const Aws::Vector<MalwareProtectionPlanSummary>& value) { SetMalwareProtectionPlans(value); return *this;}
    inline ListMalwareProtectionPlansResult& WithMalwareProtectionPlans(Aws::Vector<MalwareProtectionPlanSummary>&& value) { SetMalwareProtectionPlans(std::move(value)); return *this;}
    inline ListMalwareProtectionPlansResult& AddMalwareProtectionPlans(const MalwareProtectionPlanSummary& value) { m_malwareProtectionPlans.push_back(value); return *this; }
    inline ListMalwareProtectionPlansResult& AddMalwareProtectionPlans(MalwareProtectionPlanSummary&& value) { m_malwareProtectionPlans.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>You can use this parameter when paginating results. Set the value of this
     * parameter to null on your first call to the list action. For subsequent calls to
     * the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListMalwareProtectionPlansResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListMalwareProtectionPlansResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListMalwareProtectionPlansResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListMalwareProtectionPlansResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListMalwareProtectionPlansResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListMalwareProtectionPlansResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<MalwareProtectionPlanSummary> m_malwareProtectionPlans;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
