/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.test.AbstractTester;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RYWBenchmark
extends AbstractTester {
    private int keyCount;
    public static final int DEFAULT_KEY_COUNT = 10000;
    public static final int DEFAULT_KEY_SIZE = 16;
    private final String keyFormat;

    public RYWBenchmark() {
        this(10000, 16);
    }

    public RYWBenchmark(int n, int n2) {
        this.keyCount = n;
        this.keyFormat = "%0" + n2 + "d";
        Tests.GET_SINGLE.setFunction(transaction -> this.getSingle((Transaction)transaction, 10000));
        Tests.GET_MANY_SEQUENTIAL.setFunction(transaction -> this.getManySequential((Transaction)transaction, 10000));
        Tests.GET_RANGE_BASIC.setFunction(transaction -> this.getRangeBasic((Transaction)transaction, 1000));
        Tests.SINGLE_CLEAR_GET_RANGE.setFunction(transaction -> this.singleClearGetRange((Transaction)transaction, 1000));
        Tests.CLEAR_RANGE_GET_RANGE.setFunction(transaction -> this.clearRangeGetRange((Transaction)transaction, 1000));
        Tests.INTERLEAVED_SETS_GETS.setFunction(transaction -> this.interleavedSetsGets((Transaction)transaction, 10000));
    }

    @Override
    public void testPerformance(Database database) {
        try (Transaction transaction = database.createTransaction();){
            this.insertData(transaction);
            List<String> list = this.args.getTestsToRun().isEmpty() ? Arrays.stream(Tests.values()).map(Enum::name).map(String::toLowerCase).sorted().collect(Collectors.toList()) : this.args.getTestsToRun();
            for (String string : list) {
                Tests tests;
                try {
                    tests = Tests.valueOf(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.result.addError(new IllegalArgumentException("Test " + string + " not implemented"));
                    continue;
                }
                Function<? super Transaction, ? extends Double> function = tests.getFunction();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    this.result.addError(this.wrapAndPrintError(interruptedException, "Interrupted while sleeping"));
                }
                System.out.println("Running test " + string);
                ArrayList<Double> arrayList = new ArrayList<Double>(25);
                for (int i = 0; i < 25; ++i) {
                    try {
                        arrayList.add(function.apply((Transaction)transaction));
                        continue;
                    }
                    catch (Exception exception) {
                        this.result.addError(this.wrapAndPrintError(exception, "Performance test failed: " + string));
                        break;
                    }
                }
                if (arrayList.size() != 25) continue;
                Collections.sort(arrayList);
                this.result.addKpi(String.format("%s", tests.getKpi()), ((Double)arrayList.get(arrayList.size() / 2)).intValue(), "keys/s");
            }
            transaction.cancel();
        }
    }

    public Double getSingle(Transaction transaction, int n) {
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transaction.get(this.key(5001)).join();
        }
        long l2 = System.nanoTime();
        return (double)n * 1.0E9 / (double)(l2 - l);
    }

    public Double getManySequential(Transaction transaction, int n) {
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transaction.get(this.key(i)).join();
        }
        long l2 = System.nanoTime();
        return (double)n * 1.0E9 / (double)(l2 - l);
    }

    public Double getRangeBasic(Transaction transaction, int n) {
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transaction.getRange(this.key(0), this.key(this.keyCount)).asList().join();
        }
        long l2 = System.nanoTime();
        return (double)n * 1.0E9 * (double)this.keyCount / (double)(l2 - l);
    }

    public Double singleClearGetRange(Transaction transaction, int n) {
        for (int i = 0; i < this.keyCount; i += 2) {
            transaction.clear(("" + i).getBytes(ASCII));
        }
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transaction.getRange(this.key(0), this.key(this.keyCount)).asList().join();
        }
        long l2 = System.nanoTime();
        Double d = (double)n * 1.0E9 * (double)this.keyCount / 2.0 / (double)(l2 - l);
        this.insertData(transaction);
        return d;
    }

    public Double clearRangeGetRange(Transaction transaction, int n) {
        for (int i = 0; i < this.keyCount; i += 4) {
            transaction.clear(this.key(i), this.key(i + 1));
        }
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transaction.getRange(this.key(0), this.key(this.keyCount)).asList().join();
        }
        long l2 = System.nanoTime();
        Double d = (double)n * 1.0E9 * (double)this.keyCount * 3.0 / 4.0 / (double)(l2 - l);
        this.insertData(transaction);
        return d;
    }

    public Double interleavedSetsGets(Transaction transaction, int n) {
        long l = System.nanoTime();
        byte[] byArray = "foo".getBytes(ASCII);
        transaction.set(byArray, "1".getBytes(ASCII));
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.parseInt(new String((byte[])transaction.get(byArray).join(), ASCII));
            transaction.set(byArray, ("" + (n2 + 1)).getBytes(ASCII));
        }
        long l2 = System.nanoTime();
        return (double)n * 1.0E9 / (double)(l2 - l);
    }

    public void insertData(Transaction transaction) {
        transaction.clear(new byte[0], new byte[]{-1});
        for (int i = 0; i < this.keyCount; ++i) {
            transaction.set(this.key(i), "foo".getBytes(ASCII));
        }
    }

    public byte[] key(int n) {
        return ByteArrayUtil.join((byte[][])new byte[][]{this.args.getSubspace().pack(), String.format(this.keyFormat, n).getBytes(ASCII)});
    }

    public static void main(String[] stringArray) {
        System.out.println("Running Java RYW benchmark on Java version " + System.getProperty("java.version"));
        try {
            new RYWBenchmark().run(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Could not run test due to malformed arguments.");
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("Fatal error encountered during run: " + exception);
            exception.printStackTrace();
            System.exit(2);
        }
    }

    private static enum Tests {
        GET_SINGLE("RYW Java Completable: get single cached value throughput"),
        GET_MANY_SEQUENTIAL("RYW Java Completable: get sequential cached value throughput"),
        GET_RANGE_BASIC("RYW Java Completable: get range cached values throughput"),
        SINGLE_CLEAR_GET_RANGE("RYW Java Completable: get range cached values with clears throughput"),
        CLEAR_RANGE_GET_RANGE("RYW Java Completable: get range cached values with clear ranges throughput"),
        INTERLEAVED_SETS_GETS("RYW Java Completable: interleaved sets and gets on a single key throughput");

        private String kpi;
        private Function<? super Transaction, ? extends Double> function;

        private Tests(String string2) {
            this.kpi = string2;
        }

        public void setFunction(Function<? super Transaction, ? extends Double> function) {
            this.function = function;
        }

        public Function<? super Transaction, ? extends Double> getFunction() {
            return this.function;
        }

        public String getKpi() {
            return this.kpi;
        }
    }
}

