/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.TenantManagement;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.test.AsyncDirectoryExtension;
import com.apple.foundationdb.test.Context;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.test.Stack;
import com.apple.foundationdb.test.StackEntry;
import com.apple.foundationdb.test.StackOperation;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class AsyncStackTester {
    static final String DIRECTORY_PREFIX = "DIRECTORY_";

    static CompletableFuture<Void> processInstruction(Instruction instruction) {
        StackOperation stackOperation = StackOperation.valueOf(instruction.op);
        if (stackOperation == StackOperation.PUSH) {
            Object object2 = instruction.tokens.get(1);
            instruction.push(object2);
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.POP) {
            instruction.pop();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.DUP) {
            if (instruction.size() == 0) {
                throw new RuntimeException("No stack bro!! (" + instruction.context.preStr + ")");
            }
            StackEntry stackEntry = instruction.pop();
            instruction.push(stackEntry);
            instruction.push(stackEntry);
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.EMPTY_STACK) {
            instruction.clear();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.SWAP) {
            return instruction.popParam().thenAcceptAsync(object -> {
                int n = StackUtils.getInt(object);
                if (n >= instruction.size()) {
                    throw new IllegalArgumentException("Stack index not valid");
                }
                instruction.swap(n);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.WAIT_FUTURE) {
            return AsyncStackTester.popAndWait(instruction).thenAccept(instruction::push);
        }
        if (stackOperation == StackOperation.WAIT_EMPTY) {
            return instruction.popParam().thenComposeAsync(object -> {
                WaitEmpty waitEmpty = new WaitEmpty((byte[])object);
                return instruction.context.db.runAsync((Function)waitEmpty).thenRun(() -> instruction.push("WAITED_FOR_EMPTY".getBytes()));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.START_THREAD) {
            return instruction.popParam().thenAcceptAsync(object -> instruction.context.addContext((byte[])object), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.NEW_TRANSACTION) {
            instruction.context.newTransaction();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.USE_TRANSACTION) {
            return instruction.popParam().thenAcceptAsync(object -> instruction.context.switchTransaction((byte[])object), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.SET) {
            return instruction.popParams(2).thenComposeAsync(list -> AsyncStackTester.executeMutation(instruction, transaction -> {
                transaction.set((byte[])list.get(0), (byte[])list.get(1));
                return AsyncUtil.DONE;
            }), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.CLEAR) {
            return instruction.popParam().thenComposeAsync(object -> AsyncStackTester.executeMutation(instruction, transaction -> {
                transaction.clear((byte[])object);
                return AsyncUtil.DONE;
            }), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.CLEAR_RANGE) {
            return instruction.popParams(2).thenComposeAsync(list -> AsyncStackTester.executeMutation(instruction, transaction -> {
                transaction.clear((byte[])list.get(0), (byte[])list.get(1));
                return AsyncUtil.DONE;
            }), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.CLEAR_RANGE_STARTS_WITH) {
            return instruction.popParam().thenComposeAsync(object -> AsyncStackTester.executeMutation(instruction, transaction -> {
                transaction.clear(Range.startsWith((byte[])((byte[])object)));
                return AsyncUtil.DONE;
            }), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.ATOMIC_OP) {
            return instruction.popParams(3).thenComposeAsync(list -> {
                MutationType mutationType = MutationType.valueOf((String)((String)list.get(0)));
                return AsyncStackTester.executeMutation(instruction, transaction -> {
                    transaction.mutate(mutationType, (byte[])list.get(1), (byte[])list.get(2));
                    return AsyncUtil.DONE;
                });
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.COMMIT) {
            instruction.push(instruction.tr.commit());
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.RESET) {
            instruction.context.resetTransaction();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.CANCEL) {
            instruction.tr.cancel();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.READ_CONFLICT_RANGE) {
            return instruction.popParams(2).thenAcceptAsync(list -> {
                instruction.tr.addReadConflictRange((byte[])list.get(0), (byte[])list.get(1));
                instruction.push("SET_CONFLICT_RANGE".getBytes());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.WRITE_CONFLICT_RANGE) {
            return instruction.popParams(2).thenAcceptAsync(list -> {
                instruction.tr.addWriteConflictRange((byte[])list.get(0), (byte[])list.get(1));
                instruction.push("SET_CONFLICT_RANGE".getBytes());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.READ_CONFLICT_KEY) {
            return instruction.popParam().thenAcceptAsync(object -> {
                instruction.tr.addReadConflictKey((byte[])object);
                instruction.push("SET_CONFLICT_KEY".getBytes());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.WRITE_CONFLICT_KEY) {
            return instruction.popParam().thenAcceptAsync(object -> {
                instruction.tr.addWriteConflictKey((byte[])object);
                instruction.push("SET_CONFLICT_KEY".getBytes());
            });
        }
        if (stackOperation == StackOperation.DISABLE_WRITE_CONFLICT) {
            instruction.tr.options().setNextWriteNoWriteConflictRange();
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.GET) {
            return instruction.popParam().thenAcceptAsync(object -> instruction.push(instruction.readTcx.readAsync(readTransaction -> readTransaction.get((byte[])object))));
        }
        if (stackOperation == StackOperation.GET_ESTIMATED_RANGE_SIZE) {
            List<Object> list3 = instruction.popParams(2).join();
            return instruction.readTr.getEstimatedRangeSizeBytes((byte[])list3.get(0), (byte[])list3.get(1)).thenAcceptAsync(l -> instruction.push("GOT_ESTIMATED_RANGE_SIZE".getBytes()), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_RANGE_SPLIT_POINTS) {
            List<Object> list4 = instruction.popParams(3).join();
            return instruction.readTr.getRangeSplitPoints((byte[])list4.get(0), (byte[])list4.get(1), ((Long)list4.get(2)).longValue()).thenAcceptAsync(keyArrayResult -> instruction.push("GOT_RANGE_SPLIT_POINTS".getBytes()), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_RANGE) {
            return instruction.popParams(5).thenComposeAsync(list -> {
                int n = StackUtils.getInt(list.get(2));
                boolean bl = StackUtils.getBoolean(list.get(3));
                StreamingMode streamingMode = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(4), (Integer)StreamingMode.ITERATOR.code()));
                CompletableFuture completableFuture = instruction.readTcx.readAsync(readTransaction -> readTransaction.getRange((byte[])list.get(0), (byte[])list.get(1), n, bl, streamingMode).asList());
                return AsyncStackTester.pushRange(instruction, completableFuture);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_RANGE_SELECTOR) {
            return instruction.popParams(10).thenComposeAsync(list -> {
                int n = StackUtils.getInt(list.get(6));
                boolean bl = StackUtils.getBoolean(list.get(7));
                StreamingMode streamingMode = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(8), (Integer)StreamingMode.ITERATOR.code()));
                KeySelector keySelector = StackUtils.createSelector(list.get(0), list.get(1), list.get(2));
                KeySelector keySelector2 = StackUtils.createSelector(list.get(3), list.get(4), list.get(5));
                CompletableFuture completableFuture = instruction.readTcx.readAsync(readTransaction -> readTransaction.getRange(keySelector, keySelector2, n, bl, streamingMode).asList());
                return AsyncStackTester.pushRange(instruction, completableFuture, (byte[])list.get(9));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_RANGE_STARTS_WITH) {
            return instruction.popParams(4).thenComposeAsync(list -> {
                int n = StackUtils.getInt(list.get(1));
                boolean bl = StackUtils.getBoolean(list.get(2));
                StreamingMode streamingMode = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(3), (Integer)StreamingMode.ITERATOR.code()));
                CompletableFuture completableFuture = instruction.readTcx.readAsync(readTransaction -> readTransaction.getRange(Range.startsWith((byte[])((byte[])list.get(0))), n, bl, streamingMode).asList());
                return AsyncStackTester.pushRange(instruction, completableFuture);
            });
        }
        if (stackOperation == StackOperation.GET_KEY) {
            return instruction.popParams(4).thenAcceptAsync(list -> {
                KeySelector keySelector = StackUtils.createSelector(list.get(0), list.get(1), list.get(2));
                instruction.push(instruction.readTcx.readAsync(readTransaction -> AsyncStackTester.executeGetKey(readTransaction.getKey(keySelector), (byte[])list.get(3))));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_READ_VERSION) {
            return instruction.readTr.getReadVersion().thenAcceptAsync(l -> {
                instruction.context.lastVersion = l;
                instruction.push("GOT_READ_VERSION".getBytes());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_COMMITTED_VERSION) {
            try {
                instruction.context.lastVersion = instruction.tr.getCommittedVersion();
                instruction.push("GOT_COMMITTED_VERSION".getBytes());
            }
            catch (FDBException fDBException) {
                StackUtils.pushError(instruction, fDBException);
            }
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.GET_APPROXIMATE_SIZE) {
            return instruction.tr.getApproximateSize().thenAcceptAsync(l -> instruction.push("GOT_APPROXIMATE_SIZE".getBytes()), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.GET_VERSIONSTAMP) {
            try {
                instruction.push(instruction.tr.getVersionstamp());
            }
            catch (FDBException fDBException) {
                StackUtils.pushError(instruction, fDBException);
            }
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.SET_READ_VERSION) {
            if (instruction.context.lastVersion == null) {
                throw new IllegalArgumentException("Read version has not been read");
            }
            instruction.tr.setReadVersion(instruction.context.lastVersion.longValue());
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.ON_ERROR) {
            return instruction.popParam().thenComposeAsync(object -> {
                int n = StackUtils.getInt(object);
                boolean bl = n == 1102 || n == 2015;
                FDBException fDBException = new FDBException("Fake testing error", bl ? 1020 : n);
                Transaction transaction3 = instruction.tr;
                CompletionStage completionStage = ((CompletableFuture)transaction3.onError((Throwable)fDBException).whenComplete((transaction2, throwable) -> {
                    if (throwable != null) {
                        instruction.context.resetTransaction(transaction3);
                    } else if (!instruction.replaceTransaction(transaction3, (Transaction)transaction2)) {
                        transaction2.close();
                    }
                })).thenApply(transaction -> null);
                if (bl) {
                    ((CompletableFuture)completionStage).join();
                    throw new FDBException("Fake testing error", n);
                }
                instruction.push(completionStage);
                return AsyncUtil.DONE;
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.SUB) {
            return instruction.popParams(2).thenAcceptAsync(list -> {
                BigInteger bigInteger = StackUtils.getBigInteger(list.get(0)).subtract(StackUtils.getBigInteger(list.get(1)));
                instruction.push(bigInteger);
            });
        }
        if (stackOperation == StackOperation.CONCAT) {
            return instruction.popParams(2).thenAcceptAsync(list -> {
                if (list.get(0) instanceof String) {
                    instruction.push((String)list.get(0) + (String)list.get(1));
                } else {
                    instruction.push(ByteArrayUtil.join((byte[][])new byte[][]{(byte[])list.get(0), (byte[])list.get(1)}));
                }
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TUPLE_PACK) {
            return instruction.popParam().thenComposeAsync(object -> {
                int n = StackUtils.getInt(object);
                return instruction.popParams(n).thenAcceptAsync(list -> {
                    byte[] byArray = Tuple.fromItems((Iterable)list).pack();
                    instruction.push(byArray);
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TUPLE_PACK_WITH_VERSIONSTAMP) {
            return instruction.popParams(2).thenComposeAsync(list2 -> {
                byte[] byArray = (byte[])list2.get(0);
                int n = StackUtils.getInt(list2.get(1));
                return instruction.popParams(n).thenAcceptAsync(list -> {
                    Tuple tuple = Tuple.fromItems((Iterable)list);
                    if (!tuple.hasIncompleteVersionstamp() && Math.random() < 0.5) {
                        instruction.push("ERROR: NONE".getBytes());
                        return;
                    }
                    try {
                        byte[] byArray2 = tuple.packWithVersionstamp(byArray);
                        instruction.push("OK".getBytes());
                        instruction.push(byArray2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage().startsWith("No incomplete")) {
                            instruction.push("ERROR: NONE".getBytes());
                        }
                        instruction.push("ERROR: MULTIPLE".getBytes());
                    }
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TUPLE_UNPACK) {
            return instruction.popParam().thenAcceptAsync(object -> {
                Tuple tuple = Tuple.fromBytes((byte[])((byte[])object));
                for (Object e : tuple.getItems()) {
                    byte[] byArray = Tuple.from((Object[])new Object[]{e}).pack();
                    instruction.push(byArray);
                }
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TUPLE_RANGE) {
            return instruction.popParam().thenComposeAsync(object -> {
                int n = StackUtils.getInt(object);
                return instruction.popParams(n).thenAcceptAsync(list -> {
                    Range range = Tuple.fromItems((Iterable)list).range();
                    instruction.push(range.begin);
                    instruction.push(range.end);
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TUPLE_SORT) {
            return instruction.popParam().thenComposeAsync(object -> {
                int n = StackUtils.getInt(object);
                return instruction.popParams(n).thenAcceptAsync(list -> {
                    ArrayList<Tuple> arrayList = new ArrayList<Tuple>(n);
                    for (Object object : list) {
                        Tuple tuple = Tuple.fromBytes((byte[])((byte[])object));
                        arrayList.add(Tuple.fromList((List)tuple.getItems()));
                    }
                    Collections.sort(arrayList);
                    for (Tuple tuple : arrayList) {
                        instruction.push(tuple.pack());
                    }
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.ENCODE_FLOAT) {
            return instruction.popParam().thenAcceptAsync(object -> {
                byte[] byArray = (byte[])object;
                float f = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
                instruction.push(Float.valueOf(f));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.ENCODE_DOUBLE) {
            return instruction.popParam().thenAcceptAsync(object -> {
                byte[] byArray = (byte[])object;
                double d = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getDouble();
                instruction.push(d);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.DECODE_FLOAT) {
            return instruction.popParam().thenAcceptAsync(object -> {
                float f = ((Number)object).floatValue();
                instruction.push(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putFloat(f).array());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.DECODE_DOUBLE) {
            return instruction.popParam().thenAcceptAsync(object -> {
                double d = ((Number)object).doubleValue();
                instruction.push(ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putDouble(d).array());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TENANT_CREATE) {
            return instruction.popParam().thenAcceptAsync(object -> {
                byte[] byArray = (byte[])object;
                instruction.push(TenantManagement.createTenant((Database)instruction.context.db, (byte[])byArray));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TENANT_DELETE) {
            return instruction.popParam().thenAcceptAsync(object -> {
                byte[] byArray = (byte[])object;
                instruction.push(TenantManagement.deleteTenant((Database)instruction.context.db, (byte[])byArray));
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TENANT_LIST) {
            return instruction.popParams(3).thenAcceptAsync(list -> {
                byte[] byArray = (byte[])list.get(0);
                byte[] byArray2 = (byte[])list.get(1);
                int n = StackUtils.getInt(list.get(2));
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                try (CloseableAsyncIterator closeableAsyncIterator = TenantManagement.listTenants((Database)instruction.context.db, (byte[])byArray, (byte[])byArray2, (int)n);){
                    while (closeableAsyncIterator.hasNext()) {
                        KeyValue keyValue = (KeyValue)closeableAsyncIterator.next();
                        String string = new String(keyValue.getValue());
                        assert (StackUtils.validTenantMetadata(string)) : "Invalid Tenant Metadata";
                        arrayList.add(keyValue.getKey());
                    }
                }
                instruction.push(Tuple.fromItems(arrayList).pack());
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TENANT_SET_ACTIVE) {
            return instruction.popParam().thenComposeAsync(object -> {
                byte[] byArray = (byte[])object;
                return instruction.context.setTenant(Optional.of(byArray)).thenAcceptAsync(l -> instruction.push("SET_ACTIVE_TENANT".getBytes()), (Executor)FDB.DEFAULT_EXECUTOR);
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
        if (stackOperation == StackOperation.TENANT_CLEAR_ACTIVE) {
            instruction.context.setTenant(Optional.empty());
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.TENANT_GET_ID) {
            if (instruction.context.tenant.isPresent()) {
                return instruction.context.tenant.get().getId().thenAcceptAsync(l -> instruction.push("GOT_TENANT_ID".getBytes()), (Executor)FDB.DEFAULT_EXECUTOR);
            }
            instruction.push("NO_ACTIVE_TENANT".getBytes());
            return AsyncUtil.DONE;
        }
        if (stackOperation == StackOperation.UNIT_TESTS) {
            instruction.context.db.options().setLocationCacheSize(100001L);
            return instruction.context.db.runAsync(transaction -> {
                FDB fDB = FDB.instance();
                String string = "FoundationDB API already started at different version";
                try {
                    FDB.selectAPIVersion((int)(fDB.getAPIVersion() + 1));
                    throw new IllegalStateException("Was not stopped from selecting two API versions");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!illegalArgumentException.getMessage().equals(string)) {
                        throw illegalArgumentException;
                    }
                    try {
                        FDB.selectAPIVersion((int)(fDB.getAPIVersion() - 1));
                        throw new IllegalStateException("Was not stopped from selecting two API versions");
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        if (!illegalArgumentException2.getMessage().equals(string)) {
                            throw illegalArgumentException2;
                        }
                        Database database = transaction.getDatabase();
                        database.options().setLocationCacheSize(100001L);
                        database.options().setMaxWatches(10001L);
                        database.options().setDatacenterId("dc_id");
                        database.options().setMachineId("machine_id");
                        database.options().setSnapshotRywEnable();
                        database.options().setSnapshotRywDisable();
                        database.options().setTransactionLoggingMaxFieldLength(1000L);
                        database.options().setTransactionTimeout(100000L);
                        database.options().setTransactionTimeout(0L);
                        database.options().setTransactionMaxRetryDelay(100L);
                        database.options().setTransactionRetryLimit(10L);
                        database.options().setTransactionRetryLimit(-1L);
                        database.options().setTransactionCausalReadRisky();
                        database.options().setTransactionIncludePortInAddress();
                        database.options().setTransactionUsedDuringCommitProtectionDisable();
                        database.options().setTransactionBypassUnreadable();
                        database.options().setTransactionReportConflictingKeys();
                        double d = database.getMainThreadBusyness();
                        if (d < 0.0) {
                            throw new IllegalStateException("Network busyness cannot be less than 0");
                        }
                        transaction.options().setPrioritySystemImmediate();
                        transaction.options().setPriorityBatch();
                        transaction.options().setCausalReadRisky();
                        transaction.options().setCausalWriteRisky();
                        transaction.options().setReadYourWritesDisable();
                        transaction.options().setReadSystemKeys();
                        transaction.options().setAccessSystemKeys();
                        transaction.options().setTransactionLoggingMaxFieldLength(1000L);
                        transaction.options().setTimeout(60000L);
                        transaction.options().setRetryLimit(50L);
                        transaction.options().setMaxRetryDelay(100L);
                        transaction.options().setUsedDuringCommitProtectionDisable();
                        transaction.options().setDebugTransactionIdentifier("my_transaction");
                        transaction.options().setLogTransaction();
                        transaction.options().setReadLockAware();
                        transaction.options().setLockAware();
                        transaction.options().setIncludePortInAddress();
                        transaction.options().setReportConflictingKeys();
                        transaction.options().setBypassUnreadable();
                        if (!new FDBException("Fake", 1020).isRetryable() || new FDBException("Fake", 10).isRetryable()) {
                            throw new RuntimeException("Unit test failed: Error predicate incorrect");
                        }
                        byte[] byArray = new byte[]{-1};
                        return transaction.get(byArray).thenRunAsync(() -> {});
                    }
                }
            }).exceptionally(throwable -> {
                throw new RuntimeException("Unit tests failed: " + throwable.getMessage());
            });
        }
        if (stackOperation == StackOperation.LOG_STACK) {
            return instruction.popParam().thenComposeAsync(object -> AsyncStackTester.doLogStack(instruction, (byte[])object), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        throw new IllegalArgumentException("Unrecognized (or unimplemented) operation");
    }

    private static CompletableFuture<Void> executeMutation(Instruction instruction, Function<Transaction, CompletableFuture<Void>> function) {
        return instruction.tcx.runAsync(function).thenRunAsync(() -> {
            if (instruction.isDatabase || instruction.isTenant) {
                instruction.push("RESULT_NOT_PRESENT".getBytes());
            }
        }, FDB.DEFAULT_EXECUTOR);
    }

    private static CompletableFuture<byte[]> executeGetKey(CompletableFuture<byte[]> completableFuture, byte[] byArray) {
        return completableFuture.thenApplyAsync(byArray2 -> {
            if (ByteArrayUtil.startsWith((byte[])byArray2, (byte[])byArray)) {
                return byArray2;
            }
            if (ByteArrayUtil.compareUnsigned((byte[])byArray2, (byte[])byArray) < 0) {
                return byArray;
            }
            return ByteArrayUtil.strinc((byte[])byArray);
        }, (Executor)FDB.DEFAULT_EXECUTOR);
    }

    private static CompletableFuture<Void> doLogStack(Instruction instruction, byte[] byArray) {
        HashMap<Integer, StackEntry> hashMap = new HashMap<Integer, StackEntry>();
        while (instruction.size() > 0) {
            hashMap.put(instruction.size() - 1, instruction.pop());
            if (hashMap.size() != 100) continue;
            return AsyncStackTester.logStack(instruction.context.db, hashMap, byArray).thenComposeAsync(void_ -> AsyncStackTester.doLogStack(instruction, byArray), (Executor)FDB.DEFAULT_EXECUTOR);
        }
        return AsyncStackTester.logStack(instruction.context.db, hashMap, byArray);
    }

    private static CompletableFuture<Void> logStack(Database database, Map<Integer, StackEntry> map, byte[] byArray) {
        return database.runAsync(transaction -> {
            for (Map.Entry entry : map.entrySet()) {
                byte[] byArray2 = Tuple.from((Object[])new Object[]{entry.getKey(), ((StackEntry)entry.getValue()).idx}).pack(byArray);
                byte[] byArray3 = Tuple.from((Object[])new Object[]{StackUtils.serializeFuture(((StackEntry)entry.getValue()).value)}).pack();
                transaction.set(byArray2, byArray3.length < 40000 ? byArray3 : Arrays.copyOfRange(byArray3, 0, 40000));
            }
            return AsyncUtil.DONE;
        });
    }

    private static CompletableFuture<Void> pushRange(Instruction instruction, CompletableFuture<List<KeyValue>> completableFuture) {
        return AsyncStackTester.pushRange(instruction, completableFuture, null);
    }

    private static CompletableFuture<Void> pushRange(Instruction instruction, CompletableFuture<List<KeyValue>> completableFuture, byte[] byArray) {
        return completableFuture.thenApplyAsync((Function)new ListPusher(instruction, byArray));
    }

    static CompletableFuture<StackEntry> popAndWait(Stack stack) {
        StackEntry stackEntry = stack.pop();
        Object object2 = stackEntry.value;
        if (!(object2 instanceof CompletableFuture)) {
            return CompletableFuture.completedFuture(stackEntry);
        }
        int n = stackEntry.idx;
        CompletableFuture completableFuture = (CompletableFuture)object2;
        CompletableFuture<Object> completableFuture2 = AsyncStackTester.flatten(completableFuture);
        return completableFuture2.thenApplyAsync(object -> new StackEntry(n, object));
    }

    private static CompletableFuture<Object> flatten(CompletableFuture<?> completableFuture) {
        CompletionStage completionStage = completableFuture.thenApply(object -> {
            if (object == null) {
                return "RESULT_NOT_PRESENT".getBytes();
            }
            return object;
        });
        return AsyncUtil.composeExceptionally((CompletableFuture)completionStage, throwable -> {
            FDBException fDBException = StackUtils.getRootFDBException(throwable);
            if (fDBException != null) {
                return CompletableFuture.completedFuture(StackUtils.getErrorBytes(fDBException));
            }
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally((Throwable)throwable);
            return completableFuture;
        });
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("StackTester needs parameters <prefix> <optional_cluster_file>");
        }
        byte[] byArray = stringArray[0].getBytes();
        if (FDB.isAPIVersionSelected()) {
            throw new IllegalStateException("API version already set to " + FDB.instance().getAPIVersion());
        }
        try {
            FDB.instance();
            throw new IllegalStateException("Able to get API instance before selecting API version");
        }
        catch (FDBException fDBException) {
            if (fDBException.getCode() != 2200) {
                throw fDBException;
            }
            int n = Integer.parseInt(stringArray[1]);
            FDB fDB = FDB.selectAPIVersion((int)n);
            if (FDB.instance().getAPIVersion() != n) {
                throw new IllegalStateException("API version not correctly set to " + n);
            }
            Database database = fDB.open(stringArray.length > 2 ? stringArray[2] : null);
            AsynchronousContext asynchronousContext = new AsynchronousContext(database, byArray);
            asynchronousContext.run();
            database.close();
            System.gc();
            return;
        }
    }

    private AsyncStackTester() {
    }

    static class AsynchronousContext
    extends Context {
        List<KeyValue> operations = null;
        int currentOp = 0;
        AsyncDirectoryExtension directoryExtension = new AsyncDirectoryExtension();

        AsynchronousContext(Database database, byte[] byArray) {
            super(database, byArray);
        }

        @Override
        Context createContext(byte[] byArray) {
            return new AsynchronousContext(this.db, byArray);
        }

        CompletableFuture<Void> processOp(byte[] byArray) {
            Tuple tuple = Tuple.fromBytes((byte[])byArray);
            Instruction instruction = new Instruction(this, tuple);
            if (instruction.op.startsWith(AsyncStackTester.DIRECTORY_PREFIX)) {
                return this.directoryExtension.processInstruction(instruction).whenComplete((void_, throwable) -> instruction.releaseTransaction());
            }
            return AsyncUtil.composeExceptionally(AsyncStackTester.processInstruction(instruction), throwable -> {
                FDBException fDBException = StackUtils.getRootFDBException(throwable);
                if (fDBException != null) {
                    StackUtils.pushError(instruction, fDBException);
                    return AsyncUtil.DONE;
                }
                CompletableFuture completableFuture = new CompletableFuture();
                completableFuture.completeExceptionally((Throwable)throwable);
                return completableFuture;
            }).whenComplete((void_, throwable) -> instruction.releaseTransaction());
        }

        @Override
        void executeOperations() {
            this.executeRemainingOperations().join();
        }

        CompletableFuture<Void> executeRemainingOperations() {
            Function<Void, CompletableFuture> function = void_ -> {
                ++this.instructionIndex;
                return this.executeRemainingOperations();
            };
            if (this.operations == null || ++this.currentOp == this.operations.size()) {
                return this.db.readAsync(readTransaction -> readTransaction.getRange(this.nextKey, this.endKey, 1000).asList()).thenComposeAsync(list -> {
                    if (list.size() < 1) {
                        return AsyncUtil.DONE;
                    }
                    this.operations = list;
                    this.currentOp = 0;
                    this.nextKey = KeySelector.firstGreaterThan((byte[])((KeyValue)list.get(list.size() - 1)).getKey());
                    return this.processOp(((KeyValue)list.get(0)).getValue()).thenComposeAsync(function);
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }
            return this.processOp(this.operations.get(this.currentOp).getValue()).thenComposeAsync(function, (Executor)FDB.DEFAULT_EXECUTOR);
        }
    }

    private static class ListPusher
    implements Function<List<KeyValue>, Void> {
        final Instruction inst;
        final byte[] prefixFilter;

        ListPusher(Instruction instruction, byte[] byArray) {
            this.inst = instruction;
            this.prefixFilter = byArray;
        }

        @Override
        public Void apply(List<KeyValue> list) {
            LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
            for (KeyValue keyValue : list) {
                if (this.prefixFilter != null && !ByteArrayUtil.startsWith((byte[])keyValue.getKey(), (byte[])this.prefixFilter)) continue;
                linkedList.add(keyValue.getKey());
                linkedList.add(keyValue.getValue());
            }
            this.inst.push(Tuple.fromItems(linkedList).pack());
            return null;
        }
    }

    static class WaitEmpty
    implements Function<Transaction, CompletableFuture<Void>> {
        private final byte[] prefix;

        WaitEmpty(byte[] byArray) {
            this.prefix = byArray;
        }

        @Override
        public CompletableFuture<Void> apply(Transaction transaction) {
            return transaction.getRange(Range.startsWith((byte[])this.prefix)).asList().thenAcceptAsync(list -> {
                if (list.size() > 0) {
                    throw new FDBException("ERROR: Fake commit conflict", 1020);
                }
            }, (Executor)FDB.DEFAULT_EXECUTOR);
        }
    }
}

