#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
/*
 * SpecialKeySpace.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "boost/algorithm/string.hpp"

#include <string>
#include <time.h>
#include <msgpack.hpp>

#include <exception>
#include <unordered_set>

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "flow/Arena.h"
#include "flow/UnitTest.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StatusClient.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
const std::string kTracingTransactionIdKey = "transaction_id";
const std::string kTracingTokenKey = "token";

static bool isAlphaNumeric(const std::string& key) {
	// [A-Za-z0-9_]+
	if (!key.size())
		return false;
	for (const char& c : key) {
		if (!((c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == '_'))
			return false;
	}
	return true;
}
} // namespace

std::unordered_map<SpecialKeySpace::MODULE, KeyRange> SpecialKeySpace::moduleToBoundary = {
	{ SpecialKeySpace::MODULE::TRANSACTION, KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction0"_sr) },
	{ SpecialKeySpace::MODULE::WORKERINTERFACE,
	  KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr) },
	{ SpecialKeySpace::MODULE::STATUSJSON, singleKeyRange("\xff\xff/status/json"_sr) },
	{ SpecialKeySpace::MODULE::CONNECTIONSTRING, singleKeyRange("\xff\xff/connection_string"_sr) },
	{ SpecialKeySpace::MODULE::CLUSTERFILEPATH, singleKeyRange("\xff\xff/cluster_file_path"_sr) },
	{ SpecialKeySpace::MODULE::METRICS, KeyRangeRef("\xff\xff/metrics/"_sr, "\xff\xff/metrics0"_sr) },
	{ SpecialKeySpace::MODULE::MANAGEMENT, KeyRangeRef("\xff\xff/management/"_sr, "\xff\xff/management0"_sr) },
	{ SpecialKeySpace::MODULE::ERRORMSG, singleKeyRange("\xff\xff/error_message"_sr) },
	{ SpecialKeySpace::MODULE::CONFIGURATION, KeyRangeRef("\xff\xff/configuration/"_sr, "\xff\xff/configuration0"_sr) },
	{ SpecialKeySpace::MODULE::GLOBALCONFIG, KeyRangeRef("\xff\xff/global_config/"_sr, "\xff\xff/global_config0"_sr) },
	{ SpecialKeySpace::MODULE::TRACING, KeyRangeRef("\xff\xff/tracing/"_sr, "\xff\xff/tracing0"_sr) },
	{ SpecialKeySpace::MODULE::ACTORLINEAGE, KeyRangeRef("\xff\xff/actor_lineage/"_sr, "\xff\xff/actor_lineage0"_sr) },
	{ SpecialKeySpace::MODULE::ACTOR_PROFILER_CONF,
	  KeyRangeRef("\xff\xff/actor_profiler_conf/"_sr, "\xff\xff/actor_profiler_conf0"_sr) },
	{ SpecialKeySpace::MODULE::CLUSTERID, singleKeyRange("\xff\xff/cluster_id"_sr) },
};

std::unordered_map<std::string, KeyRange> SpecialKeySpace::managementApiCommandToRange = {
	{ "exclude", KeyRangeRef("excluded/"_sr, "excluded0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "failed", KeyRangeRef("failed/"_sr, "failed0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "excludedlocality",
	  KeyRangeRef("excluded_locality/"_sr, "excluded_locality0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "failedlocality",
	  KeyRangeRef("failed_locality/"_sr, "failed_locality0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "lock", singleKeyRange("db_locked"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "consistencycheck",
	  singleKeyRange("consistency_check_suspended"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "coordinators",
	  KeyRangeRef("coordinators/"_sr, "coordinators0"_sr).withPrefix(moduleToBoundary[MODULE::CONFIGURATION].begin) },
	{ "advanceversion",
	  singleKeyRange("min_required_commit_version"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "versionepoch", singleKeyRange("version_epoch"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "profile", KeyRangeRef("profiling/"_sr, "profiling0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "maintenance",
	  KeyRangeRef("maintenance/"_sr, "maintenance0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "datadistribution",
	  KeyRangeRef("data_distribution/"_sr, "data_distribution0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
};

std::unordered_map<std::string, KeyRange> SpecialKeySpace::actorLineageApiCommandToRange = {
	{ "state", KeyRangeRef("state/"_sr, "state0"_sr).withPrefix(moduleToBoundary[MODULE::ACTORLINEAGE].begin) },
	{ "time", KeyRangeRef("time/"_sr, "time0"_sr).withPrefix(moduleToBoundary[MODULE::ACTORLINEAGE].begin) }
};

std::set<std::string> SpecialKeySpace::options = { "excluded/force",
	                                               "failed/force",
	                                               "excluded_locality/force",
	                                               "failed_locality/force",
	                                               "worker_interfaces/verify" };

std::set<std::string> SpecialKeySpace::tracingOptions = { kTracingTransactionIdKey, kTracingTokenKey };

RangeResult rywGetRange(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr, const RangeResult& res);

// This function will move the given KeySelector as far as possible to the standard form:
// orEqual == false && offset == 1 (Standard form)
// If the corresponding key is not in the underlying key range, it will move over the range
// The cache object is used to cache the first read result from the rpc call during the key resolution,
// then when we need to do key resolution or result filtering,
// we, instead of rpc call, read from this cache object have consistent results
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via moveKeySelectorOverRangeActor()
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MoveKeySelectorOverRangeActorActor>
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MoveKeySelectorOverRangeActorActorState {
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MoveKeySelectorOverRangeActorActorState(const SpecialKeyRangeReadImpl* const& skrImpl,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : skrImpl(skrImpl),
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ks(ks),
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(cache)
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~MoveKeySelectorOverRangeActorActorState() 
	{
		fdb_probe_actor_destroy("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(!ks->orEqual);
															#line 133 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(ks->offset != 1);
															#line 135 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			startKey = Key(skrImpl->getKeyRange().begin);
															#line 136 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			endKey = Key(skrImpl->getKeyRange().end);
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result = RangeResult();
															#line 139 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset < 1)
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 141 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (skrImpl->getKeyRange().contains(ks->getKey()))
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					endKey = ks->getKey();
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 145 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (skrImpl->getKeyRange().contains(ks->getKey()))
															#line 187 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					startKey = ks->getKey();
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(startKey < endKey);
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			DisabledTraceEvent(SevDebug, "NormalizeKeySelector") .detail("OriginalKey", ks->getKey()) .detail("OriginalOffset", ks->offset) .detail("SpecialKeyRangeStart", skrImpl->getKeyRange().begin) .detail("SpecialKeyRangeEnd", skrImpl->getKeyRange().end);
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			GetRangeLimits limitsHint(ks->offset >= 1 ? ks->offset : 1 - ks->offset);
															#line 160 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (skrImpl->isAsync())
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(skrImpl);
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = ptr->getRange(ryw, KeyRangeRef(startKey, endKey), limitsHint, cache);
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 210 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 1;
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*>(static_cast<MoveKeySelectorOverRangeActorActor*>(this)));
															#line 215 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_1 = skrImpl->getRange(ryw, KeyRangeRef(startKey, endKey), limitsHint);
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 224 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 2;
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*>(static_cast<MoveKeySelectorOverRangeActorActor*>(this)));
															#line 229 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveKeySelectorOverRangeActorActorState();
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size() == 0)
															#line 253 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "ZeroElementsIntheRange").detail("Start", startKey).detail("End", endKey);
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeySelectorOverRangeActorActorState(); static_cast<MoveKeySelectorOverRangeActorActor*>(this)->destroy(); return 0; }
															#line 259 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MoveKeySelectorOverRangeActorActorState();
			static_cast<MoveKeySelectorOverRangeActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ks->offset < 1)
															#line 267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (result.size() >= 1 - ks->offset)
															#line 271 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[result.size() - (1 - ks->offset)].key));
															#line 177 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset = 1;
															#line 277 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[0].key));
															#line 180 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset += result.size();
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (result.size() >= ks->offset)
															#line 292 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 184 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[ks->offset - 1].key));
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset = 1;
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), keyAfter(result[result.size() - 1].key)));
															#line 189 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset -= result.size();
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 192 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		DisabledTraceEvent(SevDebug, "NormalizeKeySelector") .detail("NormalizedKey", ks->getKey()) .detail("NormalizedOffset", ks->offset) .detail("SpecialKeyRangeStart", skrImpl->getKeyRange().begin) .detail("SpecialKeyRangeEnd", skrImpl->getKeyRange().end);
															#line 197 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeySelectorOverRangeActorActorState(); static_cast<MoveKeySelectorOverRangeActorActor*>(this)->destroy(); return 0; }
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeySelectorOverRangeActorActorState();
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(RangeResult const& result_,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 325 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(RangeResult && result_,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result_,int loopDepth) 
	{
		loopDepth = a_body1cont6(result_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result_,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(result_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(RangeResult const& result_,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 418 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(RangeResult && result_,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 427 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult const& result_,int loopDepth) 
	{
		loopDepth = a_body1cont8(result_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult && result_,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(result_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	const SpecialKeyRangeReadImpl* skrImpl;
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector* ks;
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>>* cache;
															#line 135 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key startKey;
															#line 136 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key endKey;
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 521 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via moveKeySelectorOverRangeActor()
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MoveKeySelectorOverRangeActorActor final : public Actor<Void>, public ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >, public ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >, public FastAllocated<MoveKeySelectorOverRangeActorActor>, public MoveKeySelectorOverRangeActorActorState<MoveKeySelectorOverRangeActorActor> {
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<MoveKeySelectorOverRangeActorActor>::operator new;
	using FastAllocated<MoveKeySelectorOverRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10157234122478486272UL, 16351876030971908864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >;
friend struct ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >;
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MoveKeySelectorOverRangeActorActor(const SpecialKeyRangeReadImpl* const& skrImpl,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 544 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MoveKeySelectorOverRangeActorActorState<MoveKeySelectorOverRangeActorActor>(skrImpl, ryw, ks, cache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16581637658165629440UL, 5960354244137475072UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveKeySelectorOverRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> moveKeySelectorOverRangeActor( const SpecialKeyRangeReadImpl* const& skrImpl, ReadYourWritesTransaction* const& ryw, KeySelector* const& ks, KeyRangeMap<Optional<RangeResult>>* const& cache ) {
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new MoveKeySelectorOverRangeActorActor(skrImpl, ryw, ks, cache));
															#line 578 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 199 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

// This function will normalize the given KeySelector to a standard KeySelector:
// orEqual == false && offset == 1 (Standard form)
// If the corresponding key is outside the whole space, it will move to the begin or the end
// It does have overhead here since we query all keys twice in the worst case.
// However, moving the KeySelector while handling other parameters like limits makes the code much more complex and hard
// to maintain; Thus, separate each part to make the code easy to understand and more compact
// Boundary is the range of the legal key space, which, by default is the range of the module
// And (\xff\xff, \xff\xff\xff) if SPECIAL_KEY_SPACE_RELAXED is turned on
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via normalizeKeySelectorActor()
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class NormalizeKeySelectorActorActor>
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class NormalizeKeySelectorActorActorState {
															#line 598 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NormalizeKeySelectorActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeRef const& boundary,int* const& actualOffset,RangeResult* const& result,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ks(ks),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   boundary(boundary),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualOffset(actualOffset),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(result),
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(cache),
															#line 220 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(ks->offset < 1 ? sks->getReadImpls().rangeContainingKeyBefore(ks->getKey()) : sks->getReadImpls().rangeContaining(ks->getKey()))
															#line 619 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this));

	}
	~NormalizeKeySelectorActorActorState() 
	{
		fdb_probe_actor_destroy("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 634 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NormalizeKeySelectorActorActorState();
		static_cast<NormalizeKeySelectorActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		*actualOffset = ks->offset;
															#line 241 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!ks->isFirstGreaterOrEqual())
															#line 659 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "ReadToBoundary") .detail("TerminateKey", ks->getKey()) .detail("TerminateOffset", ks->offset);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset < 1)
															#line 665 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 248 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result->readToBegin = true;
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(boundary.begin);
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 251 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result->readThroughEnd = true;
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(boundary.end);
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ks->offset = 1;
															#line 683 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 256 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<NormalizeKeySelectorActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NormalizeKeySelectorActorActorState(); static_cast<NormalizeKeySelectorActorActor*>(this)->destroy(); return 0; }
															#line 687 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<NormalizeKeySelectorActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NormalizeKeySelectorActorActorState();
		static_cast<NormalizeKeySelectorActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!((ks->offset < 1 && iter->begin() >= boundary.begin) || (ks->offset > 1 && iter->begin() < boundary.end)))
															#line 706 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() != nullptr)
															#line 712 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = moveKeySelectorOverRangeActor(iter->value(), ryw, ks, cache);
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 718 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state = 1;
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*>(static_cast<NormalizeKeySelectorActorActor*>(this)));
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ks->offset < 1)
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter == sks->getReadImpls().ranges().begin())
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				--iter;
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 234 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset > 1)
															#line 769 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				++iter;
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state > 0) static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state = 0;
		static_cast<NormalizeKeySelectorActorActor*>(this)->ActorCallback< NormalizeKeySelectorActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector* ks;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef boundary;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int* actualOffset;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult* result;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>>* cache;
															#line 220 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::iterator iter;
															#line 883 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via normalizeKeySelectorActor()
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class NormalizeKeySelectorActorActor final : public Actor<Void>, public ActorCallback< NormalizeKeySelectorActorActor, 0, Void >, public FastAllocated<NormalizeKeySelectorActorActor>, public NormalizeKeySelectorActorActorState<NormalizeKeySelectorActorActor> {
															#line 888 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<NormalizeKeySelectorActorActor>::operator new;
	using FastAllocated<NormalizeKeySelectorActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9602493591903028736UL, 14535098220619748864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NormalizeKeySelectorActorActor, 0, Void >;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NormalizeKeySelectorActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeRef const& boundary,int* const& actualOffset,RangeResult* const& result,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NormalizeKeySelectorActorActorState<NormalizeKeySelectorActorActor>(sks, ryw, ks, boundary, actualOffset, result, cache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2217121789477885952UL, 10501505158022201600UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("normalizeKeySelectorActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> normalizeKeySelectorActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector* const& ks, KeyRangeRef const& boundary, int* const& actualOffset, RangeResult* const& result, KeyRangeMap<Optional<RangeResult>>* const& cache ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new NormalizeKeySelectorActorActor(sks, ryw, ks, boundary, actualOffset, result, cache));
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 258 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

SpecialKeySpace::SpecialKeySpace(KeyRef spaceStartKey, KeyRef spaceEndKey, bool testOnly)
  : readImpls(nullptr, spaceEndKey),
    modules(testOnly ? SpecialKeySpace::MODULE::TESTONLY : SpecialKeySpace::MODULE::UNKNOWN, spaceEndKey),
    writeImpls(nullptr, spaceEndKey), range(KeyRangeRef(spaceStartKey, spaceEndKey)) {
	// Default begin of KeyRangeMap is Key(), insert the range to update start key
	readImpls.insert(range, nullptr);
	writeImpls.insert(range, nullptr);
	if (!testOnly) {
		// testOnly is used in the correctness workload
		modulesBoundaryInit();
	}
}

void SpecialKeySpace::modulesBoundaryInit() {
	for (const auto& pair : moduleToBoundary) {
		ASSERT(range.contains(pair.second));
		// Make sure the module is not overlapping with any registered read modules
		// Note: same like ranges, one module's end cannot be another module's start, relax the condition if needed
		ASSERT(modules.rangeContaining(pair.second.begin) == modules.rangeContaining(pair.second.end) &&
		       modules[pair.second.begin] == SpecialKeySpace::MODULE::UNKNOWN);
		modules.insert(pair.second, pair.first);
		// Note: Due to underlying implementation, the insertion here is important to make cross_module_read being
		// handled correctly
		readImpls.insert(pair.second, nullptr);
		writeImpls.insert(pair.second, nullptr);
	}
}

															#line 971 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
// This generated class is to be used only via checkRYWValid()
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_CheckRYWValidActor>
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_CheckRYWValidActorState {
															#line 977 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_CheckRYWValidActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse)
															#line 994 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkRYWValid", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_CheckRYWValidActorState() 
	{
		fdb_probe_actor_destroy("checkRYWValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 293 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(ryw);
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = SpecialKeySpace::getRangeAggregationActor(sks, ryw, begin, end, limits, reverse);
															#line 294 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1013 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_1 = ryw->resetFuture();
															#line 1017 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state = 1;
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*>(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)));
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*>(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)));
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_CheckRYWValidActorState(); static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->destroy(); return 0; }
															#line 1047 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_CheckRYWValidActorState(); static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->destroy(); return 0; }
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1079 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >::remove();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 1216 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkRYWValid()
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_CheckRYWValidActor final : public Actor<RangeResult>, public ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >, public ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >, public FastAllocated<SpecialKeySpace_CheckRYWValidActor>, public SpecialKeySpace_CheckRYWValidActorState<SpecialKeySpace_CheckRYWValidActor> {
															#line 1221 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<SpecialKeySpace_CheckRYWValidActor>::operator new;
	using FastAllocated<SpecialKeySpace_CheckRYWValidActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7855210859525760000UL, 6633525987340836352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_CheckRYWValidActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 1239 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   SpecialKeySpace_CheckRYWValidActorState<SpecialKeySpace_CheckRYWValidActor>(sks, ryw, begin, end, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(771692089335300352UL, 2740106847181895936UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRYWValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> SpecialKeySpace::checkRYWValid( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new SpecialKeySpace_CheckRYWValidActor(sks, ryw, begin, end, limits, reverse));
															#line 1271 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 304 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 1276 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
// This generated class is to be used only via getRangeAggregationActor()
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_GetRangeAggregationActorActor>
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetRangeAggregationActorActorState {
															#line 1282 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetRangeAggregationActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse),
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   pairs(),
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(),
															#line 316 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualBeginOffset(),
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualEndOffset(),
															#line 318 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   moduleBoundary(),
															#line 321 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(Optional<RangeResult>(), specialKeys.end)
															#line 1313 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeAggregationActor", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_GetRangeAggregationActorActorState() 
	{
		fdb_probe_actor_destroy("getRangeAggregationActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 323 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->specialKeySpaceRelaxed())
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				moduleBoundary = sks->range;
															#line 1332 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 326 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto beginIter = sks->getModules().rangeContaining(begin.getKey());
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (beginIter->begin() <= end.getKey() && end.getKey() <= beginIter->end())
															#line 1340 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (beginIter->value() == SpecialKeySpace::MODULE::UNKNOWN)
															#line 1344 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						return a_body1Catch1(special_keys_no_module_found(), loopDepth);
															#line 1348 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
					else
					{
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						moduleBoundary = beginIter->range();
															#line 1354 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevInfo, "SpecialKeyCrossModuleRead") .detail("Begin", begin) .detail("End", end) .detail("BoundaryBegin", beginIter->begin()) .detail("BoundaryEnd", beginIter->end());
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					return a_body1Catch1(special_keys_cross_module_read(), loopDepth);
															#line 1363 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = normalizeKeySelectorActor(sks, ryw, &begin, moduleBoundary, &actualBeginOffset, &result, &cache);
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1370 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 1;
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1375 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_GetRangeAggregationActorActorState();
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = normalizeKeySelectorActor(sks, ryw, &end, moduleBoundary, &actualEndOffset, &result, &cache);
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1400 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 2;
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1405 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = normalizeKeySelectorActor(sks, ryw, &end, moduleBoundary, &actualEndOffset, &result, &cache);
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1416 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 2;
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1421 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (actualBeginOffset >= actualEndOffset && begin.getKey() >= end.getKey())
															#line 1505 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 347 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "inverted range");
															#line 348 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResultRef(false, false)); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1511 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResultRef(false, false));
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (begin.getKey() == moduleBoundary.end || end.getKey() == moduleBoundary.begin)
															#line 1519 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "query touches begin or end");
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1525 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = sks->getReadImpls().intersectingRanges(KeyRangeRef(begin.getKey(), end.getKey()));
															#line 360 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = reverse ? ranges.end() : ranges.begin();
															#line 361 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 1537 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 362 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 1541 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8loopHead1(loopDepth);
		}
		else
		{
															#line 394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			iter = ranges.begin();
															#line 1548 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (actualBeginOffset >= actualEndOffset && begin.getKey() >= end.getKey())
															#line 1558 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 347 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "inverted range");
															#line 348 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResultRef(false, false)); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1564 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResultRef(false, false));
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (begin.getKey() == moduleBoundary.end || end.getKey() == moduleBoundary.begin)
															#line 1572 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "query touches begin or end");
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1578 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = sks->getReadImpls().intersectingRanges(KeyRangeRef(begin.getKey(), end.getKey()));
															#line 360 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = reverse ? ranges.end() : ranges.begin();
															#line 361 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 1590 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 362 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 1594 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8loopHead1(loopDepth);
		}
		else
		{
															#line 394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			iter = ranges.begin();
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 425 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1686 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~SpecialKeySpace_GetRangeAggregationActorActorState();
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1(int loopDepth) 
	{
															#line 362 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(iter != ranges.begin()))
															#line 1711 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 363 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		--iter;
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() == nullptr)
															#line 1719 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1cont8loopHead1(loopDepth); // continue
		}
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRangeRef kr = iter->range();
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyStart = kr.contains(begin.getKey()) ? begin.getKey() : kr.begin;
															#line 368 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyEnd = kr.contains(end.getKey()) ? end.getKey() : kr.end;
															#line 369 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value()->isAsync() && cache.rangeContaining(keyStart).value().present())
															#line 1731 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 370 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(iter->value());
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = ptr->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits, &cache);
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1739 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 3;
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1744 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_3 = iter->value()->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits);
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1753 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when2(__when_expr_3.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 4;
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1758 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(int loopDepth) 
	{
															#line 377 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.arena().dependsOn(pairs.arena());
															#line 379 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = pairs.size() - 1;i >= 0;--i) {
															#line 380 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(iter->range().contains(pairs[i].key));
															#line 381 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), pairs[i]);
															#line 385 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			limits.decrement(pairs[i]);
															#line 386 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (limits.isReached())
															#line 1791 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 387 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.more = true;
															#line 388 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.readToBegin = false;
															#line 389 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1799 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
				this->~SpecialKeySpace_GetRangeAggregationActorActorState();
				static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont4(RangeResult const& pairs_,int loopDepth) 
	{
															#line 372 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1814 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont4(RangeResult && pairs_,int loopDepth) 
	{
															#line 372 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1823 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont4(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont4(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8loopBody1cont6(RangeResult const& pairs_,int loopDepth) 
	{
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont6(RangeResult && pairs_,int loopDepth) 
	{
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1916 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when2(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont6(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when2(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont6(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2(int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(iter != ranges.end()))
															#line 2013 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1cont8break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 395 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() == nullptr)
															#line 2019 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1cont8continue1(loopDepth); // continue
		}
															#line 397 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRangeRef kr = iter->range();
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyStart = kr.contains(begin.getKey()) ? begin.getKey() : kr.begin;
															#line 399 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyEnd = kr.contains(end.getKey()) ? end.getKey() : kr.end;
															#line 400 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value()->isAsync() && cache.rangeContaining(keyStart).value().present())
															#line 2031 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 401 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(iter->value());
															#line 402 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = ptr->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits, &cache);
															#line 402 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody2when1(__when_expr_4.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 5;
															#line 402 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 2044 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_5 = iter->value()->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits);
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2053 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody2when2(__when_expr_5.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 6;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 2058 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8break2(int loopDepth) 
	{
		try {
			return a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8continue1(int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++iter;
															#line 2081 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead2(0);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont1(int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.arena().dependsOn(pairs.arena());
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = 0;i < pairs.size();++i) {
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(iter->range().contains(pairs[i].key));
															#line 412 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), pairs[i]);
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			limits.decrement(pairs[i]);
															#line 417 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (limits.isReached())
															#line 2100 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.more = true;
															#line 419 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.readThroughEnd = false;
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 2108 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
				this->~SpecialKeySpace_GetRangeAggregationActorActorState();
				static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++iter;
															#line 2117 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead2(0);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont4(RangeResult const& pairs_,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2126 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont4(RangeResult && pairs_,int loopDepth) 
	{
															#line 403 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when1(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont4(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when1(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont4(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8loopBody2cont6(RangeResult const& pairs_,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2219 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont6(RangeResult && pairs_,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2228 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when2(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont6(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when2(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont6(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8loopBody2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8loopBody2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult pairs;
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::iterator iter;
															#line 316 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int actualBeginOffset;
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int actualEndOffset;
															#line 318 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef moduleBoundary;
															#line 321 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>> cache;
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::Ranges ranges;
															#line 2336 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeAggregationActor()
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetRangeAggregationActorActor final : public Actor<RangeResult>, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >, public FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>, public SpecialKeySpace_GetRangeAggregationActorActorState<SpecialKeySpace_GetRangeAggregationActorActor> {
															#line 2341 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>::operator new;
	using FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7574990263080236288UL, 14172837633970692096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >;
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetRangeAggregationActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 2363 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   SpecialKeySpace_GetRangeAggregationActorActorState<SpecialKeySpace_GetRangeAggregationActorActor>(sks, ryw, begin, end, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3238308827241114624UL, 16709983472663675392UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeAggregationActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> SpecialKeySpace::getRangeAggregationActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new SpecialKeySpace_GetRangeAggregationActorActor(sks, ryw, begin, end, limits, reverse));
															#line 2400 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 427 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> SpecialKeySpace::getRange(ReadYourWritesTransaction* ryw,
                                              KeySelector begin,
                                              KeySelector end,
                                              GetRangeLimits limits,
                                              Reverse reverse) {
	// validate limits here
	if (!limits.isValid())
		return range_limits_invalid();
	if (limits.isReached()) {
		CODE_PROBE(true, "Special Key Space range read limit 0");
		return RangeResult();
	}
	// make sure orEqual == false
	begin.removeOrEqual(begin.arena());
	end.removeOrEqual(end.arena());

	if (begin.offset >= end.offset && begin.getKey() >= end.getKey()) {
		CODE_PROBE(true, "range inverted");
		return RangeResult();
	}

	return checkRYWValid(this, ryw, begin, end, limits, reverse);
}

															#line 2429 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
// This generated class is to be used only via getActor()
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_GetActorActor>
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetActorActorState {
															#line 2435 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeyRef const& key) 
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   key(key)
															#line 2446 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getActor", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_GetActorActorState() 
	{
		fdb_probe_actor_destroy("getActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = sks->getRange(ryw, KeySelector(firstGreaterOrEqual(key)), KeySelector(firstGreaterOrEqual(keyAfter(key))), GetRangeLimits(CLIENT_KNOBS->TOO_MANY), Reverse::False);
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2463 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state = 1;
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*>(static_cast<SpecialKeySpace_GetActorActor*>(this)));
															#line 2468 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_GetActorActorState();
		static_cast<SpecialKeySpace_GetActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size())
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 463 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>(result[0].value)); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2497 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>(result[0].value));
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 465 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2507 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size())
															#line 2522 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 463 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>(result[0].value)); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2526 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>(result[0].value));
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 465 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2536 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetActorActor*>(this)->ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef key;
															#line 2626 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getActor()
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetActorActor final : public Actor<Optional<Value>>, public ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >, public FastAllocated<SpecialKeySpace_GetActorActor>, public SpecialKeySpace_GetActorActorState<SpecialKeySpace_GetActorActor> {
															#line 2631 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<SpecialKeySpace_GetActorActor>::operator new;
	using FastAllocated<SpecialKeySpace_GetActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3269118552911307520UL, 2685416275290040064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeyRef const& key) 
															#line 2648 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   SpecialKeySpace_GetActorActorState<SpecialKeySpace_GetActorActor>(sks, ryw, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7181471174476362496UL, 1925644596793483776UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<Value>> SpecialKeySpace::getActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeyRef const& key ) {
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<Value>>(new SpecialKeySpace_GetActorActor(sks, ryw, key));
															#line 2680 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 468 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<Value>> SpecialKeySpace::get(ReadYourWritesTransaction* ryw, const Key& key) {
	return getActor(this, ryw, key);
}

void SpecialKeySpace::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	auto impl = writeImpls[key];
	if (impl == nullptr) {
		TraceEvent(SevDebug, "SpecialKeySpaceNoWriteModuleFound")
		    .detail("Key", key.toString())
		    .detail("Value", value.toString());
		throw special_keys_no_write_module_found();
	}
	return impl->set(ryw, key, value);
}

void SpecialKeySpace::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	if (range.empty())
		return;
	auto begin = writeImpls[range.begin];
	auto end = writeImpls.rangeContainingKeyBefore(range.end)->value();
	if (begin != end) {
		TraceEvent(SevDebug, "SpecialKeySpaceCrossModuleClear").detail("Range", range);
		throw special_keys_cross_module_clear(); // ban cross module clear
	} else if (begin == nullptr) {
		TraceEvent(SevDebug, "SpecialKeySpaceNoWriteModuleFound").detail("Range", range);
		throw special_keys_no_write_module_found();
	}
	return begin->clear(ryw, range);
}

void SpecialKeySpace::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	auto impl = writeImpls[key];
	if (impl == nullptr)
		throw special_keys_no_write_module_found();
	return impl->clear(ryw, key);
}

bool validateSnakeCaseNaming(const KeyRef& k) {
	KeyRef key(k);
	// Remove prefix \xff\xff
	ASSERT(key.startsWith(specialKeys.begin));
	key = key.removePrefix(specialKeys.begin);
	// Suffix can be \xff\xff or \x00 in single key range
	if (key.endsWith(specialKeys.begin))
		key = key.removeSuffix(specialKeys.end);
	else if (key.endsWith("\x00"_sr))
		key = key.removeSuffix("\x00"_sr);
	for (const char& c : key.toString()) {
		// only small letters, numbers, '/', '_' is allowed
		ASSERT((c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') || c == '/' || c == '_');
	}
	return true;
}

void SpecialKeySpace::registerKeyRange(SpecialKeySpace::MODULE module,
                                       SpecialKeySpace::IMPLTYPE type,
                                       const KeyRangeRef& kr,
                                       SpecialKeyRangeReadImpl* impl) {
	// Not allowed to register an empty range
	ASSERT(!kr.empty());
	// module boundary check
	if (module == SpecialKeySpace::MODULE::TESTONLY) {
		ASSERT(normalKeys.contains(kr));
	} else {
		ASSERT(moduleToBoundary.at(module).contains(kr));
		// validate keys follow snake case naming style
		ASSERT(validateSnakeCaseNaming(kr.begin) && validateSnakeCaseNaming(kr.end));
	}
	// make sure the registered range is not overlapping with existing ones
	// Note: kr.end should not be the same as another range's begin, although it should work even they are the same
	for (auto iter = readImpls.rangeContaining(kr.begin); true; ++iter) {
		ASSERT(iter->value() == nullptr);
		if (iter == readImpls.rangeContaining(kr.end)) {
			// Note: relax the condition that the end can be another range's start, if needed
			break;
		}
	}
	readImpls.insert(kr, impl);
	// if rw, it means the module can do both read and write
	if (type == SpecialKeySpace::IMPLTYPE::READWRITE) {
		// since write impls are always subset of read impls,
		// no need to check overlapped registration
		auto rwImpl = dynamic_cast<SpecialKeyRangeRWImpl*>(impl);
		ASSERT(rwImpl);
		writeImpls.insert(kr, rwImpl);
	}
}

Key SpecialKeySpace::decode(const KeyRef& key) {
	auto impl = writeImpls[key];
	ASSERT(impl != nullptr);
	return impl->decode(key);
}

KeyRange SpecialKeySpace::decode(const KeyRangeRef& kr) {
	// Only allow to decode key range in the same underlying impl range
	auto begin = writeImpls.rangeContaining(kr.begin);
	ASSERT(begin->value() != nullptr);
	auto end = writeImpls.rangeContainingKeyBefore(kr.end);
	ASSERT(begin == end);
	return KeyRangeRef(begin->value()->decode(kr.begin), begin->value()->decode(kr.end));
}

															#line 2794 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitActor()
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CommitActorActor>
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CommitActorActorState {
															#line 2801 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CommitActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw) 
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ranges(ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys)),
															#line 581 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(ranges.begin()),
															#line 582 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   writeModulePtrs()
															#line 2816 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitActor", reinterpret_cast<unsigned long>(this));

	}
	~CommitActorActorState() 
	{
		fdb_probe_actor_destroy("commitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::unordered_set<SpecialKeyRangeRWImpl*> deduplicate;
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(;iter != ranges.end();) {
															#line 585 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::pair<bool, Optional<Value>> entry = iter->value();
															#line 586 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.first)
															#line 2837 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 587 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					auto modulePtr = sks->getRWImpls().rangeContaining(iter->begin())->value();
															#line 588 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					auto [_, inserted] = deduplicate.insert(modulePtr);
															#line 589 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (inserted)
															#line 2845 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 590 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						writeModulePtrs.push_back(modulePtr);
															#line 2849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 593 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				++iter;
															#line 2854 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 596 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			it = std::vector<SpecialKeyRangeRWImpl*>::const_iterator();
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			it = writeModulePtrs.begin();
															#line 2860 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitActorActorState();
		static_cast<CommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 607 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CommitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorActorState(); static_cast<CommitActorActor*>(this)->destroy(); return 0; }
															#line 2883 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CommitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitActorActorState();
		static_cast<CommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(it != writeModulePtrs.end()))
															#line 2902 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 598 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_0 = (*it)->commit(ryw);
															#line 598 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CommitActorActor*>(this)->actor_wait_state = 1;
															#line 598 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitActorActor, 0, Optional<std::string> >*>(static_cast<CommitActorActor*>(this)));
															#line 2915 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::string> const& msg,int loopDepth) 
	{
															#line 599 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (msg.present())
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(msg.get());
															#line 601 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeySpaceManagementAPIError") .detail("Reason", msg.get()) .detail("Range", (*it)->getKeyRange().toString());
															#line 604 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 2945 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++it;
															#line 2949 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::string> && msg,int loopDepth) 
	{
															#line 599 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (msg.present())
															#line 2958 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(msg.get());
															#line 601 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeySpaceManagementAPIError") .detail("Reason", msg.get()) .detail("Range", (*it)->getKeyRange().toString());
															#line 604 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 2966 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++it;
															#line 2970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::string> const& msg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(msg, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::string> && msg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(msg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitActorActor*>(this)->actor_wait_state > 0) static_cast<CommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActorActor*>(this)->ActorCallback< CommitActorActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 581 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter;
															#line 582 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<SpecialKeyRangeRWImpl*> writeModulePtrs;
															#line 596 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<SpecialKeyRangeRWImpl*>::const_iterator it;
															#line 3062 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitActor()
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CommitActorActor final : public Actor<Void>, public ActorCallback< CommitActorActor, 0, Optional<std::string> >, public FastAllocated<CommitActorActor>, public CommitActorActorState<CommitActorActor> {
															#line 3067 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitActorActor>::operator new;
	using FastAllocated<CommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4762114346587803904UL, 15588296864948963072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitActorActor, 0, Optional<std::string> >;
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CommitActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw) 
															#line 3084 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitActorActorState<CommitActorActor>(sks, ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12544606552870480896UL, 18376267601331500032UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitActorActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> commitActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw ) {
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new CommitActorActor(sks, ryw));
															#line 3117 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 609 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Void> SpecialKeySpace::commit(ReadYourWritesTransaction* ryw) {
	return commitActor(this, ryw);
}

// For SKSCTestRWImpl and SKSCTestAsyncReadImpl
Future<RangeResult> SKSCTestGetRangeBase(ReadYourWritesTransaction* ryw, KeyRangeRef kr, GetRangeLimits limitsHint) {
	auto resultFuture = ryw->getRange(kr, CLIENT_KNOBS->TOO_MANY);
	// all keys are written to RYW, since GRV is set, the read should happen locally
	ASSERT(resultFuture.isReady());
	auto result = resultFuture.getValue();
	ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
	auto kvs = resultFuture.getValue();
	return rywGetRange(ryw, kr, kvs);
}

SKSCTestRWImpl::SKSCTestRWImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> SKSCTestRWImpl::getRange(ReadYourWritesTransaction* ryw,
                                             KeyRangeRef kr,
                                             GetRangeLimits limitsHint) const {
	ASSERT(range.contains(kr));
	return SKSCTestGetRangeBase(ryw, kr, limitsHint);
}

Future<Optional<std::string>> SKSCTestRWImpl::commit(ReadYourWritesTransaction* ryw) {
	ASSERT(false);
	return Optional<std::string>();
}

SKSCTestAsyncReadImpl::SKSCTestAsyncReadImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> SKSCTestAsyncReadImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	ASSERT(range.contains(kr));
	return SKSCTestGetRangeBase(ryw, kr, limitsHint);
}

ReadConflictRangeImpl::ReadConflictRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

															#line 3162 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getReadConflictRangeImpl()
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetReadConflictRangeImplActor>
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetReadConflictRangeImplActorState {
															#line 3169 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetReadConflictRangeImplActorState(ReadYourWritesTransaction* const& ryw,KeyRange const& kr) 
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 3178 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetReadConflictRangeImplActorState() 
	{
		fdb_probe_actor_destroy("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 651 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ryw->pendingReads();
															#line 651 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3195 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state = 1;
															#line 651 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetReadConflictRangeImplActor, 0, Void >*>(static_cast<GetReadConflictRangeImplActor*>(this)));
															#line 3200 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 652 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetReadConflictRangeImplActor*>(this)->SAV<RangeResult>::futures) { (void)(ryw->getReadConflictRangeIntersecting(kr)); this->~GetReadConflictRangeImplActorState(); static_cast<GetReadConflictRangeImplActor*>(this)->destroy(); return 0; }
															#line 3223 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetReadConflictRangeImplActor*>(this)->SAV< RangeResult >::value()) RangeResult(ryw->getReadConflictRangeIntersecting(kr));
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 652 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetReadConflictRangeImplActor*>(this)->SAV<RangeResult>::futures) { (void)(ryw->getReadConflictRangeIntersecting(kr)); this->~GetReadConflictRangeImplActorState(); static_cast<GetReadConflictRangeImplActor*>(this)->destroy(); return 0; }
															#line 3235 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetReadConflictRangeImplActor*>(this)->SAV< RangeResult >::value()) RangeResult(ryw->getReadConflictRangeIntersecting(kr));
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state > 0) static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetReadConflictRangeImplActor*>(this)->ActorCallback< GetReadConflictRangeImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRange kr;
															#line 3322 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getReadConflictRangeImpl()
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetReadConflictRangeImplActor final : public Actor<RangeResult>, public ActorCallback< GetReadConflictRangeImplActor, 0, Void >, public FastAllocated<GetReadConflictRangeImplActor>, public GetReadConflictRangeImplActorState<GetReadConflictRangeImplActor> {
															#line 3327 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetReadConflictRangeImplActor>::operator new;
	using FastAllocated<GetReadConflictRangeImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9336110282604638464UL, 18051281968558219776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetReadConflictRangeImplActor, 0, Void >;
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetReadConflictRangeImplActor(ReadYourWritesTransaction* const& ryw,KeyRange const& kr) 
															#line 3344 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetReadConflictRangeImplActorState<GetReadConflictRangeImplActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16810417646147414272UL, 12854869489784131584UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getReadConflictRangeImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetReadConflictRangeImplActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getReadConflictRangeImpl( ReadYourWritesTransaction* const& ryw, KeyRange const& kr ) {
															#line 650 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetReadConflictRangeImplActor(ryw, kr));
															#line 3377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 654 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> ReadConflictRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	return getReadConflictRangeImpl(ryw, kr);
}

WriteConflictRangeImpl::WriteConflictRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> WriteConflictRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                     KeyRangeRef kr,
                                                     GetRangeLimits limitsHint) const {
	return ryw->getWriteConflictRangeIntersecting(kr);
}

ConflictingKeysImpl::ConflictingKeysImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> ConflictingKeysImpl::getRange(ReadYourWritesTransaction* ryw,
                                                  KeyRangeRef kr,
                                                  GetRangeLimits limitsHint) const {
	RangeResult result;
	if (ryw->getTransactionState()->conflictingKeys) {
		auto krMapPtr = ryw->getTransactionState()->conflictingKeys.get();
		auto beginIter = krMapPtr->rangeContaining(kr.begin);
		auto endIter = krMapPtr->rangeContaining(kr.end);

		if (!kr.contains(beginIter->begin()) && beginIter != endIter)
			++beginIter;
		for (auto it = beginIter; it != endIter; ++it) {
			result.push_back_deep(result.arena(), KeyValueRef(it->begin(), it->value()));
		}
		if (kr.contains(endIter->begin()))
			result.push_back_deep(result.arena(), KeyValueRef(endIter->begin(), endIter->value()));
	}
	return result;
}

															#line 3418 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via ddMetricsGetRangeActor()
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class DdMetricsGetRangeActorActor>
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DdMetricsGetRangeActorActorState {
															#line 3425 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DdMetricsGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 3434 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~DdMetricsGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 692 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 3449 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto keys = kr.removePrefix(ddStatsRange.begin);
															#line 695 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Standalone<VectorRef<DDMetricsRef>>> __when_expr_0 = waitDataDistributionMetricsList(ryw->getDatabase(), keys, CLIENT_KNOBS->TOO_MANY);
															#line 695 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3484 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 695 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*>(static_cast<DdMetricsGetRangeActorActor*>(this)));
															#line 3489 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 712 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			err = Error(e);
															#line 713 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() == error_code_dd_not_found)
															#line 3507 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 714 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				TraceEvent(SevWarnAlways, "DataDistributorNotPresent") .detail("Operation", "DDMetricsReqestThroughSpecialKeys");
															#line 716 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delayJittered(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 716 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3515 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 716 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*>(static_cast<DdMetricsGetRangeActorActor*>(this)));
															#line 3520 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<DDMetricsRef>> const& resultWithoutPrefix,int loopDepth) 
	{
															#line 697 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 698 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& ddMetricsRef : resultWithoutPrefix ) {
															#line 700 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef beginKey = ddMetricsRef.beginKey.withPrefix(ddStatsRange.begin, result.arena());
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			json_spirit::mObject statsObj;
															#line 703 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes"] = ddMetricsRef.shardBytes;
															#line 704 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes_per_ksecond"] = ddMetricsRef.shardBytesPerKSecond;
															#line 705 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string statsString = json_spirit::write_string(json_spirit::mValue(statsObj), json_spirit::Output_options::raw_utf8);
															#line 707 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef bytes(result.arena(), statsString);
															#line 708 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), KeyValueRef(beginKey, bytes));
															#line 3556 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 710 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DdMetricsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~DdMetricsGetRangeActorActorState(); static_cast<DdMetricsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 3560 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<DdMetricsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<DDMetricsRef>> && resultWithoutPrefix,int loopDepth) 
	{
															#line 697 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 698 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& ddMetricsRef : resultWithoutPrefix ) {
															#line 700 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef beginKey = ddMetricsRef.beginKey.withPrefix(ddStatsRange.begin, result.arena());
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			json_spirit::mObject statsObj;
															#line 703 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes"] = ddMetricsRef.shardBytes;
															#line 704 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes_per_ksecond"] = ddMetricsRef.shardBytesPerKSecond;
															#line 705 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string statsString = json_spirit::write_string(json_spirit::mValue(statsObj), json_spirit::Output_options::raw_utf8);
															#line 707 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef bytes(result.arena(), statsString);
															#line 708 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), KeyValueRef(beginKey, bytes));
															#line 3588 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 710 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DdMetricsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~DdMetricsGetRangeActorActorState(); static_cast<DdMetricsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 3592 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<DdMetricsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<DDMetricsRef>> const& resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(resultWithoutPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<DDMetricsRef>> && resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(resultWithoutPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsGetRangeActorActor*>(this)->ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Standalone<VectorRef<DDMetricsRef>> const& value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Standalone<VectorRef<DDMetricsRef>> && value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 719 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3679 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsGetRangeActorActor*>(this)->ActorCallback< DdMetricsGetRangeActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 712 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Error err;
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ddMetricsGetRangeActor()
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DdMetricsGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >, public ActorCallback< DdMetricsGetRangeActorActor, 1, Void >, public FastAllocated<DdMetricsGetRangeActorActor>, public DdMetricsGetRangeActorActorState<DdMetricsGetRangeActorActor> {
															#line 3781 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<DdMetricsGetRangeActorActor>::operator new;
	using FastAllocated<DdMetricsGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6727569935894871808UL, 13975535680725287936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >;
friend struct ActorCallback< DdMetricsGetRangeActorActor, 1, Void >;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DdMetricsGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 3799 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   DdMetricsGetRangeActorActorState<DdMetricsGetRangeActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16840869640598210816UL, 9829802680711520256UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddMetricsGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> ddMetricsGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new DdMetricsGetRangeActorActor(ryw, kr));
															#line 3833 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 723 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

DDStatsRangeImpl::DDStatsRangeImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> DDStatsRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	return ddMetricsGetRangeActor(ryw, kr);
}

Key SpecialKeySpace::getManagementApiCommandOptionSpecialKey(const std::string& command, const std::string& option) {
	Key prefix = "options/"_sr.withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin);
	auto pair = command + "/" + option;
	ASSERT(options.find(pair) != options.end());
	return prefix.withSuffix(pair);
}

ManagementCommandsOptionsImpl::ManagementCommandsOptionsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ManagementCommandsOptionsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                            KeyRangeRef kr,
                                                            GetRangeLimits limitsHint) const {
	RangeResult result;
	// Since we only have limit number of options, a brute force loop here is enough
	for (const auto& option : SpecialKeySpace::getManagementApiOptionsSet()) {
		auto key = getKeyRange().begin.withSuffix(option);
		// ignore all invalid keys
		auto r = ryw->getSpecialKeySpaceWriteMap()[key];
		if (kr.contains(key) && r.first && r.second.present()) {
			result.push_back(result.arena(), KeyValueRef(key, ValueRef()));
			result.arena().dependsOn(key.arena());
		}
	}
	return result;
}

void ManagementCommandsOptionsImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	std::string option = key.removePrefix(getKeyRange().begin).toString();
	// ignore all invalid keys
	if (SpecialKeySpace::getManagementApiOptionsSet().find(option) !=
	    SpecialKeySpace::getManagementApiOptionsSet().end()) {
		TraceEvent(SevDebug, "ManagementApiOption").detail("Option", option).detail("Key", key);
		ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
	}
}

void ManagementCommandsOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->getSpecialKeySpaceWriteMap().rawErase(range);
}

void ManagementCommandsOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	std::string option = key.removePrefix(getKeyRange().begin).toString();
	// ignore all invalid keys
	if (SpecialKeySpace::getManagementApiOptionsSet().find(option) !=
	    SpecialKeySpace::getManagementApiOptionsSet().end()) {
		ryw->getSpecialKeySpaceWriteMap().rawErase(singleKeyRange(key));
	}
}

Future<Optional<std::string>> ManagementCommandsOptionsImpl::commit(ReadYourWritesTransaction* ryw) {
	// Nothing to do, keys should be used by other impls' commit callback
	return Optional<std::string>();
}

RangeResult rywGetRange(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr, const RangeResult& res) {
	// "res" is the read result regardless of your writes, if ryw disabled, return immediately
	if (ryw->readYourWritesDisabled())
		return res;
	// If ryw enabled, we update it with writes from the transaction
	RangeResult result;
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges =
	    ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter = ranges.begin();
	auto iter2 = res.begin();
	result.arena().dependsOn(res.arena());
	while (iter != ranges.end() || iter2 != res.end()) {
		if (iter == ranges.end()) {
			result.push_back(result.arena(), KeyValueRef(iter2->key, iter2->value));
			++iter2;
		} else if (iter2 == res.end()) {
			// insert if it is a set entry
			std::pair<bool, Optional<Value>> entry = iter->value();
			if (entry.first && entry.second.present()) {
				result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
			}
			++iter;
		} else if (iter->range().contains(iter2->key)) {
			std::pair<bool, Optional<Value>> entry = iter->value();
			// if this is a valid range either for set or clear, move iter2 outside the range
			if (entry.first) {
				// insert if this is a set entry
				if (entry.second.present())
					result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
				// move iter2 outside the range
				while (iter2 != res.end() && iter->range().contains(iter2->key))
					++iter2;
			}
			++iter;
		} else if (iter->begin() > iter2->key) {
			result.push_back(result.arena(), KeyValueRef(iter2->key, iter2->value));
			++iter2;
		} else if (iter->end() <= iter2->key) {
			// insert if it is a set entry
			std::pair<bool, Optional<Value>> entry = iter->value();
			if (entry.first && entry.second.present()) {
				result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
			}
			++iter;
		}
	}
	return result;
}

// read from those readwrite modules in which special keys have one-to-one mapping with real persisted keys
															#line 3950 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rwModuleWithMappingGetRangeActor()
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class RwModuleWithMappingGetRangeActorActor>
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class RwModuleWithMappingGetRangeActorActorState {
															#line 3957 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RwModuleWithMappingGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,const SpecialKeyRangeRWImpl* const& impl,KeyRangeRef const& kr) 
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   impl(impl),
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 3968 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~RwModuleWithMappingGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = ryw->getTransaction().getRange(ryw->getDatabase()->specialKeySpace->decode(kr), CLIENT_KNOBS->TOO_MANY);
															#line 839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3985 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*>(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)));
															#line 3990 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& resultWithoutPrefix,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!resultWithoutPrefix.more && resultWithoutPrefix.size() < CLIENT_KNOBS->TOO_MANY);
															#line 842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 843 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const KeyValueRef& kv : resultWithoutPrefix ) {
															#line 844 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(impl->encode(kv.key), kv.value));
															#line 4019 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 845 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~RwModuleWithMappingGetRangeActorActorState(); static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 4023 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && resultWithoutPrefix,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!resultWithoutPrefix.more && resultWithoutPrefix.size() < CLIENT_KNOBS->TOO_MANY);
															#line 842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 843 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const KeyValueRef& kv : resultWithoutPrefix ) {
															#line 844 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(impl->encode(kv.key), kv.value));
															#line 4041 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 845 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~RwModuleWithMappingGetRangeActorActorState(); static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 4045 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(resultWithoutPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resultWithoutPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	const SpecialKeyRangeRWImpl* impl;
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 4134 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rwModuleWithMappingGetRangeActor()
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class RwModuleWithMappingGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >, public FastAllocated<RwModuleWithMappingGetRangeActorActor>, public RwModuleWithMappingGetRangeActorActorState<RwModuleWithMappingGetRangeActorActor> {
															#line 4139 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<RwModuleWithMappingGetRangeActorActor>::operator new;
	using FastAllocated<RwModuleWithMappingGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15580762452995753728UL, 11075432574656119296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >;
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RwModuleWithMappingGetRangeActorActor(ReadYourWritesTransaction* const& ryw,const SpecialKeyRangeRWImpl* const& impl,KeyRangeRef const& kr) 
															#line 4156 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   RwModuleWithMappingGetRangeActorActorState<RwModuleWithMappingGetRangeActorActor>(ryw, impl, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619561100216225280UL, 9781716562600313856UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rwModuleWithMappingGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> rwModuleWithMappingGetRangeActor( ReadYourWritesTransaction* const& ryw, const SpecialKeyRangeRWImpl* const& impl, KeyRangeRef const& kr ) {
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new RwModuleWithMappingGetRangeActorActor(ryw, impl, kr));
															#line 4189 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 847 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExcludeServersRangeImpl::ExcludeServersRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ExcludeServersRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                      KeyRangeRef kr,
                                                      GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void ExcludeServersRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key ExcludeServersRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key ExcludeServersRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

bool parseNetWorkAddrFromKeys(ReadYourWritesTransaction* ryw,
                              bool failed,
                              std::vector<AddressExclusion>& addresses,
                              std::set<AddressExclusion>& exclusions,
                              Optional<std::string>& msg) {
	KeyRangeRef range = failed ? SpecialKeySpace::getManagementApiCommandRange("failed")
	                           : SpecialKeySpace::getManagementApiCommandRange("exclude");
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for exclude(set) operation, include(clear) are not checked
		TraceEvent(SevDebug, "ParseNetworkAddress")
		    .detail("Valid", entry.first)
		    .detail("Set", entry.second.present())
		    .detail("Key", iter->begin().toString());
		if (entry.first && entry.second.present()) {
			Key address = iter->begin().removePrefix(range.begin);
			auto a = AddressExclusion::parse(address);
			if (!a.isValid()) {
				std::string error = "ERROR: \'" + address.toString() + "\' is not a valid network endpoint address\n";
				if (address.toString().find(":tls") != std::string::npos)
					error += "        Do not include the `:tls' suffix when naming a process\n";
				msg = ManagementAPIError::toJsonString(
				    false, entry.second.present() ? (failed ? "exclude failed" : "exclude") : "include", error);
				return false;
			}
			addresses.push_back(a);
			exclusions.insert(a);
		}
		++iter;
	}
	return true;
}

															#line 4253 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkExclusion()
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CheckExclusionActor>
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CheckExclusionActorState {
															#line 4260 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CheckExclusionActorState(Database const& db,std::vector<AddressExclusion> const& addresses,std::set<AddressExclusion> const& exclusions,std::unordered_set<std::string> const& localities,bool const& markFailed,Optional<std::string>* const& msg) 
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : db(db),
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(addresses),
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions(exclusions),
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities(localities),
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   markFailed(markFailed),
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg(msg)
															#line 4277 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkExclusion", reinterpret_cast<unsigned long>(this));

	}
	~CheckExclusionActorState() 
	{
		fdb_probe_actor_destroy("checkExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(db);
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CheckExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4294 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckExclusionActor*>(this)->actor_wait_state = 1;
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckExclusionActor, 0, StatusObject >*>(static_cast<CheckExclusionActor*>(this)));
															#line 4299 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckExclusionActorState();
		static_cast<CheckExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& status,int loopDepth) 
	{
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		errorString = "ERROR: Could not calculate the impact of this exclude on the total available space in the cluster.\n" "Please try the exclude again in 30 seconds.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without checking available " "space.\n";
															#line 920 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObj(status);
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 4328 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 924 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'cluster' missing.\n");
															#line 926 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4334 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 929 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader processesMap;
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObjCluster.get("processes", processesMap))
															#line 4344 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'processes' missing.\n");
															#line 933 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4350 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssTotalCount = 0;
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssExcludedCount = 0;
															#line 939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		diskLocalities = std::unordered_set<std::string>();
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytes = 0;
															#line 941 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytesNotExcluded = 0;
															#line 942 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytes = 0;
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytesNotExcluded = 0;
															#line 944 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreAvailableBytes = 0;
															#line 945 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		parsedLocalities = std::map<std::string, std::vector<std::string>>();
															#line 948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& locality : localities ) {
															#line 949 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<std::string, std::string> locality_key_value = decodeLocality(locality);
															#line 950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (locality_key_value.first == "")
															#line 4380 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 954 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parsedLocalities[locality_key_value.first].push_back(locality_key_value.second);
															#line 4386 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 965 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedAddresses = std::vector<AddressExclusion>();
															#line 966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed && !addresses.empty())
															#line 4392 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			excludedAddresses = addresses;
															#line 4396 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		try {
															#line 971 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto proc : processesMap.obj() ) {
															#line 972 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader process(proc.second);
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader localityObj;
															#line 974 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool hasLocalities = process.get("locality", localityObj);
															#line 976 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool excluded = process.has("excluded") && process.last().get_bool();
															#line 979 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!excluded)
															#line 4411 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 981 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string addrStr;
															#line 982 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!process.get("address", addrStr))
															#line 4417 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 983 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", errorString);
															#line 985 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4423 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckExclusionActorState();
						static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					NetworkAddress addr = NetworkAddress::parse(addrStr);
															#line 988 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					excluded = addressExcluded(exclusions, addr);
															#line 992 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!excluded && hasLocalities && !parsedLocalities.empty())
															#line 4435 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						for( const auto& [localityKey, localityVec] : parsedLocalities ) {
															#line 995 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							std::string localityValue;
															#line 996 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!localityObj.get(localityKey, localityValue))
															#line 4443 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
								continue;
							}
															#line 1002 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (std::find(localityVec.begin(), localityVec.end(), localityValue) != localityVec.end())
															#line 4449 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
															#line 1003 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								excluded = true;
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (markFailed)
															#line 4455 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								{
															#line 1008 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									auto addrExclusion = AddressExclusion(addr.ip, addr.port);
															#line 1009 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									if (std::find(excludedAddresses.begin(), excludedAddresses.end(), addrExclusion) != excludedAddresses.end())
															#line 4461 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
									{
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
										excludedAddresses.push_back(addrExclusion);
															#line 4465 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
									}
								}
								break;
							}
						}
					}
				}
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string disk_id;
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (hasLocalities)
															#line 4477 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					process.get("disk_id", disk_id);
															#line 4481 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
															#line 1026 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusArray rolesArray = proc.second.get_obj()["roles"].get_array();
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for( StatusObjectReader role : rolesArray ) {
															#line 1028 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (role["role"].get_str() == "storage")
															#line 4489 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1029 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ssTotalCount++;
															#line 1030 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (excluded)
															#line 4495 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1031 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ssExcludedCount++;
															#line 4499 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
															#line 1034 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t used_bytes;
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_used_bytes", used_bytes))
															#line 4505 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_used_bytes' missing for storage role.\n");
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4511 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1043 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t free_bytes;
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_free_bytes", free_bytes))
															#line 4521 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_free_bytes' missing for storage role.\n");
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4527 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t available_bytes;
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_available_bytes", available_bytes))
															#line 4537 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_available_bytes' missing for storage role.\n");
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4543 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreUsedBytes += used_bytes;
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreFreeBytes += free_bytes;
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreAvailableBytes += available_bytes;
															#line 1065 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!excluded)
															#line 4557 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1066 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							totalKvStoreUsedBytesNotExcluded += used_bytes;
															#line 1068 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (disk_id.empty() || diskLocalities.find(disk_id) == diskLocalities.end())
															#line 4563 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
															#line 1069 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								totalKvStoreFreeBytesNotExcluded += free_bytes;
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (!disk_id.empty())
															#line 4569 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								{
															#line 1071 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									diskLocalities.insert(disk_id);
															#line 4573 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1cont28(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(StatusObject && status,int loopDepth) 
	{
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		errorString = "ERROR: Could not calculate the impact of this exclude on the total available space in the cluster.\n" "Please try the exclude again in 30 seconds.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without checking available " "space.\n";
															#line 920 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObj(status);
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 4600 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 924 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'cluster' missing.\n");
															#line 926 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4606 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 929 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader processesMap;
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObjCluster.get("processes", processesMap))
															#line 4616 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'processes' missing.\n");
															#line 933 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4622 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssTotalCount = 0;
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssExcludedCount = 0;
															#line 939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		diskLocalities = std::unordered_set<std::string>();
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytes = 0;
															#line 941 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytesNotExcluded = 0;
															#line 942 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytes = 0;
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytesNotExcluded = 0;
															#line 944 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreAvailableBytes = 0;
															#line 945 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		parsedLocalities = std::map<std::string, std::vector<std::string>>();
															#line 948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& locality : localities ) {
															#line 949 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<std::string, std::string> locality_key_value = decodeLocality(locality);
															#line 950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (locality_key_value.first == "")
															#line 4652 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 954 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parsedLocalities[locality_key_value.first].push_back(locality_key_value.second);
															#line 4658 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 965 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedAddresses = std::vector<AddressExclusion>();
															#line 966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed && !addresses.empty())
															#line 4664 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			excludedAddresses = addresses;
															#line 4668 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		try {
															#line 971 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto proc : processesMap.obj() ) {
															#line 972 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader process(proc.second);
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader localityObj;
															#line 974 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool hasLocalities = process.get("locality", localityObj);
															#line 976 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool excluded = process.has("excluded") && process.last().get_bool();
															#line 979 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!excluded)
															#line 4683 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 981 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string addrStr;
															#line 982 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!process.get("address", addrStr))
															#line 4689 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 983 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", errorString);
															#line 985 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4695 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckExclusionActorState();
						static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					NetworkAddress addr = NetworkAddress::parse(addrStr);
															#line 988 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					excluded = addressExcluded(exclusions, addr);
															#line 992 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!excluded && hasLocalities && !parsedLocalities.empty())
															#line 4707 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						for( const auto& [localityKey, localityVec] : parsedLocalities ) {
															#line 995 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							std::string localityValue;
															#line 996 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!localityObj.get(localityKey, localityValue))
															#line 4715 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
								continue;
							}
															#line 1002 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (std::find(localityVec.begin(), localityVec.end(), localityValue) != localityVec.end())
															#line 4721 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
															#line 1003 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								excluded = true;
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (markFailed)
															#line 4727 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								{
															#line 1008 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									auto addrExclusion = AddressExclusion(addr.ip, addr.port);
															#line 1009 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									if (std::find(excludedAddresses.begin(), excludedAddresses.end(), addrExclusion) != excludedAddresses.end())
															#line 4733 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
									{
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
										excludedAddresses.push_back(addrExclusion);
															#line 4737 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
									}
								}
								break;
							}
						}
					}
				}
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string disk_id;
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (hasLocalities)
															#line 4749 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					process.get("disk_id", disk_id);
															#line 4753 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
															#line 1026 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusArray rolesArray = proc.second.get_obj()["roles"].get_array();
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for( StatusObjectReader role : rolesArray ) {
															#line 1028 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (role["role"].get_str() == "storage")
															#line 4761 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1029 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ssTotalCount++;
															#line 1030 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (excluded)
															#line 4767 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1031 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ssExcludedCount++;
															#line 4771 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
															#line 1034 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t used_bytes;
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_used_bytes", used_bytes))
															#line 4777 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_used_bytes' missing for storage role.\n");
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4783 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1043 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t free_bytes;
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_free_bytes", free_bytes))
															#line 4793 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_free_bytes' missing for storage role.\n");
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4799 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t available_bytes;
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_available_bytes", available_bytes))
															#line 4809 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_available_bytes' missing for storage role.\n");
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4815 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreUsedBytes += used_bytes;
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreFreeBytes += free_bytes;
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreAvailableBytes += available_bytes;
															#line 1065 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!excluded)
															#line 4829 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1066 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							totalKvStoreUsedBytesNotExcluded += used_bytes;
															#line 1068 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (disk_id.empty() || diskLocalities.find(disk_id) == diskLocalities.end())
															#line 4835 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
							{
															#line 1069 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								totalKvStoreFreeBytesNotExcluded += free_bytes;
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (!disk_id.empty())
															#line 4841 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								{
															#line 1071 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									diskLocalities.insert(disk_id);
															#line 4845 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1cont28(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(StatusObject const& status,int loopDepth) 
	{
		loopDepth = a_body1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && status,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckExclusionActor*>(this)->actor_wait_state > 0) static_cast<CheckExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckExclusionActor*>(this)->ActorCallback< CheckExclusionActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckExclusionActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1090 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ssExcludedCount > 0)
															#line 4941 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			double finalUnavailableRatio = (double)(totalKvStoreUsedBytes + totalKvStoreFreeBytes - totalKvStoreAvailableBytes) / std::max((double)(totalKvStoreUsedBytesNotExcluded + totalKvStoreFreeBytesNotExcluded), (double)1);
															#line 1099 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevInfo, "CheckExclusionDetails") .detail("SsTotalCount", ssTotalCount) .detail("SsExcludedCount", ssExcludedCount) .detail("FinalUnavailableRatio", finalUnavailableRatio) .detail("TotalKvStoreUsedBytes", totalKvStoreUsedBytes) .detail("TotalKvStoreFreeBytes", totalKvStoreFreeBytes) .detail("TotalKvStoreAvailableBytes", totalKvStoreAvailableBytes) .detail("TotalKvStoreUsedBytesNotExcluded", totalKvStoreUsedBytesNotExcluded) .detail("TotalKvStoreFreeBytesNotExcluded", totalKvStoreFreeBytesNotExcluded);
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ssExcludedCount == ssTotalCount || finalUnavailableRatio > 0.9)
															#line 4949 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string temp = "ERROR: This exclude may cause the total available space in the cluster to drop below 10%.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without " "checking available space.\n";
															#line 1114 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", temp);
															#line 1115 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4957 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckExclusionActorState();
				static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed)
															#line 4966 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1120 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			safe = bool();
															#line 4970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			try {
															#line 1122 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_1 = checkSafeExclusions(db, addresses);
															#line 1122 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<CheckExclusionActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4976 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<CheckExclusionActor*>(this)->actor_wait_state = 2;
															#line 1122 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckExclusionActor, 1, bool >*>(static_cast<CheckExclusionActor*>(this)));
															#line 4981 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont29(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "General exception raised.\n");
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5004 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont28(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont29(int loopDepth) 
	{
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5035 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckExclusionActorState();
		static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont32(int loopDepth) 
	{
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5047 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string temp = "ERROR: It is unsafe to exclude the specified servers at this time.\n" "Please check that this exclusion does not bring down an entire storage team.\n" "Please also ensure that the exclusion will keep a majority of coordinators alive.\n" "You may add more storage processes or coordinators to make the operation safe.\n" "Call set(\"0xff0xff/management/failed/<ADDRESS...>\", ...) to exclude without " "performing safety checks.\n";
															#line 1137 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", temp);
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5055 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont29(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1125 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5070 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1126 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5074 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1127 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent("CheckSafeExclusionsError").error(e);
															#line 1128 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			safe = false;
															#line 5080 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1cont32(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont33(bool const& _safe,int loopDepth) 
	{
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		safe = _safe;
															#line 5095 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont33cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont33(bool && _safe,int loopDepth) 
	{
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		safe = _safe;
															#line 5104 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont33cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool const& _safe,int loopDepth) 
	{
		loopDepth = a_body1cont33(_safe, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && _safe,int loopDepth) 
	{
		loopDepth = a_body1cont33(std::move(_safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckExclusionActor*>(this)->actor_wait_state > 0) static_cast<CheckExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckExclusionActor*>(this)->ActorCallback< CheckExclusionActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckExclusionActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont33cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont32(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Database db;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool markFailed;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string>* msg;
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::string errorString;
															#line 936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int ssTotalCount;
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int ssExcludedCount;
															#line 939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> diskLocalities;
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreFreeBytes;
															#line 941 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreFreeBytesNotExcluded;
															#line 942 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreUsedBytes;
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreUsedBytesNotExcluded;
															#line 944 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreAvailableBytes;
															#line 945 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::map<std::string, std::vector<std::string>> parsedLocalities;
															#line 965 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> excludedAddresses;
															#line 1120 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool safe;
															#line 5233 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkExclusion()
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CheckExclusionActor final : public Actor<bool>, public ActorCallback< CheckExclusionActor, 0, StatusObject >, public ActorCallback< CheckExclusionActor, 1, bool >, public FastAllocated<CheckExclusionActor>, public CheckExclusionActorState<CheckExclusionActor> {
															#line 5238 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckExclusionActor>::operator new;
	using FastAllocated<CheckExclusionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13378740179824476416UL, 15814667647617159424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckExclusionActor, 0, StatusObject >;
friend struct ActorCallback< CheckExclusionActor, 1, bool >;
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CheckExclusionActor(Database const& db,std::vector<AddressExclusion> const& addresses,std::set<AddressExclusion> const& exclusions,std::unordered_set<std::string> const& localities,bool const& markFailed,Optional<std::string>* const& msg) 
															#line 5256 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckExclusionActorState<CheckExclusionActor>(db, addresses, exclusions, localities, markFailed, msg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6176846843304675328UL, 17798302181591411200UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkExclusion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckExclusionActor, 0, StatusObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckExclusionActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<bool> checkExclusion( Database const& db, std::vector<AddressExclusion> const& addresses, std::set<AddressExclusion> const& exclusions, std::unordered_set<std::string> const& localities, bool const& markFailed, Optional<std::string>* const& msg ) {
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<bool>(new CheckExclusionActor(db, addresses, exclusions, localities, markFailed, msg));
															#line 5290 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1144 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

void includeServers(ReadYourWritesTransaction* ryw) {
	ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	// includeServers might be used in an emergency transaction, so make sure it is retry-self-conflicting and
	// CAUSAL_WRITE_RISKY
	ryw->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
	std::string versionKey = deterministicRandom()->randomUniqueID().toString();
	// for excluded servers
	auto ranges =
	    ryw->getSpecialKeySpaceWriteMap().containedRanges(SpecialKeySpace::getManagementApiCommandRange("exclude"));
	auto iter = ranges.begin();
	Transaction& tr = ryw->getTransaction();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(excludedServersVersionKey));
			tr.set(excludedServersVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter->range()));
		}
		++iter;
	}
	// for failed servers
	ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(SpecialKeySpace::getManagementApiCommandRange("failed"));
	iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(failedServersVersionKey));
			tr.set(failedServersVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter->range()));
		}
		++iter;
	}
}

															#line 5332 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via excludeCommitActor()
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExcludeCommitActorActor>
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeCommitActorActorState {
															#line 5339 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeCommitActorActorState(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   failed(failed),
															#line 1184 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 1185 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(),
															#line 1186 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions(),
															#line 1187 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities()
															#line 5356 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("excludeCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeCommitActorActorState() 
	{
		fdb_probe_actor_destroy("excludeCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1189 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!parseNetWorkAddrFromKeys(ryw, failed, addresses, exclusions, result))
															#line 5371 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1190 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5375 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
				this->~ExcludeCommitActorActorState();
				static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1192 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto force = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( failed ? "failed" : "excluded", "force")];
															#line 1195 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.size() && !(force.first && force.second.present()))
															#line 5385 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1196 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_0 = checkExclusion(ryw->getDatabase(), addresses, exclusions, localities, failed, &result);
															#line 1196 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5391 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1196 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommitActorActor, 0, bool >*>(static_cast<ExcludeCommitActorActor*>(this)));
															#line 5396 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1200 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = excludeServers(&(ryw->getTransaction()), addresses, failed);
															#line 1200 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5426 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 2;
															#line 1200 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommitActorActor, 1, Void >*>(static_cast<ExcludeCommitActorActor*>(this)));
															#line 5431 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& safe,int loopDepth) 
	{
															#line 1197 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5440 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1198 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5444 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeCommitActorActorState();
			static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && safe,int loopDepth) 
	{
															#line 1197 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5458 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1198 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5462 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeCommitActorActorState();
			static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(safe, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommitActorActor*>(this)->ActorCallback< ExcludeCommitActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeCommitActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeServers(ryw);
															#line 1203 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeServers(ryw);
															#line 1203 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5567 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommitActorActor*>(this)->ActorCallback< ExcludeCommitActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool failed;
															#line 1184 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> result;
															#line 1185 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 1186 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 1187 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 5662 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via excludeCommitActor()
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ExcludeCommitActorActor, 0, bool >, public ActorCallback< ExcludeCommitActorActor, 1, Void >, public FastAllocated<ExcludeCommitActorActor>, public ExcludeCommitActorActorState<ExcludeCommitActorActor> {
															#line 5667 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExcludeCommitActorActor>::operator new;
	using FastAllocated<ExcludeCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5480070699935081728UL, 13072329261964528640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeCommitActorActor, 0, bool >;
friend struct ActorCallback< ExcludeCommitActorActor, 1, Void >;
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeCommitActorActor(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 5685 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   ExcludeCommitActorActorState<ExcludeCommitActorActor>(ryw, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7997247617364751360UL, 12542231733836832256UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeCommitActorActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeCommitActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> excludeCommitActor( ReadYourWritesTransaction* const& ryw, bool const& failed ) {
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ExcludeCommitActorActor(ryw, failed));
															#line 5719 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1205 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> ExcludeServersRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	return excludeCommitActor(ryw, false);
}

FailedServersRangeImpl::FailedServersRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> FailedServersRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                     KeyRangeRef kr,
                                                     GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void FailedServersRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key FailedServersRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key FailedServersRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> FailedServersRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	return excludeCommitActor(ryw, true);
}

															#line 5756 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via ExclusionInProgressActor()
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExclusionInProgressActorActor>
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExclusionInProgressActorActorState {
															#line 5763 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExclusionInProgressActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1239 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 5778 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this));

	}
	~ExclusionInProgressActorActorState() 
	{
		fdb_probe_actor_destroy("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1241 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1242 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1243 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1245 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fExclusions = getAllExcludedServers(&tr);
															#line 1246 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fExcludedLocalities = getAllExcludedLocalities(&tr);
															#line 1247 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fServerList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1248 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fLogsKey = tr.get(logsKey);
															#line 1249 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fExclusions) && success(fExcludedLocalities) && success(fServerList);
															#line 1249 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5809 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 1;
															#line 1249 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 0, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 5814 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1251 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excl = fExclusions.get();
															#line 1252 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		exclusions = std::set<AddressExclusion>(excl.begin(), excl.end());
															#line 1253 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		inProgressExclusion = std::set<NetworkAddress>();
															#line 1256 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		serverList = fServerList.get();
															#line 1257 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1261 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedLocalities = fExcludedLocalities.get();
															#line 1263 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 1264 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& excludedLocality : excludedLocalities ) {
															#line 1265 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			decodedExcludedLocalities.push_back(decodeLocality(excludedLocality));
															#line 5853 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1268 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& s : serverList ) {
															#line 1269 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto decodedServer = decodeServerListValue(s.value);
															#line 1270 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 1271 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addressExcluded(exclusions, addresses.address))
															#line 5863 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1272 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 5867 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1275 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.secondaryAddress.present() && addressExcluded(exclusions, addresses.secondaryAddress.get()))
															#line 5871 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5875 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1280 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 1281 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 5881 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 5887 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 1290 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 5895 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1291 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5899 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(fLogsKey);
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5907 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 2;
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 1, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 5912 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1251 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excl = fExclusions.get();
															#line 1252 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		exclusions = std::set<AddressExclusion>(excl.begin(), excl.end());
															#line 1253 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		inProgressExclusion = std::set<NetworkAddress>();
															#line 1256 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		serverList = fServerList.get();
															#line 1257 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1261 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedLocalities = fExcludedLocalities.get();
															#line 1263 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 1264 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& excludedLocality : excludedLocalities ) {
															#line 1265 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			decodedExcludedLocalities.push_back(decodeLocality(excludedLocality));
															#line 5937 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1268 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& s : serverList ) {
															#line 1269 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto decodedServer = decodeServerListValue(s.value);
															#line 1270 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 1271 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addressExcluded(exclusions, addresses.address))
															#line 5947 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1272 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 5951 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1275 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.secondaryAddress.present() && addressExcluded(exclusions, addresses.secondaryAddress.get()))
															#line 5955 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5959 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1280 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 1281 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 5965 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 5971 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 1290 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 5979 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1291 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5983 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(fLogsKey);
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5991 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 2;
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 1, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 5996 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state > 0) static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExclusionInProgressActorActor*>(this)->ActorCallback< ExclusionInProgressActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1297 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<Standalone<StringRef>> value = fLogsKey.get();
															#line 1298 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(value.present());
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6088 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6092 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1308 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.second ) {
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6099 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1310 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6103 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1315 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::set<std::string> inProgressAddresses;
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressExclusion ) {
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			inProgressAddresses.insert(formatIpPort(address.ip, address.port));
															#line 6112 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressAddresses ) {
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key addrKey = prefix.withSuffix(address);
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(addrKey))
															#line 6120 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1323 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(addrKey, ValueRef()));
															#line 1324 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(addrKey.arena());
															#line 6126 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1328 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExclusionInProgressActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ExclusionInProgressActorActorState(); static_cast<ExclusionInProgressActorActor*>(this)->destroy(); return 0; }
															#line 6131 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExclusionInProgressActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1297 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<Standalone<StringRef>> value = fLogsKey.get();
															#line 1298 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(value.present());
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6151 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1305 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6155 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1308 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.second ) {
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6162 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1310 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6166 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1315 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::set<std::string> inProgressAddresses;
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressExclusion ) {
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			inProgressAddresses.insert(formatIpPort(address.ip, address.port));
															#line 6175 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressAddresses ) {
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key addrKey = prefix.withSuffix(address);
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(addrKey))
															#line 6183 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1323 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(addrKey, ValueRef()));
															#line 1324 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(addrKey.arena());
															#line 6189 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1328 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExclusionInProgressActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ExclusionInProgressActorActorState(); static_cast<ExclusionInProgressActorActor*>(this)->destroy(); return 0; }
															#line 6194 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExclusionInProgressActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state > 0) static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExclusionInProgressActorActor*>(this)->ActorCallback< ExclusionInProgressActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1239 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1245 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<std::vector<AddressExclusion>> fExclusions;
															#line 1246 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<std::vector<std::string>> fExcludedLocalities;
															#line 1247 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<RangeResult> fServerList;
															#line 1248 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<Optional<Standalone<StringRef>>> fLogsKey;
															#line 1251 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> excl;
															#line 1252 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 1253 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<NetworkAddress> inProgressExclusion;
															#line 1256 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult serverList;
															#line 1261 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::string> excludedLocalities;
															#line 1263 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::pair<std::string, std::string>> decodedExcludedLocalities;
															#line 6307 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ExclusionInProgressActor()
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExclusionInProgressActorActor final : public Actor<RangeResult>, public ActorCallback< ExclusionInProgressActorActor, 0, Void >, public ActorCallback< ExclusionInProgressActorActor, 1, Void >, public FastAllocated<ExclusionInProgressActorActor>, public ExclusionInProgressActorActorState<ExclusionInProgressActorActor> {
															#line 6312 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExclusionInProgressActorActor>::operator new;
	using FastAllocated<ExclusionInProgressActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6713743683094953984UL, 7526823812967529216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExclusionInProgressActorActor, 0, Void >;
friend struct ActorCallback< ExclusionInProgressActorActor, 1, Void >;
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExclusionInProgressActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 6330 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   ExclusionInProgressActorActorState<ExclusionInProgressActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10733041304823415808UL, 1142347301358771456UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ExclusionInProgressActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExclusionInProgressActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExclusionInProgressActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> ExclusionInProgressActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1238 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new ExclusionInProgressActorActor(ryw, prefix, kr));
															#line 6364 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1330 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExclusionInProgressRangeImpl::ExclusionInProgressRangeImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> ExclusionInProgressRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                           KeyRangeRef kr,
                                                           GetRangeLimits limitsHint) const {
	return ExclusionInProgressActor(ryw, getKeyRange().begin, kr);
}

															#line 6377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getProcessClassActor()
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetProcessClassActorActor>
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassActorActorState {
															#line 6384 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 6395 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getProcessClassActor", reinterpret_cast<unsigned long>(this));

	}
	~GetProcessClassActorActorState() 
	{
		fdb_probe_actor_destroy("getProcessClassActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1340 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1341 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1341 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetProcessClassActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6414 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetProcessClassActorActor*>(this)->actor_wait_state = 1;
															#line 1341 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*>(static_cast<GetProcessClassActorActor*>(this)));
															#line 6419 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
															#line 1342 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1344 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1352 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1353 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1354 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1356 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port), result.arena()));
															#line 1357 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 6456 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1358 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef v(result.arena(), w.processClass.toString());
															#line 1359 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 6462 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1362 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~GetProcessClassActorActorState(); static_cast<GetProcessClassActorActor*>(this)->destroy(); return 0; }
															#line 6467 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetProcessClassActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
															#line 1342 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1344 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1352 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1353 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1354 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1356 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port), result.arena()));
															#line 1357 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 6493 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1358 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef v(result.arena(), w.processClass.toString());
															#line 1359 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 6499 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1362 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~GetProcessClassActorActorState(); static_cast<GetProcessClassActorActor*>(this)->destroy(); return 0; }
															#line 6504 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetProcessClassActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetProcessClassActorActor*>(this)->actor_wait_state > 0) static_cast<GetProcessClassActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetProcessClassActorActor*>(this)->ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 6593 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getProcessClassActor()
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassActorActor final : public Actor<RangeResult>, public ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >, public FastAllocated<GetProcessClassActorActor>, public GetProcessClassActorActorState<GetProcessClassActorActor> {
															#line 6598 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetProcessClassActorActor>::operator new;
	using FastAllocated<GetProcessClassActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6463974033499493120UL, 2809630896374033408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >;
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 6615 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetProcessClassActorActorState<GetProcessClassActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17035494225643581952UL, 4137256890976619776UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProcessClassActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getProcessClassActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1339 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetProcessClassActorActor(ryw, prefix, kr));
															#line 6648 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1364 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 6653 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via processClassCommitActor()
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ProcessClassCommitActorActor>
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ProcessClassCommitActorActorState {
															#line 6660 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessClassCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& range) 
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   range(range)
															#line 6669 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processClassCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ProcessClassCommitActorActorState() 
	{
		fdb_probe_actor_destroy("processClassCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1367 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1368 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1369 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 1370 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6694 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1371 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*>(static_cast<ProcessClassCommitActorActor*>(this)));
															#line 6699 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 1374 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
															#line 1375 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto iter = ranges.begin();
															#line 1376 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1377 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = iter->value();
															#line 1379 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first && entry.second.present())
															#line 6730 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key address = iter->begin().removePrefix(range.begin);
															#line 1382 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				AddressExclusion addr = AddressExclusion::parse(address);
															#line 1384 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef processClassType = entry.second.get();
															#line 1385 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
															#line 1387 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool foundChange = false;
															#line 1388 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for(int i = 0;i < workers.size();i++) {
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (addr.excludes(workers[i].address))
															#line 6746 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1390 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (processClass.classType() != ProcessClass::InvalidClass)
															#line 6750 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1391 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().set(processClassKeyFor(workers[i].locality.processId().get()), processClassValue(processClass));
															#line 6754 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().clear(processClassKeyFor(workers[i].locality.processId().get()));
															#line 6760 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
															#line 1395 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						foundChange = true;
															#line 6764 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 1398 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (foundChange)
															#line 6769 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1399 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 6773 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 1401 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 6778 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1403 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ProcessClassCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ProcessClassCommitActorActorState(); static_cast<ProcessClassCommitActorActor*>(this)->destroy(); return 0; }
															#line 6782 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ProcessClassCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 1374 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
															#line 1375 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto iter = ranges.begin();
															#line 1376 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1377 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = iter->value();
															#line 1379 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first && entry.second.present())
															#line 6802 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key address = iter->begin().removePrefix(range.begin);
															#line 1382 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				AddressExclusion addr = AddressExclusion::parse(address);
															#line 1384 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef processClassType = entry.second.get();
															#line 1385 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
															#line 1387 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool foundChange = false;
															#line 1388 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for(int i = 0;i < workers.size();i++) {
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (addr.excludes(workers[i].address))
															#line 6818 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1390 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (processClass.classType() != ProcessClass::InvalidClass)
															#line 6822 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 1391 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().set(processClassKeyFor(workers[i].locality.processId().get()), processClassValue(processClass));
															#line 6826 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().clear(processClassKeyFor(workers[i].locality.processId().get()));
															#line 6832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
															#line 1395 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						foundChange = true;
															#line 6836 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 1398 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (foundChange)
															#line 6841 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1399 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 6845 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 1401 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 6850 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1403 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ProcessClassCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ProcessClassCommitActorActorState(); static_cast<ProcessClassCommitActorActor*>(this)->destroy(); return 0; }
															#line 6854 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ProcessClassCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessClassCommitActorActor*>(this)->ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef range;
															#line 6941 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processClassCommitActor()
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ProcessClassCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >, public FastAllocated<ProcessClassCommitActorActor>, public ProcessClassCommitActorActorState<ProcessClassCommitActorActor> {
															#line 6946 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessClassCommitActorActor>::operator new;
	using FastAllocated<ProcessClassCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15763286123816615424UL, 1941161665051436288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >;
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessClassCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& range) 
															#line 6963 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   ProcessClassCommitActorActorState<ProcessClassCommitActorActor>(ryw, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6201390959570557184UL, 15133764612521489664UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processClassCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> processClassCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& range ) {
															#line 1365 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ProcessClassCommitActorActor(ryw, range));
															#line 6996 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ProcessClassRangeImpl::ProcessClassRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ProcessClassRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	return getProcessClassActor(ryw, getKeyRange().begin, kr);
}

Future<Optional<std::string>> ProcessClassRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// Validate network address and process class type
	Optional<std::string> errorMsg;
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(getKeyRange());
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for setclass(set) operation, (clear) are forbidden thus not exist
		if (entry.first && entry.second.present()) {
			// validate network address
			Key address = iter->begin().removePrefix(range.begin);
			AddressExclusion addr = AddressExclusion::parse(address);
			if (!addr.isValid()) {
				std::string error = "ERROR: \'" + address.toString() + "\' is not a valid network endpoint address\n";
				if (address.toString().find(":tls") != std::string::npos)
					error += "        Do not include the `:tls' suffix when naming a process\n";
				errorMsg = ManagementAPIError::toJsonString(false, "setclass", error);
				return errorMsg;
			}
			// validate class type
			ValueRef processClassType = entry.second.get();
			ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
			if (processClass.classType() == ProcessClass::InvalidClass && processClassType != "default"_sr) {
				std::string error = "ERROR: \'" + processClassType.toString() + "\' is not a valid process class\n";
				errorMsg = ManagementAPIError::toJsonString(false, "setclass", error);
				return errorMsg;
			}
		}
		++iter;
	}
	return processClassCommitActor(ryw, getKeyRange());
}

void throwSpecialKeyApiFailure(ReadYourWritesTransaction* ryw, std::string command, std::string message) {
	auto msg = ManagementAPIError::toJsonString(false, command, message);
	ryw->setSpecialKeySpaceErrorMsg(msg);
	throw special_keys_api_failure();
}

void ProcessClassRangeImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(ryw, "setclass", "Clear operation is meaningless thus forbidden for setclass");
}

void ProcessClassRangeImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw, "setclass", "Clear range operation is meaningless thus forbidden for setclass");
}

															#line 7057 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getProcessClassSourceActor()
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetProcessClassSourceActorActor>
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassSourceActorActorState {
															#line 7064 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassSourceActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 7075 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this));

	}
	~GetProcessClassSourceActorActorState() 
	{
		fdb_probe_actor_destroy("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1463 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1464 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1464 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7094 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state = 1;
															#line 1464 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*>(static_cast<GetProcessClassSourceActorActor*>(this)));
															#line 7099 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
															#line 1465 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1471 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1475 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1476 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1477 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1479 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port)));
															#line 1480 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 7136 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1481 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Value v(w.processClass.sourceString());
															#line 1482 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 1483 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(k.arena());
															#line 1484 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(v.arena());
															#line 7146 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1487 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassSourceActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetProcessClassSourceActorActorState(); static_cast<GetProcessClassSourceActorActor*>(this)->destroy(); return 0; }
															#line 7151 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetProcessClassSourceActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
															#line 1465 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1471 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1475 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1476 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1477 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1479 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port)));
															#line 1480 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 7177 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1481 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Value v(w.processClass.sourceString());
															#line 1482 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 1483 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(k.arena());
															#line 1484 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(v.arena());
															#line 7187 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1487 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassSourceActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetProcessClassSourceActorActorState(); static_cast<GetProcessClassSourceActorActor*>(this)->destroy(); return 0; }
															#line 7192 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetProcessClassSourceActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state > 0) static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetProcessClassSourceActorActor*>(this)->ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 7281 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getProcessClassSourceActor()
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassSourceActorActor final : public Actor<RangeResult>, public ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >, public FastAllocated<GetProcessClassSourceActorActor>, public GetProcessClassSourceActorActorState<GetProcessClassSourceActorActor> {
															#line 7286 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetProcessClassSourceActorActor>::operator new;
	using FastAllocated<GetProcessClassSourceActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7889184346472750080UL, 114586533302367232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >;
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassSourceActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 7303 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetProcessClassSourceActorActorState<GetProcessClassSourceActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2541792583674743040UL, 11696546713018679040UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProcessClassSourceActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getProcessClassSourceActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetProcessClassSourceActorActor(ryw, prefix, kr));
															#line 7336 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1489 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ProcessClassSourceRangeImpl::ProcessClassSourceRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> ProcessClassSourceRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                          KeyRangeRef kr,
                                                          GetRangeLimits limitsHint) const {
	return getProcessClassSourceActor(ryw, getKeyRange().begin, kr);
}

															#line 7349 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getLockedKeyActor()
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetLockedKeyActorActor>
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetLockedKeyActorActorState {
															#line 7356 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetLockedKeyActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 7365 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getLockedKeyActor", reinterpret_cast<unsigned long>(this));

	}
	~GetLockedKeyActorActorState() 
	{
		fdb_probe_actor_destroy("getLockedKeyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1499 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1500 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1501 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1501 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7386 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state = 1;
															#line 1501 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*>(static_cast<GetLockedKeyActorActor*>(this)));
															#line 7391 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1503 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7416 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1504 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			UID uid = UID::fromString(BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()).toString());
															#line 1505 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, Value(uid.toString())));
															#line 7422 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1507 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetLockedKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetLockedKeyActorActorState(); static_cast<GetLockedKeyActorActor*>(this)->destroy(); return 0; }
															#line 7426 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetLockedKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1503 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7440 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1504 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			UID uid = UID::fromString(BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()).toString());
															#line 1505 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, Value(uid.toString())));
															#line 7446 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1507 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetLockedKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetLockedKeyActorActorState(); static_cast<GetLockedKeyActorActor*>(this)->destroy(); return 0; }
															#line 7450 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetLockedKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetLockedKeyActorActor*>(this)->ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 7537 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getLockedKeyActor()
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetLockedKeyActorActor final : public Actor<RangeResult>, public ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >, public FastAllocated<GetLockedKeyActorActor>, public GetLockedKeyActorActorState<GetLockedKeyActorActor> {
															#line 7542 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetLockedKeyActorActor>::operator new;
	using FastAllocated<GetLockedKeyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5373462457906724864UL, 17510059369561406208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >;
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetLockedKeyActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 7559 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetLockedKeyActorActorState<GetLockedKeyActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1065936102906652160UL, 2992215969153277440UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLockedKeyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getLockedKeyActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1498 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetLockedKeyActorActor(ryw, kr));
															#line 7592 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1509 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

LockDatabaseImpl::LockDatabaseImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> LockDatabaseImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto lockEntry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("lock")];
	if (!ryw->readYourWritesDisabled() && lockEntry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (lockEntry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, lockEntry.second.get()));
		}
		return result;
	} else {
		return getLockedKeyActor(ryw, kr);
	}
}

															#line 7617 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via lockDatabaseCommitActor()
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class LockDatabaseCommitActorActor>
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class LockDatabaseCommitActorActorState {
															#line 7624 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	LockDatabaseCommitActorActorState(ReadYourWritesTransaction* const& ryw,UID const& uid) 
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   uid(uid),
															#line 1531 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg()
															#line 7635 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~LockDatabaseCommitActorActorState() 
	{
		fdb_probe_actor_destroy("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1532 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7656 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*>(static_cast<LockDatabaseCommitActorActor*>(this)));
															#line 7661 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present() && BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()) != uid)
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1539 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(database_locked(), loopDepth);
															#line 7688 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!val.present())
															#line 7694 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1542 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().atomicOp( databaseLockedKey, BinaryWriter::toValue(uid, Unversioned()).withPrefix("0123456789"_sr).withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().addWriteConflictRange(normalKeys);
															#line 7700 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1549 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<LockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~LockDatabaseCommitActorActorState(); static_cast<LockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7705 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<LockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present() && BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()) != uid)
															#line 7717 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1539 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(database_locked(), loopDepth);
															#line 7721 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!val.present())
															#line 7727 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1542 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().atomicOp( databaseLockedKey, BinaryWriter::toValue(uid, Unversioned()).withPrefix("0123456789"_sr).withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().addWriteConflictRange(normalKeys);
															#line 7733 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1549 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<LockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~LockDatabaseCommitActorActorState(); static_cast<LockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7738 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<LockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state > 0) static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockDatabaseCommitActorActor*>(this)->ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UID uid;
															#line 1531 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> msg;
															#line 7827 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via lockDatabaseCommitActor()
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class LockDatabaseCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >, public FastAllocated<LockDatabaseCommitActorActor>, public LockDatabaseCommitActorActorState<LockDatabaseCommitActorActor> {
															#line 7832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<LockDatabaseCommitActorActor>::operator new;
	using FastAllocated<LockDatabaseCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13993445350646009088UL, 14420775956693714432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >;
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	LockDatabaseCommitActorActor(ReadYourWritesTransaction* const& ryw,UID const& uid) 
															#line 7849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   LockDatabaseCommitActorActorState<LockDatabaseCommitActorActor>(ryw, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(126074855386773248UL, 15412498777109478144UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockDatabaseCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> lockDatabaseCommitActor( ReadYourWritesTransaction* const& ryw, UID const& uid ) {
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new LockDatabaseCommitActorActor(ryw, uid));
															#line 7882 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1551 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 7887 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via unlockDatabaseCommitActor()
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class UnlockDatabaseCommitActorActor>
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class UnlockDatabaseCommitActorActorState {
															#line 7894 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UnlockDatabaseCommitActorActorState(ReadYourWritesTransaction* const& ryw) 
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw)
															#line 7901 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~UnlockDatabaseCommitActorActorState() 
	{
		fdb_probe_actor_destroy("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1554 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7922 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*>(static_cast<UnlockDatabaseCommitActorActor*>(this)));
															#line 7927 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1556 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7950 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1557 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().clear(singleKeyRange(databaseLockedKey));
															#line 7954 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1559 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~UnlockDatabaseCommitActorActorState(); static_cast<UnlockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7958 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1556 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1557 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().clear(singleKeyRange(databaseLockedKey));
															#line 7974 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1559 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~UnlockDatabaseCommitActorActorState(); static_cast<UnlockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7978 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseCommitActorActor*>(this)->ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 8063 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via unlockDatabaseCommitActor()
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class UnlockDatabaseCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >, public FastAllocated<UnlockDatabaseCommitActorActor>, public UnlockDatabaseCommitActorActorState<UnlockDatabaseCommitActorActor> {
															#line 8068 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<UnlockDatabaseCommitActorActor>::operator new;
	using FastAllocated<UnlockDatabaseCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16830256224172717056UL, 14633654756727415808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >;
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UnlockDatabaseCommitActorActor(ReadYourWritesTransaction* const& ryw) 
															#line 8085 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   UnlockDatabaseCommitActorActorState<UnlockDatabaseCommitActorActor>(ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14993729202959126272UL, 16424019614688849920UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unlockDatabaseCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> unlockDatabaseCommitActor( ReadYourWritesTransaction* const& ryw ) {
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new UnlockDatabaseCommitActorActor(ryw));
															#line 8118 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1561 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> LockDatabaseImpl::commit(ReadYourWritesTransaction* ryw) {
	auto lockId = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("lock")].second;
	if (lockId.present()) {
		std::string uidStr = lockId.get().toString();
		UID uid;
		try {
			uid = UID::fromString(uidStr);
		} catch (Error& e) {
			return Optional<std::string>(
			    ManagementAPIError::toJsonString(false, "lock", "Invalid UID hex string: " + uidStr));
		}
		return lockDatabaseCommitActor(ryw, uid);
	} else {
		return unlockDatabaseCommitActor(ryw);
	}
}

															#line 8140 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getConsistencyCheckKeyActor()
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetConsistencyCheckKeyActorActor>
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetConsistencyCheckKeyActorActorState {
															#line 8147 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetConsistencyCheckKeyActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 8156 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckKeyActorActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1581 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1582 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(fdbShouldConsistencyCheckBeSuspended);
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8179 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state = 1;
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*>(static_cast<GetConsistencyCheckKeyActorActor*>(this)));
															#line 8184 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool ccSuspendSetting = val.present() ? BinaryReader::fromStringRef<bool>(val.get(), Unversioned()) : false;
															#line 1585 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ccSuspendSetting)
															#line 8211 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, ValueRef()));
															#line 8215 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1589 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetConsistencyCheckKeyActorActorState(); static_cast<GetConsistencyCheckKeyActorActor*>(this)->destroy(); return 0; }
															#line 8219 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool ccSuspendSetting = val.present() ? BinaryReader::fromStringRef<bool>(val.get(), Unversioned()) : false;
															#line 1585 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ccSuspendSetting)
															#line 8235 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, ValueRef()));
															#line 8239 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1589 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetConsistencyCheckKeyActorActorState(); static_cast<GetConsistencyCheckKeyActorActor*>(this)->destroy(); return 0; }
															#line 8243 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 8330 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getConsistencyCheckKeyActor()
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetConsistencyCheckKeyActorActor final : public Actor<RangeResult>, public ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >, public FastAllocated<GetConsistencyCheckKeyActorActor>, public GetConsistencyCheckKeyActorActorState<GetConsistencyCheckKeyActorActor> {
															#line 8335 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetConsistencyCheckKeyActorActor>::operator new;
	using FastAllocated<GetConsistencyCheckKeyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4907582546420940800UL, 15776709458771319040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >;
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetConsistencyCheckKeyActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 8352 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetConsistencyCheckKeyActorActorState<GetConsistencyCheckKeyActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14611963771812431104UL, 9262370184234012160UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckKeyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getConsistencyCheckKeyActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1579 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetConsistencyCheckKeyActorActor(ryw, kr));
															#line 8385 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1591 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ConsistencyCheckImpl::ConsistencyCheckImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ConsistencyCheckImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto entry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck")];
	if (!ryw->readYourWritesDisabled() && entry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (entry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, entry.second.get()));
		}
		return result;
	} else {
		return getConsistencyCheckKeyActor(ryw, kr);
	}
}

Future<Optional<std::string>> ConsistencyCheckImpl::commit(ReadYourWritesTransaction* ryw) {
	auto entry =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck")].second;
	ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
	ryw->getTransaction().set(fdbShouldConsistencyCheckBeSuspended,
	                          BinaryWriter::toValue(entry.present(), Unversioned()));
	return Optional<std::string>();
}

GlobalConfigImpl::GlobalConfigImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Returns key-value pairs for each value stored in the global configuration
// framework within the range specified. The special-key-space getrange
// function should only be used for informational purposes. All values are
// returned as strings regardless of their true type.
Future<RangeResult> GlobalConfigImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	RangeResult result;
	KeyRangeRef modified =
	    KeyRangeRef(kr.begin.removePrefix(getKeyRange().begin), kr.end.removePrefix(getKeyRange().begin));
	std::map<KeyRef, Reference<ConfigValue>> values = ryw->getDatabase()->globalConfig->get(modified);
	for (const auto& [key, config] : values) {
		Key prefixedKey = key.withPrefix(getKeyRange().begin);
		if (config.isValid() && config->value.has_value()) {
			if (config->value.type() == typeid(StringRef)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::any_cast<StringRef>(config->value).toString()));
			} else if (config->value.type() == typeid(int64_t)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<int64_t>(config->value))));
			} else if (config->value.type() == typeid(bool)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<bool>(config->value))));
			} else if (config->value.type() == typeid(float)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<float>(config->value))));
			} else if (config->value.type() == typeid(double)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<double>(config->value))));
			} else {
				ASSERT(false);
			}
		}
	}

	return result;
}

// Marks the key for insertion into global configuration.
void GlobalConfigImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
}

// Writes global configuration changes to durable memory. Also writes the
// changes made in the transaction to a recent history set, and updates the
// latest version which the global configuration was updated at.
															#line 8469 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via globalConfigCommitActor()
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GlobalConfigCommitActorActor>
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GlobalConfigCommitActorActorState {
															#line 8476 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigCommitActorActorState(GlobalConfigImpl* const& globalConfig,ReadYourWritesTransaction* const& ryw) 
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : globalConfig(globalConfig),
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 1673 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 8487 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("globalConfigCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigCommitActorActorState() 
	{
		fdb_probe_actor_destroy("globalConfigCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1674 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8506 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*>(static_cast<GlobalConfigCommitActorActor*>(this)));
															#line 8511 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& history,int loopDepth) 
	{
															#line 1679 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		constexpr int kGlobalConfigMaxHistorySize = 3;
															#line 1680 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (history.size() > kGlobalConfigMaxHistorySize - 1)
															#line 8536 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1681 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < history.size() - (kGlobalConfigMaxHistorySize - 1);++i) {
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				tr.clear(history[i].key);
															#line 8542 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1686 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> insertions;
															#line 1687 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> clears;
															#line 1692 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys);
															#line 1694 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = ranges.begin();
															#line 1695 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1696 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<bool, Optional<Value>> entry = iter->value();
															#line 1697 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first)
															#line 8559 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1698 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.second.present() && iter->begin().startsWith(globalConfig->getKeyRange().begin))
															#line 8563 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1699 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					Key bareKey = iter->begin().removePrefix(globalConfig->getKeyRange().begin);
															#line 1700 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					insertions.push_back_deep(insertions.arena(), KeyValueRef(bareKey, entry.second.get()));
															#line 8569 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1701 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!entry.second.present() && iter->range().begin.startsWith(globalConfig->getKeyRange().begin) && iter->range().end.startsWith(globalConfig->getKeyRange().begin))
															#line 8575 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1703 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeBegin = iter->range().begin.removePrefix(globalConfig->getKeyRange().begin);
															#line 1704 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeEnd = iter->range().end.removePrefix(globalConfig->getKeyRange().begin);
															#line 1705 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						clears.push_back_deep(clears.arena(), KeyRangeRef(bareRangeBegin, bareRangeEnd));
															#line 8583 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1708 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 8589 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1710 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		GlobalConfig::applyChanges(tr, insertions, clears);
															#line 1712 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GlobalConfigCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~GlobalConfigCommitActorActorState(); static_cast<GlobalConfigCommitActorActor*>(this)->destroy(); return 0; }
															#line 8595 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GlobalConfigCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && history,int loopDepth) 
	{
															#line 1679 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		constexpr int kGlobalConfigMaxHistorySize = 3;
															#line 1680 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (history.size() > kGlobalConfigMaxHistorySize - 1)
															#line 8609 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1681 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < history.size() - (kGlobalConfigMaxHistorySize - 1);++i) {
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				tr.clear(history[i].key);
															#line 8615 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1686 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> insertions;
															#line 1687 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> clears;
															#line 1692 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys);
															#line 1694 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = ranges.begin();
															#line 1695 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1696 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<bool, Optional<Value>> entry = iter->value();
															#line 1697 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first)
															#line 8632 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1698 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.second.present() && iter->begin().startsWith(globalConfig->getKeyRange().begin))
															#line 8636 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1699 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					Key bareKey = iter->begin().removePrefix(globalConfig->getKeyRange().begin);
															#line 1700 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					insertions.push_back_deep(insertions.arena(), KeyValueRef(bareKey, entry.second.get()));
															#line 8642 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1701 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!entry.second.present() && iter->range().begin.startsWith(globalConfig->getKeyRange().begin) && iter->range().end.startsWith(globalConfig->getKeyRange().begin))
															#line 8648 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 1703 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeBegin = iter->range().begin.removePrefix(globalConfig->getKeyRange().begin);
															#line 1704 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeEnd = iter->range().end.removePrefix(globalConfig->getKeyRange().begin);
															#line 1705 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						clears.push_back_deep(clears.arena(), KeyRangeRef(bareRangeBegin, bareRangeEnd));
															#line 8656 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1708 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 8662 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1710 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		GlobalConfig::applyChanges(tr, insertions, clears);
															#line 1712 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GlobalConfigCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~GlobalConfigCommitActorActorState(); static_cast<GlobalConfigCommitActorActor*>(this)->destroy(); return 0; }
															#line 8668 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GlobalConfigCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1cont1(history, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigCommitActorActor*>(this)->ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigImpl* globalConfig;
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1673 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1692 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 1694 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter;
															#line 8761 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via globalConfigCommitActor()
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GlobalConfigCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >, public FastAllocated<GlobalConfigCommitActorActor>, public GlobalConfigCommitActorActorState<GlobalConfigCommitActorActor> {
															#line 8766 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GlobalConfigCommitActorActor>::operator new;
	using FastAllocated<GlobalConfigCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12360067587940656128UL, 941279172704862464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >;
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigCommitActorActor(GlobalConfigImpl* const& globalConfig,ReadYourWritesTransaction* const& ryw) 
															#line 8783 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   GlobalConfigCommitActorActorState<GlobalConfigCommitActorActor>(globalConfig, ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7286398798349763072UL, 930146673228728064UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> globalConfigCommitActor( GlobalConfigImpl* const& globalConfig, ReadYourWritesTransaction* const& ryw ) {
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new GlobalConfigCommitActorActor(globalConfig, ryw));
															#line 8816 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1714 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

// Called when a transaction includes keys in the global configuration special-key-space range.
Future<Optional<std::string>> GlobalConfigImpl::commit(ReadYourWritesTransaction* ryw) {
	return globalConfigCommitActor(this, ryw);
}

// Marks the range for deletion from global configuration.
void GlobalConfigImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->getSpecialKeySpaceWriteMap().insert(range, std::make_pair(true, Optional<Value>()));
}

// Marks the key for deletion from global configuration.
void GlobalConfigImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>()));
}

TracingOptionsImpl::TracingOptionsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> TracingOptionsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                 KeyRangeRef kr,
                                                 GetRangeLimits limitsHint) const {
	RangeResult result;
	for (const auto& option : SpecialKeySpace::getTracingOptions()) {
		auto key = getKeyRange().begin.withSuffix(option);
		if (!kr.contains(key)) {
			continue;
		}

		if (key.endsWith(kTracingTransactionIdKey)) {
			result.push_back_deep(result.arena(),
			                      KeyValueRef(key, ryw->getTransactionState()->spanContext.traceID.toString()));
		} else if (key.endsWith(kTracingTokenKey)) {
			result.push_back_deep(result.arena(),
			                      KeyValueRef(key, std::to_string(ryw->getTransactionState()->spanContext.spanID)));
		}
	}
	return result;
}

void TracingOptionsImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	if (ryw->getApproximateSize() > 0) {
		ryw->setSpecialKeySpaceErrorMsg(
		    ManagementAPIError::toJsonString(false, "configure trace", "tracing options must be set first"));
		ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>()));
		return;
	}

	if (key.endsWith(kTracingTransactionIdKey)) {
		ryw->setTransactionID(UID::fromString(value.toString()));
	} else if (key.endsWith(kTracingTokenKey)) {
		if (value.toString() == "true") {
			ryw->setToken(deterministicRandom()->randomUInt64());
		} else if (value.toString() == "false") {
			ryw->setToken(0);
		} else {
			ryw->setSpecialKeySpaceErrorMsg(
			    ManagementAPIError::toJsonString(false, "configure trace token", "token must be set to true/false"));
			throw special_keys_api_failure();
		}
	}
}

Future<Optional<std::string>> TracingOptionsImpl::commit(ReadYourWritesTransaction* ryw) {
	if (ryw->getSpecialKeySpaceWriteMap().size() > 0) {
		throw special_keys_api_failure();
	}
	return Optional<std::string>();
}

void TracingOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString(false, "clear trace", "clear range disabled"));
	throw special_keys_api_failure();
}

void TracingOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString(false, "clear trace", "clear disabled"));
	throw special_keys_api_failure();
}

CoordinatorsImpl::CoordinatorsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

															#line 8901 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via coordinatorsGetRangeActor()
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsGetRangeActorActor>
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsGetRangeActorActorState {
															#line 8908 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1796 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cs(ryw->getDatabase()->getConnectionRecord()->getConnectionString())
															#line 8921 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8938 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsGetRangeActorActor*>(this)));
															#line 8943 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsGetRangeActorActorState();
		static_cast<CoordinatorsGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1799 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key cluster_description_key = prefix.withSuffix("cluster_description"_sr);
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(cluster_description_key))
															#line 8970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1801 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(cluster_description_key, cs.clusterKeyName()));
															#line 8974 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(coordinator_processes.begin(), coordinator_processes.end(), [](const NetworkAddress& lhs, const NetworkAddress& rhs) { return lhs.toString() < rhs.toString(); });
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::string processes_str;
															#line 1809 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& w : coordinator_processes ) {
															#line 1810 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (processes_str.size())
															#line 8984 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1811 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				processes_str += ",";
															#line 8988 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1812 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			processes_str += w.toString();
															#line 8992 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1814 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key processes_key = prefix.withSuffix("processes"_sr);
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(processes_key))
															#line 8998 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(processes_key, Value(processes_str)));
															#line 9002 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1818 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~CoordinatorsGetRangeActorActorState(); static_cast<CoordinatorsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 9006 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~CoordinatorsGetRangeActorActorState();
		static_cast<CoordinatorsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& __coordinator_processes,int loopDepth) 
	{
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		coordinator_processes = __coordinator_processes;
															#line 9018 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && __coordinator_processes,int loopDepth) 
	{
		coordinator_processes = std::move(__coordinator_processes);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsGetRangeActorActor*>(this)->ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1796 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString cs;
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<NetworkAddress> coordinator_processes;
															#line 9103 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via coordinatorsGetRangeActor()
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >, public FastAllocated<CoordinatorsGetRangeActorActor>, public CoordinatorsGetRangeActorActorState<CoordinatorsGetRangeActorActor> {
															#line 9108 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<CoordinatorsGetRangeActorActor>::operator new;
	using FastAllocated<CoordinatorsGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6092736814762395648UL, 6281462882936127232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >;
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 9125 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   CoordinatorsGetRangeActorActorState<CoordinatorsGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6364174339737764352UL, 13532682984794991360UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinatorsGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> coordinatorsGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1795 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new CoordinatorsGetRangeActorActor(ryw, prefix, kr));
															#line 9158 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1820 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> CoordinatorsImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	KeyRef prefix(getKeyRange().begin);
	return coordinatorsGetRangeActor(ryw, prefix, kr);
}

															#line 9170 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via coordinatorsCommitActor()
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsCommitActorActor>
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsCommitActorActorState {
															#line 9177 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1829 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   conn(),
															#line 1830 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   process_address_or_hostname_strs(),
															#line 1831 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg(),
															#line 1832 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   index(),
															#line 1833 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   parse_error(false)
															#line 9196 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsCommitActorActorState() 
	{
		fdb_probe_actor_destroy("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key processes_key = "processes"_sr.withPrefix(kr.begin);
															#line 1837 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto processes_entry = ryw->getSpecialKeySpaceWriteMap()[processes_key];
															#line 1838 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (processes_entry.first)
															#line 9215 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ASSERT(processes_entry.second.present());
															#line 1840 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto processesStr = processes_entry.second.get().toString();
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				boost::split(process_address_or_hostname_strs, processesStr, [](char c) { return c == ','; });
															#line 1842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!process_address_or_hostname_strs.size())
															#line 9225 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1843 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "coordinators", "New coordinators\' processes are empty, please specify new processes\' network addresses with format " "\"IP:PORT,IP:PORT,...,IP:PORT\" or \"HOSTNAME:PORT,HOSTNAME:PORT,...,HOSTNAME:PORT\"")); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9229 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "coordinators", "New coordinators\' processes are empty, please specify new processes\' network addresses with format " "\"IP:PORT,IP:PORT,...,IP:PORT\" or \"HOSTNAME:PORT,HOSTNAME:PORT,...,HOSTNAME:PORT\""));
					this->~CoordinatorsCommitActorActorState();
					static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				index = 0;
															#line 9237 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::string newName;
															#line 1876 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key cluster_description_key = "cluster_description"_sr.withPrefix(kr.begin);
															#line 1877 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto entry = ryw->getSpecialKeySpaceWriteMap()[cluster_description_key];
															#line 1878 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (entry.first)
															#line 9271 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1880 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.second.present() && isAlphaNumeric(entry.second.get().toString()))
															#line 9275 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				newName = entry.second.get().toString();
															#line 9279 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1885 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "coordinators", "Cluster description must match [A-Za-z0-9_]+")); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9285 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "coordinators", "Cluster description must match [A-Za-z0-9_]+"));
				this->~CoordinatorsCommitActorActorState();
				static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto configDBEntry = ryw->getSpecialKeySpaceWriteMap()["config_db"_sr.withPrefix(kr.begin)];
															#line 1892 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsStart") .detail("NewConnectionString", conn.toString()) .detail("Description", entry.first ? entry.second.get().toString() : "") .detail("ConfigDBDisabled", configDBEntry.first);
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Optional<CoordinatorsResult>> __when_expr_0 = changeQuorumChecker(&ryw->getTransaction(), &conn, newName, configDBEntry.first);
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9300 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*>(static_cast<CoordinatorsCommitActorActor*>(this)));
															#line 9305 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(index < process_address_or_hostname_strs.size()))
															#line 9327 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 1851 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (Hostname::isHostname(process_address_or_hostname_strs[index]))
															#line 9334 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				conn.hostnames.push_back(Hostname::parse(process_address_or_hostname_strs[index]));
															#line 9338 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1854 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				NetworkAddress a = NetworkAddress::parse(process_address_or_hostname_strs[index]);
															#line 1855 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!a.isValid())
															#line 9346 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1856 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					parse_error = true;
															#line 9350 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1858 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					conn.coords.push_back(a);
															#line 9356 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1866 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (parse_error)
															#line 9386 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1867 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string error = "ERROR: \'" + process_address_or_hostname_strs[index] + "\' is not a valid network endpoint address\n";
															#line 1869 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString(false, "coordinators", error)); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9392 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString(false, "coordinators", error));
			this->~CoordinatorsCommitActorActorState();
			static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		index++;
															#line 9400 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1862 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeysNetworkParseError").error(e);
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parse_error = true;
															#line 9412 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4(Optional<CoordinatorsResult> const& r,int loopDepth) 
	{
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsFinish") .detail("Result", r.present() ? static_cast<int>(r.get()) : -1);
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (r.present())
															#line 9442 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto res = r.get();
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			bool retriable = false;
															#line 1905 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (res == CoordinatorsResult::COORDINATOR_UNREACHABLE)
															#line 9450 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1906 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				retriable = true;
															#line 9454 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (res == CoordinatorsResult::SUCCESS)
															#line 9460 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1908 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevError, "SpecialKeysForCoordinators").detail("UnexpectedSuccessfulResult", "");
															#line 1909 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ASSERT(false);
															#line 9466 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			msg = ManagementAPIError::toJsonString(retriable, "coordinators", ManagementAPI::generateErrorMessage(res));
															#line 9471 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9475 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<CoordinatorsResult> && r,int loopDepth) 
	{
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsFinish") .detail("Result", r.present() ? static_cast<int>(r.get()) : -1);
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (r.present())
															#line 9489 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto res = r.get();
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			bool retriable = false;
															#line 1905 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (res == CoordinatorsResult::COORDINATOR_UNREACHABLE)
															#line 9497 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 1906 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				retriable = true;
															#line 9501 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1907 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (res == CoordinatorsResult::SUCCESS)
															#line 9507 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 1908 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevError, "SpecialKeysForCoordinators").detail("UnexpectedSuccessfulResult", "");
															#line 1909 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ASSERT(false);
															#line 9513 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			msg = ManagementAPIError::toJsonString(retriable, "coordinators", ManagementAPI::generateErrorMessage(res));
															#line 9518 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9522 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<CoordinatorsResult> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont4(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<CoordinatorsResult> && r,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsCommitActorActor*>(this)->ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Optional<CoordinatorsResult> const& value) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Optional<CoordinatorsResult> && value) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1829 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString conn;
															#line 1830 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::string> process_address_or_hostname_strs;
															#line 1831 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> msg;
															#line 1832 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int index;
															#line 1833 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool parse_error;
															#line 9619 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via coordinatorsCommitActor()
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >, public FastAllocated<CoordinatorsCommitActorActor>, public CoordinatorsCommitActorActorState<CoordinatorsCommitActorActor> {
															#line 9624 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<CoordinatorsCommitActorActor>::operator new;
	using FastAllocated<CoordinatorsCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3785325572140718592UL, 5575480388545050880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >;
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 9641 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   CoordinatorsCommitActorActorState<CoordinatorsCommitActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1759015567785200128UL, 14922565753913665792UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinatorsCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> coordinatorsCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new CoordinatorsCommitActorActor(ryw, kr));
															#line 9674 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1915 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> CoordinatorsImpl::commit(ReadYourWritesTransaction* ryw) {
	return coordinatorsCommitActor(ryw, getKeyRange());
}

void CoordinatorsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(ryw, "coordinators", "Clear range is meaningless thus forbidden for coordinators");
}

void CoordinatorsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw, "coordinators", "Clear operation is meaningless thus forbidden for coordinators");
}

CoordinatorsAutoImpl::CoordinatorsAutoImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

															#line 9694 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via CoordinatorsAutoImplActor()
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsAutoImplActorActor>
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsAutoImplActorActorState {
															#line 9701 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsAutoImplActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1932 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   res(),
															#line 1933 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   autoCoordinatorsKey(),
															#line 1934 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 9716 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsAutoImplActorActorState() 
	{
		fdb_probe_actor_destroy("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1937 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1938 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(coordinatorsKey);
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9741 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 1;
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9746 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& currentKey,int loopDepth) 
	{
															#line 1942 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!currentKey.present())
															#line 9769 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "auto_coordinators", "The coordinator key does not exist"));
															#line 1945 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 9775 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1947 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		old = ClusterConnectionString(currentKey.get().toString());
															#line 1948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = CoordinatorsResult::SUCCESS;
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9785 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 2;
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9790 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && currentKey,int loopDepth) 
	{
															#line 1942 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!currentKey.present())
															#line 9799 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "auto_coordinators", "The coordinator key does not exist"));
															#line 1945 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 9805 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1947 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		old = ClusterConnectionString(currentKey.get().toString());
															#line 1948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = CoordinatorsResult::SUCCESS;
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9815 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 2;
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9820 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& currentKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(currentKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && currentKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(currentKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<NetworkAddress> const& oldCoordinators,int loopDepth) 
	{
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = autoQuorumChange()->getDesiredCoordinators( &tr, oldCoordinators, Reference<ClusterConnectionMemoryRecord>(new ClusterConnectionMemoryRecord(old)), result);
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9906 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 3;
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9911 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<NetworkAddress> && oldCoordinators,int loopDepth) 
	{
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = autoQuorumChange()->getDesiredCoordinators( &tr, oldCoordinators, Reference<ClusterConnectionMemoryRecord>(new ClusterConnectionMemoryRecord(old)), result);
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9922 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 3;
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9927 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<NetworkAddress> const& oldCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(oldCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<NetworkAddress> && oldCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(oldCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(std::vector<NetworkAddress> const& _desiredCoordinators,int loopDepth) 
	{
															#line 1957 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::NOT_ENOUGH_MACHINES)
															#line 10011 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1960 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( true, "auto_coordinators", "Too few fdbserver machines to provide coordination at the current redundancy level"));
															#line 1964 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 10017 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::SAME_NETWORK_ADDRESSES)
															#line 10021 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1968 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& host : old.hostnames ) {
															#line 1969 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1970 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += host.toString();
															#line 10029 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& coord : old.coords ) {
															#line 1973 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += coord.toString();
															#line 10037 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 1977 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& address : _desiredCoordinators ) {
															#line 1978 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1979 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += address.toString();
															#line 10048 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1982 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		res.push_back_deep(res.arena(), KeyValueRef(kr.begin, Value(autoCoordinatorsKey)));
															#line 1983 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~CoordinatorsAutoImplActorActorState(); static_cast<CoordinatorsAutoImplActorActor*>(this)->destroy(); return 0; }
															#line 10055 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(std::vector<NetworkAddress> && _desiredCoordinators,int loopDepth) 
	{
															#line 1957 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::NOT_ENOUGH_MACHINES)
															#line 10067 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1960 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( true, "auto_coordinators", "Too few fdbserver machines to provide coordination at the current redundancy level"));
															#line 1964 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 10073 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 1967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::SAME_NETWORK_ADDRESSES)
															#line 10077 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 1968 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& host : old.hostnames ) {
															#line 1969 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1970 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += host.toString();
															#line 10085 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& coord : old.coords ) {
															#line 1973 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += coord.toString();
															#line 10093 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 1977 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& address : _desiredCoordinators ) {
															#line 1978 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 1979 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += address.toString();
															#line 10104 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 1982 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		res.push_back_deep(res.arena(), KeyValueRef(kr.begin, Value(autoCoordinatorsKey)));
															#line 1983 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~CoordinatorsAutoImplActorActorState(); static_cast<CoordinatorsAutoImplActorActor*>(this)->destroy(); return 0; }
															#line 10111 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> const& _desiredCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont4(_desiredCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> && _desiredCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_desiredCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1932 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult res;
															#line 1933 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::string autoCoordinatorsKey;
															#line 1934 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1947 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString old;
															#line 1948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsResult result;
															#line 10208 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via CoordinatorsAutoImplActor()
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsAutoImplActorActor final : public Actor<RangeResult>, public ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >, public ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >, public ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >, public FastAllocated<CoordinatorsAutoImplActorActor>, public CoordinatorsAutoImplActorActorState<CoordinatorsAutoImplActorActor> {
															#line 10213 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<CoordinatorsAutoImplActorActor>::operator new;
	using FastAllocated<CoordinatorsAutoImplActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1871830522373711616UL, 9518919799022693632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >;
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >;
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >;
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsAutoImplActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 10232 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   CoordinatorsAutoImplActorActorState<CoordinatorsAutoImplActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8864986884343506176UL, 12776331881952517376UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("CoordinatorsAutoImplActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> CoordinatorsAutoImplActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new CoordinatorsAutoImplActorActor(ryw, kr));
															#line 10267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 1985 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> CoordinatorsAutoImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	return CoordinatorsAutoImplActor(ryw, kr);
}

															#line 10280 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getMinCommitVersionActor()
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetMinCommitVersionActorActor>
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetMinCommitVersionActorActorState {
															#line 10287 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetMinCommitVersionActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 10296 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this));

	}
	~GetMinCommitVersionActorActorState() 
	{
		fdb_probe_actor_destroy("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1995 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1997 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(minRequiredCommitVersionKey);
															#line 1997 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10317 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state = 1;
															#line 1997 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*>(static_cast<GetMinCommitVersionActorActor*>(this)));
															#line 10322 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1998 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1999 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 10347 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2000 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Version minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(val.get(), Unversioned());
															#line 2001 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(minRequiredCommitVersion));
															#line 2002 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 10355 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2004 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetMinCommitVersionActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetMinCommitVersionActorActorState(); static_cast<GetMinCommitVersionActorActor*>(this)->destroy(); return 0; }
															#line 10359 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetMinCommitVersionActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1998 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1999 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 10373 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2000 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Version minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(val.get(), Unversioned());
															#line 2001 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(minRequiredCommitVersion));
															#line 2002 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 10381 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2004 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetMinCommitVersionActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetMinCommitVersionActorActorState(); static_cast<GetMinCommitVersionActorActor*>(this)->destroy(); return 0; }
															#line 10385 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetMinCommitVersionActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinCommitVersionActorActor*>(this)->ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 10472 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getMinCommitVersionActor()
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetMinCommitVersionActorActor final : public Actor<RangeResult>, public ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >, public FastAllocated<GetMinCommitVersionActorActor>, public GetMinCommitVersionActorActorState<GetMinCommitVersionActorActor> {
															#line 10477 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetMinCommitVersionActorActor>::operator new;
	using FastAllocated<GetMinCommitVersionActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9936437523440983808UL, 18425618204826542848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >;
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetMinCommitVersionActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 10494 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetMinCommitVersionActorActorState<GetMinCommitVersionActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16975584647062044416UL, 988944995584749824UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMinCommitVersionActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getMinCommitVersionActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetMinCommitVersionActorActor(ryw, kr));
															#line 10527 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2006 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

AdvanceVersionImpl::AdvanceVersionImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> AdvanceVersionImpl::getRange(ReadYourWritesTransaction* ryw,
                                                 KeyRangeRef kr,
                                                 GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto entry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("advanceversion")];
	if (!ryw->readYourWritesDisabled() && entry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (entry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, entry.second.get()));
		}
		return result;
	} else {
		return getMinCommitVersionActor(ryw, kr);
	}
}

															#line 10552 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via advanceVersionCommitActor()
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class AdvanceVersionCommitActorActor>
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class AdvanceVersionCommitActorActorState {
															#line 10559 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	AdvanceVersionCommitActorActorState(ReadYourWritesTransaction* const& ryw,Version const& v) 
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   v(v)
															#line 10568 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~AdvanceVersionCommitActorActorState() 
	{
		fdb_probe_actor_destroy("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2028 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = ryw->getTransaction().get(versionEpochKey);
															#line 2028 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10585 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2028 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10590 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (versionEpochValue.present())
															#line 10613 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10617 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		static const Version maxAllowedVerion = std::numeric_limits<int64_t>::max() - 1 - CLIENT_KNOBS->VERSIONS_PER_SECOND * 3600 * 24 * 365 * 1000;
															#line 2039 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2040 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "AdvanceVersion").detail("MaxAllowedVersion", maxAllowedVerion);
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (v > maxAllowedVerion)
															#line 10633 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2043 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10637 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Version> __when_expr_1 = ryw->getTransaction().getReadVersion();
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10647 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10652 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (versionEpochValue.present())
															#line 10661 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10665 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		static const Version maxAllowedVerion = std::numeric_limits<int64_t>::max() - 1 - CLIENT_KNOBS->VERSIONS_PER_SECOND * 3600 * 24 * 365 * 1000;
															#line 2039 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2040 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "AdvanceVersion").detail("MaxAllowedVersion", maxAllowedVerion);
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (v > maxAllowedVerion)
															#line 10681 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2043 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10685 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Version> __when_expr_1 = ryw->getTransaction().getReadVersion();
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10695 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10700 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommitActorActor*>(this)->ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& rv,int loopDepth) 
	{
															#line 2049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (rv <= v)
															#line 10784 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2050 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 10788 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10794 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2055 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10802 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Version && rv,int loopDepth) 
	{
															#line 2049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (rv <= v)
															#line 10814 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2050 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 10818 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10824 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2055 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommitActorActor*>(this)->ActorCallback< AdvanceVersionCommitActorActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Version v;
															#line 10919 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via advanceVersionCommitActor()
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class AdvanceVersionCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >, public ActorCallback< AdvanceVersionCommitActorActor, 1, Version >, public FastAllocated<AdvanceVersionCommitActorActor>, public AdvanceVersionCommitActorActorState<AdvanceVersionCommitActorActor> {
															#line 10924 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<AdvanceVersionCommitActorActor>::operator new;
	using FastAllocated<AdvanceVersionCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(683137393258924032UL, 6971818493763786752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< AdvanceVersionCommitActorActor, 1, Version >;
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	AdvanceVersionCommitActorActor(ReadYourWritesTransaction* const& ryw,Version const& v) 
															#line 10942 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   AdvanceVersionCommitActorActorState<AdvanceVersionCommitActorActor>(ryw, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15411806673587825152UL, 12887272844449880320UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("advanceVersionCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> advanceVersionCommitActor( ReadYourWritesTransaction* const& ryw, Version const& v ) {
															#line 2027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new AdvanceVersionCommitActorActor(ryw, v));
															#line 10976 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2057 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> AdvanceVersionImpl::commit(ReadYourWritesTransaction* ryw) {
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
	auto minCommitVersion =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("advanceversion")].second;
	if (minCommitVersion.present()) {
		try {
			// Version is int64_t
			Version v = boost::lexical_cast<int64_t>(minCommitVersion.get().toString());
			return advanceVersionCommitActor(ryw, v);
		} catch (boost::bad_lexical_cast& e) {
			return Optional<std::string>(ManagementAPIError::toJsonString(
			    false, "advanceversion", "Invalid version(int64_t) argument: " + minCommitVersion.get().toString()));
		}
	} else {
		ryw->getTransaction().clear(minRequiredCommitVersionKey);
	}
	return Optional<std::string>();
}

															#line 11000 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getVersionEpochActor()
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetVersionEpochActorActor>
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetVersionEpochActorActorState {
															#line 11007 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetVersionEpochActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 11016 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getVersionEpochActor", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionEpochActorActorState() 
	{
		fdb_probe_actor_destroy("getVersionEpochActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2078 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2079 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2080 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(versionEpochKey);
															#line 2080 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11037 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state = 1;
															#line 2080 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*>(static_cast<GetVersionEpochActorActor*>(this)));
															#line 11042 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2081 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2082 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 11067 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2083 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(val.get(), Unversioned());
															#line 2084 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(versionEpoch));
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 11075 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2087 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetVersionEpochActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetVersionEpochActorActorState(); static_cast<GetVersionEpochActorActor*>(this)->destroy(); return 0; }
															#line 11079 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionEpochActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2081 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2082 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 11093 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2083 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(val.get(), Unversioned());
															#line 2084 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(versionEpoch));
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 11101 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2087 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetVersionEpochActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetVersionEpochActorActorState(); static_cast<GetVersionEpochActorActor*>(this)->destroy(); return 0; }
															#line 11105 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<GetVersionEpochActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state > 0) static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionEpochActorActor*>(this)->ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 11192 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getVersionEpochActor()
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetVersionEpochActorActor final : public Actor<RangeResult>, public ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >, public FastAllocated<GetVersionEpochActorActor>, public GetVersionEpochActorActorState<GetVersionEpochActorActor> {
															#line 11197 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetVersionEpochActorActor>::operator new;
	using FastAllocated<GetVersionEpochActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2168084653960260864UL, 2295288032300844544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >;
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetVersionEpochActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 11214 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   GetVersionEpochActorActorState<GetVersionEpochActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6887551967245793024UL, 9563326708339697408UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionEpochActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getVersionEpochActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2077 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetVersionEpochActorActor(ryw, kr));
															#line 11247 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2089 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

VersionEpochImpl::VersionEpochImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> VersionEpochImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	ASSERT(kr == getKeyRange());
	return getVersionEpochActor(ryw, kr);
}

Future<Optional<std::string>> VersionEpochImpl::commit(ReadYourWritesTransaction* ryw) {
	auto versionEpoch =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("versionepoch")].second;
	if (versionEpoch.present()) {
		int64_t epoch = BinaryReader::fromStringRef<int64_t>(versionEpoch.get(), Unversioned());
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
		ryw->getTransaction().set(versionEpochKey, BinaryWriter::toValue(epoch, Unversioned()));
	} else {
		ryw->getTransaction().clear(versionEpochKey);
	}
	return Optional<std::string>();
}

ClientProfilingImpl::ClientProfilingImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ClientProfilingImpl::getRange(ReadYourWritesTransaction* ryw,
                                                  KeyRangeRef kr,
                                                  GetRangeLimits limitsHint) const {
	KeyRef prefix = getKeyRange().begin;
	RangeResult result = RangeResult();
	// client_txn_sample_rate
	Key sampleRateKey = "client_txn_sample_rate"_sr.withPrefix(prefix);

	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	if (kr.contains(sampleRateKey)) {
		auto entry = ryw->getSpecialKeySpaceWriteMap()[sampleRateKey];
		if (!ryw->readYourWritesDisabled() && entry.first) {
			// clear is forbidden
			ASSERT(entry.second.present());
			result.push_back_deep(result.arena(), KeyValueRef(sampleRateKey, entry.second.get()));
		} else {
			std::string sampleRateStr = "default";
			const double sampleRateDbl = ryw->getDatabase()->globalConfig->get<double>(
			    fdbClientInfoTxnSampleRate, std::numeric_limits<double>::infinity());
			if (!std::isinf(sampleRateDbl)) {
				sampleRateStr = std::to_string(sampleRateDbl);
			}
			result.push_back_deep(result.arena(), KeyValueRef(sampleRateKey, Value(sampleRateStr)));
		}
	}
	// client_txn_size_limit
	Key txnSizeLimitKey = "client_txn_size_limit"_sr.withPrefix(prefix);
	if (kr.contains(txnSizeLimitKey)) {
		auto entry = ryw->getSpecialKeySpaceWriteMap()[txnSizeLimitKey];
		if (!ryw->readYourWritesDisabled() && entry.first) {
			// clear is forbidden
			ASSERT(entry.second.present());
			result.push_back_deep(result.arena(), KeyValueRef(txnSizeLimitKey, entry.second.get()));
		} else {
			std::string sizeLimitStr = "default";
			const int64_t sizeLimit = ryw->getDatabase()->globalConfig->get<int64_t>(fdbClientInfoTxnSizeLimit, -1);
			if (sizeLimit != -1) {
				sizeLimitStr = boost::lexical_cast<std::string>(sizeLimit);
			}
			result.push_back_deep(result.arena(), KeyValueRef(txnSizeLimitKey, Value(sizeLimitStr)));
		}
	}
	return result;
}

Future<Optional<std::string>> ClientProfilingImpl::commit(ReadYourWritesTransaction* ryw) {
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	Standalone<VectorRef<KeyValueRef>> insertions;
	Standalone<VectorRef<KeyRangeRef>> clears;

	// client_txn_sample_rate
	Key sampleRateKey = "client_txn_sample_rate"_sr.withPrefix(getKeyRange().begin);
	auto rateEntry = ryw->getSpecialKeySpaceWriteMap()[sampleRateKey];

	if (rateEntry.first && rateEntry.second.present()) {
		std::string sampleRateStr = rateEntry.second.get().toString();
		if (sampleRateStr == "default") {
			clears.push_back_deep(clears.arena(),
			                      KeyRangeRef(fdbClientInfoTxnSampleRate, keyAfter(fdbClientInfoTxnSampleRate)));
		} else {
			try {
				double sampleRate = boost::lexical_cast<double>(sampleRateStr);
				Tuple rate = Tuple::makeTuple(sampleRate);
				insertions.push_back_deep(insertions.arena(), KeyValueRef(fdbClientInfoTxnSampleRate, rate.pack()));
			} catch (boost::bad_lexical_cast& e) {
				return Optional<std::string>(ManagementAPIError::toJsonString(
				    false, "profile", "Invalid transaction sample rate(double): " + sampleRateStr));
			}
		}
	}
	// client_txn_size_limit
	Key txnSizeLimitKey = "client_txn_size_limit"_sr.withPrefix(getKeyRange().begin);
	auto sizeLimitEntry = ryw->getSpecialKeySpaceWriteMap()[txnSizeLimitKey];
	if (sizeLimitEntry.first && sizeLimitEntry.second.present()) {
		std::string sizeLimitStr = sizeLimitEntry.second.get().toString();
		if (sizeLimitStr == "default") {
			clears.push_back_deep(clears.arena(),
			                      KeyRangeRef(fdbClientInfoTxnSizeLimit, keyAfter(fdbClientInfoTxnSizeLimit)));
		} else {
			try {
				int64_t sizeLimit = boost::lexical_cast<int64_t>(sizeLimitStr);
				Tuple size = Tuple::makeTuple(sizeLimit);
				insertions.push_back_deep(insertions.arena(), KeyValueRef(fdbClientInfoTxnSizeLimit, size.pack()));
			} catch (boost::bad_lexical_cast& e) {
				return Optional<std::string>(ManagementAPIError::toJsonString(
				    false, "profile", "Invalid transaction size limit(int64_t): " + sizeLimitStr));
			}
		}
	}
	GlobalConfig::applyChanges(ryw->getTransaction(), insertions, clears);
	return Optional<std::string>();
}

void ClientProfilingImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(
	    ryw, "profile", "Clear range is forbidden for profile client. You can set it to default to disable profiling.");
}

void ClientProfilingImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw,
	    "profile",
	    "Clear operation is forbidden for profile client. You can set it to default to disable profiling.");
}

ActorLineageImpl::ActorLineageImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

void parse(StringRef& val, int& i) {
	i = std::stoi(val.toString());
}

void parse(StringRef& val, double& d) {
	d = std::stod(val.toString());
}

void parse(StringRef& val, WaitState& w) {
	if (val == "disk"_sr || val == "Disk"_sr) {
		w = WaitState::Disk;
	} else if (val == "network"_sr || val == "Network"_sr) {
		w = WaitState::Network;
	} else if (val == "running"_sr || val == "Running"_sr) {
		w = WaitState::Running;
	} else {
		throw std::range_error("failed to parse run state");
	}
}

void parse(StringRef& val, time_t& t) {
	struct tm tm;
#ifdef _WIN32
	std::istringstream s(val.toString());
	s.imbue(std::locale(setlocale(LC_TIME, nullptr)));
	s >> std::get_time(&tm, "%FT%T%z");
	if (s.fail()) {
		throw std::invalid_argument("failed to parse ISO 8601 datetime");
	}
	long timezone;
	if (_get_timezone(&timezone) != 0) {
		throw std::runtime_error("failed to convert ISO 8601 datetime");
	}
	timezone = -timezone;
#else
	if (strptime(val.toString().c_str(), "%FT%T%z", &tm) == nullptr) {
		throw std::invalid_argument("failed to parse ISO 8601 datetime");
	}
	long timezone = tm.tm_gmtoff;
	t = timegm(&tm);
	if (t == -1) {
		throw std::runtime_error("failed to convert ISO 8601 datetime");
	}
	t -= timezone;
#endif
}

void parse(StringRef& val, NetworkAddress& a) {
	auto address = NetworkAddress::parse(val.toString());
	if (!address.isValid()) {
		throw std::invalid_argument("invalid host");
	}
	a = address;
}

// Base case function for parsing function below.
template <typename T>
void parse(std::vector<StringRef>::iterator it, std::vector<StringRef>::iterator end, T& t1) {
	if (it == end) {
		return;
	}
	parse(*it, t1);
}

// Given an iterator into a vector of string tokens, an iterator to the end of
// the search space in the vector (exclusive), and a list of references to
// types, parses each token in the vector into the associated type according to
// the order of the arguments.
//
// For example, given the vector ["1", "1.5", "127.0.0.1:4000"] and the
// argument list int a, double b, NetworkAddress c, after this function returns
// each parameter passed in will hold the parsed value from the token list.
//
// The appropriate parsing function must be implemented for the type you wish
// to parse. See the existing parsing functions above, and add your own if
// necessary.
template <typename T, typename... Types>
void parse(std::vector<StringRef>::iterator it, std::vector<StringRef>::iterator end, T& t1, Types&... remaining) {
	// Return as soon as all tokens have been parsed. This allows parameters
	// passed at the end to act as optional parameters -- they will only be set
	// if the value exists.
	if (it == end) {
		return;
	}

	try {
		parse(*it, t1);
		parse(++it, end, remaining...);
	} catch (Error& e) {
		throw e;
	} catch (std::exception& e) {
		throw e;
	}
}

															#line 11481 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via actorLineageGetRangeActor()
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ActorLineageGetRangeActorActor>
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ActorLineageGetRangeActorActorState {
															#line 11488 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ActorLineageGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2322 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2326 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   host(),
															#line 2327 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   waitStateStart(WaitState{ 0 }),
															#line 2328 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   waitStateEnd(WaitState{ 2 }),
															#line 2329 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   timeStart(0),
															#line 2330 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   timeEnd(std::numeric_limits<time_t>::max()),
															#line 2331 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   seqStart(0),
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   seqEnd(std::numeric_limits<int>::max()),
															#line 2334 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   beginValues(kr.begin.removePrefix(prefix).splitAny("/"_sr)),
															#line 2335 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   endValues(kr.end.removePrefix(prefix).splitAny("/"_sr))
															#line 11519 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~ActorLineageGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2337 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (beginValues.size() < 2 || endValues.size() < 2)
															#line 11534 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2338 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "missing required parameters (index, host)"));
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11540 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 2343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			endRangeHost = NetworkAddress();
															#line 11544 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			try {
															#line 2345 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11548 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					parse(beginValues.begin() + 1, beginValues.end(), host, waitStateStart, timeStart, seqStart);
															#line 2348 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (kr.begin != kr.end)
															#line 11554 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2349 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						parse(endValues.begin() + 1, endValues.end(), endRangeHost, waitStateEnd, timeEnd, seqEnd);
															#line 11558 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2351 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11565 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						parse(beginValues.begin() + 1, beginValues.end(), host, timeStart, waitStateStart, seqStart);
															#line 2354 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (kr.begin != kr.end)
															#line 11571 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						{
															#line 2355 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							parse(endValues.begin() + 1, endValues.end(), endRangeHost, timeEnd, waitStateEnd, seqEnd);
															#line 11575 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
						}
					}
					else
					{
															#line 2358 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "invalid index in actor_lineage"));
															#line 2360 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						return a_body1Catch2(special_keys_api_failure(), loopDepth);
															#line 11584 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1cont10(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2372 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.begin != kr.end && host != endRangeHost)
															#line 11615 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2375 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( false, "read actor_lineage", "the host must remain the same on both ends of the range"));
															#line 2377 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11621 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2382 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = ProcessInterface();
															#line 2383 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process.getInterface = RequestStream<GetProcessInterfaceRequest>(Endpoint::wellKnown({ host }, WLTOKEN_PROCESS));
															#line 2384 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ProcessInterface> __when_expr_0 = retryBrokenPromise(process.getInterface, GetProcessInterfaceRequest{});
															#line 2384 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11631 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2384 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11636 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2363 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() != special_keys_api_failure().code())
															#line 11646 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "failed to parse key"));
															#line 2366 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11652 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2368 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11658 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(ProcessInterface const& p,int loopDepth) 
	{
															#line 2385 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = p;
															#line 2387 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ActorLineageRequest actorLineageRequest;
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateStart = waitStateStart;
															#line 2389 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateEnd = waitStateEnd;
															#line 2390 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeStart = timeStart;
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeEnd = timeEnd;
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ActorLineageReply> __when_expr_1 = process.actorLineage.getReply(actorLineageRequest);
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11700 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11705 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(ProcessInterface && p,int loopDepth) 
	{
															#line 2385 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = p;
															#line 2387 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ActorLineageRequest actorLineageRequest;
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateStart = waitStateStart;
															#line 2389 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateEnd = waitStateEnd;
															#line 2390 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeStart = timeStart;
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeEnd = timeEnd;
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ActorLineageReply> __when_expr_1 = process.actorLineage.getReply(actorLineageRequest);
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11728 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2392 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11733 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(ProcessInterface const& p,int loopDepth) 
	{
		loopDepth = a_body1cont11(p, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ProcessInterface && p,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(p), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<ActorLineageGetRangeActorActor*>(this)->ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >::remove();

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,ProcessInterface const& value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,ProcessInterface && value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,Error err) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11cont1(ActorLineageReply const& reply,int loopDepth) 
	{
															#line 2394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		time_t dt = 0;
															#line 2395 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int seq = -1;
															#line 2396 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& sample : reply.samples ) {
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			time_t datetime = (time_t)sample.time;
															#line 2398 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			char buf[50];
															#line 2399 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			struct tm* tm;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tm = localtime(&datetime);
															#line 2401 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			size_t size = strftime(buf, 50, "%FT%T%z", tm);
															#line 2402 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string date(buf, size);
															#line 2404 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			seq = dt == datetime ? seq + 1 : 0;
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			dt = datetime;
															#line 2407 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [waitState, data] : sample.data ) {
															#line 2408 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seq < seqStart)
															#line 11841 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
				else
				{
															#line 2410 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (seq >= seqEnd)
															#line 11849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
						break;
					}
				}
															#line 2414 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2415 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11858 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2416 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/" << to_string(waitState) << "/" << date;
															#line 11862 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11868 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2419 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/" << to_string(waitState);
															#line 11872 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2422 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 11878 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2426 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object_handle oh = msgpack::unpack(data.data(), data.size());
															#line 2427 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object deserialized = oh.get();
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream stream;
															#line 2430 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				stream << deserialized;
															#line 2432 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), stream.str()));
															#line 11893 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (sample.data.size() == 0)
															#line 11897 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2436 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2437 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11903 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/Running/" << date;
															#line 11907 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11913 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2441 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/Running";
															#line 11917 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2444 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 11923 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 2446 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), "{}"_sr));
															#line 11930 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 2451 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ActorLineageGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ActorLineageGetRangeActorActorState(); static_cast<ActorLineageGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 11935 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ActorLineageGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(ActorLineageReply && reply,int loopDepth) 
	{
															#line 2394 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		time_t dt = 0;
															#line 2395 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int seq = -1;
															#line 2396 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& sample : reply.samples ) {
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			time_t datetime = (time_t)sample.time;
															#line 2398 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			char buf[50];
															#line 2399 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			struct tm* tm;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tm = localtime(&datetime);
															#line 2401 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			size_t size = strftime(buf, 50, "%FT%T%z", tm);
															#line 2402 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string date(buf, size);
															#line 2404 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			seq = dt == datetime ? seq + 1 : 0;
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			dt = datetime;
															#line 2407 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [waitState, data] : sample.data ) {
															#line 2408 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seq < seqStart)
															#line 11971 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
					continue;
				}
				else
				{
															#line 2410 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (seq >= seqEnd)
															#line 11979 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
						break;
					}
				}
															#line 2414 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2415 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11988 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2416 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/" << to_string(waitState) << "/" << date;
															#line 11992 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11998 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2419 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/" << to_string(waitState);
															#line 12002 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2422 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 12008 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2426 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object_handle oh = msgpack::unpack(data.data(), data.size());
															#line 2427 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object deserialized = oh.get();
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream stream;
															#line 2430 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				stream << deserialized;
															#line 2432 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), stream.str()));
															#line 12023 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (sample.data.size() == 0)
															#line 12027 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2436 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2437 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 12033 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/Running/" << date;
															#line 12037 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 12043 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					{
															#line 2441 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/Running";
															#line 12047 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
					else
					{
															#line 2444 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 12053 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					}
				}
															#line 2446 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), "{}"_sr));
															#line 12060 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 2451 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ActorLineageGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ActorLineageGetRangeActorActorState(); static_cast<ActorLineageGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12065 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ActorLineageGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(ActorLineageReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ActorLineageReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<ActorLineageGetRangeActorActor*>(this)->ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >::remove();

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,ActorLineageReply const& value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,ActorLineageReply && value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,Error err) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2322 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2326 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NetworkAddress host;
															#line 2327 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WaitState waitStateStart;
															#line 2328 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WaitState waitStateEnd;
															#line 2329 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	time_t timeStart;
															#line 2330 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	time_t timeEnd;
															#line 2331 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int seqStart;
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int seqEnd;
															#line 2334 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<StringRef> beginValues;
															#line 2335 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<StringRef> endValues;
															#line 2343 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NetworkAddress endRangeHost;
															#line 2382 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessInterface process;
															#line 12178 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via actorLineageGetRangeActor()
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ActorLineageGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >, public ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >, public FastAllocated<ActorLineageGetRangeActorActor>, public ActorLineageGetRangeActorActorState<ActorLineageGetRangeActorActor> {
															#line 12183 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ActorLineageGetRangeActorActor>::operator new;
	using FastAllocated<ActorLineageGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1765398479022081280UL, 15614192932334842368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >;
friend struct ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ActorLineageGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 12201 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   ActorLineageGetRangeActorActorState<ActorLineageGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5704535707815985408UL, 4894892317905807872UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorLineageGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> actorLineageGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new ActorLineageGetRangeActorActor(ryw, prefix, kr));
															#line 12235 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2453 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> ActorLineageImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	return actorLineageGetRangeActor(ryw, getKeyRange().begin, kr);
}

namespace {
std::string_view to_string_view(StringRef sr) {
	return std::string_view(reinterpret_cast<const char*>(sr.begin()), sr.size());
}
} // namespace

ActorProfilerConf::ActorProfilerConf(KeyRangeRef kr)
  : SpecialKeyRangeRWImpl(kr), config(ProfilerConfig::instance().getConfig()) {}

Future<RangeResult> ActorProfilerConf::getRange(ReadYourWritesTransaction* ryw,
                                                KeyRangeRef kr,
                                                GetRangeLimits limitsHint) const {
	RangeResult res;
	std::string_view begin(to_string_view(kr.begin.removePrefix(range.begin))),
	    end(to_string_view(kr.end.removePrefix(range.begin)));
	for (auto& p : config) {
		if (p.first > end) {
			break;
		} else if (p.first > begin) {
			KeyValueRef kv;
			kv.key = StringRef(res.arena(), p.first).withPrefix(kr.begin, res.arena());
			kv.value = StringRef(res.arena(), p.second);
			res.push_back(res.arena(), kv);
		}
	}
	return res;
}

void ActorProfilerConf::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	config[key.removePrefix(range.begin).toString()] = value.toString();
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
	didWrite = true;
}

void ActorProfilerConf::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr) {
	std::string begin(kr.begin.removePrefix(range.begin).toString()), end(kr.end.removePrefix(range.begin).toString());
	auto first = config.lower_bound(begin);
	if (first == config.end()) {
		// nothing to clear
		return;
	}
	didWrite = true;
	auto last = config.upper_bound(end);
	config.erase(first, last);
}

void ActorProfilerConf::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	std::string k = key.removePrefix(range.begin).toString();
	auto iter = config.find(k);
	if (iter != config.end()) {
		config.erase(iter);
	}
	didWrite = true;
}

Future<Optional<std::string>> ActorProfilerConf::commit(ReadYourWritesTransaction* ryw) {
	Optional<std::string> res{};
	try {
		if (didWrite) {
			ProfilerConfig::instance().reset(config);
		}
		return res;
	} catch (ConfigError& err) {
		return Optional<std::string>{ err.description };
	}
}

MaintenanceImpl::MaintenanceImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Used to read the healthZoneKey
// If the key is persisted and the delayed read version is still larger than current read version,
// we will calculate the remaining time(truncated to integer, the same as fdbcli) and return back as the value
// If the zoneId is the special one `ignoreSSFailuresZoneString`,
// value will be 0 (same as fdbcli)
															#line 12320 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via MaintenanceGetRangeActor()
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MaintenanceGetRangeActorActor>
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceGetRangeActorActorState {
															#line 12327 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2537 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result()
															#line 12340 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~MaintenanceGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2539 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(healthyZoneKey);
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12361 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*>(static_cast<MaintenanceGetRangeActorActor*>(this)));
															#line 12366 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2542 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 12389 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2543 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(val.get());
															#line 2544 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if ((healthyZone.first == ignoreSSFailuresZoneString) || (healthyZone.second > ryw->getTransaction().getReadVersion().get()))
															#line 12395 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2546 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key zone_key = healthyZone.first.withPrefix(prefix);
															#line 2547 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				double seconds = healthyZone.first == ignoreSSFailuresZoneString ? 0 : (healthyZone.second - ryw->getTransaction().getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 2551 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(zone_key))
															#line 12403 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(zone_key, Value(boost::lexical_cast<std::string>(seconds))));
															#line 12407 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2557 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~MaintenanceGetRangeActorActorState(); static_cast<MaintenanceGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12413 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<MaintenanceGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2542 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 12425 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2543 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(val.get());
															#line 2544 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if ((healthyZone.first == ignoreSSFailuresZoneString) || (healthyZone.second > ryw->getTransaction().getReadVersion().get()))
															#line 12431 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2546 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key zone_key = healthyZone.first.withPrefix(prefix);
															#line 2547 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				double seconds = healthyZone.first == ignoreSSFailuresZoneString ? 0 : (healthyZone.second - ryw->getTransaction().getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 2551 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(zone_key))
															#line 12439 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2552 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(zone_key, Value(boost::lexical_cast<std::string>(seconds))));
															#line 12443 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2557 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~MaintenanceGetRangeActorActorState(); static_cast<MaintenanceGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12449 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<MaintenanceGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceGetRangeActorActor*>(this)->ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2537 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 12540 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via MaintenanceGetRangeActor()
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >, public FastAllocated<MaintenanceGetRangeActorActor>, public MaintenanceGetRangeActorActorState<MaintenanceGetRangeActorActor> {
															#line 12545 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<MaintenanceGetRangeActorActor>::operator new;
	using FastAllocated<MaintenanceGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17073350208013839872UL, 10802417507733571584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >;
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 12562 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   MaintenanceGetRangeActorActorState<MaintenanceGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16464056766269663232UL, 11056517360414997248UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("MaintenanceGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> MaintenanceGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new MaintenanceGetRangeActorActor(ryw, prefix, kr));
															#line 12595 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2559 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> MaintenanceImpl::getRange(ReadYourWritesTransaction* ryw,
                                              KeyRangeRef kr,
                                              GetRangeLimits limitsHint) const {
	return MaintenanceGetRangeActor(ryw, getKeyRange().begin, kr);
}

// Commit the change to healthZoneKey
// We do not allow more than one zone to be set in maintenance in one transaction
// In addition, if the zoneId now is 'ignoreSSFailuresZoneString',
// which means the data distribution is disabled for storage failures.
// Only clear this specific key is allowed, any other operations will throw error
															#line 12611 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via maintenanceCommitActor()
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MaintenanceCommitActorActor>
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceCommitActorActorState {
															#line 12618 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 12627 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("maintenanceCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~MaintenanceCommitActorActorState() 
	{
		fdb_probe_actor_destroy("maintenanceCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2573 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2574 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2575 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2576 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(healthyZoneKey);
															#line 2576 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12650 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2576 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*>(static_cast<MaintenanceCommitActorActor*>(this)));
															#line 12655 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2577 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<std::pair<Key, Version>> healthyZone = val.present() ? decodeHealthyZoneValue(val.get()) : Optional<std::pair<Key, Version>>();
															#line 2580 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
															#line 2582 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key zoneId;
															#line 2583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		double seconds;
															#line 2584 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool isSet = false;
															#line 2588 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(auto iter = ranges.begin();iter != ranges.end();++iter) {
															#line 2589 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!iter->value().first)
															#line 12690 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 2591 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter->value().second.present())
															#line 12696 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2592 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (isSet)
															#line 12700 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2593 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time"))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12704 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time")));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2595 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				isSet = true;
															#line 2596 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				zoneId = iter->begin().removePrefix(kr.begin);
															#line 2597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				seconds = boost::lexical_cast<double>(iter->value().second.get().toString());
															#line 12716 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2600 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!isSet && healthyZone.present() && iter.range().contains(healthyZone.get().first.withPrefix(kr.begin)))
															#line 12722 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2601 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().clear(healthyZoneKey);
															#line 12726 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2605 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (isSet)
															#line 12732 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2606 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (healthyZone.present() && healthyZone.get().first == ignoreSSFailuresZoneString)
															#line 12736 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2607 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string msg = "Maintenance mode cannot be used while data distribution is disabled for storage " "server failures.";
															#line 2609 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12742 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
				this->~MaintenanceCommitActorActorState();
				static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2610 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seconds < 0)
															#line 12752 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2611 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string msg = "The specified maintenance time " + boost::lexical_cast<std::string>(seconds) + " is a negative value";
															#line 2613 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12758 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2615 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevDebug, "SKSMaintenanceSet").detail("ZoneId", zoneId.toString());
															#line 2616 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(healthyZoneKey, healthyZoneValue(zoneId, ryw->getTransaction().getReadVersion().get() + (seconds * CLIENT_KNOBS->CORE_VERSIONSPERSECOND)));
															#line 12770 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2622 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12776 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2577 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<std::pair<Key, Version>> healthyZone = val.present() ? decodeHealthyZoneValue(val.get()) : Optional<std::pair<Key, Version>>();
															#line 2580 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
															#line 2582 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key zoneId;
															#line 2583 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		double seconds;
															#line 2584 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool isSet = false;
															#line 2588 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(auto iter = ranges.begin();iter != ranges.end();++iter) {
															#line 2589 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!iter->value().first)
															#line 12800 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 2591 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter->value().second.present())
															#line 12806 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2592 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (isSet)
															#line 12810 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2593 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time"))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12814 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time")));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2595 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				isSet = true;
															#line 2596 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				zoneId = iter->begin().removePrefix(kr.begin);
															#line 2597 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				seconds = boost::lexical_cast<double>(iter->value().second.get().toString());
															#line 12826 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2600 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!isSet && healthyZone.present() && iter.range().contains(healthyZone.get().first.withPrefix(kr.begin)))
															#line 12832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2601 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().clear(healthyZoneKey);
															#line 12836 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2605 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (isSet)
															#line 12842 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2606 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (healthyZone.present() && healthyZone.get().first == ignoreSSFailuresZoneString)
															#line 12846 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2607 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string msg = "Maintenance mode cannot be used while data distribution is disabled for storage " "server failures.";
															#line 2609 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12852 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
				this->~MaintenanceCommitActorActorState();
				static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2610 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seconds < 0)
															#line 12862 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2611 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string msg = "The specified maintenance time " + boost::lexical_cast<std::string>(seconds) + " is a negative value";
															#line 2613 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12868 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2615 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevDebug, "SKSMaintenanceSet").detail("ZoneId", zoneId.toString());
															#line 2616 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(healthyZoneKey, healthyZoneValue(zoneId, ryw->getTransaction().getReadVersion().get() + (seconds * CLIENT_KNOBS->CORE_VERSIONSPERSECOND)));
															#line 12880 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2622 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12886 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceCommitActorActor*>(this)->ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2580 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 12975 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via maintenanceCommitActor()
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >, public FastAllocated<MaintenanceCommitActorActor>, public MaintenanceCommitActorActorState<MaintenanceCommitActorActor> {
															#line 12980 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<MaintenanceCommitActorActor>::operator new;
	using FastAllocated<MaintenanceCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10217090109717635584UL, 14513151188216987136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >;
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 12997 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   MaintenanceCommitActorActorState<MaintenanceCommitActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10112509306944654592UL, 3774263305590945024UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maintenanceCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> maintenanceCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2571 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new MaintenanceCommitActorActor(ryw, kr));
															#line 13030 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2624 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> MaintenanceImpl::commit(ReadYourWritesTransaction* ryw) {
	return maintenanceCommitActor(ryw, getKeyRange());
}

DataDistributionImpl::DataDistributionImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Read the system keys dataDistributionModeKey and rebalanceDDIgnoreKey
															#line 13042 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via DataDistributionGetRangeActor()
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class DataDistributionGetRangeActorActor>
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DataDistributionGetRangeActorActorState {
															#line 13049 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DataDistributionGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2635 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2637 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   modeKey("mode"_sr.withPrefix(prefix))
															#line 13064 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~DataDistributionGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2639 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2641 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(modeKey))
															#line 13081 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2642 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto entry = ryw->getSpecialKeySpaceWriteMap()[modeKey];
															#line 2643 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (ryw->readYourWritesDisabled() || !entry.first)
															#line 13087 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2644 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(dataDistributionModeKey);
															#line 2644 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13093 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2644 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*>(static_cast<DataDistributionGetRangeActorActor*>(this)));
															#line 13098 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataDistributionGetRangeActorActorState();
		static_cast<DataDistributionGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2653 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		rebalanceIgnoredKey = "rebalance_ignored"_sr.withPrefix(prefix);
															#line 2654 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(rebalanceIgnoredKey))
															#line 13133 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2655 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = ryw->getSpecialKeySpaceWriteMap()[rebalanceIgnoredKey];
															#line 2656 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->readYourWritesDisabled() || !entry.first)
															#line 13139 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2657 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_1 = ryw->getTransaction().get(rebalanceDDIgnoreKey);
															#line 2657 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13145 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2657 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*>(static_cast<DataDistributionGetRangeActorActor*>(this)));
															#line 13150 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont7(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& f,int loopDepth) 
	{
															#line 2645 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int mode = -1;
															#line 2646 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13177 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2647 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			mode = BinaryReader::fromStringRef<int>(f.get(), Unversioned());
															#line 13181 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2649 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.push_back_deep(result.arena(), KeyValueRef(modeKey, Value(boost::lexical_cast<std::string>(mode))));
															#line 13185 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && f,int loopDepth) 
	{
															#line 2645 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int mode = -1;
															#line 2646 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13196 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2647 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			mode = BinaryReader::fromStringRef<int>(f.get(), Unversioned());
															#line 13200 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 2649 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.push_back_deep(result.arena(), KeyValueRef(modeKey, Value(boost::lexical_cast<std::string>(mode))));
															#line 13204 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionGetRangeActorActor*>(this)->ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2663 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DataDistributionGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~DataDistributionGetRangeActorActorState(); static_cast<DataDistributionGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 13288 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<DataDistributionGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~DataDistributionGetRangeActorActorState();
		static_cast<DataDistributionGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> const& f,int loopDepth) 
	{
															#line 2658 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13306 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2659 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(rebalanceIgnoredKey, Value()));
															#line 13310 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && f,int loopDepth) 
	{
															#line 2658 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13320 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2659 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(rebalanceIgnoredKey, Value()));
															#line 13324 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont8(f, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionGetRangeActorActor*>(this)->ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2635 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2637 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key modeKey;
															#line 2653 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key rebalanceIgnoredKey;
															#line 13417 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via DataDistributionGetRangeActor()
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DataDistributionGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >, public ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >, public FastAllocated<DataDistributionGetRangeActorActor>, public DataDistributionGetRangeActorActorState<DataDistributionGetRangeActorActor> {
															#line 13422 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<DataDistributionGetRangeActorActor>::operator new;
	using FastAllocated<DataDistributionGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2706369258263927552UL, 10703953784491330304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >;
friend struct ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >;
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DataDistributionGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 13440 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   DataDistributionGetRangeActorActorState<DataDistributionGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2365075205275177216UL, 1751127139512214016UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("DataDistributionGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> DataDistributionGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2632 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new DataDistributionGetRangeActorActor(ryw, prefix, kr));
															#line 13474 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2665 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> DataDistributionImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	return DataDistributionGetRangeActor(ryw, getKeyRange().begin, kr);
}

Future<Optional<std::string>> DataDistributionImpl::commit(ReadYourWritesTransaction* ryw) {
	// there are two valid keys in the range
	// <prefix>/mode -> dataDistributionModeKey, the value is only allowed to be set as "0"(disable) or "1"(enable)
	// <prefix>/rebalance_ignored -> rebalanceDDIgnoreKey, value is unused thus empty
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	Optional<std::string> msg;
	KeyRangeRef kr = getKeyRange();
	Key modeKey = "mode"_sr.withPrefix(kr.begin);
	Key rebalanceIgnoredKey = "rebalance_ignored"_sr.withPrefix(kr.begin);
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
	for (auto iter = ranges.begin(); iter != ranges.end(); ++iter) {
		if (!iter->value().first)
			continue;
		if (iter->value().second.present()) {
			if (iter->range() == singleKeyRange(modeKey)) {
				try {
					int mode = boost::lexical_cast<int>(iter->value().second.get().toString());
					Value modeVal = BinaryWriter::toValue(mode, Unversioned());
					if (mode == 0 || mode == 1 || mode == 2) {
						// Whenever configuration changes or DD related system keyspace is changed,
						// actor must grab the moveKeysLockOwnerKey and update moveKeysLockWriteKey.
						// This prevents concurrent write to the same system keyspace.
						// When the owner of the DD related system keyspace changes, DD will reboot
						BinaryWriter wrMyOwner(Unversioned());
						wrMyOwner << dataDistributionModeLock;
						ryw->getTransaction().set(moveKeysLockOwnerKey, wrMyOwner.toValue());
						BinaryWriter wrLastWrite(Unversioned());
						wrLastWrite << deterministicRandom()->randomUniqueID();
						ryw->getTransaction().set(moveKeysLockWriteKey, wrLastWrite.toValue());
						// set mode
						ryw->getTransaction().set(dataDistributionModeKey, modeVal);
					} else
						msg = ManagementAPIError::toJsonString(false,
						                                       "datadistribution",
						                                       "Please set the value of the data_distribution/mode to "
						                                       "0(disable) or 1(enable), other values are not allowed");
				} catch (boost::bad_lexical_cast& e) {
					msg = ManagementAPIError::toJsonString(false,
					                                       "datadistribution",
					                                       "Invalid datadistribution mode(int): " +
					                                           iter->value().second.get().toString());
				}
			} else if (iter->range() == singleKeyRange(rebalanceIgnoredKey)) {
				ValueRef val = iter->value().second.get();
				try {
					boost::lexical_cast<int>(iter->value().second.get().toString());
				} catch (boost::bad_lexical_cast& e) {
					ManagementAPIError::toJsonString(
					    false,
					    "datadistribution",
					    "Invalid datadistribution rebalance ignore option (int or empty): " +
					        iter->value().second.get().toString());
					val = ""_sr;
				}
				ryw->getTransaction().set(rebalanceDDIgnoreKey, iter->value().second.get());
			} else {
				msg = ManagementAPIError::toJsonString(
				    false,
				    "datadistribution",
				    "Changing invalid keys, please read the documentation to check valid keys in the range");
			}
		} else {
			// clear
			if (iter->range().contains(modeKey))
				ryw->getTransaction().clear(dataDistributionModeKey);
			else if (iter->range().contains(rebalanceIgnoredKey))
				ryw->getTransaction().clear(rebalanceDDIgnoreKey);
		}
	}
	return msg;
}

// Clears the special management api keys excludeLocality and failedLocality.
void includeLocalities(ReadYourWritesTransaction* ryw) {
	ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
	// includeLocalities might be used in an emergency transaction, so make sure it is retry-self-conflicting and
	// CAUSAL_WRITE_RISKY
	ryw->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
	std::string versionKey = deterministicRandom()->randomUniqueID().toString();
	// for excluded localities
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(
	    SpecialKeySpace::getManagementApiCommandRange("excludedlocality"));
	Transaction& tr = ryw->getTransaction();
	for (auto& iter : ranges) {
		auto entry = iter.value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(excludedLocalityVersionKey));
			tr.set(excludedLocalityVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter.range()));
		}
	}
	// for failed localities
	ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(
	    SpecialKeySpace::getManagementApiCommandRange("failedlocality"));
	for (auto& iter : ranges) {
		auto entry = iter.value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(failedLocalityVersionKey));
			tr.set(failedLocalityVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter.range()));
		}
	}
}

// Reads the excludedlocality and failed locality keys using management api,
// parses them and returns the list.
bool parseLocalitiesFromKeys(ReadYourWritesTransaction* ryw,
                             bool failed,
                             std::unordered_set<std::string>& localities,
                             Optional<std::string>& msg) {
	KeyRangeRef range = failed ? SpecialKeySpace::getManagementApiCommandRange("failedlocality")
	                           : SpecialKeySpace::getManagementApiCommandRange("excludedlocality");
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for exclude(set) operation, include(clear) are not checked
		TraceEvent(SevDebug, "ParseLocalities")
		    .detail("Valid", entry.first)
		    .detail("Set", entry.second.present())
		    .detail("Key", iter->begin().toString());
		if (entry.first && entry.second.present()) {
			Key locality = iter->begin().removePrefix(range.begin);
			if (locality.startsWith(LocalityData::ExcludeLocalityPrefix) &&
			    locality.toString().find(':') != std::string::npos) {
				localities.insert(locality.toString());
			} else {
				std::string error = "ERROR: \'" + locality.toString() + "\' is not a valid locality\n";
				msg = ManagementAPIError::toJsonString(
				    false, entry.second.present() ? (failed ? "exclude failed" : "exclude") : "include", error);
				return false;
			}
		}
		++iter;
	}
	return true;
}

// On commit, parses the special exclusion keys and get the localities to be excluded, check for exclusions
// and add them to the exclusion list. Also, clears the special management api keys with includeLocalities.
															#line 13629 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via excludeLocalityCommitActor()
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExcludeLocalityCommitActorActor>
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeLocalityCommitActorActorState {
															#line 13636 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeLocalityCommitActorActorState(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   failed(failed),
															#line 2817 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2818 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities(),
															#line 2819 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(),
															#line 2820 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions()
															#line 13653 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeLocalityCommitActorActorState() 
	{
		fdb_probe_actor_destroy("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2822 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2823 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2824 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2830 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!parseLocalitiesFromKeys(ryw, failed, localities, result))
															#line 13674 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2831 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13678 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
				this->~ExcludeLocalityCommitActorActorState();
				static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2833 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto force = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( failed ? "failed_locality" : "excluded_locality", "force")];
															#line 2836 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (localities.size() && !(force.first && force.second.present()))
															#line 13688 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2837 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_0 = checkExclusion(ryw->getDatabase(), addresses, exclusions, localities, failed, &result);
															#line 2837 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13694 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2837 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*>(static_cast<ExcludeLocalityCommitActorActor*>(this)));
															#line 13699 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = excludeLocalities(&ryw->getTransaction(), localities, failed);
															#line 2842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13729 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2842 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*>(static_cast<ExcludeLocalityCommitActorActor*>(this)));
															#line 13734 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& safe,int loopDepth) 
	{
															#line 2838 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 13743 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13747 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeLocalityCommitActorActorState();
			static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && safe,int loopDepth) 
	{
															#line 2838 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 13761 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2839 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13765 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeLocalityCommitActorActorState();
			static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(safe, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeLocalityCommitActorActor*>(this)->ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2843 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeLocalities(ryw);
															#line 2845 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13856 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2843 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeLocalities(ryw);
															#line 2845 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13870 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeLocalityCommitActorActor*>(this)->ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool failed;
															#line 2817 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> result;
															#line 2818 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 2819 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 2820 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 13965 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via excludeLocalityCommitActor()
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeLocalityCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >, public ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >, public FastAllocated<ExcludeLocalityCommitActorActor>, public ExcludeLocalityCommitActorActorState<ExcludeLocalityCommitActorActor> {
															#line 13970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExcludeLocalityCommitActorActor>::operator new;
	using FastAllocated<ExcludeLocalityCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6404336792059175680UL, 15722478357516486656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >;
friend struct ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >;
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeLocalityCommitActorActor(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 13988 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   ExcludeLocalityCommitActorActorState<ExcludeLocalityCommitActorActor>(ryw, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11551239430571558400UL, 17348860154491991296UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeLocalityCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> excludeLocalityCommitActor( ReadYourWritesTransaction* const& ryw, bool const& failed ) {
															#line 2816 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ExcludeLocalityCommitActorActor(ryw, failed));
															#line 14022 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2847 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExcludedLocalitiesRangeImpl::ExcludedLocalitiesRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ExcludedLocalitiesRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                          KeyRangeRef kr,
                                                          GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void ExcludedLocalitiesRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key ExcludedLocalitiesRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key ExcludedLocalitiesRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> ExcludedLocalitiesRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// exclude locality with failed option as false.
	return excludeLocalityCommitActor(ryw, false);
}

FailedLocalitiesRangeImpl::FailedLocalitiesRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> FailedLocalitiesRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                        KeyRangeRef kr,
                                                        GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void FailedLocalitiesRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key FailedLocalitiesRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key FailedLocalitiesRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> FailedLocalitiesRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// exclude locality with failed option as true.
	return excludeLocalityCommitActor(ryw, true);
}

// Defined in ReadYourWrites.actor.cpp
															#line 14086 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
[[nodiscard]] Future<RangeResult> getWorkerInterfaces( Reference<IClusterConnectionRecord> const& clusterRecord );

#line 2908 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
// Defined in NativeAPI.actor.cpp
															#line 14091 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
[[nodiscard]] Future<bool> verifyInterfaceActor( Reference<FlowLock> const& connectLock, ClientWorkerInterface const& workerInterf );

#line 2910 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 14096 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerInterfacesImplGetRangeActor()
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class WorkerInterfacesImplGetRangeActorActor>
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class WorkerInterfacesImplGetRangeActorActorState {
															#line 14103 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WorkerInterfacesImplGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 14114 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~WorkerInterfacesImplGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2914 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!ryw->getDatabase().getPtr() || !ryw->getDatabase()->getConnectionRecord())
															#line 14129 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2915 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResult()); this->~WorkerInterfacesImplGetRangeActorActorState(); static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 14133 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				new (&static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResult());
				this->~WorkerInterfacesImplGetRangeActorActorState();
				static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2917 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = getWorkerInterfaces(ryw->getDatabase()->getConnectionRecord());
															#line 2917 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14143 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2917 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*>(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)));
															#line 14148 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerInterfacesImplGetRangeActorActorState();
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2919 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto [verify, _] = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( "worker_interfaces", "verify")];
															#line 2921 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = RangeResult();
															#line 2922 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (verify)
															#line 14175 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2924 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Reference<FlowLock> connectLock(new FlowLock(CLIENT_KNOBS->CLI_CONNECT_PARALLELISM));
															#line 2925 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			verifyInterfs = std::vector<Future<bool>>();
															#line 2926 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [k_, value] : interfs ) {
															#line 2927 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto k = k_.withPrefix(prefix);
															#line 2928 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(k))
															#line 14187 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2929 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ClientWorkerInterface workerInterf = BinaryReader::fromStringRef<ClientWorkerInterface>(value, IncludeVersion());
															#line 2931 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					verifyInterfs.push_back(verifyInterfaceActor(connectLock, workerInterf));
															#line 14193 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2933 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					verifyInterfs.push_back(false);
															#line 14199 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
															#line 2936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(verifyInterfs);
															#line 2936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14206 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2936 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*>(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)));
															#line 14211 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2946 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [k_, v] : interfs ) {
															#line 2947 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto k = k_.withPrefix(prefix);
															#line 2948 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(k))
															#line 14222 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 2949 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(k, v));
															#line 14226 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __interfs,int loopDepth) 
	{
															#line 2917 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		interfs = __interfs;
															#line 14238 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __interfs,int loopDepth) 
	{
		interfs = std::move(__interfs);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2952 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(result.begin(), result.end(), KeyValueRef::OrderByKey{});
															#line 2953 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~WorkerInterfacesImplGetRangeActorActorState(); static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 14319 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~WorkerInterfacesImplGetRangeActorActorState();
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2938 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int index = 0;index < interfs.size();index++) {
															#line 2939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (verifyInterfs[index].get())
															#line 14333 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2941 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(interfs[index].key.withPrefix(prefix), interfs[index].value));
															#line 14337 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2938 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int index = 0;index < interfs.size();index++) {
															#line 2939 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (verifyInterfs[index].get())
															#line 14350 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2941 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(interfs[index].key.withPrefix(prefix), interfs[index].value));
															#line 14354 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2917 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult interfs;
															#line 2921 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2925 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<Future<bool>> verifyInterfs;
															#line 14448 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerInterfacesImplGetRangeActor()
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class WorkerInterfacesImplGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >, public ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >, public FastAllocated<WorkerInterfacesImplGetRangeActorActor>, public WorkerInterfacesImplGetRangeActorActorState<WorkerInterfacesImplGetRangeActorActor> {
															#line 14453 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerInterfacesImplGetRangeActorActor>::operator new;
	using FastAllocated<WorkerInterfacesImplGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7575725488602693888UL, 6261708678300156672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >;
friend struct ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >;
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WorkerInterfacesImplGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 14471 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   WorkerInterfacesImplGetRangeActorActorState<WorkerInterfacesImplGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9308834139300597760UL, 12982850668395028224UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerInterfacesImplGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> workerInterfacesImplGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2911 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new WorkerInterfacesImplGetRangeActorActor(ryw, prefix, kr));
															#line 14505 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2955 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

WorkerInterfacesSpecialKeyImpl::WorkerInterfacesSpecialKeyImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> WorkerInterfacesSpecialKeyImpl::getRange(ReadYourWritesTransaction* ryw,
                                                             KeyRangeRef kr,
                                                             GetRangeLimits limitsHint) const {
	return workerInterfacesImplGetRangeActor(ryw, getKeyRange().begin, kr);
}

															#line 14518 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
[[nodiscard]] Future<Optional<Value>> getJSON( Database const& db, std::string const& jsonField = "" );

#line 2965 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 14523 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via FaultToleranceMetricsImplActor()
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class FaultToleranceMetricsImplActorActor>
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class FaultToleranceMetricsImplActorActorState {
															#line 14530 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	FaultToleranceMetricsImplActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   res()
															#line 14541 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this));

	}
	~FaultToleranceMetricsImplActorActorState() 
	{
		fdb_probe_actor_destroy("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2968 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->getDatabase().getPtr() && ryw->getDatabase()->getConnectionRecord())
															#line 14556 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2969 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = getJSON(ryw->getDatabase(), "fault_tolerance");
															#line 2969 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14562 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state = 1;
															#line 2969 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*>(static_cast<FaultToleranceMetricsImplActorActor*>(this)));
															#line 14567 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FaultToleranceMetricsImplActorActorState();
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2974 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<FaultToleranceMetricsImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~FaultToleranceMetricsImplActorActorState(); static_cast<FaultToleranceMetricsImplActorActor*>(this)->destroy(); return 0; }
															#line 14595 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<FaultToleranceMetricsImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~FaultToleranceMetricsImplActorActorState();
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 2970 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 14607 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2971 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			res.push_back_deep(res.arena(), KeyValueRef(kr.begin, val.get()));
															#line 14611 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 2970 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 14621 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 2971 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			res.push_back_deep(res.arena(), KeyValueRef(kr.begin, val.get()));
															#line 14625 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state > 0) static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2967 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult res;
															#line 14712 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via FaultToleranceMetricsImplActor()
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class FaultToleranceMetricsImplActorActor final : public Actor<RangeResult>, public ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >, public FastAllocated<FaultToleranceMetricsImplActorActor>, public FaultToleranceMetricsImplActorActorState<FaultToleranceMetricsImplActorActor> {
															#line 14717 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<FaultToleranceMetricsImplActorActor>::operator new;
	using FastAllocated<FaultToleranceMetricsImplActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13956984830814683648UL, 13988216617448002560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >;
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	FaultToleranceMetricsImplActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 14734 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<RangeResult>(),
		   FaultToleranceMetricsImplActorActorState<FaultToleranceMetricsImplActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16663529165361424896UL, 2276141065095804672UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("FaultToleranceMetricsImplActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> FaultToleranceMetricsImplActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2966 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new FaultToleranceMetricsImplActorActor(ryw, kr));
															#line 14767 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 2976 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

FaultToleranceMetricsImpl::FaultToleranceMetricsImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> FaultToleranceMetricsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                        KeyRangeRef kr,
                                                        GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	return FaultToleranceMetricsImplActor(ryw, kr);
}

															#line 14782 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via validateSpecialSubrangeRead()
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ValidateSpecialSubrangeReadActor>
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ValidateSpecialSubrangeReadActorState {
															#line 14789 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ValidateSpecialSubrangeReadActorState(ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse,RangeResult const& result) 
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse),
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(result)
															#line 14806 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this));

	}
	~ValidateSpecialSubrangeReadActorState() 
	{
		fdb_probe_actor_destroy("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2993 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!result.size())
															#line 14821 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 2994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = ryw->getRange(begin, end, limits, Snapshot::True, reverse);
															#line 2994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14827 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 1;
															#line 2994 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*>(static_cast<ValidateSpecialSubrangeReadActor*>(this)));
															#line 14832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2999 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 14860 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 3000 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(std::is_sorted(result.begin(), result.end(), KeyValueRef::OrderByKeyBack{}));
															#line 14864 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
		else
		{
															#line 3002 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(std::is_sorted(result.begin(), result.end(), KeyValueRef::OrderByKey{}));
															#line 14870 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 3007 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::vector<Key> candidateKeys;
															#line 3008 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 14876 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 3009 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = result.size() - 1;i >= 0;--i) {
															#line 3010 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				candidateKeys.emplace_back(result[i].key);
															#line 3011 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (i - 1 >= 0)
															#line 14884 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 3012 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					candidateKeys.emplace_back(keyBetween(KeyRangeRef(result[i].key, result[i - 1].key)));
															#line 14888 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 3016 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < result.size();++i) {
															#line 3017 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				candidateKeys.emplace_back(result[i].key);
															#line 3018 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (i + 1 < result.size())
															#line 14900 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				{
															#line 3019 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					candidateKeys.emplace_back(keyBetween(KeyRangeRef(result[i].key, result[i + 1].key)));
															#line 14904 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
				}
			}
		}
															#line 3023 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(candidateKeys.begin(), candidateKeys.end());
															#line 3024 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int originalSize = candidateKeys.size();
															#line 3026 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = 0;i < originalSize - 1;++i) {
															#line 3027 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			candidateKeys.emplace_back(keyBetween(KeyRangeRef(candidateKeys[i], candidateKeys[i + 1])));
															#line 14916 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 3029 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::vector<Key> keys;
															#line 3030 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		keys = { deterministicRandom()->randomChoice(candidateKeys), deterministicRandom()->randomChoice(candidateKeys) };
															#line 3031 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(keys.begin(), keys.end());
															#line 3032 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		testBegin = firstGreaterOrEqual(keys[0]);
															#line 3033 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		testEnd = firstGreaterOrEqual(keys[1]);
															#line 3037 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		expectedResult = RangeResult();
															#line 3040 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& kr : result ) {
															#line 3041 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.key >= keys[0] && kr.key < keys[1])
															#line 14934 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			{
															#line 3042 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				expectedResult.push_back(expectedResult.arena(), kr);
															#line 14938 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
		}
															#line 3047 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = ryw->getRange(testBegin, testEnd, limits, Snapshot::True, reverse);
															#line 3047 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14945 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 2;
															#line 3047 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*>(static_cast<ValidateSpecialSubrangeReadActor*>(this)));
															#line 14950 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& testResult,int loopDepth) 
	{
															#line 2995 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(testResult == result);
															#line 2996 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 14961 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && testResult,int loopDepth) 
	{
															#line 2995 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(testResult == result);
															#line 2996 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 14975 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& testResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(testResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && testResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(testResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state > 0) static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(RangeResult const& testResult,int loopDepth) 
	{
															#line 3048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (testResult != expectedResult)
															#line 15062 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 3049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Reverse: {}\n", static_cast<bool>(reverse));
															#line 3050 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original range: [{}, {})\n", begin.toString(), end.toString());
															#line 3051 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original result:\n");
															#line 3052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : result ) {
															#line 3053 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15074 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3055 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Test range: [{}, {})\n", testBegin.getKey().printable(), testEnd.getKey().printable());
															#line 3056 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Expected:\n");
															#line 3057 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : expectedResult ) {
															#line 3058 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15084 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3060 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Got:\n");
															#line 3061 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : testResult ) {
															#line 3062 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15092 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3064 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(testResult == expectedResult);
															#line 15096 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 3066 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15100 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(RangeResult && testResult,int loopDepth) 
	{
															#line 3048 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (testResult != expectedResult)
															#line 15112 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		{
															#line 3049 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Reverse: {}\n", static_cast<bool>(reverse));
															#line 3050 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original range: [{}, {})\n", begin.toString(), end.toString());
															#line 3051 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original result:\n");
															#line 3052 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : result ) {
															#line 3053 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15124 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3055 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Test range: [{}, {})\n", testBegin.getKey().printable(), testEnd.getKey().printable());
															#line 3056 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Expected:\n");
															#line 3057 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : expectedResult ) {
															#line 3058 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15134 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3060 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Got:\n");
															#line 3061 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : testResult ) {
															#line 3062 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15142 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
			}
															#line 3064 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(testResult == expectedResult);
															#line 15146 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		}
															#line 3066 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15150 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& testResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(testResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && testResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(testResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state > 0) static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 3032 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector testBegin;
															#line 3033 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector testEnd;
															#line 3037 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult expectedResult;
															#line 15251 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
};
// This generated class is to be used only via validateSpecialSubrangeRead()
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ValidateSpecialSubrangeReadActor final : public Actor<Void>, public ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >, public ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >, public FastAllocated<ValidateSpecialSubrangeReadActor>, public ValidateSpecialSubrangeReadActorState<ValidateSpecialSubrangeReadActor> {
															#line 15256 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
public:
	using FastAllocated<ValidateSpecialSubrangeReadActor>::operator new;
	using FastAllocated<ValidateSpecialSubrangeReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9460136114796665600UL, 13562880488458696192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >;
friend struct ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >;
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ValidateSpecialSubrangeReadActor(ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse,RangeResult const& result) 
															#line 15274 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ValidateSpecialSubrangeReadActorState<ValidateSpecialSubrangeReadActor>(ryw, begin, end, limits, reverse, result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9908613209698180352UL, 4450646321188080896UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateSpecialSubrangeRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> validateSpecialSubrangeRead( ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse, RangeResult const& result ) {
															#line 2987 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new ValidateSpecialSubrangeReadActor(ryw, begin, end, limits, reverse, result));
															#line 15308 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/SpecialKeySpace.actor.g.cpp.py_gen"
}

#line 3068 "/Users/ec2-user/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
