#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
/*
 * IdempotencyId.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/IdempotencyId.actor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "flow/BooleanParam.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // this has to be the last include

struct IdempotencyIdKVBuilderImpl {
	Optional<Version> commitVersion;
	Optional<uint8_t> batchIndexHighOrderByte;
	BinaryWriter value{ IncludeVersion() };
};

IdempotencyIdKVBuilder::IdempotencyIdKVBuilder() : impl(PImpl<IdempotencyIdKVBuilderImpl>::create()) {}

void IdempotencyIdKVBuilder::setCommitVersion(Version commitVersion) {
	impl->commitVersion = commitVersion;
}

void IdempotencyIdKVBuilder::add(const IdempotencyIdRef& id, uint16_t batchIndex) {
	ASSERT(id.valid());
	if (impl->batchIndexHighOrderByte.present()) {
		ASSERT((batchIndex >> 8) == impl->batchIndexHighOrderByte.get());
	} else {
		impl->batchIndexHighOrderByte = batchIndex >> 8;
		impl->value << int64_t(now());
	}
	StringRef s = id.asStringRefUnsafe();
	impl->value << uint8_t(s.size());
	impl->value.serializeBytes(s);
	impl->value << uint8_t(batchIndex); // Low order byte of batchIndex
}

Optional<KeyValue> IdempotencyIdKVBuilder::buildAndClear() {
	ASSERT(impl->commitVersion.present());
	if (!impl->batchIndexHighOrderByte.present()) {
		return {};
	}

	Value v = impl->value.toValue();

	KeyRef key =
	    makeIdempotencySingleKeyRange(v.arena(), impl->commitVersion.get(), impl->batchIndexHighOrderByte.get()).begin;

	impl->value = BinaryWriter(IncludeVersion());
	impl->batchIndexHighOrderByte = Optional<uint8_t>();

	Optional<KeyValue> result = KeyValue();
	result.get().arena() = v.arena();
	result.get().key = key;
	result.get().value = v;
	return result;
}

IdempotencyIdKVBuilder::~IdempotencyIdKVBuilder() = default;

Optional<CommitResult> kvContainsIdempotencyId(const KeyValueRef& kv, const IdempotencyIdRef& id) {
	ASSERT(id.valid());
	StringRef needle = id.asStringRefUnsafe();
	StringRef haystack = kv.value;

#ifndef _WIN32
	// The common case is that the kv does not contain the idempotency id, so early return if memmem is available
	if (memmem(haystack.begin(), haystack.size(), needle.begin(), needle.size()) == nullptr) {
		return {};
	}
#endif

	// Even if id is a substring of value, it may still not actually contain it.
	BinaryReader reader(kv.value.begin(), kv.value.size(), IncludeVersion());
	int64_t timestamp; // ignored
	reader >> timestamp;
	while (!reader.empty()) {
		uint8_t length;
		reader >> length;
		StringRef candidate{ reinterpret_cast<const uint8_t*>(reader.readBytes(length)), length };
		uint8_t lowOrderBatchIndex;
		reader >> lowOrderBatchIndex;
		if (candidate == needle) {
			Version commitVersion;
			uint8_t highOrderBatchIndex;
			decodeIdempotencyKey(kv.key, commitVersion, highOrderBatchIndex);
			return CommitResult{ commitVersion,
				                 static_cast<uint16_t>((uint16_t(highOrderBatchIndex) << 8) |
				                                       uint16_t(lowOrderBatchIndex)) };
		}
	}
	return {};
}

void forceLinkIdempotencyIdTests() {}

namespace {
IdempotencyIdRef generate(Arena& arena) {
	int length = deterministicRandom()->coinflip() ? deterministicRandom()->randomInt(16, 256) : 16;
	StringRef id = makeString(length, arena);
	deterministicRandom()->randomBytes(mutateString(id), length);
	return IdempotencyIdRef(id);
}
} // namespace

															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase123()
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
template <class FlowTestCase123Actor>
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class FlowTestCase123ActorState {
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	FlowTestCase123ActorState(UnitTestParameters const& params) 
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		 : params(params)
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase123", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase123ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase123", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			Arena arena;
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			uint16_t firstBatchIndex = deterministicRandom()->randomUInt32();
															#line 126 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			firstBatchIndex &= 0xff7f;
															#line 127 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			uint16_t batchIndex = firstBatchIndex;
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			Version commitVersion = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max());
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			std::vector<IdempotencyIdRef> idVector;
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			std::unordered_set<IdempotencyIdRef> idSet;
															#line 131 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			IdempotencyIdKVBuilder builder;
															#line 132 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			builder.setCommitVersion(commitVersion);
															#line 134 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			for(int i = 0;i < 5;++i) {
															#line 135 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				auto id = generate(arena);
															#line 136 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				idVector.emplace_back(id);
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				idSet.emplace(id);
															#line 138 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				builder.add(id, batchIndex++);
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			}
															#line 141 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			batchIndex = firstBatchIndex;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			Optional<KeyValue> kvOpt = builder.buildAndClear();
															#line 143 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			ASSERT(kvOpt.present());
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			const auto& kv = kvOpt.get();
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			ASSERT(idSet.size() == idVector.size());
															#line 147 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			for( const auto& id : idVector ) {
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				auto commitResult = kvContainsIdempotencyId(kv, id);
															#line 149 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(commitResult.present());
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(commitResult.get().commitVersion == commitVersion);
															#line 151 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(commitResult.get().batchIndex == batchIndex++);
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(idSet.find(id) != idSet.end());
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				idSet.erase(id);
															#line 154 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(idSet.find(id) == idSet.end());
															#line 208 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			}
															#line 156 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			ASSERT(idSet.size() == 0);
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			ASSERT(!kvContainsIdempotencyId(kv, generate(arena)).present());
															#line 160 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (!static_cast<FlowTestCase123Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase123ActorState(); static_cast<FlowTestCase123Actor*>(this)->destroy(); return 0; }
															#line 216 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase123Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase123ActorState();
			static_cast<FlowTestCase123Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase123ActorState();
		static_cast<FlowTestCase123Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	UnitTestParameters params;
															#line 240 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase123()
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class FlowTestCase123Actor final : public Actor<Void>, public FastAllocated<FlowTestCase123Actor>, public FlowTestCase123ActorState<FlowTestCase123Actor> {
															#line 245 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase123Actor>::operator new;
	using FastAllocated<FlowTestCase123Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14986125102012091136UL, 211998034605419776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	FlowTestCase123Actor(UnitTestParameters const& params) 
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase123ActorState<FlowTestCase123Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase123", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1348267762950107392UL, 9207433820124294656UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase123Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase123");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase123", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
static Future<Void> flowTestCase123( UnitTestParameters const& params ) {
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	return Future<Void>(new FlowTestCase123Actor(params));
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase123, "/fdbclient/IdempotencyId/basic")

#line 162 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"

															#line 299 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase163()
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
template <class FlowTestCase163Actor>
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class FlowTestCase163ActorState {
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	FlowTestCase163ActorState(UnitTestParameters const& params) 
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		 : params(params)
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase163ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			ASSERT(ObjectReader::fromStringRef<IdempotencyIdRef>(ObjectWriter::toValue(IdempotencyIdRef(), Unversioned()), Unversioned()) == IdempotencyIdRef());
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			for(int i = 0;i < 1000;++i) {
															#line 167 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				Arena arena;
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				auto id = generate(arena);
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				auto serialized = ObjectWriter::toValue(id, Unversioned());
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				IdempotencyIdRef t;
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ObjectReader reader(serialized.begin(), Unversioned());
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				reader.deserialize(t);
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
				ASSERT(t == id);
															#line 344 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			}
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (!static_cast<FlowTestCase163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase163ActorState(); static_cast<FlowTestCase163Actor*>(this)->destroy(); return 0; }
															#line 348 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase163Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase163ActorState();
			static_cast<FlowTestCase163Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase163ActorState();
		static_cast<FlowTestCase163Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	UnitTestParameters params;
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase163()
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class FlowTestCase163Actor final : public Actor<Void>, public FastAllocated<FlowTestCase163Actor>, public FlowTestCase163ActorState<FlowTestCase163Actor> {
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase163Actor>::operator new;
	using FastAllocated<FlowTestCase163Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(846909782231733504UL, 3019851551744953856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	FlowTestCase163Actor(UnitTestParameters const& params) 
															#line 393 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase163ActorState<FlowTestCase163Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12050036035296398592UL, 4823101645924892928UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase163Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase163");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
static Future<Void> flowTestCase163( UnitTestParameters const& params ) {
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	return Future<Void>(new FlowTestCase163Actor(params));
															#line 425 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase163, "/fdbclient/IdempotencyId/serialization")

#line 177 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"

KeyRangeRef makeIdempotencySingleKeyRange(Arena& arena, Version version, uint8_t highOrderBatchIndex) {
	static const auto size =
	    idempotencyIdKeys.begin.size() + sizeof(version) + sizeof(highOrderBatchIndex) + /*\x00*/ 1;

	StringRef second = makeString(size, arena);
	auto* dst = mutateString(second);

	memcpy(dst, idempotencyIdKeys.begin.begin(), idempotencyIdKeys.begin.size());
	dst += idempotencyIdKeys.begin.size();

	version = bigEndian64(version);
	memcpy(dst, &version, sizeof(version));
	dst += sizeof(version);

	*dst++ = highOrderBatchIndex;

	*dst++ = 0;

	ASSERT_EQ(dst - second.begin(), size);

	return KeyRangeRef(second.removeSuffix("\x00"_sr), second);
}

void decodeIdempotencyKey(KeyRef key, Version& commitVersion, uint8_t& highOrderBatchIndex) {
	BinaryReader reader(key, Unversioned());
	reader.readBytes(idempotencyIdKeys.begin.size());
	reader >> commitVersion;
	commitVersion = bigEndian64(commitVersion);
	reader >> highOrderBatchIndex;
}

FDB_BOOLEAN_PARAM(Oldest);

// Find the youngest or oldest idempotency id key in `range` (depending on `oldest`)
// Write the timestamp to `*time` and the version to `*version` when non-null.
															#line 466 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getBoundary()
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
template <class GetBoundaryActor>
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class GetBoundaryActorState {
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	GetBoundaryActorState(Reference<ReadYourWritesTransaction> const& tr,KeyRange const& range,Oldest const& oldest,Version* const& version,int64_t* const& time) 
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		 : tr(tr),
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   range(range),
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldest(oldest),
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   version(version),
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   time(time)
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBoundary", reinterpret_cast<unsigned long>(this));

	}
	~GetBoundaryActorState() 
	{
		fdb_probe_actor_destroy("getBoundary", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 218 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(range, 1, Snapshot::False, oldest ? Reverse::False : Reverse::True);
															#line 218 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<GetBoundaryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 505 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBoundaryActor*>(this)->actor_wait_state = 1;
															#line 218 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBoundaryActor, 0, RangeResult >*>(static_cast<GetBoundaryActor*>(this)));
															#line 510 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBoundaryActorState();
		static_cast<GetBoundaryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!result.size())
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 221 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (!static_cast<GetBoundaryActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>()); this->~GetBoundaryActorState(); static_cast<GetBoundaryActor*>(this)->destroy(); return 0; }
															#line 537 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			new (&static_cast<GetBoundaryActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>());
			this->~GetBoundaryActorState();
			static_cast<GetBoundaryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (version != nullptr)
															#line 545 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			BinaryReader rd(result.front().key, Unversioned());
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd.readBytes(idempotencyIdKeys.begin.size());
															#line 226 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd >> *version;
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			*version = bigEndian64(*version);
															#line 555 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (time != nullptr)
															#line 559 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 230 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			BinaryReader rd(result.front().value, IncludeVersion());
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd >> *time;
															#line 565 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!static_cast<GetBoundaryActor*>(this)->SAV<Optional<Key>>::futures) { (void)(result.front().key); this->~GetBoundaryActorState(); static_cast<GetBoundaryActor*>(this)->destroy(); return 0; }
															#line 569 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		new (&static_cast<GetBoundaryActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(result.front().key);
		this->~GetBoundaryActorState();
		static_cast<GetBoundaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!result.size())
															#line 581 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 221 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (!static_cast<GetBoundaryActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>()); this->~GetBoundaryActorState(); static_cast<GetBoundaryActor*>(this)->destroy(); return 0; }
															#line 585 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			new (&static_cast<GetBoundaryActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>());
			this->~GetBoundaryActorState();
			static_cast<GetBoundaryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (version != nullptr)
															#line 593 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			BinaryReader rd(result.front().key, Unversioned());
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd.readBytes(idempotencyIdKeys.begin.size());
															#line 226 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd >> *version;
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			*version = bigEndian64(*version);
															#line 603 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (time != nullptr)
															#line 607 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 230 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			BinaryReader rd(result.front().value, IncludeVersion());
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			rd >> *time;
															#line 613 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!static_cast<GetBoundaryActor*>(this)->SAV<Optional<Key>>::futures) { (void)(result.front().key); this->~GetBoundaryActorState(); static_cast<GetBoundaryActor*>(this)->destroy(); return 0; }
															#line 617 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		new (&static_cast<GetBoundaryActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(result.front().key);
		this->~GetBoundaryActorState();
		static_cast<GetBoundaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBoundaryActor*>(this)->actor_wait_state > 0) static_cast<GetBoundaryActor*>(this)->actor_wait_state = 0;
		static_cast<GetBoundaryActor*>(this)->ActorCallback< GetBoundaryActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBoundaryActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBoundary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBoundaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBoundary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBoundaryActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBoundary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBoundaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBoundary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBoundaryActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBoundary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBoundaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBoundary", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	KeyRange range;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Oldest oldest;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Version* version;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t* time;
															#line 710 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBoundary()
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class GetBoundaryActor final : public Actor<Optional<Key>>, public ActorCallback< GetBoundaryActor, 0, RangeResult >, public FastAllocated<GetBoundaryActor>, public GetBoundaryActorState<GetBoundaryActor> {
															#line 715 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBoundaryActor>::operator new;
	using FastAllocated<GetBoundaryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13853562161045795328UL, 13382352621404793088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Key>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBoundaryActor, 0, RangeResult >;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	GetBoundaryActor(Reference<ReadYourWritesTransaction> const& tr,KeyRange const& range,Oldest const& oldest,Version* const& version,int64_t* const& time) 
															#line 732 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		 : Actor<Optional<Key>>(),
		   GetBoundaryActorState<GetBoundaryActor>(tr, range, oldest, version, time),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBoundary", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8823819120097908992UL, 14941238109965944320UL);
		ActorExecutionContextHelper __helper(static_cast<GetBoundaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBoundary");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBoundary", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBoundaryActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
[[nodiscard]] static Future<Optional<Key>> getBoundary( Reference<ReadYourWritesTransaction> const& tr, KeyRange const& range, Oldest const& oldest, Version* const& version, int64_t* const& time ) {
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	return Future<Optional<Key>>(new GetBoundaryActor(tr, range, oldest, version, time));
															#line 765 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
}

#line 235 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"

															#line 770 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getIdmpKeyStatus()
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
template <class GetIdmpKeyStatusActor>
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class GetIdmpKeyStatusActorState {
															#line 777 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	GetIdmpKeyStatusActorState(Database const& db) 
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		 : db(db),
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   size(),
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   expired(),
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   expiredKey(idempotencyIdsExpiredVersion, Unversioned()),
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldestIdVersion(0),
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldestIdTime(0)
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this));

	}
	~GetIdmpKeyStatusActorState() 
	{
		fdb_probe_actor_destroy("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 244 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			;
															#line 811 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetIdmpKeyStatusActorState();
		static_cast<GetIdmpKeyStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 246 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(size, tr->getEstimatedRangeSizeBytes(idempotencyIdKeys)) && store(expired, expiredKey.getD(tr)) && success(getBoundary(tr, idempotencyIdKeys, Oldest::True, &oldestIdVersion, &oldestIdTime));
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 848 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state = 1;
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetIdmpKeyStatusActor, 0, Void >*>(static_cast<GetIdmpKeyStatusActor*>(this)));
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 268 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 268 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state = 2;
															#line 268 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetIdmpKeyStatusActor, 1, Void >*>(static_cast<GetIdmpKeyStatusActor*>(this)));
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		JsonBuilderObject result;
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		result["size_bytes"] = size;
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (expired.expired != 0)
															#line 901 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["expired_version"] = expired.expired;
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (expired.expiredTime != 0)
															#line 909 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["expired_age"] = int64_t(now()) - expired.expiredTime;
															#line 913 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 260 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (oldestIdVersion != 0)
															#line 917 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["oldest_id_version"] = oldestIdVersion;
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 263 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (oldestIdTime != 0)
															#line 925 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["oldest_id_age"] = int64_t(now()) - oldestIdTime;
															#line 929 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!static_cast<GetIdmpKeyStatusActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(result); this->~GetIdmpKeyStatusActorState(); static_cast<GetIdmpKeyStatusActor*>(this)->destroy(); return 0; }
															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		new (&static_cast<GetIdmpKeyStatusActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(result);
		this->~GetIdmpKeyStatusActorState();
		static_cast<GetIdmpKeyStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		JsonBuilderObject result;
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		result["size_bytes"] = size;
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (expired.expired != 0)
															#line 949 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["expired_version"] = expired.expired;
															#line 953 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (expired.expiredTime != 0)
															#line 957 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["expired_age"] = int64_t(now()) - expired.expiredTime;
															#line 961 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 260 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (oldestIdVersion != 0)
															#line 965 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["oldest_id_version"] = oldestIdVersion;
															#line 969 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 263 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (oldestIdTime != 0)
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			result["oldest_id_age"] = int64_t(now()) - oldestIdTime;
															#line 977 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		}
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!static_cast<GetIdmpKeyStatusActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(result); this->~GetIdmpKeyStatusActorState(); static_cast<GetIdmpKeyStatusActor*>(this)->destroy(); return 0; }
															#line 981 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		new (&static_cast<GetIdmpKeyStatusActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(result);
		this->~GetIdmpKeyStatusActorState();
		static_cast<GetIdmpKeyStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state > 0) static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetIdmpKeyStatusActor*>(this)->ActorCallback< GetIdmpKeyStatusActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetIdmpKeyStatusActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetIdmpKeyStatusActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetIdmpKeyStatusActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state > 0) static_cast<GetIdmpKeyStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetIdmpKeyStatusActor*>(this)->ActorCallback< GetIdmpKeyStatusActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetIdmpKeyStatusActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetIdmpKeyStatusActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetIdmpKeyStatusActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Database db;
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t size;
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	IdempotencyIdsExpiredVersion expired;
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	KeyBackedObjectProperty<IdempotencyIdsExpiredVersion, _Unversioned> expiredKey;
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t oldestIdVersion;
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t oldestIdTime;
															#line 1165 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getIdmpKeyStatus()
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class GetIdmpKeyStatusActor final : public Actor<JsonBuilderObject>, public ActorCallback< GetIdmpKeyStatusActor, 0, Void >, public ActorCallback< GetIdmpKeyStatusActor, 1, Void >, public FastAllocated<GetIdmpKeyStatusActor>, public GetIdmpKeyStatusActorState<GetIdmpKeyStatusActor> {
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetIdmpKeyStatusActor>::operator new;
	using FastAllocated<GetIdmpKeyStatusActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15422192950910330112UL, 6539563050773377536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetIdmpKeyStatusActor, 0, Void >;
friend struct ActorCallback< GetIdmpKeyStatusActor, 1, Void >;
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	GetIdmpKeyStatusActor(Database const& db) 
															#line 1188 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		 : Actor<JsonBuilderObject>(),
		   GetIdmpKeyStatusActorState<GetIdmpKeyStatusActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12620917142728680960UL, 16924143290714099968UL);
		ActorExecutionContextHelper __helper(static_cast<GetIdmpKeyStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getIdmpKeyStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getIdmpKeyStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetIdmpKeyStatusActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetIdmpKeyStatusActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> getIdmpKeyStatus( Database const& db ) {
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	return Future<JsonBuilderObject>(new GetIdmpKeyStatusActor(db));
															#line 1222 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
}

#line 272 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"

															#line 1227 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cleanIdempotencyIds()
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
template <class CleanIdempotencyIdsActor>
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class CleanIdempotencyIdsActorState {
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	CleanIdempotencyIdsActorState(Database const& db,double const& minAgeSeconds) 
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		 : db(db),
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   minAgeSeconds(minAgeSeconds),
															#line 274 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   idmpKeySize(),
															#line 275 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   candidateDeleteSize(),
															#line 276 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   finalRange(),
															#line 277 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   tr(),
															#line 280 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldestKey(),
															#line 281 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldestVersion(),
															#line 282 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   oldestTime(),
															#line 285 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   candidateDeleteVersion(),
															#line 286 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   candidateDeleteTime(),
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		   candidateRangeToClean()
															#line 1263 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this));

	}
	~CleanIdempotencyIdsActorState() 
	{
		fdb_probe_actor_destroy("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 289 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(db);
															#line 290 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			;
															#line 1280 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanIdempotencyIdsActorState();
		static_cast<CleanIdempotencyIdsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!static_cast<CleanIdempotencyIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanIdempotencyIdsActorState(); static_cast<CleanIdempotencyIdsActor*>(this)->destroy(); return 0; }
															#line 1303 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		new (&static_cast<CleanIdempotencyIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanIdempotencyIdsActorState();
		static_cast<CleanIdempotencyIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 292 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 293 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 296 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<Optional<Key>> __when_expr_0 = getBoundary(tr, idempotencyIdKeys, Oldest::True, &oldestVersion, &oldestTime);
															#line 296 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1329 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 1;
															#line 296 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1334 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 370 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			TraceEvent("IdempotencyIdsCleanerError").error(e);
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr->onError(e);
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1373 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 7;
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 6, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Key> const& oldestKey_,int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!oldestKey_.present())
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 301 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		oldestKey = oldestKey_.get();
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (int64_t(now()) - oldestTime < minAgeSeconds)
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(idmpKeySize, tr->getEstimatedRangeSizeBytes(idempotencyIdKeys));
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 2;
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 1, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1414 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Key> && oldestKey_,int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!oldestKey_.present())
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 301 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		oldestKey = oldestKey_.get();
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (int64_t(now()) - oldestTime < minAgeSeconds)
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(idmpKeySize, tr->getEstimatedRangeSizeBytes(idempotencyIdKeys));
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1439 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 2;
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 1, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1444 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Key> const& oldestKey_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(oldestKey_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Key> && oldestKey_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(oldestKey_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success( getBoundary(tr, idempotencyIdKeys, Oldest::False, &candidateDeleteVersion, &candidateDeleteTime));
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1530 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 3;
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 2, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1535 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success( getBoundary(tr, idempotencyIdKeys, Oldest::False, &candidateDeleteVersion, &candidateDeleteTime));
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1546 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 3;
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 2, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1551 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		;
															#line 1635 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		;
															#line 1644 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		finalRange = KeyRangeRef(idempotencyIdKeys.begin, candidateRangeToClean.end);
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (!finalRange.empty())
															#line 1730 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
															#line 354 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->addReadConflictRange(finalRange);
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->clear(finalRange);
															#line 356 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			tr->set( idempotencyIdsExpiredVersion, ObjectWriter::toValue(IdempotencyIdsExpiredVersion{ candidateDeleteVersion, candidateDeleteTime }, Unversioned()));
															#line 360 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			TraceEvent("IdempotencyIdsCleanerAttempt") .detail("Range", finalRange.toString()) .detail("IdmpKeySizeEstimate", idmpKeySize) .detail("ClearRangeSizeEstimate", candidateDeleteSize) .detail("ExpiredVersion", candidateDeleteVersion) .detail("ExpiredVersionAgeEstimate", static_cast<int64_t>(now()) - candidateDeleteTime);
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->commit();
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1744 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
			static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 6;
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 5, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1749 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1(int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		candidateRangeToClean = KeyRangeRef(oldestKey, BinaryWriter::toValue(bigEndian64(candidateDeleteVersion + 1), Unversioned()) .withPrefix(idempotencyIdKeys.begin));
															#line 323 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (oldestVersion == candidateDeleteVersion)
															#line 1772 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(getBoundary( tr, candidateRangeToClean, Oldest::False, &candidateDeleteVersion, &candidateDeleteTime));
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1780 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 4;
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 3, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1785 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		candidateRangeToClean = KeyRangeRef(oldestKey, BinaryWriter::toValue(bigEndian64(candidateDeleteVersion + 1), Unversioned()) .withPrefix(idempotencyIdKeys.begin));
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(candidateDeleteSize, tr->getEstimatedRangeSizeBytes(candidateRangeToClean));
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1811 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 5;
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 4, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1816 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		candidateRangeToClean = KeyRangeRef(oldestKey, BinaryWriter::toValue(bigEndian64(candidateDeleteVersion + 1), Unversioned()) .withPrefix(idempotencyIdKeys.begin));
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(candidateDeleteSize, tr->getEstimatedRangeSizeBytes(candidateRangeToClean));
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 5;
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CleanIdempotencyIdsActor, 4, Void >*>(static_cast<CleanIdempotencyIdsActor*>(this)));
															#line 1834 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		int64_t youngestAge = int64_t(now()) - candidateDeleteTime;
															#line 341 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		TraceEvent("IdempotencyIdsCleanerCandidateDelete") .detail("Range", candidateRangeToClean.toString()) .detail("IdmpKeySizeEstimate", idmpKeySize) .detail("YoungestIdAge", youngestAge) .detail("MinAgeSeconds", minAgeSeconds) .detail("ClearRangeSizeEstimate", candidateDeleteSize);
															#line 347 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (youngestAge > minAgeSeconds)
															#line 1922 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 350 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		candidateDeleteVersion = (oldestVersion + candidateDeleteVersion) / 2;
															#line 1928 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		int64_t youngestAge = int64_t(now()) - candidateDeleteTime;
															#line 341 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		TraceEvent("IdempotencyIdsCleanerCandidateDelete") .detail("Range", candidateRangeToClean.toString()) .detail("IdmpKeySizeEstimate", idmpKeySize) .detail("YoungestIdAge", youngestAge) .detail("MinAgeSeconds", minAgeSeconds) .detail("ClearRangeSizeEstimate", candidateDeleteSize);
															#line 347 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		if (youngestAge > minAgeSeconds)
															#line 1941 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 350 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
		candidateDeleteVersion = (oldestVersion + candidateDeleteVersion) / 2;
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<CleanIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanIdempotencyIdsActor*>(this)->ActorCallback< CleanIdempotencyIdsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CleanIdempotencyIdsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CleanIdempotencyIdsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Database db;
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	double minAgeSeconds;
															#line 274 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t idmpKeySize;
															#line 275 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t candidateDeleteSize;
															#line 276 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	KeyRange finalRange;
															#line 277 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 280 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Key oldestKey;
															#line 281 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Version oldestVersion;
															#line 282 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t oldestTime;
															#line 285 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	Version candidateDeleteVersion;
															#line 286 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	int64_t candidateDeleteTime;
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	KeyRange candidateRangeToClean;
															#line 2231 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cleanIdempotencyIds()
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
class CleanIdempotencyIdsActor final : public Actor<Void>, public ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >, public ActorCallback< CleanIdempotencyIdsActor, 1, Void >, public ActorCallback< CleanIdempotencyIdsActor, 2, Void >, public ActorCallback< CleanIdempotencyIdsActor, 3, Void >, public ActorCallback< CleanIdempotencyIdsActor, 4, Void >, public ActorCallback< CleanIdempotencyIdsActor, 5, Void >, public ActorCallback< CleanIdempotencyIdsActor, 6, Void >, public FastAllocated<CleanIdempotencyIdsActor>, public CleanIdempotencyIdsActorState<CleanIdempotencyIdsActor> {
															#line 2236 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
public:
	using FastAllocated<CleanIdempotencyIdsActor>::operator new;
	using FastAllocated<CleanIdempotencyIdsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12397783510500561408UL, 2989046397737761280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 1, Void >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 2, Void >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 3, Void >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 4, Void >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 5, Void >;
friend struct ActorCallback< CleanIdempotencyIdsActor, 6, Void >;
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	CleanIdempotencyIdsActor(Database const& db,double const& minAgeSeconds) 
															#line 2259 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CleanIdempotencyIdsActorState<CleanIdempotencyIdsActor>(db, minAgeSeconds),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7968403796774987008UL, 2754000855849244672UL);
		ActorExecutionContextHelper __helper(static_cast<CleanIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanIdempotencyIds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanIdempotencyIds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 0, Optional<Key> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CleanIdempotencyIdsActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
[[nodiscard]] Future<Void> cleanIdempotencyIds( Database const& db, double const& minAgeSeconds ) {
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
	return Future<Void>(new CleanIdempotencyIdsActor(db, minAgeSeconds));
															#line 2298 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/IdempotencyId.actor.g.cpp.py_gen"
}

#line 376 "/Users/ec2-user/foundationdb/fdbclient/IdempotencyId.actor.cpp"
