#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
/*
 * LocationMetadataCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/IClientApi.h"
#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
															#line 34 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via describeServers()
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class DescribeServersActor>
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class DescribeServersActorState {
															#line 40 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	DescribeServersActorState(Reference<ReadYourWritesTransaction> const& tr,std::vector<UID> const& ids) 
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : tr(tr),
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   ids(ids)
															#line 49 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("describeServers", reinterpret_cast<unsigned long>(this));

	}
	~DescribeServersActorState() 
	{
		fdb_probe_actor_destroy("describeServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 33 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 34 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			for( const UID& id : ids ) {
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				serverListEntries.push_back(tr->get(serverListKeyFor(id)));
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			}
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(serverListEntries);
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<DescribeServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DescribeServersActor*>(this)->actor_wait_state = 1;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >*>(static_cast<DescribeServersActor*>(this)));
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DescribeServersActorState();
		static_cast<DescribeServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		std::string res;
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 40 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(v.get());
															#line 41 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (!res.empty())
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 42 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				res += ", ";
															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			}
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			res += fmt::format("ServerID: {}, Addr: {}", ssi.uniqueID.toString(), ssi.stableAddress().toString());
															#line 116 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		}
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<DescribeServersActor*>(this)->SAV<std::string>::futures) { (void)(res); this->~DescribeServersActorState(); static_cast<DescribeServersActor*>(this)->destroy(); return 0; }
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<DescribeServersActor*>(this)->SAV< std::string >::value()) std::string(res);
		this->~DescribeServersActorState();
		static_cast<DescribeServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		std::string res;
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for( auto& v : serverListValues ) {
															#line 40 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(v.get());
															#line 41 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (!res.empty())
															#line 138 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 42 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				res += ", ";
															#line 142 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			}
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			res += fmt::format("ServerID: {}, Addr: {}", ssi.uniqueID.toString(), ssi.stableAddress().toString());
															#line 146 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		}
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<DescribeServersActor*>(this)->SAV<std::string>::futures) { (void)(res); this->~DescribeServersActorState(); static_cast<DescribeServersActor*>(this)->destroy(); return 0; }
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<DescribeServersActor*>(this)->SAV< std::string >::value()) std::string(res);
		this->~DescribeServersActorState();
		static_cast<DescribeServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DescribeServersActor*>(this)->actor_wait_state > 0) static_cast<DescribeServersActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeServersActor*>(this)->ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("describeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("describeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("describeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeServers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	std::vector<UID> ids;
															#line 237 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via describeServers()
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class DescribeServersActor final : public Actor<std::string>, public ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >, public FastAllocated<DescribeServersActor>, public DescribeServersActorState<DescribeServersActor> {
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<DescribeServersActor>::operator new;
	using FastAllocated<DescribeServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2482035248008278016UL, 14652671356127324160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >;
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	DescribeServersActor(Reference<ReadYourWritesTransaction> const& tr,std::vector<UID> const& ids) 
															#line 259 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   DescribeServersActorState<DescribeServersActor>(tr, ids),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("describeServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4582867851365029888UL, 16103309345395276032UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("describeServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("describeServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DescribeServersActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<std::string> describeServers( Reference<ReadYourWritesTransaction> const& tr, std::vector<UID> const& ids ) {
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<std::string>(new DescribeServersActor(tr, ids));
															#line 291 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 49 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

															#line 296 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printKeyServersEntry()
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class PrintKeyServersEntryActor>
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintKeyServersEntryActorState {
															#line 302 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintKeyServersEntryActorState(Reference<ReadYourWritesTransaction> const& tr,RangeResultRef const& UIDtoTagMap,Value const& entry,KeyRangeRef const& range) 
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : tr(tr),
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   UIDtoTagMap(UIDtoTagMap),
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   entry(entry),
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   range(range),
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   src(),
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   dest(),
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   srcId(),
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   destId()
															#line 323 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printKeyServersEntry", reinterpret_cast<unsigned long>(this));

	}
	~PrintKeyServersEntryActorState() 
	{
		fdb_probe_actor_destroy("printKeyServersEntry", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, entry, src, dest, srcId, destId);
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = describeServers(tr, src);
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 342 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state = 1;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintKeyServersEntryActor, 0, std::string >*>(static_cast<PrintKeyServersEntryActor*>(this)));
															#line 347 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintKeyServersEntryActorState();
		static_cast<PrintKeyServersEntryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = describeServers(tr, dest);
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state = 2;
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintKeyServersEntryActor, 1, std::string >*>(static_cast<PrintKeyServersEntryActor*>(this)));
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __srcDesc,int loopDepth) 
	{
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		srcDesc = __srcDesc;
															#line 386 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __srcDesc,int loopDepth) 
	{
		srcDesc = std::move(__srcDesc);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state > 0) static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintKeyServersEntryActor*>(this)->ActorCallback< PrintKeyServersEntryActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< PrintKeyServersEntryActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintKeyServersEntryActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintKeyServersEntryActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::string const& destDesc,int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		printf("Range: %s, ShardID: %s, Src Servers: %s, Dest Servers: %s\n", Traceable<KeyRangeRef>::toString(range).c_str(), srcId.toString().c_str(), srcDesc.c_str(), destDesc.c_str());
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<PrintKeyServersEntryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintKeyServersEntryActorState(); static_cast<PrintKeyServersEntryActor*>(this)->destroy(); return 0; }
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintKeyServersEntryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintKeyServersEntryActorState();
		static_cast<PrintKeyServersEntryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && destDesc,int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		printf("Range: %s, ShardID: %s, Src Servers: %s, Dest Servers: %s\n", Traceable<KeyRangeRef>::toString(range).c_str(), srcId.toString().c_str(), srcDesc.c_str(), destDesc.c_str());
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<PrintKeyServersEntryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintKeyServersEntryActorState(); static_cast<PrintKeyServersEntryActor*>(this)->destroy(); return 0; }
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintKeyServersEntryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintKeyServersEntryActorState();
		static_cast<PrintKeyServersEntryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& destDesc,int loopDepth) 
	{
		loopDepth = a_body1cont2(destDesc, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && destDesc,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(destDesc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state > 0) static_cast<PrintKeyServersEntryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintKeyServersEntryActor*>(this)->ActorCallback< PrintKeyServersEntryActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< PrintKeyServersEntryActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintKeyServersEntryActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintKeyServersEntryActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResultRef UIDtoTagMap;
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Value entry;
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	KeyRangeRef range;
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	std::vector<UID> src;
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	std::vector<UID> dest;
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	UID srcId;
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	UID destId;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	std::string srcDesc;
															#line 582 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printKeyServersEntry()
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintKeyServersEntryActor final : public Actor<Void>, public ActorCallback< PrintKeyServersEntryActor, 0, std::string >, public ActorCallback< PrintKeyServersEntryActor, 1, std::string >, public FastAllocated<PrintKeyServersEntryActor>, public PrintKeyServersEntryActorState<PrintKeyServersEntryActor> {
															#line 587 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintKeyServersEntryActor>::operator new;
	using FastAllocated<PrintKeyServersEntryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17608134442947347968UL, 69257494218125568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintKeyServersEntryActor, 0, std::string >;
friend struct ActorCallback< PrintKeyServersEntryActor, 1, std::string >;
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintKeyServersEntryActor(Reference<ReadYourWritesTransaction> const& tr,RangeResultRef const& UIDtoTagMap,Value const& entry,KeyRangeRef const& range) 
															#line 605 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintKeyServersEntryActorState<PrintKeyServersEntryActor>(tr, UIDtoTagMap, entry, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printKeyServersEntry", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6973323260692246528UL, 11179665495488555264UL);
		ActorExecutionContextHelper __helper(static_cast<PrintKeyServersEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printKeyServersEntry");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printKeyServersEntry", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintKeyServersEntryActor, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintKeyServersEntryActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<Void> printKeyServersEntry( Reference<ReadYourWritesTransaction> const& tr, RangeResultRef const& UIDtoTagMap, Value const& entry, KeyRangeRef const& range ) {
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<Void>(new PrintKeyServersEntryActor(tr, UIDtoTagMap, entry, range));
															#line 638 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 68 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

															#line 643 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printRandomShards()
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class PrintRandomShardsActor>
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintRandomShardsActorState {
															#line 649 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintRandomShardsActorState(Database const& cx,int const& n,bool const& physicalShard) 
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : cx(cx),
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   n(n),
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   physicalShard(physicalShard),
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   begin(allKeys.begin),
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   numShards(0)
															#line 664 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printRandomShards", reinterpret_cast<unsigned long>(this));

	}
	~PrintRandomShardsActorState() 
	{
		fdb_probe_actor_destroy("printRandomShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			;
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintRandomShardsActorState();
		static_cast<PrintRandomShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		printf("Found %d %s shards\n", numShards, physicalShard ? "Physical" : "Non-physical");
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<PrintRandomShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintRandomShardsActorState(); static_cast<PrintRandomShardsActor*>(this)->destroy(); return 0; }
															#line 704 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintRandomShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintRandomShardsActorState();
		static_cast<PrintRandomShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(begin < allKeys.end && numShards < n))
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 731 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 1;
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintRandomShardsActor, 0, RangeResult >*>(static_cast<PrintRandomShardsActor*>(this)));
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 817 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 4;
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PrintRandomShardsActor, 3, Void >*>(static_cast<PrintRandomShardsActor*>(this)));
															#line 822 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		currentKeys = KeyRangeRef(begin, allKeys.end);
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = krmGetRanges(tr, keyServersPrefix, currentKeys, n, CLIENT_KNOBS->TOO_MANY);
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 843 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 2;
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintRandomShardsActor, 1, RangeResult >*>(static_cast<PrintRandomShardsActor*>(this)));
															#line 848 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 857 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintRandomShardsActor*>(this)->ActorCallback< PrintRandomShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintRandomShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		i = 0;
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& __shards,int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		shards = __shards;
															#line 947 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && __shards,int loopDepth) 
	{
		shards = std::move(__shards);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintRandomShardsActor*>(this)->ActorCallback< PrintRandomShardsActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintRandomShardsActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = shards.back().key;
															#line 1026 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(i < shards.size() - 1 && numShards < n))
															#line 1042 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		KeyRangeRef currentRange(shards[i].key, shards[i + 1].key);
															#line 93 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		std::vector<UID> src;
															#line 94 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		std::vector<UID> dest;
															#line 95 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		UID srcId;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		UID destId;
															#line 97 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (physicalShard == (srcId != anonymousShardId))
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
															#line 99 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = printKeyServersEntry(tr, UIDtoTagMap, shards[i].value, currentRange);
															#line 99 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1066 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 3;
															#line 99 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PrintRandomShardsActor, 2, Void >*>(static_cast<PrintRandomShardsActor*>(this)));
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		++i;
															#line 1098 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		++numShards;
															#line 1107 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		++numShards;
															#line 1116 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintRandomShardsActor*>(this)->ActorCallback< PrintRandomShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PrintRandomShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PrintRandomShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintRandomShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintRandomShardsActor*>(this)->ActorCallback< PrintRandomShardsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PrintRandomShardsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PrintRandomShardsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Database cx;
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int n;
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	bool physicalShard;
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Key begin;
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int numShards;
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	KeyRangeRef currentKeys;
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResult shards;
															#line 90 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int i;
															#line 1303 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printRandomShards()
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintRandomShardsActor final : public Actor<Void>, public ActorCallback< PrintRandomShardsActor, 0, RangeResult >, public ActorCallback< PrintRandomShardsActor, 1, RangeResult >, public ActorCallback< PrintRandomShardsActor, 2, Void >, public ActorCallback< PrintRandomShardsActor, 3, Void >, public FastAllocated<PrintRandomShardsActor>, public PrintRandomShardsActorState<PrintRandomShardsActor> {
															#line 1308 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintRandomShardsActor>::operator new;
	using FastAllocated<PrintRandomShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18437982715229124608UL, 14110360675435993856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintRandomShardsActor, 0, RangeResult >;
friend struct ActorCallback< PrintRandomShardsActor, 1, RangeResult >;
friend struct ActorCallback< PrintRandomShardsActor, 2, Void >;
friend struct ActorCallback< PrintRandomShardsActor, 3, Void >;
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintRandomShardsActor(Database const& cx,int const& n,bool const& physicalShard) 
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintRandomShardsActorState<PrintRandomShardsActor>(cx, n, physicalShard),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printRandomShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12956750829369505024UL, 5919881604036675072UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRandomShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printRandomShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printRandomShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintRandomShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintRandomShardsActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PrintRandomShardsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PrintRandomShardsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<Void> printRandomShards( Database const& cx, int const& n, bool const& physicalShard ) {
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<Void>(new PrintRandomShardsActor(cx, n, physicalShard));
															#line 1363 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 116 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

															#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printPhysicalShardCount()
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class PrintPhysicalShardCountActor>
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintPhysicalShardCountActorState {
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintPhysicalShardCountActorState(Database const& cx) 
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : cx(cx),
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   begin(allKeys.begin),
															#line 119 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   numShards(0),
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   numPhysicalShards(0)
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printPhysicalShardCount", reinterpret_cast<unsigned long>(this));

	}
	~PrintPhysicalShardCountActorState() 
	{
		fdb_probe_actor_destroy("printPhysicalShardCount", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			;
															#line 1402 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintPhysicalShardCountActorState();
		static_cast<PrintPhysicalShardCountActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		printf("Total number of shards: %d, number of physical shards: %d\n", numShards, numPhysicalShards);
															#line 161 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<PrintPhysicalShardCountActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPhysicalShardCountActorState(); static_cast<PrintPhysicalShardCountActor*>(this)->destroy(); return 0; }
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintPhysicalShardCountActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintPhysicalShardCountActorState();
		static_cast<PrintPhysicalShardCountActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(begin < allKeys.end))
															#line 1446 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 1454 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 129 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 1;
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >*>(static_cast<PrintPhysicalShardCountActor*>(this)));
															#line 1503 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1540 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 3;
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PrintPhysicalShardCountActor, 2, Void >*>(static_cast<PrintPhysicalShardCountActor*>(this)));
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		KeyRangeRef currentKeys(begin, allKeys.end);
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = krmGetRanges(tr, keyServersPrefix, currentKeys, CLIENT_KNOBS->TOO_MANY, CLIENT_KNOBS->TOO_MANY);
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1566 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 2;
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >*>(static_cast<PrintPhysicalShardCountActor*>(this)));
															#line 1571 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 1580 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state > 0) static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 0;
		static_cast<PrintPhysicalShardCountActor*>(this)->ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(RangeResult const& shards,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			std::vector<UID> src;
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			std::vector<UID> dest;
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID srcId;
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID destId;
															#line 144 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (srcId != anonymousShardId)
															#line 1671 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				++numPhysicalShards;
															#line 1675 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			}
		}
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = shards.back().key;
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		numShards += shards.size() - 1;
															#line 1682 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(RangeResult && shards,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for(int i = 0;i < shards.size() - 1;++i) {
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			std::vector<UID> src;
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			std::vector<UID> dest;
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID srcId;
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID destId;
															#line 144 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (srcId != anonymousShardId)
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				++numPhysicalShards;
															#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			}
		}
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = shards.back().key;
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		numShards += shards.size() - 1;
															#line 1714 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& shards,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(shards, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && shards,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(shards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state > 0) static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 0;
		static_cast<PrintPhysicalShardCountActor*>(this)->ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state > 0) static_cast<PrintPhysicalShardCountActor*>(this)->actor_wait_state = 0;
		static_cast<PrintPhysicalShardCountActor*>(this)->ActorCallback< PrintPhysicalShardCountActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PrintPhysicalShardCountActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PrintPhysicalShardCountActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Database cx;
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Key begin;
															#line 119 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int numShards;
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int numPhysicalShards;
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1893 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printPhysicalShardCount()
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintPhysicalShardCountActor final : public Actor<Void>, public ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >, public ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >, public ActorCallback< PrintPhysicalShardCountActor, 2, Void >, public FastAllocated<PrintPhysicalShardCountActor>, public PrintPhysicalShardCountActorState<PrintPhysicalShardCountActor> {
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintPhysicalShardCountActor>::operator new;
	using FastAllocated<PrintPhysicalShardCountActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(568801615241918720UL, 1777716814745356800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >;
friend struct ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >;
friend struct ActorCallback< PrintPhysicalShardCountActor, 2, Void >;
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintPhysicalShardCountActor(Database const& cx) 
															#line 1917 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintPhysicalShardCountActorState<PrintPhysicalShardCountActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10185989918815314176UL, 8279526968949025280UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPhysicalShardCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printPhysicalShardCount");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printPhysicalShardCount", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintPhysicalShardCountActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintPhysicalShardCountActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PrintPhysicalShardCountActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<Void> printPhysicalShardCount( Database const& cx ) {
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<Void>(new PrintPhysicalShardCountActor(cx));
															#line 1951 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 163 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

															#line 1956 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via printServerShards()
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class PrintServerShardsActor>
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintServerShardsActorState {
															#line 1962 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintServerShardsActorState(Database const& cx,UID const& serverId) 
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : cx(cx),
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   serverId(serverId),
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   begin(allKeys.begin)
															#line 1973 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("printServerShards", reinterpret_cast<unsigned long>(this));

	}
	~PrintServerShardsActorState() 
	{
		fdb_probe_actor_destroy("printServerShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			;
															#line 1988 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintServerShardsActorState();
		static_cast<PrintServerShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<PrintServerShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintServerShardsActorState(); static_cast<PrintServerShardsActor*>(this)->destroy(); return 0; }
															#line 2011 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<PrintServerShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintServerShardsActorState();
		static_cast<PrintServerShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(begin < allKeys.end))
															#line 2030 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 171 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 2038 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 177 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, serverKeysPrefixFor(serverId), KeyRangeRef(begin, allKeys.end));
															#line 177 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2082 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintServerShardsActor*>(this)->actor_wait_state = 1;
															#line 177 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintServerShardsActor, 0, RangeResult >*>(static_cast<PrintServerShardsActor*>(this)));
															#line 2087 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<PrintServerShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2124 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintServerShardsActor*>(this)->actor_wait_state = 2;
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintServerShardsActor, 1, Void >*>(static_cast<PrintServerShardsActor*>(this)));
															#line 2129 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult const& serverShards,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for(int i = 0;i < serverShards.size() - 1;++i) {
															#line 181 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			KeyRangeRef currentRange(serverShards[i].key, serverShards[i + 1].key);
															#line 182 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID shardId;
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			bool assigned, emptyRange;
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 185 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			decodeServerKeysValue( serverShards[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			printf("Range: %s, ShardID: %s, Assigned: %s\n", Traceable<KeyRangeRef>::toString(currentRange).c_str(), shardId.toString().c_str(), assigned ? "true" : "false");
															#line 2158 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		}
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = serverShards.back().key;
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult && serverShards,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		for(int i = 0;i < serverShards.size() - 1;++i) {
															#line 181 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			KeyRangeRef currentRange(serverShards[i].key, serverShards[i + 1].key);
															#line 182 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			UID shardId;
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			bool assigned, emptyRange;
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			DataMoveType dataMoveType = DataMoveType::LOGICAL;
															#line 185 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			DataMovementReason dataMoveReason = DataMovementReason::INVALID;
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			decodeServerKeysValue( serverShards[i].value, assigned, emptyRange, dataMoveType, shardId, dataMoveReason);
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			printf("Range: %s, ShardID: %s, Assigned: %s\n", Traceable<KeyRangeRef>::toString(currentRange).c_str(), shardId.toString().c_str(), assigned ? "true" : "false");
															#line 2185 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		}
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = serverShards.back().key;
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& serverShards,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(serverShards, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && serverShards,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(serverShards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintServerShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintServerShardsActor*>(this)->ActorCallback< PrintServerShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PrintServerShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintServerShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintServerShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintServerShardsActor*>(this)->actor_wait_state > 0) static_cast<PrintServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<PrintServerShardsActor*>(this)->ActorCallback< PrintServerShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintServerShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintServerShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintServerShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Database cx;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	UID serverId;
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Key begin;
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2364 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via printServerShards()
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class PrintServerShardsActor final : public Actor<Void>, public ActorCallback< PrintServerShardsActor, 0, RangeResult >, public ActorCallback< PrintServerShardsActor, 1, Void >, public FastAllocated<PrintServerShardsActor>, public PrintServerShardsActorState<PrintServerShardsActor> {
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrintServerShardsActor>::operator new;
	using FastAllocated<PrintServerShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9742857645618020096UL, 8269080562357503232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintServerShardsActor, 0, RangeResult >;
friend struct ActorCallback< PrintServerShardsActor, 1, Void >;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	PrintServerShardsActor(Database const& cx,UID const& serverId) 
															#line 2387 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrintServerShardsActorState<PrintServerShardsActor>(cx, serverId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printServerShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4251800717607831808UL, 6129428369928463872UL);
		ActorExecutionContextHelper __helper(static_cast<PrintServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printServerShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printServerShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintServerShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintServerShardsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<Void> printServerShards( Database const& cx, UID const& serverId ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<Void>(new PrintServerShardsActor(cx, serverId));
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 204 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

															#line 2425 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via resolveRange()
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class ResolveRangeActor>
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class ResolveRangeActorState {
															#line 2431 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	ResolveRangeActorState(Database const& cx,KeyRange const& range) 
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : cx(cx),
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   range(range),
															#line 206 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   begin(range.begin)
															#line 2442 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("resolveRange", reinterpret_cast<unsigned long>(this));

	}
	~ResolveRangeActorState() 
	{
		fdb_probe_actor_destroy("resolveRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			;
															#line 2457 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResolveRangeActorState();
		static_cast<ResolveRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<ResolveRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResolveRangeActorState(); static_cast<ResolveRangeActor*>(this)->destroy(); return 0; }
															#line 2480 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<ResolveRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResolveRangeActorState();
		static_cast<ResolveRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(begin < range.end))
															#line 2499 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 212 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 2507 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 215 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<ResolveRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2551 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResolveRangeActor*>(this)->actor_wait_state = 1;
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResolveRangeActor, 0, RangeResult >*>(static_cast<ResolveRangeActor*>(this)));
															#line 2556 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (static_cast<ResolveRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2593 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ResolveRangeActor*>(this)->actor_wait_state = 4;
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ResolveRangeActor, 3, Void >*>(static_cast<ResolveRangeActor*>(this)));
															#line 2598 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 221 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		currentKeys = KeyRangeRef(begin, range.end);
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = krmGetRanges(tr, keyServersPrefix, currentKeys, CLIENT_KNOBS->TOO_MANY, CLIENT_KNOBS->TOO_MANY);
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResolveRangeActor*>(this)->actor_wait_state = 2;
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResolveRangeActor, 1, RangeResult >*>(static_cast<ResolveRangeActor*>(this)));
															#line 2624 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 2633 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state > 0) static_cast<ResolveRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveRangeActor*>(this)->ActorCallback< ResolveRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResolveRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		i = 0;
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		;
															#line 2714 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& __shards,int loopDepth) 
	{
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		shards = __shards;
															#line 2723 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && __shards,int loopDepth) 
	{
		shards = std::move(__shards);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state > 0) static_cast<ResolveRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveRangeActor*>(this)->ActorCallback< ResolveRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResolveRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 231 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		begin = shards.back().key;
															#line 2802 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!(i < shards.size() - 1))
															#line 2818 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		currentRange = KeyRangeRef(shards[i].key, shards[i + 1].key);
															#line 228 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = printKeyServersEntry(tr, UIDtoTagMap, shards[i].value, currentRange);
															#line 228 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2828 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ResolveRangeActor*>(this)->actor_wait_state = 3;
															#line 228 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResolveRangeActor, 2, Void >*>(static_cast<ResolveRangeActor*>(this)));
															#line 2833 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		++i;
															#line 2855 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		++i;
															#line 2864 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state > 0) static_cast<ResolveRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveRangeActor*>(this)->ActorCallback< ResolveRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ResolveRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ResolveRangeActor*>(this)->actor_wait_state > 0) static_cast<ResolveRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveRangeActor*>(this)->ActorCallback< ResolveRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ResolveRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ResolveRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Database cx;
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	KeyRange range;
															#line 206 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Key begin;
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 221 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	KeyRangeRef currentKeys;
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	RangeResult shards;
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	int i;
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	KeyRangeRef currentRange;
															#line 3049 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via resolveRange()
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class ResolveRangeActor final : public Actor<Void>, public ActorCallback< ResolveRangeActor, 0, RangeResult >, public ActorCallback< ResolveRangeActor, 1, RangeResult >, public ActorCallback< ResolveRangeActor, 2, Void >, public ActorCallback< ResolveRangeActor, 3, Void >, public FastAllocated<ResolveRangeActor>, public ResolveRangeActorState<ResolveRangeActor> {
															#line 3054 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<ResolveRangeActor>::operator new;
	using FastAllocated<ResolveRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15225324223601693696UL, 3506666545356902144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResolveRangeActor, 0, RangeResult >;
friend struct ActorCallback< ResolveRangeActor, 1, RangeResult >;
friend struct ActorCallback< ResolveRangeActor, 2, Void >;
friend struct ActorCallback< ResolveRangeActor, 3, Void >;
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	ResolveRangeActor(Database const& cx,KeyRange const& range) 
															#line 3074 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ResolveRangeActorState<ResolveRangeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resolveRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2616554211734330112UL, 13294532485623999488UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resolveRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resolveRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResolveRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResolveRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ResolveRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ResolveRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<Void> resolveRange( Database const& cx, KeyRange const& range ) {
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<Void>(new ResolveRangeActor(cx, range));
															#line 3109 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 241 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

} // namespace

namespace fdb_cli {

															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via locationMetadataCommandActor()
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
template <class LocationMetadataCommandActorActor>
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class LocationMetadataCommandActorActorState {
															#line 3124 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	LocationMetadataCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		 : cx(cx),
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		   tokens(tokens)
															#line 3133 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~LocationMetadataCommandActorActorState() 
	{
		fdb_probe_actor_destroy("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (tokens.size() < 2 || tokens.size() > 4)
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 248 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 249 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
				new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~LocationMetadataCommandActorActorState();
				static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 252 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
			if (tokens.size() == 2)
															#line 3162 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
			{
															#line 253 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				if (!tokencmp(tokens[1], "physicalshards"))
															#line 3166 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
				{
															#line 254 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 255 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
					if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
					new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~LocationMetadataCommandActorActorState();
					static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 257 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = printPhysicalShardCount(cx);
															#line 257 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3182 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 1;
															#line 257 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LocationMetadataCommandActorActor, 0, Void >*>(static_cast<LocationMetadataCommandActorActor*>(this)));
															#line 3187 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
				if (tokencmp(tokens[1], "resolve"))
															#line 3194 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
				{
															#line 259 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
					if (tokens.size() == 3)
															#line 3198 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
					{
															#line 260 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = resolveRange(cx, singleKeyRange(tokens[2]));
															#line 260 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3204 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 2;
															#line 260 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LocationMetadataCommandActorActor, 1, Void >*>(static_cast<LocationMetadataCommandActorActor*>(this)));
															#line 3209 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 262 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						StrictFuture<Void> __when_expr_2 = resolveRange(cx, KeyRangeRef(tokens[2], tokens[3]));
															#line 262 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3218 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 3;
															#line 262 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LocationMetadataCommandActorActor, 2, Void >*>(static_cast<LocationMetadataCommandActorActor*>(this)));
															#line 3223 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
				}
				else
				{
															#line 264 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
					if (tokencmp(tokens[1], "servershards"))
															#line 3231 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
					{
															#line 265 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 3235 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						{
															#line 266 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3241 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
							new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~LocationMetadataCommandActorActorState();
							static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 269 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						StrictFuture<Void> __when_expr_3 = printServerShards(cx, UID::fromString(tokens[2].toString()));
															#line 269 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3251 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
						static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 4;
															#line 269 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LocationMetadataCommandActorActor, 3, Void >*>(static_cast<LocationMetadataCommandActorActor*>(this)));
															#line 3256 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 270 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
						if (tokencmp(tokens[1], "listshards"))
															#line 3263 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
						{
															#line 271 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							if (tokens.size() == 4 && !tokencmp(tokens[3], "physical"))
															#line 3267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
							{
															#line 272 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 273 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
								if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3273 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
								new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~LocationMetadataCommandActorActorState();
								static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 275 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							const bool physical = tokens.size() == 4;
															#line 276 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							StrictFuture<Void> __when_expr_4 = printRandomShards(cx, std::stoi(tokens[2].toString()), physical);
															#line 276 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3285 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
							static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 5;
															#line 276 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LocationMetadataCommandActorActor, 4, Void >*>(static_cast<LocationMetadataCommandActorActor*>(this)));
															#line 3290 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 278 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 279 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
							if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3299 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
							new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~LocationMetadataCommandActorActorState();
							static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LocationMetadataCommandActorActorState();
		static_cast<LocationMetadataCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
		if (!static_cast<LocationMetadataCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~LocationMetadataCommandActorActorState(); static_cast<LocationMetadataCommandActorActor*>(this)->destroy(); return 0; }
															#line 3329 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		new (&static_cast<LocationMetadataCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~LocationMetadataCommandActorActorState();
		static_cast<LocationMetadataCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LocationMetadataCommandActorActor*>(this)->ActorCallback< LocationMetadataCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LocationMetadataCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LocationMetadataCommandActorActor*>(this)->ActorCallback< LocationMetadataCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LocationMetadataCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LocationMetadataCommandActorActor*>(this)->ActorCallback< LocationMetadataCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LocationMetadataCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LocationMetadataCommandActorActor*>(this)->ActorCallback< LocationMetadataCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LocationMetadataCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state > 0) static_cast<LocationMetadataCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<LocationMetadataCommandActorActor*>(this)->ActorCallback< LocationMetadataCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LocationMetadataCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LocationMetadataCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	Database cx;
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 3800 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via locationMetadataCommandActor()
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
class LocationMetadataCommandActorActor final : public Actor<bool>, public ActorCallback< LocationMetadataCommandActorActor, 0, Void >, public ActorCallback< LocationMetadataCommandActorActor, 1, Void >, public ActorCallback< LocationMetadataCommandActorActor, 2, Void >, public ActorCallback< LocationMetadataCommandActorActor, 3, Void >, public ActorCallback< LocationMetadataCommandActorActor, 4, Void >, public FastAllocated<LocationMetadataCommandActorActor>, public LocationMetadataCommandActorActorState<LocationMetadataCommandActorActor> {
															#line 3805 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<LocationMetadataCommandActorActor>::operator new;
	using FastAllocated<LocationMetadataCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15351908333225251328UL, 4245929231807200256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LocationMetadataCommandActorActor, 0, Void >;
friend struct ActorCallback< LocationMetadataCommandActorActor, 1, Void >;
friend struct ActorCallback< LocationMetadataCommandActorActor, 2, Void >;
friend struct ActorCallback< LocationMetadataCommandActorActor, 3, Void >;
friend struct ActorCallback< LocationMetadataCommandActorActor, 4, Void >;
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	LocationMetadataCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 3826 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   LocationMetadataCommandActorActorState<LocationMetadataCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2242038487658022656UL, 8815481168060479232UL);
		ActorExecutionContextHelper __helper(static_cast<LocationMetadataCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("locationMetadataCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("locationMetadataCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LocationMetadataCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LocationMetadataCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LocationMetadataCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LocationMetadataCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LocationMetadataCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
[[nodiscard]] Future<bool> locationMetadataCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"
	return Future<bool>(new LocationMetadataCommandActorActor(cx, tokens));
															#line 3862 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/LocationMetadataCommand.actor.g.cpp.py_gen"
}

#line 284 "/Users/ec2-user/foundationdb/fdbcli/LocationMetadataCommand.actor.cpp"

CommandFactory locationMetadataFactory(
    "location_metadata",
    CommandHelp(
        "location_metadata [physicalshards|resolve|servershards|listshards] [<id>|<begin>|<n>] [<end>|physical]",
        "Check location metadata",
        "To check number of physical shards: `location_metadata physicalshards'\n"
        "To check the location of a key: `location_metadata resolve <key>'\n"
        "To check the location of a keyrange: `location_metadata resolve <begin> <end>'\n"
        "To check shard assignments of a storage server: `location_metadata servershards <ssID>'\n"
        "To list <n> random physical shards: `location_metadata listshards <n> physical'\n"
        "To list <n> random non-physical shards: `location_metadata listshards <n>'\n"));
} // namespace fdb_cli
