/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBLibraryRule;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TuplePackingTest {
    private static final byte FF = -1;
    @RegisterExtension
    static final FDBLibraryRule fdbLib = FDBLibraryRule.current();
    static final List<Tuple> baseTuples = Arrays.asList(new Tuple(), Tuple.from((Object[])new Object[0]), Tuple.from((Object[])new Object[]{null}), Tuple.from((Object[])new Object[]{"prefix"}), Tuple.from((Object[])new Object[]{"prefix", null}), Tuple.from((Object[])new Object[]{new UUID(100L, 1000L)}), Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1)}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)2)})}), Tuple.from((Object[])new Object[]{Collections.singletonList(Versionstamp.incomplete((int)3))}));
    static final List<Object> items = Arrays.asList(null, 1066L, BigInteger.valueOf(1066L), BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE), Float.valueOf(-3.14f), 2.71828, new byte[]{1, 2, 3}, new byte[]{1, 0, 2, 0, 3}, "hello there", "hell\u0000 there", "\ud83d\udd25", "\ufb14", false, true, Float.valueOf(Float.NaN), Float.valueOf(Float.intBitsToFloat(Integer.MAX_VALUE)), Double.NaN, Double.longBitsToDouble(Long.MAX_VALUE), Versionstamp.complete((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (int)100), Versionstamp.incomplete((int)4), new UUID(-1L, 1L), Tuple.from((Object[])new Object[]{null}), Tuple.from((Object[])new Object[]{"suffix", "tuple"}), Tuple.from((Object[])new Object[]{"s\u0000ffix", "tuple"}), Arrays.asList("suffix", "tuple"), Arrays.asList("suffix", null, "tuple"), Tuple.from((Object[])new Object[]{"suffix", null, "tuple"}), Tuple.from((Object[])new Object[]{"suffix", Versionstamp.incomplete((int)4), "tuple"}), Arrays.asList("suffix", Arrays.asList("inner", Versionstamp.incomplete((int)5), "tuple"), "tuple"));

    TuplePackingTest() {
    }

    static final Stream<Arguments> baseAddCartesianProduct() {
        return baseTuples.stream().flatMap(tuple -> {
            Stream stream = items.stream();
            return items.stream().map(object -> Arguments.of((Object[])new Object[]{tuple, object}));
        });
    }

    static List<Tuple> twoIncomplete() {
        return Arrays.asList(Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1), Versionstamp.incomplete((int)2)}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)3)}), Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)4)})}), new Tuple().add(Versionstamp.incomplete()).add(Versionstamp.incomplete()), new Tuple().add(Versionstamp.incomplete()).add(3L).add(Versionstamp.incomplete()), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{Versionstamp.incomplete()}), "dummy_string"}).add(Tuple.from((Object[])new Object[]{Versionstamp.incomplete()})), Tuple.from((Object[])new Object[]{Arrays.asList(Versionstamp.incomplete(), "dummy_string")}).add(Tuple.from((Object[])new Object[]{Versionstamp.incomplete()})), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{Versionstamp.incomplete()}), "dummy_string"}).add(Collections.singletonList(Versionstamp.incomplete())));
    }

    static final List<byte[]> malformedSequences() {
        return Arrays.asList({1, -34, -83, -64, -34}, {1, -34, -83, 0, -1, -64, -34}, {2, 104, 101, 108, 108, 111}, {2, 104, 101, 108, 0, -1, 108, 111}, {2, 117, 116, 102, 8, -128, 0}, {2, 117, 116, 102, 8, -64, 1, 0}, {2, 117, 116, 102, 16, -19, -96, -67, 0}, {2, 117, 116, 102, 16, -19, -76, -91, 0}, {2, 117, 116, 102, 16, -19, -96, -67, -19, -76, -91, 0}, {5, 2, 104, 101, 108, 108, 111, 0}, {5, 2, 104, 101, 108, 108, 111, 0, 0, -1, 2, 116, 104, 101, 114, 101, 0}, {22, 1}, {18, 1}, {29, 9, 1, 2, 3, 4, 5, 6, 7, 8}, {11, -10, 1, 2, 3, 4, 5, 6, 7, 8}, {32, 1, 2, 3}, {33, 1, 2, 3, 4, 5, 6, 7}, {48, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, {51, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {-1});
    }

    static final List<byte[]> wellFormedSequences() {
        return Arrays.asList(Tuple.from((Object[])new Object[]{new byte[]{1, 2}}).pack(), Tuple.from((Object[])new Object[]{"hello"}).pack(), Tuple.from((Object[])new Object[]{"hell\u0000"}).pack(), Tuple.from((Object[])new Object[]{1066L}).pack(), Tuple.from((Object[])new Object[]{-1066L}).pack(), Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(65)}).pack(), Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(65).negate()}).pack(), Tuple.from((Object[])new Object[]{Float.valueOf(-3.14f)}).pack(), Tuple.from((Object[])new Object[]{2.71828}).pack(), Tuple.from((Object[])new Object[]{new UUID(1066L, 1415L)}).pack(), Tuple.from((Object[])new Object[]{Versionstamp.fromBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12})}).pack());
    }

    @Test
    void testEmptyTuple() throws Exception {
        Tuple tuple = new Tuple();
        Assertions.assertTrue((boolean)tuple.isEmpty(), (String)"Empty tuple is not empty");
        Assertions.assertEquals((int)0, (int)tuple.getPackedSize(), (String)"empty tuple packed size is not 0");
        Assertions.assertEquals((int)0, (int)tuple.pack().length, (String)"empty tuple is not packed to the empty byte string");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void packedSizeMatches(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Tuple tuple3 = tuple.addAll(tuple2);
        Tuple tuple4 = tuple.addObject(object);
        Tuple tuple5 = tuple.addAll(Collections.singletonList(object));
        Assertions.assertEquals((int)(tuple.getPackedSize() + tuple2.getPackedSize()), (int)tuple3.getPackedSize(), (String)"Packed sizes aren't correct for addAll(Tuple)");
        Assertions.assertEquals((int)(tuple.getPackedSize() + tuple2.getPackedSize()), (int)tuple5.getPackedSize(), (String)"Packed sizes aren't correct for addAll(Collection)");
        Assertions.assertEquals((int)(tuple.getPackedSize() + tuple2.getPackedSize()), (int)tuple4.getPackedSize(), (String)"Packed sizes aren't correct for addObject()");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackIncorrectlyWithNoIncompleteVersionstamp(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"Skipping because baseTuple has an incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"Skipping because newItem has an incomplete versionstamp");
        Tuple tuple3 = tuple.addAll(tuple2);
        Tuple tuple4 = tuple.addObject(object);
        Tuple tuple5 = tuple.addAll(Collections.singletonList(object));
        for (Tuple tuple6 : Arrays.asList(tuple3, tuple4, tuple5)) {
            try {
                tuple6.packWithVersionstamp();
                Assertions.fail((String)"able to pack tuple with incomplete versionstamp using packWithVersionstamp");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackIncorrectlyWithAddedItemIncompleteVersionstamp(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"Skipping because baseTuple has an incomplete versionstamp");
        Assumptions.assumeTrue((boolean)tuple2.hasIncompleteVersionstamp(), (String)"Skipping because newItem has an incomplete versionstamp");
        Tuple tuple3 = tuple.addAll(tuple2);
        Tuple tuple4 = tuple.addObject(object);
        Tuple tuple5 = tuple.addAll(Collections.singletonList(object));
        for (Tuple tuple6 : Arrays.asList(tuple3, tuple4, tuple5)) {
            try {
                tuple6.pack();
                Assertions.fail((String)"able to pack tuple with incomplete versionstamp using packWithVersionstamp");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackIncorrectlyWithBaseTupleIncompleteVersionstamp(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((boolean)tuple.hasIncompleteVersionstamp(), (String)"Skipping because baseTuple has an incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"Skipping because newItem has an incomplete versionstamp");
        Tuple tuple3 = tuple.addAll(tuple2);
        Tuple tuple4 = tuple.addObject(object);
        Tuple tuple5 = tuple.addAll(Collections.singletonList(object));
        for (Tuple tuple6 : Arrays.asList(tuple3, tuple4, tuple5)) {
            try {
                tuple6.pack();
                Assertions.fail((String)"able to pack tuple with incomplete versionstamp using packWithVersionstamp");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackIncorrectlyWithOnlyIncompleteVersionstamp(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((boolean)tuple.hasIncompleteVersionstamp(), (String)"Skipping because baseTuple has an incomplete versionstamp");
        Assumptions.assumeTrue((boolean)tuple2.hasIncompleteVersionstamp(), (String)"Skipping because newItem does not have an incomplete versionstamp");
        Tuple tuple3 = tuple.addAll(tuple2);
        Tuple tuple4 = tuple.addObject(object);
        Tuple tuple5 = tuple.addAll(Collections.singletonList(object));
        for (Tuple tuple6 : Arrays.asList(tuple3, tuple4, tuple5)) {
            try {
                tuple6.pack();
                Assertions.fail((String)"able to pack tuple with incomplete versionstamp using packWithVersionstamp");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void canAddMethodsFromStream(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object)));
        Assertions.assertEquals((int)(tuple.size() + 1), (int)tuple2.size(), (String)"Incorrect tuple size after stream concat");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void canEncodeAddedItemsWithCompleteVersionstamps(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"addingTuple has incomplete versionstamp");
        byte[] byArray = ByteArrayUtil.join((byte[][])new byte[][]{tuple.pack(), tuple2.pack()});
        byte[] byArray2 = tuple2.pack(tuple.pack());
        byte[] byArray3 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object))).pack();
        byte[] byArray4 = tuple.addAll(tuple2).pack();
        byte[] byArray5 = tuple.addAll(Arrays.asList(object)).pack();
        Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray2, (String)"concatPacked != prefixPacked!");
        Assertions.assertArrayEquals((byte[])byArray2, (byte[])byArray3, (String)"prefixPacked != streamPacked!");
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])byArray4, (String)"streamPacked != tupleAddedPacked!");
        Assertions.assertArrayEquals((byte[])byArray4, (byte[])byArray5, (String)"tupleAddedPacked != listAddedPacked!");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackItemsWithCompleteVersionstamps(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"addingTuple has incomplete versionstamp");
        Tuple tuple3 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object)));
        Tuple tuple4 = tuple.addAll(tuple2);
        Tuple tuple5 = tuple.addAll(Arrays.asList(object));
        Tuple tuple6 = tuple.addObject(object);
        List<Tuple> list = Arrays.asList(tuple3, tuple4, tuple5, tuple6);
        for (Tuple tuple7 : list) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> tuple7.packWithVersionstamp());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void canEncodeAddedItemsWithIncompleteVersionstamps(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((boolean)tuple2.hasIncompleteVersionstamp(), (String)"addingTuple has incomplete versionstamp");
        byte[] byArray = tuple2.packWithVersionstamp(tuple.pack());
        byte[] byArray2 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object))).packWithVersionstamp();
        byte[] byArray3 = tuple.addAll(tuple2).packWithVersionstamp();
        byte[] byArray4 = tuple.addAll(Arrays.asList(object)).packWithVersionstamp();
        Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray2, (String)"prefixPacked != streamPacked!");
        Assertions.assertArrayEquals((byte[])byArray2, (byte[])byArray3, (String)"streamPacked != tupleAddedPacked!");
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])byArray4, (String)"tupleAddedPacked != listAddedPacked!");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackItemsWithCompleteVersionstampsForNewItem(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((!tuple.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((boolean)tuple2.hasIncompleteVersionstamp(), (String)"addingTuple has incomplete versionstamp");
        Tuple tuple3 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object)));
        Tuple tuple4 = tuple.addAll(tuple2);
        Tuple tuple5 = tuple.addAll(Arrays.asList(object));
        Tuple tuple6 = tuple.addObject(object);
        List<Tuple> list = Arrays.asList(tuple3, tuple4, tuple5, tuple6);
        for (Tuple tuple7 : list) {
            try {
                tuple7.pack();
                Assertions.fail((String)"was able to pack tuple without incomplete versionstamps");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void canEncodeAddedItemsWithIncompleteTupleVersionstamps(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((boolean)tuple.hasIncompleteVersionstamp(), (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"addingTuple has incomplete versionstamp");
        byte[] byArray = tuple.addObject(object).packWithVersionstamp();
        byte[] byArray2 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object))).packWithVersionstamp();
        byte[] byArray3 = tuple.addAll(tuple2).packWithVersionstamp();
        byte[] byArray4 = tuple.addAll(Arrays.asList(object)).packWithVersionstamp();
        Assertions.assertArrayEquals((byte[])byArray, (byte[])byArray2, (String)"prefixPacked != streamPacked!");
        Assertions.assertArrayEquals((byte[])byArray2, (byte[])byArray3, (String)"streamPacked != tupleAddedPacked!");
        Assertions.assertArrayEquals((byte[])byArray3, (byte[])byArray4, (String)"tupleAddedPacked != listAddedPacked!");
    }

    @ParameterizedTest
    @MethodSource(value={"baseAddCartesianProduct"})
    void cannotPackItemsWithCompleteVersionstampsForBaseTuple(Tuple tuple, Object object) throws Exception {
        Tuple tuple2 = Tuple.from((Object[])new Object[]{object});
        Assumptions.assumeTrue((boolean)tuple.hasIncompleteVersionstamp(), (String)"baseTuple has incomplete versionstamp");
        Assumptions.assumeTrue((!tuple2.hasIncompleteVersionstamp() ? 1 : 0) != 0, (String)"addingTuple has incomplete versionstamp");
        Tuple tuple3 = Tuple.fromStream(Stream.concat(tuple.stream(), Stream.of(object)));
        Tuple tuple4 = tuple.addAll(tuple2);
        Tuple tuple5 = tuple.addAll(Arrays.asList(object));
        Tuple tuple6 = tuple.addObject(object);
        List<Tuple> list = Arrays.asList(tuple3, tuple4, tuple5, tuple6);
        for (Tuple tuple7 : list) {
            try {
                tuple7.pack();
                Assertions.fail((String)"was able to pack tuple without incomplete versionstamps");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    void testIncompleteVersionstamps() throws Exception {
        Assumptions.assumeTrue((FDB.instance().getAPIVersion() > 520 ? 1 : 0) != 0, (String)"Skipping test because version is too old");
        byte[] byArray = new byte[65790];
        Arrays.fill(byArray, (byte)127);
        Tuple tuple = Tuple.from((Object[])new Object[]{byArray, Versionstamp.complete((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}), new byte[]{1, 1}});
        Tuple tuple2 = Tuple.from((Object[])new Object[]{byArray, Versionstamp.incomplete()});
        Assertions.assertNotEquals((Object)tuple, (Object)tuple2, (String)("tuples " + tuple + " and " + tuple2 + " compared equal"));
        byte[] byArray2 = tuple.pack();
        byte[] byArray3 = tuple2.packWithVersionstamp();
        Assertions.assertArrayEquals((byte[])byArray2, (byte[])byArray3, (String)("tuples " + tuple + " and " + tuple2 + " did not have matching representations"));
        Assertions.assertNotEquals((Object)tuple, (Object)tuple2, (String)("tuples " + tuple + " and " + tuple2 + "+ compared equal with memoized packed representations"));
    }

    @Test
    void testPositionInformationAdjustmentForIncompleteVersionstamp() throws Exception {
        Tuple tuple = Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1)});
        Assertions.assertEquals((int)17, (int)tuple.getPackedSize(), (String)("incomplete versionstamp has incorrect packed size: " + tuple.getPackedSize()));
        byte[] byArray = tuple.packWithVersionstamp();
        Assertions.assertEquals((int)1, (int)ByteBuffer.wrap(byArray, byArray.length - 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt(), (String)"incomplete versionstamp has incorrect position");
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1)}), (Object)Tuple.fromBytes((byte[])byArray, (int)0, (int)(byArray.length - 4)), (String)"unpacked bytes did not match");
        Subspace subspace = new Subspace(Tuple.from((Object[])new Object[]{"prefix"}));
        byte[] byArray2 = subspace.packWithVersionstamp(tuple);
        Assertions.assertEquals((int)(1 + subspace.getKey().length), (int)ByteBuffer.wrap(byArray2, byArray2.length - 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt(), (String)"incomplete versionstamp has incorrect position with prefix");
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{"prefix", Versionstamp.incomplete((int)1)}), (Object)Tuple.fromBytes((byte[])byArray2, (int)0, (int)(byArray2.length - 4)), (String)"unpacked bytes with subspace did not match");
        try {
            tuple.pack();
            Assertions.fail((String)"was able to pack versionstamp with incomplete versionstamp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"twoIncomplete"})
    void testTwoIncompleteVersionstamps(Tuple tuple) {
        Assertions.assertTrue((boolean)tuple.hasIncompleteVersionstamp(), (String)"tuple doesn't think is has incomplete versionstamps");
        Assertions.assertTrue((tuple.getPackedSize() >= 34 ? 1 : 0) != 0, (String)("tuple packed size " + tuple.getPackedSize() + " is smaller than expected"));
        try {
            tuple.pack();
            Assertions.fail((String)"no error throws when packing any incomplete versionstamps");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            tuple.packWithVersionstamp();
            Assertions.fail((String)"no error thrown when packing with versionstamp with two incompletes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"malformedSequences"})
    void cantUnpackMalformedSequences(byte[] byArray) {
        try {
            Tuple tuple = Tuple.fromBytes((byte[])byArray);
            Assertions.fail((String)("Able to unpack " + ByteArrayUtil.printable((byte[])byArray) + " into " + tuple));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"wellFormedSequences"})
    void cantUnpackSequencesWithLastCharacter(byte[] byArray) throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)0, (int)(byArray.length - 1)), (String)String.format("Able to unpack <%s> without last character", ByteArrayUtil.printable((byte[])byArray)));
    }

    @Test
    void malformedStrings() throws Exception {
        List<String> list = Arrays.asList("\ud83d", "\ud83da", "\ud83d\ud8ed", "\udd25", "\udd26\udd6f", "a\udd25", "a\udd25\udd6e", "a\udd25\udd6f", "\ud33d\udd25\udd25");
        for (String string : list) {
            Tuple tuple = Tuple.from((Object[])new Object[]{string});
            try {
                tuple.getPackedSize();
                Assertions.fail((String)("able to get packed size of malformed string " + ByteArrayUtil.printable((byte[])string.getBytes())));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                tuple.pack();
                Assertions.fail((String)("able to pack malformed string " + ByteArrayUtil.printable((byte[])string.getBytes())));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                Field field = Tuple.class.getDeclaredField("memoizedPackedSize");
                AccessController.doPrivileged(() -> {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.setInt(tuple, 2 + string.getBytes("UTF-8").length);
                    return null;
                });
                tuple.pack();
                Assertions.fail((String)"able to pack malformed string");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

