/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.test.TestResult;
import com.apple.foundationdb.test.TesterArgs;
import java.nio.charset.Charset;
import java.util.Random;

public abstract class AbstractTester {
    protected static final int NUM_RUNS = 25;
    protected static final Charset ASCII = Charset.forName("ASCII");
    protected TesterArgs args = null;
    protected Random random = new Random();
    protected TestResult result = new TestResult(this.random);
    protected FDB fdb;

    public void runTest() {
        try (Database database = this.fdb.open();){
            try {
                this.testPerformance(database);
            }
            catch (Exception exception) {
                this.result.addError(this.wrapAndPrintError(exception, "Failed to complete all tests"));
            }
        }
        catch (Exception exception) {
            this.result.addError(this.wrapAndPrintError(exception, "fdb.open failed"));
            return;
        }
    }

    public abstract void testPerformance(Database var1);

    public String multiVersionDescription() {
        if (this.args == null) {
            return "";
        }
        if (!this.args.useMultiversionApi()) {
            return "multi-version API disabled";
        }
        if (this.args.useExternalClient()) {
            if (this.args.putCallbacksOnExternalThread()) {
                return "external client on external thread";
            }
            return "external client on main thread";
        }
        return "local client";
    }

    public void run(String[] stringArray) {
        this.args = TesterArgs.parseArgs(stringArray);
        if (this.args == null) {
            return;
        }
        this.fdb = FDB.selectAPIVersion((int)740);
        if (!this.args.useMultiversionApi()) {
            if (this.args.putCallbacksOnExternalThread() || this.args.useExternalClient()) {
                throw new IllegalArgumentException("Invalid multi-version API argument combination");
            }
            this.fdb.options().setDisableMultiVersionClientApi();
        }
        if (this.args.putCallbacksOnExternalThread()) {
            if (!this.args.useExternalClient()) {
                throw new IllegalArgumentException("Cannot enable callbacks on external thread without using external client");
            }
            this.fdb.options().setCallbacksOnExternalThreads();
        }
        if (this.args.useExternalClient()) {
            this.fdb.options().setDisableLocalClient();
        }
        try {
            this.runTest();
        }
        catch (Exception exception) {
            this.result.addError(exception);
        }
        this.result.save(this.args.getOutputDirectory());
    }

    public RuntimeException wrapAndPrintError(Throwable throwable, String string) {
        String string2 = string + ": " + throwable.getClass() + ": " + throwable.getMessage() + "\n";
        throwable.printStackTrace();
        return new RuntimeException(string2, throwable);
    }
}

