/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.async.CloneableException;

public class FDBException
extends RuntimeException
implements CloneableException {
    private static final long serialVersionUID = 1L;
    private final int code;

    public FDBException(String string, int n) {
        super(string);
        this.code = n;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.getCode() == 0;
    }

    @Override
    public Exception retargetClone() {
        FDBException fDBException = new FDBException(this.getMessage(), this.code);
        fDBException.initCause(this);
        return fDBException;
    }

    public boolean isRetryable() {
        return FDB.evalErrorPredicate(50000, this.code);
    }

    public boolean isMaybeCommitted() {
        return FDB.evalErrorPredicate(50001, this.code);
    }

    public boolean isRetryableNotCommitted() {
        return FDB.evalErrorPredicate(50002, this.code);
    }
}

