#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
/*
 * GenericManagementAPI.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H
#include "fdbclient/GenericManagementAPI.actor.g.h"
#elif !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H

/* This file defines "management" interfaces that have been templated to support both IClientAPI
and Native version of databases, transactions, etc., and includes functions for performing cluster
management tasks. It isn't exposed to C clients or anywhere outside our code base and doesn't need
to be versioned. It doesn't do anything you can't do with the standard API and some knowledge of
the contents of the system key space.
*/

#include <string>
#include <map>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/Status.h"
#include "fdbclient/Subspace.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // has to be last include

// ConfigurationResult enumerates normal outcomes of changeConfig() and various error
// conditions specific to it.  changeConfig may also throw an Error to report other problems.
enum class ConfigurationResult {
	NO_OPTIONS_PROVIDED,
	CONFLICTING_OPTIONS,
	UNKNOWN_OPTION,
	INCOMPLETE_CONFIGURATION,
	INVALID_CONFIGURATION,
	STORAGE_MIGRATION_DISABLED,
	DATABASE_ALREADY_CREATED,
	DATABASE_CREATED,
	DATABASE_UNAVAILABLE,
	STORAGE_IN_UNKNOWN_DCID,
	REGION_NOT_FULLY_REPLICATED,
	MULTIPLE_ACTIVE_REGIONS,
	REGIONS_CHANGED,
	NOT_ENOUGH_WORKERS,
	REGION_REPLICATION_MISMATCH,
	DCID_MISSING,
	LOCKED_NOT_NEW,
	SUCCESS_WARN_PPW_GRADUAL,
	SUCCESS,
	SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_IS_REGISTERED,
	ENCRYPTION_AT_REST_MODE_ALREADY_SET,
	INVALID_STORAGE_TYPE
};

enum class CoordinatorsResult {
	INVALID_NETWORK_ADDRESSES,
	SAME_NETWORK_ADDRESSES,
	NOT_COORDINATORS, // FIXME: not detected
	DATABASE_UNREACHABLE, // FIXME: not detected
	BAD_DATABASE_STATE,
	COORDINATOR_UNREACHABLE,
	NOT_ENOUGH_MACHINES,
	SUCCESS
};

struct ConfigureAutoResult {
	std::map<NetworkAddress, ProcessClass> address_class;
	int32_t processes;
	int32_t machines;

	std::string old_replication;
	int32_t old_commit_proxies;
	int32_t old_grv_proxies;
	int32_t old_resolvers;
	int32_t old_logs;
	int32_t old_processes_with_transaction;
	int32_t old_machines_with_transaction;

	std::string auto_replication;
	int32_t auto_commit_proxies;
	int32_t auto_grv_proxies;
	int32_t auto_resolvers;
	int32_t auto_logs;
	int32_t auto_processes_with_transaction;
	int32_t auto_machines_with_transaction;

	int32_t desired_commit_proxies;
	int32_t desired_grv_proxies;
	int32_t desired_resolvers;
	int32_t desired_logs;

	ConfigureAutoResult()
	  : processes(-1), machines(-1), old_commit_proxies(-1), old_grv_proxies(-1), old_resolvers(-1), old_logs(-1),
	    old_processes_with_transaction(-1), old_machines_with_transaction(-1), auto_commit_proxies(-1),
	    auto_grv_proxies(-1), auto_resolvers(-1), auto_logs(-1), auto_processes_with_transaction(-1),
	    auto_machines_with_transaction(-1), desired_commit_proxies(-1), desired_grv_proxies(-1), desired_resolvers(-1),
	    desired_logs(-1) {}

	bool isValid() const { return processes != -1; }
};

ConfigurationResult buildConfiguration(
    std::vector<StringRef> const& modeTokens,
    std::map<std::string, std::string>& outConf); // Accepts a vector of configuration tokens
ConfigurationResult buildConfiguration(
    std::string const& modeString,
    std::map<std::string, std::string>& outConf); // Accepts tokens separated by spaces in a single string

bool isCompleteConfiguration(std::map<std::string, std::string> const& options);

ConfigureAutoResult parseConfig(StatusObject const& status);

// TODO(gglass): consider removing
bool isEncryptionAtRestModeConfigValid(Optional<DatabaseConfiguration> oldConfiguration,
                                       std::map<std::string, std::string> newConfig,
                                       bool creating);

// Management API written in template code to support both IClientAPI and NativeAPI
namespace ManagementAPI {

															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
// This generated class is to be used only via getWorkers()
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr, class GetWorkersActor>
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActorState {
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActorState(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : tr(tr),
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processClassesF(processClassesF),
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processDataF(processDataF)
															#line 161 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = tr->getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = tr->getRange(workerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 149 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClasses = safeThreadFutureToFuture(processClassesF);
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processData = safeThreadFutureToFuture(processDataF);
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_0 = success(processClasses) && success(processData);
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 154 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 156 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 157 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 222 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 234 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 246 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 251 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 154 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 156 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 157 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 271 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 287 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 291 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 295 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 300 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<Tr> tr;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processClassesF;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processDataF;
															#line 149 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processClasses;
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processData;
															#line 393 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
};
// This generated class is to be used only via getWorkers()
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActor final : public Actor<std::vector<ProcessData>>, public ActorCallback< GetWorkersActor<Tr>, 0, Void >, public FastAllocated<GetWorkersActor<Tr>>, public GetWorkersActorState<Tr, GetWorkersActor<Tr>> {
															#line 400 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
	using FastAllocated<GetWorkersActor<Tr>>::operator new;
	using FastAllocated<GetWorkersActor<Tr>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8009756277549272576UL, 14250803930886064128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<ProcessData>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor<Tr>, 0, Void >;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActor(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 417 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		 : Actor<std::vector<ProcessData>>(),
		   GetWorkersActorState<Tr, GetWorkersActor<Tr>>(tr, processClassesF, processDataF),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor<Tr>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Reference<Tr> const& tr, typename Tr::template FutureT<RangeResult> const& processClassesF, typename Tr::template FutureT<RangeResult> const& processDataF ) {
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<std::vector<ProcessData>>(new GetWorkersActor<Tr>(tr, processClassesF, processDataF));
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
}

#line 178 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// All versions of changeConfig apply the given set of configuration tokens to the database, and return a
// ConfigurationResult (or error).

// Accepts a full configuration in key/value format (from buildConfiguration)
															#line 460 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
// This generated class is to be used only via changeConfig()
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class ChangeConfigActor>
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActorState {
															#line 466 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActorState(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   m(m),
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   force(force),
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   initIdKey("\xff/init_id"_sr),
															#line 186 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction())
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigActorState() 
	{
		fdb_probe_actor_destroy("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!m.size())
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 189 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NO_OPTIONS_PROVIDED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 500 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NO_OPTIONS_PROVIDED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 193 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::string initKey = configKeysPrefix.toString() + "initialized";
															#line 194 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			creating = m.count(initKey) != 0;
															#line 195 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			locked = Optional<UID>();
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 197 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				auto iter = m.find(databaseLockedKey.toString());
															#line 198 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (iter != m.end())
															#line 518 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 199 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!creating)
															#line 522 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 200 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::LOCKED_NOT_NEW); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::LOCKED_NOT_NEW);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 202 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					locked = UID::fromString(iter->second);
															#line 203 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					m.erase(iter);
															#line 536 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
															#line 206 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (creating)
															#line 541 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 207 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				m[initIdKey.toString()] = deterministicRandom()->randomUniqueID().toString();
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!isCompleteConfiguration(m))
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 209 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 551 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (m.count(encryptionAtRestModeConfKey.toString()) != 0)
															#line 562 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 566 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 216 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tooLong = delay(60);
															#line 217 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			versionKey = BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned());
															#line 218 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = false;
															#line 221 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			resetPPWStats = false;
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnPPWGradual = false;
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnShardedRocksDBIsExperimental = false;
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 587 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigActorState();
		static_cast<ChangeConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 494 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (warnPPWGradual)
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 614 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (warnShardedRocksDBIsExperimental)
															#line 624 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 497 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 628 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 638 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 228 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 230 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!creating && !force)
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfigF = tr->getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 235 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfig = safeThreadFutureToFuture(fConfigF);
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fWorkers = getWorkers(tr, processClassesF, processDataF);
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				StrictFuture<Void> __when_expr_0 = success(fConfig) || tooLong;
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeConfigActor*>(this)->actor_wait_state = 1;
															#line 239 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 0, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 464 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			e1 = Error(e);
															#line 465 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if ((e.code() == error_code_not_committed || e.code() == error_code_transaction_too_old) && creating)
															#line 731 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 468 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->reset();
															#line 469 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				;
															#line 737 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (creating)
															#line 757 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 423 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::INITIALIZE_NEW_DATABASE);
															#line 424 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->addReadConflictRange(singleKeyRange(initIdKey));
															#line 763 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
		else
		{
															#line 425 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m.size())
															#line 769 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->addReadConflictRange(singleKeyRange(m.begin()->first));
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 432 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (locked.present())
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 433 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(creating);
															#line 434 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->atomicOp(databaseLockedKey, BinaryWriter::toValue(locked.get(), Unversioned()) .withPrefix("0123456789"_sr) .withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 786 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 441 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(auto i = m.begin();i != m.end();++i) {
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(StringRef(i->first), StringRef(i->second));
															#line 443 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (i->first == perpetualStorageWiggleKey)
															#line 794 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (i->second == "0")
															#line 798 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 445 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					resetPPWStats = true;
															#line 802 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
				else
				{
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (i->first == "1")
															#line 808 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						resetPPWStats = false;
															#line 812 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					}
				}
			}
		}
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!creating && resetPPWStats)
															#line 819 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			wiggleData = StorageWiggleData();
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_5 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(true));
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 6;
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 5, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 832 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont24(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 246 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 248 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 251 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 872 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid())
															#line 876 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 880 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 888 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 892 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 264 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 902 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 267 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 268 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 910 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
															#line 270 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 916 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 272 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 277 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 278 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 279 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 280 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					}
				}
															#line 283 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 946 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 290 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 293 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 978 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 320 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 323 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 991 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						{
															#line 325 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 326 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 997 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						}
					}
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1004 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1009 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 1029 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 1041 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 246 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 248 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 251 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid())
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1063 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1075 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 264 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 1085 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 267 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 268 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 1093 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
															#line 270 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 1099 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 272 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1103 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 277 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 278 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 279 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 1116 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 280 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 1120 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					}
				}
															#line 283 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 1125 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 290 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 293 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 1142 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 1146 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1156 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1161 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 320 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 323 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						{
															#line 325 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 326 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						}
					}
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1187 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1192 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 1293 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_3 = success(fServerList) || tooLong;
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1299 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 4;
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 3, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 1324 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 303 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 306 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 308 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 309 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 1350 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 1357 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 1376 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1380 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 303 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 305 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 306 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 308 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 309 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 1402 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 315 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1413 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont19(Void const& _,int loopDepth) 
	{
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 332 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 1505 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1509 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 1517 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1521 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(Void && _,int loopDepth) 
	{
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 332 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 1538 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1542 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_4 = success(fWorkers) || tooLong;
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1646 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont22when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 5;
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 4, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1651 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void const& _,int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 1660 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1664 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 348 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 349 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 1680 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 356 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 358 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 1690 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 359 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 1694 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 362 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 1699 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 363 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void && _,int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 1717 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1721 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 348 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 349 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 1737 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 356 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 358 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 1747 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 359 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 1751 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 362 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 1756 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 363 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 368 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 369 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1853 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 372 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 1861 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 373 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 1869 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 376 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 1873 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
															#line 379 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 380 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 1880 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 382 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1884 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 384 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 1892 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 385 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 386 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 387 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 1900 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					}
															#line 389 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 1904 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 390 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1908 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 395 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 396 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 397 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 1925 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 1929 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
															#line 401 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 1934 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 402 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1938 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 407 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1951 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 412 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1963 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 413 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 1973 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 1977 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
			else
			{
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 1983 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
		}
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1(Void && _,int loopDepth) 
	{
															#line 368 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 1999 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 369 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2003 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 372 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 2011 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 373 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2019 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 376 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 2023 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
															#line 379 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 380 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2030 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 382 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 384 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 2042 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 385 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 386 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 387 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 2050 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					}
															#line 389 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 2054 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
					{
															#line 390 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2058 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 395 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 396 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 397 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2075 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 2079 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
															#line 401 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2084 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 402 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2088 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 2097 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 407 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2101 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 2109 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 412 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2113 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 413 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 2123 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 2127 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
			else
			{
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 2133 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				{
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 2137 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				}
			}
		}
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont24(int loopDepth) 
	{
															#line 458 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 459 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_7 = safeThreadFutureToFuture(tr->commit());
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont24when1(__when_expr_7.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 8;
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 7, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2235 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void const& _,int loopDepth) 
	{
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_6 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2246 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_6.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 7;
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 6, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2251 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void && _,int loopDepth) 
	{
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_6 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2262 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_6.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 7;
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 6, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont34cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont34when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont34when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont24cont1(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24cont1(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont24when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont24when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 490 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_10 = safeThreadFutureToFuture(tr->onError(e1));
															#line 490 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2527 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 11;
															#line 490 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 10, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2532 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
		try {
															#line 471 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 472 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 473 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 474 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 476 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			vF = tr->get(initIdKey);
															#line 477 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<Value>> __when_expr_8 = safeThreadFutureToFuture(vF);
															#line 477 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 9;
															#line 477 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 8, Optional<Value> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2566 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_9 = safeThreadFutureToFuture(tr->onError(e2));
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2590 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 10;
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 9, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2595 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 2610 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 479 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2614 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 480 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 2624 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 482 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2628 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 484 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2638 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 2652 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 479 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2656 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 480 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 2666 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 482 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2670 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 484 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2680 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 8, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 8, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::map<std::string, std::string> m;
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool force;
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StringRef initIdKey;
															#line 186 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 194 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool creating;
															#line 195 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Optional<UID> locked;
															#line 216 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<Void> tooLong;
															#line 217 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 218 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool oldReplicationUsesDcId;
															#line 221 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool resetPPWStats;
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnPPWGradual;
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnShardedRocksDBIsExperimental;
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fConfigF;
															#line 235 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fConfig;
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<std::vector<ProcessData>> fWorkers;
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration oldConfig;
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration newConfig;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fServerListF;
															#line 290 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fServerList;
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fLocalityListF;
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fLocalityList;
															#line 320 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>> replicasFuturesF;
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StorageWiggleData wiggleData;
															#line 464 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Error e1;
															#line 476 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<Optional<Value>> vF;
															#line 2997 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
};
// This generated class is to be used only via changeConfig()
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< ChangeConfigActor<DB>, 0, Void >, public ActorCallback< ChangeConfigActor<DB>, 1, Void >, public ActorCallback< ChangeConfigActor<DB>, 2, Void >, public ActorCallback< ChangeConfigActor<DB>, 3, Void >, public ActorCallback< ChangeConfigActor<DB>, 4, Void >, public ActorCallback< ChangeConfigActor<DB>, 5, Void >, public ActorCallback< ChangeConfigActor<DB>, 6, Void >, public ActorCallback< ChangeConfigActor<DB>, 7, Void >, public ActorCallback< ChangeConfigActor<DB>, 8, Optional<Value> >, public ActorCallback< ChangeConfigActor<DB>, 9, Void >, public ActorCallback< ChangeConfigActor<DB>, 10, Void >, public FastAllocated<ChangeConfigActor<DB>>, public ChangeConfigActorState<DB, ChangeConfigActor<DB>> {
															#line 3004 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
	using FastAllocated<ChangeConfigActor<DB>>::operator new;
	using FastAllocated<ChangeConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8890408498617069568UL, 12899111807254906624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigActor<DB>, 0, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 1, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 2, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 3, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 4, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 5, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 6, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 7, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 8, Optional<Value> >;
friend struct ActorCallback< ChangeConfigActor<DB>, 9, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 10, Void >;
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActor(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 3031 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		 : Actor<ConfigurationResult>(),
		   ChangeConfigActorState<DB, ChangeConfigActor<DB>>(db, m, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6578240440549909504UL, 3862103298456711424UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 8, Optional<Value> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> changeConfig( Reference<DB> const& db, std::map<std::string, std::string> const& m, bool const& force ) {
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new ChangeConfigActor<DB>(db, m, force));
															#line 3075 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
}

#line 502 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

															#line 3080 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
// This generated class is to be used only via autoConfig()
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class AutoConfigActor>
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActorState {
															#line 3086 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActorState(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   conf(conf),
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction()),
															#line 506 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   versionKey(BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned()))
															#line 3099 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
	{
		fdb_probe_actor_create("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	~AutoConfigActorState() 
	{
		fdb_probe_actor_destroy("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!conf.address_class.size())
															#line 3114 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 509 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 3126 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 513 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 514 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 515 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 516 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 519 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 520 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(tr, processClassesF, processDataF);
															#line 520 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3171 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 1;
															#line 520 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*>(static_cast<AutoConfigActor*>(this)));
															#line 3176 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 567 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 567 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3200 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 3;
															#line 567 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 2, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3205 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 521 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 522 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 523 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 3224 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 526 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 527 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 3230 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 528 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 3234 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
			else
			{
															#line 530 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 3240 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 534 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 3245 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 535 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 3249 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 537 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 3253 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 538 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 540 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 3261 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 3265 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 3269 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 544 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 3273 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 546 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 3277 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 547 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 3281 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 549 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 3285 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 551 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 552 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 553 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 554 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 3297 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 555 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3301 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 557 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 558 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 3311 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 561 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 562 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3322 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3327 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 521 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 522 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 523 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 526 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 527 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 3346 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 528 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 3350 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
			else
			{
															#line 530 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 3356 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 534 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 3361 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 535 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 3365 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 537 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 3369 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 538 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 3373 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 540 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 3377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 3381 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 3385 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 544 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 3389 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 546 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 3393 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 547 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 3397 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		}
															#line 549 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 3401 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 551 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 552 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 553 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 554 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 3413 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			{
															#line 555 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3417 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 557 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 558 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 3427 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
			}
		}
															#line 561 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 562 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3438 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 564 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 3443 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3527 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 3539 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ConfigureAutoResult conf;
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 506 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 519 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 3721 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
};
// This generated class is to be used only via autoConfig()
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >, public ActorCallback< AutoConfigActor<DB>, 1, Void >, public ActorCallback< AutoConfigActor<DB>, 2, Void >, public FastAllocated<AutoConfigActor<DB>>, public AutoConfigActorState<DB, AutoConfigActor<DB>> {
															#line 3728 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
public:
	using FastAllocated<AutoConfigActor<DB>>::operator new;
	using FastAllocated<AutoConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(989963130631614464UL, 5411228296757714176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >;
friend struct ActorCallback< AutoConfigActor<DB>, 1, Void >;
friend struct ActorCallback< AutoConfigActor<DB>, 2, Void >;
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActor(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 3747 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
		 : Actor<ConfigurationResult>(),
		   AutoConfigActorState<DB, AutoConfigActor<DB>>(db, conf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(851761084017320448UL, 5414860964962561792UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("autoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> autoConfig( Reference<DB> const& db, ConfigureAutoResult const& conf ) {
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new AutoConfigActor<DB>(db, conf));
															#line 3783 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h.py_gen"
}

#line 571 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// Accepts tokens separated by spaces in a single string
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db, std::string const& modes, bool force) {
	TraceEvent("ChangeConfig").detail("Mode", modes);
	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// Accepts a vector of configuration tokens
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db,
                                         std::vector<StringRef> const& modes,
                                         Optional<ConfigureAutoResult> const& conf,
                                         bool force) {
	if (modes.size() && modes[0] == "auto"_sr && conf.present()) {
		return autoConfig(db, conf.get());
	}

	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// return the corresponding error message for the CoordinatorsResult
// used by special keys and fdbcli
std::string generateErrorMessage(const CoordinatorsResult& res);

} // namespace ManagementAPI

#include "flow/unactorcompiler.h"
#endif
