#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
/*
 * GetAuditStatusCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fmt/core.h>

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/IClientApi.h"
#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 37 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgressByRange()
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressByRangeActor>
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByRangeActorState {
															#line 43 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByRangeActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange),
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToRead(auditRange),
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToReadBegin(auditRange.begin),
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   retryCount(0),
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   finishCount(0)
															#line 64 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgressByRange", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressByRangeActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgressByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressByRangeActorState();
		static_cast<GetAuditProgressByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Finished range count: {}", finishCount);
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressByRangeActorState(); static_cast<GetAuditProgressByRangeActor*>(this)->destroy(); return 0; }
															#line 104 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAuditProgressByRangeActorState();
		static_cast<GetAuditProgressByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 40 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 123 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 41 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 43 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByRange(cx, auditType, auditId, rangeToRead);
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 169 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 1;
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*>(static_cast<GetAuditProgressByRangeActor*>(this)));
															#line 174 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 61 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 209 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 213 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (retryCount > 30)
															#line 217 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				fmt::println("Incomplete check");
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressByRangeActorState(); static_cast<GetAuditProgressByRangeActor*>(this)->destroy(); return 0; }
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetAuditProgressByRangeActorState();
				static_cast<GetAuditProgressByRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 68 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 68 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 2;
															#line 68 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByRangeActor, 1, Void >*>(static_cast<GetAuditProgressByRangeActor*>(this)));
															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 46 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				fmt::println("( Ongoing ) {}", auditStates[i].range.toString());
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (phase == AuditPhase::Error)
															#line 267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fmt::println("( Error   ) {}", auditStates[i].range.toString());
															#line 52 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					++finishCount;
															#line 273 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					++finishCount;
															#line 279 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 58 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 286 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		auditStates = __auditStates;
															#line 295 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByRangeActor*>(this)->ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 374 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 383 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByRangeActor*>(this)->ActorCallback< GetAuditProgressByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 36 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange rangeToRead;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Key rangeToReadBegin;
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int retryCount;
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int64_t finishCount;
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgressByRange()
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByRangeActor final : public Actor<Void>, public ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< GetAuditProgressByRangeActor, 1, Void >, public FastAllocated<GetAuditProgressByRangeActor>, public GetAuditProgressByRangeActorState<GetAuditProgressByRangeActor> {
															#line 486 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressByRangeActor>::operator new;
	using FastAllocated<GetAuditProgressByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(878603218099526656UL, 10014120587819809024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditProgressByRangeActor, 1, Void >;
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByRangeActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 504 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAuditProgressByRangeActorState<GetAuditProgressByRangeActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3099155687841437696UL, 2572556085011420416UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgressByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgressByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressByRangeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<Void> getAuditProgressByRange( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<Void>(new GetAuditProgressByRangeActor(cx, auditType, auditId, auditRange));
															#line 537 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 76 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 542 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getStorageServers()
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetStorageServersActor>
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetStorageServersActorState {
															#line 548 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetStorageServersActorState(Database const& cx) 
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 78 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   tr(cx)
															#line 557 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 572 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		try {
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, RangeResult >*>(static_cast<GetStorageServersActor*>(this)));
															#line 615 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 2;
															#line 91 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 1, Void >*>(static_cast<GetStorageServersActor*>(this)));
															#line 644 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& serverList,int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 85 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		servers.reserve(serverList.size());
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 88 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 667 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && serverList,int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 85 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		servers.reserve(serverList.size());
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 88 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 695 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 78 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Transaction tr;
															#line 869 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getStorageServers()
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetStorageServersActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< GetStorageServersActor, 0, RangeResult >, public ActorCallback< GetStorageServersActor, 1, Void >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 874 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17533007284590913280UL, 9753788128283431424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, RangeResult >;
friend struct ActorCallback< GetStorageServersActor, 1, Void >;
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetStorageServersActor(Database const& cx) 
															#line 892 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<std::vector<StorageServerInterface>>(),
		   GetStorageServersActorState<GetStorageServersActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> getStorageServers( Database const& cx ) {
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new GetStorageServersActor(cx));
															#line 925 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 95 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 930 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgressByServer()
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressByServerActor>
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByServerActorState {
															#line 936 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByServerActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId) 
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange),
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   serverId(serverId),
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToRead(auditRange),
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   rangeToReadBegin(auditRange.begin),
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   retryCount(0)
															#line 957 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgressByServer", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressByServerActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgressByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			;
															#line 972 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressByServerActorState();
		static_cast<GetAuditProgressByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Complete); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 995 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Complete);
		this->~GetAuditProgressByServerActorState();
		static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 1014 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 1020 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByServer(cx, auditType, auditId, serverId, rangeToRead);
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 1;
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*>(static_cast<GetAuditProgressByServerActor*>(this)));
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 121 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1100 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 1104 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (retryCount > 30)
															#line 1108 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 125 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Invalid); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Invalid);
				this->~GetAuditProgressByServerActorState();
				static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1122 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 2;
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressByServerActor, 1, Void >*>(static_cast<GetAuditProgressByServerActor*>(this)));
															#line 1127 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 1146 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Running); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1150 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Running);
				this->~GetAuditProgressByServerActorState();
				static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (phase == AuditPhase::Error)
															#line 1160 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (!static_cast<GetAuditProgressByServerActor*>(this)->SAV<AuditPhase>::futures) { (void)(AuditPhase::Error); this->~GetAuditProgressByServerActorState(); static_cast<GetAuditProgressByServerActor*>(this)->destroy(); return 0; }
															#line 1164 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					new (&static_cast<GetAuditProgressByServerActor*>(this)->SAV< AuditPhase >::value()) AuditPhase(AuditPhase::Error);
					this->~GetAuditProgressByServerActorState();
					static_cast<GetAuditProgressByServerActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		auditStates = __auditStates;
															#line 1183 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByServerActor*>(this)->ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 1262 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		retryCount++;
															#line 1271 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressByServerActor*>(this)->ActorCallback< GetAuditProgressByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID serverId;
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange rangeToRead;
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Key rangeToReadBegin;
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int retryCount;
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 1369 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgressByServer()
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressByServerActor final : public Actor<AuditPhase>, public ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >, public ActorCallback< GetAuditProgressByServerActor, 1, Void >, public FastAllocated<GetAuditProgressByServerActor>, public GetAuditProgressByServerActorState<GetAuditProgressByServerActor> {
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressByServerActor>::operator new;
	using FastAllocated<GetAuditProgressByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12437066355880308224UL, 17854440968524758016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditPhase>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditProgressByServerActor, 1, Void >;
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressByServerActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId) 
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<AuditPhase>(),
		   GetAuditProgressByServerActorState<GetAuditProgressByServerActor>(cx, auditType, auditId, auditRange, serverId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6092320488064633088UL, 17915599859443968512UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgressByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgressByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressByServerActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<AuditPhase> getAuditProgressByServer( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange, UID const& serverId ) {
															#line 96 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<AuditPhase>(new GetAuditProgressByServerActor(cx, auditType, auditId, auditRange, serverId));
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 134 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 1430 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditProgress()
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditProgressActor>
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressActorState {
															#line 1436 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditType(auditType),
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditId(auditId),
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   auditRange(auditRange)
															#line 1449 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditProgress", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditProgressActorState() 
	{
		fdb_probe_actor_destroy("getAuditProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica || auditType == AuditType::ValidateLocationMetadata)
															#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getAuditProgressByRange(cx, auditType, auditId, auditRange);
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 1;
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 0, Void >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (auditType == AuditType::ValidateStorageServerShard)
															#line 1482 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fs = std::vector<Future<Void>>();
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					res = std::unordered_map<UID, bool>();
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1492 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 2;
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					fmt::println("AuditType not implemented");
															#line 1504 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditProgressActorState();
		static_cast<GetAuditProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAuditProgressActorState(); static_cast<GetAuditProgressActor*>(this)->destroy(); return 0; }
															#line 1529 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAuditProgressActorState();
		static_cast<GetAuditProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i = 0;
															#line 144 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numCompleteServers = 0;
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numOngoingServers = 0;
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numErrorServers = 0;
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		numTSSes = 0;
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		;
															#line 1644 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<StorageServerInterface> const& __interfs,int loopDepth) 
	{
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		interfs = __interfs;
															#line 1653 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(std::vector<StorageServerInterface> && __interfs,int loopDepth) 
	{
		interfs = std::move(__interfs);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("CompleteServers: {}", numCompleteServers);
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("OngoingServers: {}", numOngoingServers);
															#line 166 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("ErrorServers: {}", numErrorServers);
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("IgnoredTSSes: {}", numTSSes);
															#line 1738 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!(i < interfs.size()))
															#line 1754 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (interfs[i].isTss())
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numTSSes++;
															#line 1764 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			return a_body1cont4continue1(loopDepth); // continue
		}
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		StrictFuture<AuditPhase> __when_expr_2 = getAuditProgressByServer(cx, auditType, auditId, allKeys, interfs[i].id());
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1771 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 3;
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAuditProgressActor, 2, AuditPhase >*>(static_cast<GetAuditProgressActor*>(this)));
															#line 1776 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4continue1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(AuditPhase const& serverPhase,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (serverPhase == AuditPhase::Running)
															#line 1807 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numOngoingServers++;
															#line 1811 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (serverPhase == AuditPhase::Complete)
															#line 1817 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				numCompleteServers++;
															#line 1821 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (serverPhase == AuditPhase::Error)
															#line 1827 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					numErrorServers++;
															#line 1831 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (serverPhase == AuditPhase::Invalid)
															#line 1837 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 161 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						fmt::println("SS {} partial progress fetched", interfs[i].id().toString());
															#line 1841 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1848 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(AuditPhase && serverPhase,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (serverPhase == AuditPhase::Running)
															#line 1857 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			numOngoingServers++;
															#line 1861 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		else
		{
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (serverPhase == AuditPhase::Complete)
															#line 1867 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				numCompleteServers++;
															#line 1871 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (serverPhase == AuditPhase::Error)
															#line 1877 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					numErrorServers++;
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (serverPhase == AuditPhase::Invalid)
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 161 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						fmt::println("SS {} partial progress fetched", interfs[i].id().toString());
															#line 1891 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		i++;
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(AuditPhase const& serverPhase,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(serverPhase, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(AuditPhase && serverPhase,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(serverPhase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAuditProgressActor*>(this)->actor_wait_state > 0) static_cast<GetAuditProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditProgressActor*>(this)->ActorCallback< GetAuditProgressActor, 2, AuditPhase >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,AuditPhase const& value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,AuditPhase && value) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAuditProgressActor, 2, AuditPhase >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditType auditType;
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	UID auditId;
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	KeyRange auditRange;
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<Future<Void>> fs;
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::unordered_map<UID, bool> res;
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<StorageServerInterface> interfs;
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int i;
															#line 144 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numCompleteServers;
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numOngoingServers;
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numErrorServers;
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	int numTSSes;
															#line 2002 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditProgress()
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditProgressActor final : public Actor<Void>, public ActorCallback< GetAuditProgressActor, 0, Void >, public ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< GetAuditProgressActor, 2, AuditPhase >, public FastAllocated<GetAuditProgressActor>, public GetAuditProgressActorState<GetAuditProgressActor> {
															#line 2007 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditProgressActor>::operator new;
	using FastAllocated<GetAuditProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17253387304688686336UL, 10334356440018667520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditProgressActor, 0, Void >;
friend struct ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetAuditProgressActor, 2, AuditPhase >;
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditProgressActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 2026 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAuditProgressActorState<GetAuditProgressActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1505681669917957376UL, 1459007093216598528UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditProgressActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAuditProgressActor, 2, AuditPhase >*)0, actor_cancelled()); break;
		}

	}
};
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<Void> getAuditProgress( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<Void>(new GetAuditProgressActor(cx, auditType, auditId, auditRange));
															#line 2060 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 173 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

															#line 2065 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via getAuditStatusCommandActor()
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
template <class GetAuditStatusCommandActorActor>
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditStatusCommandActorActorState {
															#line 2071 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditStatusCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		 : cx(cx),
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		   tokens(tokens)
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStatusCommandActorActorState() 
	{
		fdb_probe_actor_destroy("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokens.size() < 2 || tokens.size() > 5)
															#line 2095 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 177 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2101 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetAuditStatusCommandActorActorState();
				static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			AuditType type = AuditType::Invalid;
															#line 181 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokencmp(tokens[1], "ha"))
															#line 2111 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 182 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				type = AuditType::ValidateHA;
															#line 2115 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			}
			else
			{
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokencmp(tokens[1], "replica"))
															#line 2121 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					type = AuditType::ValidateReplica;
															#line 2125 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 185 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokencmp(tokens[1], "locationmetadata"))
															#line 2131 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						type = AuditType::ValidateLocationMetadata;
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 187 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokencmp(tokens[1], "ssshard"))
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							type = AuditType::ValidateStorageServerShard;
															#line 2145 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						}
						else
						{
															#line 190 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 191 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2153 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~GetAuditStatusCommandActorActorState();
							static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (tokencmp(tokens[2], "id"))
															#line 2164 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			{
															#line 195 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokens.size() != 4)
															#line 2168 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2174 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~GetAuditStatusCommandActorActorState();
					static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 199 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				const UID id = UID::fromString(tokens[3].toString());
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				StrictFuture<AuditStorageState> __when_expr_0 = getAuditState(cx, type, id);
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 1;
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2191 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 202 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
				if (tokencmp(tokens[2], "progress"))
															#line 2198 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
				{
															#line 203 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokens.size() != 4)
															#line 2202 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 204 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 205 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2208 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetAuditStatusCommandActorActorState();
						static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 207 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					const UID id = UID::fromString(tokens[3].toString());
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					StrictFuture<AuditStorageState> __when_expr_1 = getAuditState(cx, type, id);
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2220 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 2;
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2225 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
					if (tokencmp(tokens[2], "recent"))
															#line 2232 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
					{
															#line 215 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						int count = CLIENT_KNOBS->TOO_MANY;
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokens.size() == 4)
															#line 2238 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 217 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							count = std::stoi(tokens[3].toString());
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						}
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						StrictFuture<std::vector<AuditStorageState>> __when_expr_3 = getAuditStates(cx, type, true, count);
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2248 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when3(__when_expr_3.get(), loopDepth); };
						static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 4;
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2253 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 223 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
						if (tokencmp(tokens[2], "phase"))
															#line 2260 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
						{
															#line 224 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							AuditPhase phase = stringToAuditPhase(tokens[3].toString());
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (phase == AuditPhase::Invalid)
															#line 2266 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							{
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2272 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
								new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~GetAuditStatusCommandActorActorState();
								static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 229 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							int count = CLIENT_KNOBS->TOO_MANY;
															#line 230 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (tokens.size() == 5)
															#line 2282 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							{
															#line 231 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
								count = std::stoi(tokens[4].toString());
															#line 2286 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							}
															#line 233 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							StrictFuture<std::vector<AuditStorageState>> __when_expr_4 = getAuditStates(cx, type, true, count, phase);
															#line 233 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2292 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when4(__when_expr_4.get(), loopDepth); };
							static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 5;
															#line 233 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2297 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 238 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 239 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
							if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2306 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
							new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~GetAuditStatusCommandActorActorState();
							static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStatusCommandActorActorState();
		static_cast<GetAuditStatusCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (!static_cast<GetAuditStatusCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetAuditStatusCommandActorActorState(); static_cast<GetAuditStatusCommandActorActor*>(this)->destroy(); return 0; }
															#line 2336 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStatusCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetAuditStatusCommandActorActorState();
		static_cast<GetAuditStatusCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(AuditStorageState const& res,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Audit result is:\n{}", res.toString());
															#line 2348 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(AuditStorageState && res,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		fmt::println("Audit result is:\n{}", res.toString());
															#line 2357 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(AuditStorageState const& res,int loopDepth) 
	{
		loopDepth = a_body1cont11(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(AuditStorageState && res,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 209 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		if (res.getPhase() == AuditPhase::Running)
															#line 2447 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		{
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = getAuditProgress(cx, res.getType(), res.id, res.range);
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2453 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont14when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 3;
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*>(static_cast<GetAuditStatusCommandActorActor*>(this)));
															#line 2458 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 212 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Already complete");
															#line 2465 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1cont14cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2(AuditStorageState const& __res,int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		res = __res;
															#line 2475 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when2(AuditStorageState && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14cont1(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 221 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(std::vector<AuditStorageState> && res,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 221 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2667 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1when3(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont17(res, loopDepth);

		return loopDepth;
	}
	int a_body1when3(std::vector<AuditStorageState> && res,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 235 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(std::vector<AuditStorageState> && res,int loopDepth) 
	{
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
		for( const auto& it : res ) {
															#line 235 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
			fmt::println("Audit result is:\n{}", it.toString());
															#line 2772 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1when4(std::vector<AuditStorageState> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont20(res, loopDepth);

		return loopDepth;
	}
	int a_body1when4(std::vector<AuditStorageState> && res,int loopDepth) 
	{
		loopDepth = a_body1cont20(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatusCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatusCommandActorActor*>(this)->ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	Database cx;
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	AuditStorageState res;
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStatusCommandActor()
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
class GetAuditStatusCommandActorActor final : public Actor<bool>, public ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >, public ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >, public ActorCallback< GetAuditStatusCommandActorActor, 2, Void >, public ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >, public ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >, public FastAllocated<GetAuditStatusCommandActorActor>, public GetAuditStatusCommandActorActorState<GetAuditStatusCommandActorActor> {
															#line 2864 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStatusCommandActorActor>::operator new;
	using FastAllocated<GetAuditStatusCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9422297928667035648UL, 7319862599235567616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 2, Void >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >;
friend struct ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >;
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	GetAuditStatusCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 2885 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   GetAuditStatusCommandActorActorState<GetAuditStatusCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11706623673812082688UL, 3755119283022406400UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatusCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStatusCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStatusCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 0, AuditStorageState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 1, AuditStorageState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 3, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetAuditStatusCommandActorActor, 4, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
[[nodiscard]] Future<bool> getAuditStatusCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"
	return Future<bool>(new GetAuditStatusCommandActorActor(cx, tokens));
															#line 2921 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/GetAuditStatusCommand.actor.g.cpp.py_gen"
}

#line 244 "/Users/ec2-user/foundationdb/fdbcli/GetAuditStatusCommand.actor.cpp"

CommandFactory getAuditStatusFactory(
    "get_audit_status",
    CommandHelp("get_audit_status [ha|replica|locationmetadata|ssshard] [id|recent|phase|progress] [ARGs]",
                "Retrieve audit storage status",
                "To fetch audit status via ID: `get_audit_status [Type] id [ID]'\n"
                "To fetch status of most recent audit: `get_audit_status [Type] recent [Count]'\n"
                "To fetch status of audits in a specific phase: `get_audit_status [Type] phase "
                "[running|complete|failed|error] count'\n"
                "To fetch audit progress via ID: `get_audit_status [Type] progress [ID]'\n"
                "Supported types include: 'ha', `replica`, `locationmetadata`, `ssshard`. \n"
                "If specified, `Count' is how many rows to audit.\n"
                "If not specified, check all rows in audit.\n"
                "Phase can be `Invalid=0', `Running=1', `Complete=2', `Error=3', or `Failed=4'.\n"
                "See also `audit_storage' command."));
} // namespace fdb_cli
