#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
/*
 * FlowLineNoise.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/FlowLineNoise.h"
#include "flow/IThreadPool.h"

#ifndef BOOST_SYSTEM_NO_LIB
#define BOOST_SYSTEM_NO_LIB
#endif
#ifndef BOOST_DATE_TIME_NO_LIB
#define BOOST_DATE_TIME_NO_LIB
#endif
#ifndef BOOST_REGEX_NO_LIB
#define BOOST_REGEX_NO_LIB
#endif
#include "boost/asio.hpp"

#include "flow/ThreadHelper.actor.h"

#if __unixish__
#define HAVE_LINENOISE 1
#include "linenoise/linenoise.h"
#else
#define HAVE_LINENOISE 0
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

struct LineNoiseReader final : IThreadPoolReceiver {
	void init() override {}

	struct Read final : TypedAction<LineNoiseReader, Read> {
		std::string prompt;
		ThreadReturnPromise<Optional<std::string>> result;

		double getTimeEstimate() const override { return 0.0; }
		explicit Read(std::string const& prompt) : prompt(prompt) {}
	};

	void action(Read& r) {
		try {
			r.result.send(read(r.prompt));
		} catch (Error& e) {
			r.result.sendError(e);
		} catch (...) {
			r.result.sendError(unknown_error());
		}
	}

private:
	Optional<std::string> read(std::string const& prompt) {
#if HAVE_LINENOISE
		errno = 0;
		char* line = linenoise(prompt.c_str());
		if (line) {
			std::string s(line);
			free(line);
			return s;
		} else {
			if (errno == EAGAIN) // Ctrl-C
				return std::string();
			return Optional<std::string>();
		}
#else
		std::string line;
		std::fputs(prompt.c_str(), stdout);
		if (!std::getline(std::cin, line).eof()) {
			return line;
		} else
			return Optional<std::string>();
#endif
	}
};

LineNoise::LineNoise(std::function<void(std::string const&, std::vector<std::string>&)> _completion_callback,
                     std::function<Hint(std::string const&)> _hint_callback,
                     int maxHistoryLines,
                     bool multiline)
  : threadPool(createGenericThreadPool()) {
	reader = new LineNoiseReader();

#if HAVE_LINENOISE
	// It should be OK to call these functions from this thread, since read() can't be called yet
	// The callbacks passed to linenoise*() will be invoked from the thread pool, and use onMainThread() to safely
	// invoke the callbacks we've been given

	// linenoise doesn't provide any form of data parameter to callbacks, so we have to use static variables
	static std::function<void(std::string const&, std::vector<std::string>&)> completion_callback;
	static std::function<Hint(std::string const&)> hint_callback;
	completion_callback = _completion_callback;
	hint_callback = _hint_callback;

	linenoiseHistorySetMaxLen(maxHistoryLines);
	linenoiseSetMultiLine(multiline);
	linenoiseSetCompletionCallback([](const char* line, linenoiseCompletions* lc) {
		// This code will run in the thread pool
		std::vector<std::string> completions;
		onMainThread([line, &completions]() -> Future<Void> {
			completion_callback(line, completions);
			return Void();
		}).getBlocking();
		for (auto const& c : completions)
			linenoiseAddCompletion(lc, c.c_str());
	});
	linenoiseSetHintsCallback([](const char* line, int* color, int* bold) -> char* {
		Hint h = onMainThread([line]() -> Future<Hint> { return hint_callback(line); }).getBlocking();
		if (!h.valid)
			return nullptr;
		*color = h.color;
		*bold = h.bold;
		return strdup(h.text.c_str());
	});
	linenoiseSetFreeHintsCallback(free);
#endif

	threadPool->addThread(reader, "fdb-linenoise");
}

LineNoise::~LineNoise() {
	threadPool->stop();
}

Future<Optional<std::string>> LineNoise::read(std::string const& prompt) {
	auto r = new LineNoiseReader::Read(prompt);
	auto f = r->result.getFuture();
	threadPool->post(r);
	return f;
}

															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitKeyboardInterrupt()
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
template <class WaitKeyboardInterruptActor>
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
class WaitKeyboardInterruptActorState {
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
public:
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
	WaitKeyboardInterruptActorState(boost::asio::io_service* const& ios) 
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
		 : ios(ios),
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
		   signals(*ios, SIGINT)
															#line 164 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this));

	}
	~WaitKeyboardInterruptActorState() 
	{
		fdb_probe_actor_destroy("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
			Promise<Void> result;
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
			signals.async_wait([result](const boost::system::error_code& error, int signal_number) { if (error) { result.sendError(io_error()); } else { result.send(Void()); } });
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
			StrictFuture<Void> __when_expr_0 = result.getFuture();
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
			if (static_cast<WaitKeyboardInterruptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitKeyboardInterruptActor*>(this)->actor_wait_state = 1;
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitKeyboardInterruptActor, 0, Void >*>(static_cast<WaitKeyboardInterruptActor*>(this)));
															#line 190 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitKeyboardInterruptActorState();
		static_cast<WaitKeyboardInterruptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
		if (!static_cast<WaitKeyboardInterruptActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitKeyboardInterruptActorState(); static_cast<WaitKeyboardInterruptActor*>(this)->destroy(); return 0; }
															#line 213 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
		new (&static_cast<WaitKeyboardInterruptActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitKeyboardInterruptActorState();
		static_cast<WaitKeyboardInterruptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
		if (!static_cast<WaitKeyboardInterruptActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitKeyboardInterruptActorState(); static_cast<WaitKeyboardInterruptActor*>(this)->destroy(); return 0; }
															#line 225 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
		new (&static_cast<WaitKeyboardInterruptActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitKeyboardInterruptActorState();
		static_cast<WaitKeyboardInterruptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitKeyboardInterruptActor*>(this)->actor_wait_state > 0) static_cast<WaitKeyboardInterruptActor*>(this)->actor_wait_state = 0;
		static_cast<WaitKeyboardInterruptActor*>(this)->ActorCallback< WaitKeyboardInterruptActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitKeyboardInterruptActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitKeyboardInterruptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitKeyboardInterruptActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitKeyboardInterruptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitKeyboardInterruptActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitKeyboardInterruptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
	boost::asio::io_service* ios;
															#line 147 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
	boost::asio::signal_set signals;
															#line 312 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitKeyboardInterrupt()
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
class WaitKeyboardInterruptActor final : public Actor<Void>, public ActorCallback< WaitKeyboardInterruptActor, 0, Void >, public FastAllocated<WaitKeyboardInterruptActor>, public WaitKeyboardInterruptActorState<WaitKeyboardInterruptActor> {
															#line 317 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitKeyboardInterruptActor>::operator new;
	using FastAllocated<WaitKeyboardInterruptActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12191707044061840896UL, 6817175276274430208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitKeyboardInterruptActor, 0, Void >;
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
	WaitKeyboardInterruptActor(boost::asio::io_service* const& ios) 
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitKeyboardInterruptActorState<WaitKeyboardInterruptActor>(ios),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8431007327285319168UL, 5622545030400184576UL);
		ActorExecutionContextHelper __helper(static_cast<WaitKeyboardInterruptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitKeyboardInterrupt");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitKeyboardInterrupt", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitKeyboardInterruptActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
[[nodiscard]] Future<Void> waitKeyboardInterrupt( boost::asio::io_service* const& ios ) {
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"
	return Future<Void>(new WaitKeyboardInterruptActor(ios));
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbcli/FlowLineNoise.actor.g.cpp.py_gen"
}

#line 160 "/Users/ec2-user/foundationdb/fdbcli/FlowLineNoise.actor.cpp"

Future<Void> LineNoise::onKeyboardInterrupt() {
	boost::asio::io_service* ios = (boost::asio::io_service*)g_network->global(INetwork::enASIOService);
	if (!ios)
		return Never();
	return waitKeyboardInterrupt(ios);
}

void LineNoise::historyAdd(std::string const& line) {
#if HAVE_LINENOISE
	linenoiseHistoryAdd(line.c_str());
#endif
}
void LineNoise::historyLoad(std::string const& filename) {
#if HAVE_LINENOISE
	if (linenoiseHistoryLoad(filename.c_str()) != 0) {
		throw io_error();
	}
#endif
}
void LineNoise::historySave(std::string const& filename) {
#if HAVE_LINENOISE
	if (linenoiseHistorySave(filename.c_str()) != 0) {
		throw io_error();
	}
#endif
}
