#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
/*
 * HTTPServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/HTTP.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 30 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via callbackHandler()
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class CallbackHandlerActor>
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class CallbackHandlerActorState {
															#line 37 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	CallbackHandlerActorState(Reference<IConnection> const& conn,Future<Void> const& readRequestDone,Reference<HTTP::IRequestHandler> const& requestHandler,Reference<HTTP::IncomingRequest> const& req,FlowMutex* const& mutex) 
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : conn(conn),
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   readRequestDone(readRequestDone),
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   requestHandler(requestHandler),
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   req(req),
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   mutex(mutex),
															#line 33 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   response(makeReference<HTTP::OutgoingResponse>()),
															#line 34 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   content()
															#line 56 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("callbackHandler", reinterpret_cast<unsigned long>(this));

	}
	~CallbackHandlerActorState() 
	{
		fdb_probe_actor_destroy("callbackHandler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 35 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			response->data.content = &content;
															#line 36 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			response->data.contentLen = 0;
															#line 73 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			try {
															#line 39 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = readRequestDone;
															#line 39 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 1;
															#line 39 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallbackHandlerActor, 0, Void >*>(static_cast<CallbackHandlerActor*>(this)));
															#line 84 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallbackHandlerActorState();
		static_cast<CallbackHandlerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 63 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_2 = mutex->take();
															#line 63 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 3;
															#line 63 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >*>(static_cast<CallbackHandlerActor*>(this)));
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 42 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 130 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 43 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
															#line 46 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() == error_code_connection_failed)
															#line 138 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 47 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				TraceEvent(SevWarn, "HTTPServerConnHandlerFailed").error(e);
															#line 49 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				if (!static_cast<CallbackHandlerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallbackHandlerActorState(); static_cast<CallbackHandlerActor*>(this)->destroy(); return 0; }
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				new (&static_cast<CallbackHandlerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallbackHandlerActorState();
				static_cast<CallbackHandlerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 51 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() == error_code_http_request_failed || e.code() == error_code_http_bad_response)
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 52 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				TraceEvent(SevWarn, "HTTPServerConnHandlerInternalError").errorUnsuppressed(e);
															#line 54 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				response->reset();
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				response->code = 500;
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
			else
			{
															#line 57 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				TraceEvent(SevWarn, "HTTPServerConnHandlerUnexpectedError").errorUnsuppressed(e);
															#line 58 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 168 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = requestHandler->handleRequest(req, response);
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 2;
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallbackHandlerActor, 1, Void >*>(static_cast<CallbackHandlerActor*>(this)));
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = requestHandler->handleRequest(req, response);
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 2;
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallbackHandlerActor, 1, Void >*>(static_cast<CallbackHandlerActor*>(this)));
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state > 0) static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<CallbackHandlerActor*>(this)->ActorCallback< CallbackHandlerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallbackHandlerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state > 0) static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<CallbackHandlerActor*>(this)->ActorCallback< CallbackHandlerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallbackHandlerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
															#line 65 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = response->write(conn);
															#line 65 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 394 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont5Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 4;
															#line 65 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallbackHandlerActor, 3, Void >*>(static_cast<CallbackHandlerActor*>(this)));
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(FlowMutex::Lock const& __lock,int loopDepth) 
	{
															#line 63 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		lock = __lock;
															#line 414 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(FlowMutex::Lock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state > 0) static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<CallbackHandlerActor*>(this)->ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >*,FlowMutex::Lock const& value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >*,FlowMutex::Lock && value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		lock.release();
															#line 77 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<CallbackHandlerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallbackHandlerActorState(); static_cast<CallbackHandlerActor*>(this)->destroy(); return 0; }
															#line 495 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<CallbackHandlerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallbackHandlerActorState();
		static_cast<CallbackHandlerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 67 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			lock.release();
															#line 68 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() == error_code_connection_failed)
															#line 510 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 70 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				TraceEvent("HTTPServerConnHandlerResponseError").errorUnsuppressed(e);
															#line 71 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				if (!static_cast<CallbackHandlerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallbackHandlerActorState(); static_cast<CallbackHandlerActor*>(this)->destroy(); return 0; }
															#line 516 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				new (&static_cast<CallbackHandlerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallbackHandlerActorState();
				static_cast<CallbackHandlerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 73 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			TraceEvent("HTTPServerConnHandlerResponseUnexpectedError").errorUnsuppressed(e);
															#line 74 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallbackHandlerActor*>(this)->actor_wait_state > 0) static_cast<CallbackHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<CallbackHandlerActor*>(this)->ActorCallback< CallbackHandlerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallbackHandlerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallbackHandlerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Future<Void> readRequestDone;
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IRequestHandler> requestHandler;
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowMutex* mutex;
															#line 33 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 34 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnsentPacketQueue content;
															#line 63 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowMutex::Lock lock;
															#line 652 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via callbackHandler()
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class CallbackHandlerActor final : public Actor<Void>, public ActorCallback< CallbackHandlerActor, 0, Void >, public ActorCallback< CallbackHandlerActor, 1, Void >, public ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >, public ActorCallback< CallbackHandlerActor, 3, Void >, public FastAllocated<CallbackHandlerActor>, public CallbackHandlerActorState<CallbackHandlerActor> {
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<CallbackHandlerActor>::operator new;
	using FastAllocated<CallbackHandlerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17604008471880741120UL, 16275105263151752704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallbackHandlerActor, 0, Void >;
friend struct ActorCallback< CallbackHandlerActor, 1, Void >;
friend struct ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >;
friend struct ActorCallback< CallbackHandlerActor, 3, Void >;
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	CallbackHandlerActor(Reference<IConnection> const& conn,Future<Void> const& readRequestDone,Reference<HTTP::IRequestHandler> const& requestHandler,Reference<HTTP::IncomingRequest> const& req,FlowMutex* const& mutex) 
															#line 677 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   CallbackHandlerActorState<CallbackHandlerActor>(conn, readRequestDone, requestHandler, req, mutex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("callbackHandler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10466938805450116608UL, 6050186692443428864UL);
		ActorExecutionContextHelper __helper(static_cast<CallbackHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("callbackHandler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("callbackHandler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallbackHandlerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallbackHandlerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallbackHandlerActor, 2, FlowMutex::Lock >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallbackHandlerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> callbackHandler( Reference<IConnection> const& conn, Future<Void> const& readRequestDone, Reference<HTTP::IRequestHandler> const& requestHandler, Reference<HTTP::IncomingRequest> const& req, FlowMutex* const& mutex ) {
															#line 28 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new CallbackHandlerActor(conn, readRequestDone, requestHandler, req, mutex));
															#line 713 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 79 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 718 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via connectionHandler()
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class ConnectionHandlerActor>
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class ConnectionHandlerActorState {
															#line 725 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	ConnectionHandlerActorState(Reference<HTTP::SimServerContext> const& server,Reference<IConnection> const& conn,Reference<HTTP::IRequestHandler> const& requestHandler) 
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : server(server),
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   conn(conn),
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   requestHandler(requestHandler)
															#line 736 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("connectionHandler", reinterpret_cast<unsigned long>(this));

	}
	~ConnectionHandlerActorState() 
	{
		fdb_probe_actor_destroy("connectionHandler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 85 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				responseMutex = FlowMutex();
															#line 86 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				readPrevRequest = Future<Void>(Void());
															#line 87 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = conn->acceptHandshake();
															#line 87 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 758 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 1;
															#line 87 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 0, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 763 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConnectionHandlerActorState();
		static_cast<ConnectionHandlerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<ConnectionHandlerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConnectionHandlerActorState(); static_cast<ConnectionHandlerActor*>(this)->destroy(); return 0; }
															#line 792 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<ConnectionHandlerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConnectionHandlerActorState();
		static_cast<ConnectionHandlerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 98 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				TraceEvent("HTTPConnectionError", server->dbgid) .errorUnsuppressed(e) .suppressFor(1.0) .detail("ConnID", conn->getDebugID()) .detail("FromAddress", conn->getPeerAddress());
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
															#line 104 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			conn->close();
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 88 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		;
															#line 828 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 88 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		;
															#line 837 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state > 0) static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectionHandlerActor*>(this)->ActorCallback< ConnectionHandlerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConnectionHandlerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = readPrevRequest;
															#line 89 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 930 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 2;
															#line 89 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 1, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 935 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 946 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 3;
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 2, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 951 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 962 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 3;
															#line 90 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 2, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state > 0) static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectionHandlerActor*>(this)->ActorCallback< ConnectionHandlerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConnectionHandlerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = conn->onReadable();
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 4;
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 3, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 1058 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = conn->onReadable();
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1069 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 4;
															#line 91 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConnectionHandlerActor, 3, Void >*>(static_cast<ConnectionHandlerActor*>(this)));
															#line 1074 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state > 0) static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectionHandlerActor*>(this)->ActorCallback< ConnectionHandlerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConnectionHandlerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 92 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		req = makeReference<HTTP::IncomingRequest>();
															#line 93 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		readPrevRequest = req->read(conn, false);
															#line 94 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		server->actors.add(callbackHandler(conn, readPrevRequest, requestHandler, req, &responseMutex));
															#line 1162 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 92 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		req = makeReference<HTTP::IncomingRequest>();
															#line 93 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		readPrevRequest = req->read(conn, false);
															#line 94 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		server->actors.add(callbackHandler(conn, readPrevRequest, requestHandler, req, &responseMutex));
															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConnectionHandlerActor*>(this)->actor_wait_state > 0) static_cast<ConnectionHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectionHandlerActor*>(this)->ActorCallback< ConnectionHandlerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConnectionHandlerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConnectionHandlerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::SimServerContext> server;
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IRequestHandler> requestHandler;
															#line 85 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowMutex responseMutex;
															#line 86 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Future<Void> readPrevRequest;
															#line 92 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 1267 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via connectionHandler()
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class ConnectionHandlerActor final : public Actor<Void>, public ActorCallback< ConnectionHandlerActor, 0, Void >, public ActorCallback< ConnectionHandlerActor, 1, Void >, public ActorCallback< ConnectionHandlerActor, 2, Void >, public ActorCallback< ConnectionHandlerActor, 3, Void >, public FastAllocated<ConnectionHandlerActor>, public ConnectionHandlerActorState<ConnectionHandlerActor> {
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<ConnectionHandlerActor>::operator new;
	using FastAllocated<ConnectionHandlerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11911030510851746560UL, 9340450948494280448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConnectionHandlerActor, 0, Void >;
friend struct ActorCallback< ConnectionHandlerActor, 1, Void >;
friend struct ActorCallback< ConnectionHandlerActor, 2, Void >;
friend struct ActorCallback< ConnectionHandlerActor, 3, Void >;
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	ConnectionHandlerActor(Reference<HTTP::SimServerContext> const& server,Reference<IConnection> const& conn,Reference<HTTP::IRequestHandler> const& requestHandler) 
															#line 1292 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   ConnectionHandlerActorState<ConnectionHandlerActor>(server, conn, requestHandler),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("connectionHandler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15039178362760819456UL, 3604371775921038080UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectionHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("connectionHandler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("connectionHandler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConnectionHandlerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConnectionHandlerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConnectionHandlerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConnectionHandlerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> connectionHandler( Reference<HTTP::SimServerContext> const& server, Reference<IConnection> const& conn, Reference<HTTP::IRequestHandler> const& requestHandler ) {
															#line 80 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new ConnectionHandlerActor(server, conn, requestHandler));
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 108 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via listenActor()
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class ListenActorActor>
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class ListenActorActorState {
															#line 1340 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	ListenActorActorState(Reference<HTTP::SimServerContext> const& server,Reference<HTTP::IRequestHandler> const& requestHandler,NetworkAddress const& addr,Reference<IListener> const& listener) 
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : server(server),
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   requestHandler(requestHandler),
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   addr(addr),
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   listener(listener)
															#line 1353 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("listenActor", reinterpret_cast<unsigned long>(this));

	}
	~ListenActorActorState() 
	{
		fdb_probe_actor_destroy("listenActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			TraceEvent(SevDebug, "HTTPServerListenStart", server->dbgid).detail("ListenAddress", addr.toString());
															#line 115 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = requestHandler->init();
															#line 115 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<ListenActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListenActorActor*>(this)->actor_wait_state = 1;
															#line 115 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListenActorActor, 0, Void >*>(static_cast<ListenActorActor*>(this)));
															#line 1377 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListenActorActorState();
		static_cast<ListenActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 117 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		TraceEvent(SevDebug, "HTTPServerListenInitialized", server->dbgid).detail("ListenAddress", addr.toString());
															#line 1400 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		try {
															#line 120 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			;
															#line 1404 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 117 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		TraceEvent(SevDebug, "HTTPServerListenInitialized", server->dbgid).detail("ListenAddress", addr.toString());
															#line 1419 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		try {
															#line 120 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			;
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListenActorActor*>(this)->actor_wait_state > 0) static_cast<ListenActorActor*>(this)->actor_wait_state = 0;
		static_cast<ListenActorActor*>(this)->ActorCallback< ListenActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListenActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListenActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListenActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 135 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<ListenActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorActorState(); static_cast<ListenActorActor*>(this)->destroy(); return 0; }
															#line 1513 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<ListenActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorActorState();
		static_cast<ListenActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			TraceEvent(SevError, "HTTPListenError", server->dbgid).error(e);
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1528 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 121 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Reference<IConnection>> __when_expr_1 = listener->accept();
															#line 121 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<ListenActorActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1557 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListenActorActor*>(this)->actor_wait_state = 2;
															#line 121 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListenActorActor, 1, Reference<IConnection> >*>(static_cast<ListenActorActor*>(this)));
															#line 1562 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Reference<IConnection> const& conn,int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!server->running)
															#line 1584 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 123 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			TraceEvent("HTTPServerExitedAfterAccept", server->dbgid);
															#line 1588 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (conn)
															#line 1593 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 127 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			server->actors.add(connectionHandler(server, conn, requestHandler));
															#line 1597 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Reference<IConnection> && conn,int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!server->running)
															#line 1607 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 123 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			TraceEvent("HTTPServerExitedAfterAccept", server->dbgid);
															#line 1611 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (conn)
															#line 1616 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 127 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			server->actors.add(connectionHandler(server, conn, requestHandler));
															#line 1620 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Reference<IConnection> const& conn,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(conn, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Reference<IConnection> && conn,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(conn), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListenActorActor*>(this)->actor_wait_state > 0) static_cast<ListenActorActor*>(this)->actor_wait_state = 0;
		static_cast<ListenActorActor*>(this)->ActorCallback< ListenActorActor, 1, Reference<IConnection> >::remove();

	}
	void a_callback_fire(ActorCallback< ListenActorActor, 1, Reference<IConnection> >*,Reference<IConnection> const& value) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListenActorActor, 1, Reference<IConnection> >*,Reference<IConnection> && value) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListenActorActor, 1, Reference<IConnection> >*,Error err) 
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::SimServerContext> server;
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IRequestHandler> requestHandler;
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	NetworkAddress addr;
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IListener> listener;
															#line 1722 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via listenActor()
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class ListenActorActor final : public Actor<Void>, public ActorCallback< ListenActorActor, 0, Void >, public ActorCallback< ListenActorActor, 1, Reference<IConnection> >, public FastAllocated<ListenActorActor>, public ListenActorActorState<ListenActorActor> {
															#line 1727 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<ListenActorActor>::operator new;
	using FastAllocated<ListenActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5471391865041564416UL, 15445537252300121600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListenActorActor, 0, Void >;
friend struct ActorCallback< ListenActorActor, 1, Reference<IConnection> >;
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	ListenActorActor(Reference<HTTP::SimServerContext> const& server,Reference<HTTP::IRequestHandler> const& requestHandler,NetworkAddress const& addr,Reference<IListener> const& listener) 
															#line 1745 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   ListenActorActorState<ListenActorActor>(server, requestHandler, addr, listener),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listenActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16735330741962867712UL, 10151596213835410944UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listenActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listenActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListenActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListenActorActor, 1, Reference<IConnection> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> listenActor( Reference<HTTP::SimServerContext> const& server, Reference<HTTP::IRequestHandler> const& requestHandler, NetworkAddress const& addr, Reference<IListener> const& listener ) {
															#line 109 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new ListenActorActor(server, requestHandler, addr, listener));
															#line 1779 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 137 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

void HTTP::SimServerContext::registerNewServer(NetworkAddress addr, Reference<HTTP::IRequestHandler> requestHandler) {
	listenAddresses.push_back(addr);
	listeners.push_back(INetworkConnections::net()->listen(addr));
	actors.add(listenActor(Reference<HTTP::SimServerContext>::addRef(this), requestHandler, addr, listeners.back()));
}

void HTTP::SimRegisteredHandlerContext::updateDNS() {
	// if addresses is empty, that violates the assumption that there is at least one address when doing resolution.
	// Only update dns if we have at least one address
	if (!addresses.empty()) {
		INetworkConnections::net()->addMockTCPEndpoint(hostname, service, addresses);
	}
}

void HTTP::SimRegisteredHandlerContext::addAddress(NetworkAddress addr) {
	addresses.push_back(addr);
	fmt::print("HTTP: adding address {0} for {1}:{2}\n", addr.toString(), hostname, service);
	updateDNS();
}

void HTTP::SimRegisteredHandlerContext::removeIp(IPAddress ip) {
	fmt::print("HTTP: removing ip {0} for {1}:{2}\n", ip.toString(), hostname, service);
	for (int i = 0; i < addresses.size(); i++) {
		if (addresses[i].ip == ip) {
			swapAndPop(&addresses, i);
			i--;
		}
	}
	updateDNS();
}

struct AlwaysFailRequestHandler final : HTTP::IRequestHandler, ReferenceCounted<AlwaysFailRequestHandler> {
	Future<Void> handleRequest(Reference<HTTP::IncomingRequest> req,
	                           Reference<HTTP::OutgoingResponse> response) override {
		ASSERT(false);
		return Void();
	}
	Reference<HTTP::IRequestHandler> clone() override { return makeReference<AlwaysFailRequestHandler>(); }

	void addref() override { ReferenceCounted<AlwaysFailRequestHandler>::addref(); }
	void delref() override { ReferenceCounted<AlwaysFailRequestHandler>::delref(); }
};

Future<Void> HTTP::registerAlwaysFailHTTPHandler() {
	return g_simulator->registerSimHTTPServer("alwaysfail_donotuse", "80", makeReference<AlwaysFailRequestHandler>());
}

// unit test stuff

															#line 1833 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via helloWorldServerCallback()
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class HelloWorldServerCallbackActor>
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloWorldServerCallbackActorState {
															#line 1840 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloWorldServerCallbackActorState(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : req(req),
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   response(response)
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("helloWorldServerCallback", reinterpret_cast<unsigned long>(this));

	}
	~HelloWorldServerCallbackActorState() 
	{
		fdb_probe_actor_destroy("helloWorldServerCallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 189 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<HelloWorldServerCallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1866 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HelloWorldServerCallbackActor*>(this)->actor_wait_state = 1;
															#line 189 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HelloWorldServerCallbackActor, 0, Void >*>(static_cast<HelloWorldServerCallbackActor*>(this)));
															#line 1871 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HelloWorldServerCallbackActorState();
		static_cast<HelloWorldServerCallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->verb, HTTP::HTTP_VERB_POST);
															#line 191 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->resource, "/hello-world");
															#line 192 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 2);
															#line 193 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Hello"));
															#line 195 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Hello"], "World");
															#line 196 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Content-Length"));
															#line 197 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 198 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 199 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.content, "Hello World Request!");
															#line 201 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->code = 200;
															#line 202 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Hello"] = "World";
															#line 204 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string hello = "Hello World Response!";
															#line 205 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(hello);
															#line 207 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		PacketWriter pw(response->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		pw.serializeBytes(hello);
															#line 209 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.contentLen = hello.size();
															#line 211 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<HelloWorldServerCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HelloWorldServerCallbackActorState(); static_cast<HelloWorldServerCallbackActor*>(this)->destroy(); return 0; }
															#line 1926 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<HelloWorldServerCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HelloWorldServerCallbackActorState();
		static_cast<HelloWorldServerCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->verb, HTTP::HTTP_VERB_POST);
															#line 191 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->resource, "/hello-world");
															#line 192 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 2);
															#line 193 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Hello"));
															#line 195 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Hello"], "World");
															#line 196 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Content-Length"));
															#line 197 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 198 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 199 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.content, "Hello World Request!");
															#line 201 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->code = 200;
															#line 202 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Hello"] = "World";
															#line 204 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string hello = "Hello World Response!";
															#line 205 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(hello);
															#line 207 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		PacketWriter pw(response->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		pw.serializeBytes(hello);
															#line 209 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.contentLen = hello.size();
															#line 211 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<HelloWorldServerCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HelloWorldServerCallbackActorState(); static_cast<HelloWorldServerCallbackActor*>(this)->destroy(); return 0; }
															#line 1970 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<HelloWorldServerCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HelloWorldServerCallbackActorState();
		static_cast<HelloWorldServerCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HelloWorldServerCallbackActor*>(this)->actor_wait_state > 0) static_cast<HelloWorldServerCallbackActor*>(this)->actor_wait_state = 0;
		static_cast<HelloWorldServerCallbackActor*>(this)->ActorCallback< HelloWorldServerCallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HelloWorldServerCallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloWorldServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HelloWorldServerCallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloWorldServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HelloWorldServerCallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HelloWorldServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 2057 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via helloWorldServerCallback()
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloWorldServerCallbackActor final : public Actor<Void>, public ActorCallback< HelloWorldServerCallbackActor, 0, Void >, public FastAllocated<HelloWorldServerCallbackActor>, public HelloWorldServerCallbackActorState<HelloWorldServerCallbackActor> {
															#line 2062 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<HelloWorldServerCallbackActor>::operator new;
	using FastAllocated<HelloWorldServerCallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9515810990449531648UL, 605259862794611712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HelloWorldServerCallbackActor, 0, Void >;
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloWorldServerCallbackActor(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 2079 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   HelloWorldServerCallbackActorState<HelloWorldServerCallbackActor>(req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11385988314929867264UL, 4072161416153843712UL);
		ActorExecutionContextHelper __helper(static_cast<HelloWorldServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("helloWorldServerCallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("helloWorldServerCallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HelloWorldServerCallbackActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> helloWorldServerCallback( Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new HelloWorldServerCallbackActor(req, response));
															#line 2112 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 213 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

struct HelloWorldRequestHandler : HTTP::IRequestHandler, ReferenceCounted<HelloWorldRequestHandler> {
	Future<Void> handleRequest(Reference<HTTP::IncomingRequest> req,
	                           Reference<HTTP::OutgoingResponse> response) override {
		return helloWorldServerCallback(req, response);
	}
	Reference<HTTP::IRequestHandler> clone() override { return makeReference<HelloWorldRequestHandler>(); }

	void addref() override { ReferenceCounted<HelloWorldRequestHandler>::addref(); }
	void delref() override { ReferenceCounted<HelloWorldRequestHandler>::delref(); }
};

															#line 2128 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via helloErrorServerCallback()
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class HelloErrorServerCallbackActor>
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloErrorServerCallbackActorState {
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloErrorServerCallbackActorState(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : req(req),
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   response(response)
															#line 2144 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("helloErrorServerCallback", reinterpret_cast<unsigned long>(this));

	}
	~HelloErrorServerCallbackActorState() 
	{
		fdb_probe_actor_destroy("helloErrorServerCallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 227 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 227 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<HelloErrorServerCallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2161 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HelloErrorServerCallbackActor*>(this)->actor_wait_state = 1;
															#line 227 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HelloErrorServerCallbackActor, 0, Void >*>(static_cast<HelloErrorServerCallbackActor*>(this)));
															#line 2166 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HelloErrorServerCallbackActorState();
		static_cast<HelloErrorServerCallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 229 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(http_bad_response(), loopDepth);
															#line 2193 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		else
		{
															#line 231 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(http_request_failed(), loopDepth);
															#line 2199 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 2208 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		{
															#line 229 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(http_bad_response(), loopDepth);
															#line 2212 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}
		else
		{
															#line 231 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			return a_body1Catch1(http_request_failed(), loopDepth);
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HelloErrorServerCallbackActor*>(this)->actor_wait_state > 0) static_cast<HelloErrorServerCallbackActor*>(this)->actor_wait_state = 0;
		static_cast<HelloErrorServerCallbackActor*>(this)->ActorCallback< HelloErrorServerCallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HelloErrorServerCallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloErrorServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HelloErrorServerCallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloErrorServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HelloErrorServerCallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HelloErrorServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 2302 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via helloErrorServerCallback()
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloErrorServerCallbackActor final : public Actor<Void>, public ActorCallback< HelloErrorServerCallbackActor, 0, Void >, public FastAllocated<HelloErrorServerCallbackActor>, public HelloErrorServerCallbackActorState<HelloErrorServerCallbackActor> {
															#line 2307 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<HelloErrorServerCallbackActor>::operator new;
	using FastAllocated<HelloErrorServerCallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6990656952454708992UL, 15906792865244112384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HelloErrorServerCallbackActor, 0, Void >;
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloErrorServerCallbackActor(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   HelloErrorServerCallbackActorState<HelloErrorServerCallbackActor>(req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11967353465696974848UL, 8916301737527802368UL);
		ActorExecutionContextHelper __helper(static_cast<HelloErrorServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("helloErrorServerCallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("helloErrorServerCallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HelloErrorServerCallbackActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> helloErrorServerCallback( Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 225 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new HelloErrorServerCallbackActor(req, response));
															#line 2357 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 234 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

struct HelloErrorRequestHandler : HTTP::IRequestHandler, ReferenceCounted<HelloErrorRequestHandler> {
	Future<Void> handleRequest(Reference<HTTP::IncomingRequest> req,
	                           Reference<HTTP::OutgoingResponse> response) override {
		return helloErrorServerCallback(req, response);
	}
	Reference<HTTP::IRequestHandler> clone() override { return makeReference<HelloErrorRequestHandler>(); }

	void addref() override { ReferenceCounted<HelloErrorRequestHandler>::addref(); }
	void delref() override { ReferenceCounted<HelloErrorRequestHandler>::delref(); }
};

															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via helloBadMD5ServerCallback()
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class HelloBadMD5ServerCallbackActor>
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloBadMD5ServerCallbackActorState {
															#line 2380 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloBadMD5ServerCallbackActorState(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : req(req),
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   response(response)
															#line 2389 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this));

	}
	~HelloBadMD5ServerCallbackActorState() 
	{
		fdb_probe_actor_destroy("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 248 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 248 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<HelloBadMD5ServerCallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2406 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HelloBadMD5ServerCallbackActor*>(this)->actor_wait_state = 1;
															#line 248 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >*>(static_cast<HelloBadMD5ServerCallbackActor*>(this)));
															#line 2411 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HelloBadMD5ServerCallbackActorState();
		static_cast<HelloBadMD5ServerCallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->verb, HTTP::HTTP_VERB_GET);
															#line 250 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->resource, "/hello-world");
															#line 251 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 1);
															#line 252 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Content-Length"));
															#line 253 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 254 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 255 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.content, "Hello Bad MD5 Request!");
															#line 257 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->code = 200;
															#line 258 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Hello"] = "World";
															#line 260 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string hello = "Hello World Response!";
															#line 261 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(hello);
															#line 264 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		hello = "Hello Bad MD5 Response";
															#line 266 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		PacketWriter pw(response->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 267 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		pw.serializeBytes(hello);
															#line 268 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.contentLen = hello.size();
															#line 270 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<HelloBadMD5ServerCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HelloBadMD5ServerCallbackActorState(); static_cast<HelloBadMD5ServerCallbackActor*>(this)->destroy(); return 0; }
															#line 2464 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<HelloBadMD5ServerCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HelloBadMD5ServerCallbackActorState();
		static_cast<HelloBadMD5ServerCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->verb, HTTP::HTTP_VERB_GET);
															#line 250 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->resource, "/hello-world");
															#line 251 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 1);
															#line 252 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(req->data.headers.count("Content-Length"));
															#line 253 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 254 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 255 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(req->data.content, "Hello Bad MD5 Request!");
															#line 257 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->code = 200;
															#line 258 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Hello"] = "World";
															#line 260 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string hello = "Hello World Response!";
															#line 261 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(hello);
															#line 264 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		hello = "Hello Bad MD5 Response";
															#line 266 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		PacketWriter pw(response->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 267 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		pw.serializeBytes(hello);
															#line 268 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		response->data.contentLen = hello.size();
															#line 270 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<HelloBadMD5ServerCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HelloBadMD5ServerCallbackActorState(); static_cast<HelloBadMD5ServerCallbackActor*>(this)->destroy(); return 0; }
															#line 2506 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<HelloBadMD5ServerCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HelloBadMD5ServerCallbackActorState();
		static_cast<HelloBadMD5ServerCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HelloBadMD5ServerCallbackActor*>(this)->actor_wait_state > 0) static_cast<HelloBadMD5ServerCallbackActor*>(this)->actor_wait_state = 0;
		static_cast<HelloBadMD5ServerCallbackActor*>(this)->ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloBadMD5ServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HelloBadMD5ServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HelloBadMD5ServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 2593 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via helloBadMD5ServerCallback()
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class HelloBadMD5ServerCallbackActor final : public Actor<Void>, public ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >, public FastAllocated<HelloBadMD5ServerCallbackActor>, public HelloBadMD5ServerCallbackActorState<HelloBadMD5ServerCallbackActor> {
															#line 2598 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<HelloBadMD5ServerCallbackActor>::operator new;
	using FastAllocated<HelloBadMD5ServerCallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3653474802016545280UL, 3945616915528040960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >;
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	HelloBadMD5ServerCallbackActor(Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   HelloBadMD5ServerCallbackActorState<HelloBadMD5ServerCallbackActor>(req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12967430452106607616UL, 12869795896508667648UL);
		ActorExecutionContextHelper __helper(static_cast<HelloBadMD5ServerCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("helloBadMD5ServerCallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("helloBadMD5ServerCallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HelloBadMD5ServerCallbackActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Void> helloBadMD5ServerCallback( Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 246 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new HelloBadMD5ServerCallbackActor(req, response));
															#line 2648 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 272 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

struct HelloBadMD5RequestHandler : HTTP::IRequestHandler, ReferenceCounted<HelloBadMD5RequestHandler> {
	Future<Void> handleRequest(Reference<HTTP::IncomingRequest> req,
	                           Reference<HTTP::OutgoingResponse> response) override {
		return helloBadMD5ServerCallback(req, response);
	}
	Reference<HTTP::IRequestHandler> clone() override { return makeReference<HelloBadMD5RequestHandler>(); }

	void addref() override { ReferenceCounted<HelloBadMD5RequestHandler>::addref(); }
	void delref() override { ReferenceCounted<HelloBadMD5RequestHandler>::delref(); }
};

typedef std::function<Future<Reference<HTTP::IncomingResponse>>(Reference<IConnection> conn)> DoRequestFunction;

// handles retrying on timeout and reinitializing connection like other users of HTTP (S3BlobStore, RestClient)
															#line 2667 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doRequestTest()
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class DoRequestTestActor>
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoRequestTestActorState {
															#line 2674 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoRequestTestActorState(std::string const& hostname,std::string const& service,DoRequestFunction const& reqFunction) 
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : hostname(hostname),
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   service(service),
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   reqFunction(reqFunction),
															#line 290 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   conn()
															#line 2687 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doRequestTest", reinterpret_cast<unsigned long>(this));

	}
	~DoRequestTestActorState() 
	{
		fdb_probe_actor_destroy("doRequestTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 291 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			;
															#line 2702 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoRequestTestActorState();
		static_cast<DoRequestTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 293 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (!conn)
															#line 2733 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(conn, INetworkConnections::net()->connect(hostname, service, false));
															#line 294 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				if (static_cast<DoRequestTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2739 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoRequestTestActor*>(this)->actor_wait_state = 1;
															#line 294 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoRequestTestActor, 0, Void >*>(static_cast<DoRequestTestActor*>(this)));
															#line 2744 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 304 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (conn)
															#line 2771 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				conn->close();
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
															#line 307 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (e.code() != error_code_timed_out && e.code() != error_code_connection_failed && e.code() != error_code_lookup_failed)
															#line 2779 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			{
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2783 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			}
															#line 312 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			conn.clear();
															#line 313 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.1);
															#line 313 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<DoRequestTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2791 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoRequestTestActor*>(this)->actor_wait_state = 4;
															#line 313 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoRequestTestActor, 3, Void >*>(static_cast<DoRequestTestActor*>(this)));
															#line 2796 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 299 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		Future<Reference<HTTP::IncomingResponse>> f = reqFunction(conn);
															#line 300 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_2 = f;
															#line 300 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2815 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoRequestTestActor*>(this)->actor_wait_state = 3;
															#line 300 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >*>(static_cast<DoRequestTestActor*>(this)));
															#line 2820 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(conn.isValid());
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = conn->connectHandshake();
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2833 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoRequestTestActor*>(this)->actor_wait_state = 2;
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoRequestTestActor, 1, Void >*>(static_cast<DoRequestTestActor*>(this)));
															#line 2838 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(conn.isValid());
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = conn->connectHandshake();
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2851 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoRequestTestActor*>(this)->actor_wait_state = 2;
															#line 296 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoRequestTestActor, 1, Void >*>(static_cast<DoRequestTestActor*>(this)));
															#line 2856 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state > 0) static_cast<DoRequestTestActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequestTestActor*>(this)->ActorCallback< DoRequestTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoRequestTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state > 0) static_cast<DoRequestTestActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequestTestActor*>(this)->ActorCallback< DoRequestTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoRequestTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		conn->close();
															#line 302 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoRequestTestActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoRequestTestActorState(); static_cast<DoRequestTestActor*>(this)->destroy(); return 0; }
															#line 3029 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoRequestTestActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoRequestTestActorState();
		static_cast<DoRequestTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		conn->close();
															#line 302 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoRequestTestActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoRequestTestActorState(); static_cast<DoRequestTestActor*>(this)->destroy(); return 0; }
															#line 3043 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoRequestTestActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoRequestTestActorState();
		static_cast<DoRequestTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(response, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state > 0) static_cast<DoRequestTestActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequestTestActor*>(this)->ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoRequestTestActor*>(this)->actor_wait_state > 0) static_cast<DoRequestTestActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequestTestActor*>(this)->ActorCallback< DoRequestTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoRequestTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoRequestTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	std::string hostname;
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	std::string service;
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoRequestFunction reqFunction;
															#line 290 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 3221 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via doRequestTest()
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoRequestTestActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoRequestTestActor, 0, Void >, public ActorCallback< DoRequestTestActor, 1, Void >, public ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >, public ActorCallback< DoRequestTestActor, 3, Void >, public FastAllocated<DoRequestTestActor>, public DoRequestTestActorState<DoRequestTestActor> {
															#line 3226 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<DoRequestTestActor>::operator new;
	using FastAllocated<DoRequestTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11894288794473173504UL, 2771451702783780096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoRequestTestActor, 0, Void >;
friend struct ActorCallback< DoRequestTestActor, 1, Void >;
friend struct ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >;
friend struct ActorCallback< DoRequestTestActor, 3, Void >;
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoRequestTestActor(std::string const& hostname,std::string const& service,DoRequestFunction const& reqFunction) 
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoRequestTestActorState<DoRequestTestActor>(hostname, service, reqFunction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRequestTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4954859916119019008UL, 4441072776035768576UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequestTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRequestTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRequestTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoRequestTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoRequestTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoRequestTestActor, 2, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoRequestTestActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doRequestTest( std::string const& hostname, std::string const& service, DoRequestFunction const& reqFunction ) {
															#line 287 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoRequestTestActor(hostname, service, reqFunction));
															#line 3282 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 317 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 3287 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doHelloWorldReq()
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class DoHelloWorldReqActor>
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloWorldReqActorState {
															#line 3294 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloWorldReqActorState(Reference<IConnection> const& conn) 
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : conn(conn),
															#line 319 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   content(),
															#line 320 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   req(makeReference<HTTP::OutgoingRequest>()),
															#line 322 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   sendReceiveRate(makeReference<Unlimited>()),
															#line 323 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   bytes_sent(0)
															#line 3309 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doHelloWorldReq", reinterpret_cast<unsigned long>(this));

	}
	~DoHelloWorldReqActorState() 
	{
		fdb_probe_actor_destroy("doHelloWorldReq", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->verb = HTTP::HTTP_VERB_POST;
															#line 326 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->resource = "/hello-world";
															#line 327 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.headers["Hello"] = "World";
															#line 329 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			std::string hello = "Hello World Request!";
															#line 331 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.content = &content;
															#line 332 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.contentLen = hello.size();
															#line 334 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			PacketWriter pw(req->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 335 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			pw.serializeBytes(hello);
															#line 337 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_0 = timeoutError(HTTP::doRequest(conn, req, sendReceiveRate, &bytes_sent, sendReceiveRate), 30.0);
															#line 337 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<DoHelloWorldReqActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3342 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoHelloWorldReqActor*>(this)->actor_wait_state = 1;
															#line 337 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >*>(static_cast<DoHelloWorldReqActor*>(this)));
															#line 3347 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoHelloWorldReqActorState();
		static_cast<DoHelloWorldReqActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string expectedContent = "Hello World Response!";
															#line 342 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->code, 200);
															#line 343 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers.size(), 3);
															#line 344 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Hello"));
															#line 345 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Hello"], "World");
															#line 346 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Content-Length"));
															#line 347 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Content-Length"], std::to_string(response->data.content.size()));
															#line 348 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Content-MD5"));
															#line 349 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Content-MD5"], HTTP::computeMD5Sum(expectedContent));
															#line 350 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.contentLen, response->data.content.size());
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.content, expectedContent);
															#line 353 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloWorldReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloWorldReqActorState(); static_cast<DoHelloWorldReqActor*>(this)->destroy(); return 0; }
															#line 3392 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloWorldReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloWorldReqActorState();
		static_cast<DoHelloWorldReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		std::string expectedContent = "Hello World Response!";
															#line 342 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->code, 200);
															#line 343 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers.size(), 3);
															#line 344 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Hello"));
															#line 345 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Hello"], "World");
															#line 346 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Content-Length"));
															#line 347 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Content-Length"], std::to_string(response->data.content.size()));
															#line 348 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->data.headers.count("Content-MD5"));
															#line 349 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.headers["Content-MD5"], HTTP::computeMD5Sum(expectedContent));
															#line 350 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.contentLen, response->data.content.size());
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT_EQ(response->data.content, expectedContent);
															#line 353 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloWorldReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloWorldReqActorState(); static_cast<DoHelloWorldReqActor*>(this)->destroy(); return 0; }
															#line 3426 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloWorldReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloWorldReqActorState();
		static_cast<DoHelloWorldReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoHelloWorldReqActor*>(this)->actor_wait_state > 0) static_cast<DoHelloWorldReqActor*>(this)->actor_wait_state = 0;
		static_cast<DoHelloWorldReqActor*>(this)->ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldReq", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 319 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnsentPacketQueue content;
															#line 320 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingRequest> req;
															#line 322 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IRateControl> sendReceiveRate;
															#line 323 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	int64_t bytes_sent;
															#line 3519 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via doHelloWorldReq()
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloWorldReqActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >, public FastAllocated<DoHelloWorldReqActor>, public DoHelloWorldReqActorState<DoHelloWorldReqActor> {
															#line 3524 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<DoHelloWorldReqActor>::operator new;
	using FastAllocated<DoHelloWorldReqActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2440082794588038144UL, 3473254879558658048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >;
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloWorldReqActor(Reference<IConnection> const& conn) 
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoHelloWorldReqActorState<DoHelloWorldReqActor>(conn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doHelloWorldReq", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11035200704979941888UL, 6462700785749837056UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doHelloWorldReq");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doHelloWorldReq", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoHelloWorldReqActor, 0, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doHelloWorldReq( Reference<IConnection> const& conn ) {
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoHelloWorldReqActor(conn));
															#line 3574 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 355 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 3579 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doHelloWorldErrorReq()
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class DoHelloWorldErrorReqActor>
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloWorldErrorReqActorState {
															#line 3586 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloWorldErrorReqActorState(Reference<IConnection> const& conn) 
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : conn(conn),
															#line 357 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   content(),
															#line 358 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   req(makeReference<HTTP::OutgoingRequest>()),
															#line 360 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   sendReceiveRate(makeReference<Unlimited>()),
															#line 361 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   bytes_sent(0)
															#line 3601 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this));

	}
	~DoHelloWorldErrorReqActorState() 
	{
		fdb_probe_actor_destroy("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 363 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->verb = HTTP::HTTP_VERB_GET;
															#line 364 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->resource = "/hello-error";
															#line 366 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.content = &content;
															#line 367 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.contentLen = 0;
															#line 369 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_0 = timeoutError(HTTP::doRequest(conn, req, sendReceiveRate, &bytes_sent, sendReceiveRate), 30.0);
															#line 369 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<DoHelloWorldErrorReqActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3626 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoHelloWorldErrorReqActor*>(this)->actor_wait_state = 1;
															#line 369 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >*>(static_cast<DoHelloWorldErrorReqActor*>(this)));
															#line 3631 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoHelloWorldErrorReqActorState();
		static_cast<DoHelloWorldErrorReqActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 372 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->code == 500);
															#line 374 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloWorldErrorReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloWorldErrorReqActorState(); static_cast<DoHelloWorldErrorReqActor*>(this)->destroy(); return 0; }
															#line 3656 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloWorldErrorReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloWorldErrorReqActorState();
		static_cast<DoHelloWorldErrorReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 372 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(response->code == 500);
															#line 374 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloWorldErrorReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloWorldErrorReqActorState(); static_cast<DoHelloWorldErrorReqActor*>(this)->destroy(); return 0; }
															#line 3670 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloWorldErrorReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloWorldErrorReqActorState();
		static_cast<DoHelloWorldErrorReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoHelloWorldErrorReqActor*>(this)->actor_wait_state > 0) static_cast<DoHelloWorldErrorReqActor*>(this)->actor_wait_state = 0;
		static_cast<DoHelloWorldErrorReqActor*>(this)->ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldErrorReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldErrorReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldErrorReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 357 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnsentPacketQueue content;
															#line 358 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingRequest> req;
															#line 360 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IRateControl> sendReceiveRate;
															#line 361 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	int64_t bytes_sent;
															#line 3763 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via doHelloWorldErrorReq()
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloWorldErrorReqActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >, public FastAllocated<DoHelloWorldErrorReqActor>, public DoHelloWorldErrorReqActorState<DoHelloWorldErrorReqActor> {
															#line 3768 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<DoHelloWorldErrorReqActor>::operator new;
	using FastAllocated<DoHelloWorldErrorReqActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(418272769309886464UL, 17368384019913100032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >;
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloWorldErrorReqActor(Reference<IConnection> const& conn) 
															#line 3785 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoHelloWorldErrorReqActorState<DoHelloWorldErrorReqActor>(conn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12746108889721997568UL, 5171032651815603712UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloWorldErrorReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doHelloWorldErrorReq");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doHelloWorldErrorReq", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoHelloWorldErrorReqActor, 0, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doHelloWorldErrorReq( Reference<IConnection> const& conn ) {
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoHelloWorldErrorReqActor(conn));
															#line 3818 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 376 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 3823 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doHelloBadMD5Req()
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class DoHelloBadMD5ReqActor>
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloBadMD5ReqActorState {
															#line 3830 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloBadMD5ReqActorState(Reference<IConnection> const& conn) 
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : conn(conn),
															#line 378 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   content(),
															#line 379 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   req(makeReference<HTTP::OutgoingRequest>()),
															#line 381 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   sendReceiveRate(makeReference<Unlimited>()),
															#line 382 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		   bytes_sent(0)
															#line 3845 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this));

	}
	~DoHelloBadMD5ReqActorState() 
	{
		fdb_probe_actor_destroy("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 384 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->verb = HTTP::HTTP_VERB_GET;
															#line 385 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->resource = "/hello-world";
															#line 387 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			std::string hello = "Hello Bad MD5 Request!";
															#line 389 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.content = &content;
															#line 390 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			req->data.contentLen = hello.size();
															#line 392 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			PacketWriter pw(req->data.content->getWriteBuffer(hello.size()), nullptr, Unversioned());
															#line 393 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			pw.serializeBytes(hello);
															#line 395 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_0 = timeoutError(HTTP::doRequest(conn, req, sendReceiveRate, &bytes_sent, sendReceiveRate), 30.0);
															#line 395 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<DoHelloBadMD5ReqActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3876 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoHelloBadMD5ReqActor*>(this)->actor_wait_state = 1;
															#line 395 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >*>(static_cast<DoHelloBadMD5ReqActor*>(this)));
															#line 3881 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoHelloBadMD5ReqActorState();
		static_cast<DoHelloBadMD5ReqActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(false);
															#line 401 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloBadMD5ReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloBadMD5ReqActorState(); static_cast<DoHelloBadMD5ReqActor*>(this)->destroy(); return 0; }
															#line 3906 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloBadMD5ReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloBadMD5ReqActorState();
		static_cast<DoHelloBadMD5ReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(false);
															#line 401 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<DoHelloBadMD5ReqActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoHelloBadMD5ReqActorState(); static_cast<DoHelloBadMD5ReqActor*>(this)->destroy(); return 0; }
															#line 3920 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<DoHelloBadMD5ReqActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoHelloBadMD5ReqActorState();
		static_cast<DoHelloBadMD5ReqActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoHelloBadMD5ReqActor*>(this)->actor_wait_state > 0) static_cast<DoHelloBadMD5ReqActor*>(this)->actor_wait_state = 0;
		static_cast<DoHelloBadMD5ReqActor*>(this)->ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloBadMD5ReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloBadMD5ReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloBadMD5ReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IConnection> conn;
															#line 378 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnsentPacketQueue content;
															#line 379 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<HTTP::OutgoingRequest> req;
															#line 381 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	Reference<IRateControl> sendReceiveRate;
															#line 382 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	int64_t bytes_sent;
															#line 4013 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via doHelloBadMD5Req()
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class DoHelloBadMD5ReqActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >, public FastAllocated<DoHelloBadMD5ReqActor>, public DoHelloBadMD5ReqActorState<DoHelloBadMD5ReqActor> {
															#line 4018 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<DoHelloBadMD5ReqActor>::operator new;
	using FastAllocated<DoHelloBadMD5ReqActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17225549798096517888UL, 6739756100727646464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >;
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	DoHelloBadMD5ReqActor(Reference<IConnection> const& conn) 
															#line 4035 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoHelloBadMD5ReqActorState<DoHelloBadMD5ReqActor>(conn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6850613091163242496UL, 1926785081027088896UL);
		ActorExecutionContextHelper __helper(static_cast<DoHelloBadMD5ReqActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doHelloBadMD5Req");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doHelloBadMD5Req", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoHelloBadMD5ReqActor, 0, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doHelloBadMD5Req( Reference<IConnection> const& conn ) {
															#line 377 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoHelloBadMD5ReqActor(conn));
															#line 4068 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}

#line 403 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

// can't run as regular unit test right now because it needs special setup
															#line 4074 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase405()
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class FlowTestCase405Actor>
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase405ActorState {
															#line 4081 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase405ActorState(UnitTestParameters const& params) 
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : params(params)
															#line 4088 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase405", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase405ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase405", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 406 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 407 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			fmt::print("Registering sim server\n");
															#line 408 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			hostname = "helloworld-" + deterministicRandom()->randomUniqueID().toString();
															#line 409 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer(hostname, "80", makeReference<HelloWorldRequestHandler>());
															#line 409 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<FlowTestCase405Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4111 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase405Actor*>(this)->actor_wait_state = 1;
															#line 409 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase405Actor, 0, Void >*>(static_cast<FlowTestCase405Actor*>(this)));
															#line 4116 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase405ActorState();
		static_cast<FlowTestCase405Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 410 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloWorldReq));
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<FlowTestCase405Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4143 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase405Actor*>(this)->actor_wait_state = 2;
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase405Actor, 1, Void >*>(static_cast<FlowTestCase405Actor*>(this)));
															#line 4148 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 410 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloWorldReq));
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<FlowTestCase405Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4161 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase405Actor*>(this)->actor_wait_state = 2;
															#line 412 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase405Actor, 1, Void >*>(static_cast<FlowTestCase405Actor*>(this)));
															#line 4166 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase405Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase405Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase405Actor*>(this)->ActorCallback< FlowTestCase405Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase405Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase405Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase405Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Done Hello\n");
															#line 415 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<FlowTestCase405Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase405ActorState(); static_cast<FlowTestCase405Actor*>(this)->destroy(); return 0; }
															#line 4252 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<FlowTestCase405Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase405ActorState();
		static_cast<FlowTestCase405Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 414 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Done Hello\n");
															#line 415 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<FlowTestCase405Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase405ActorState(); static_cast<FlowTestCase405Actor*>(this)->destroy(); return 0; }
															#line 4266 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<FlowTestCase405Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase405ActorState();
		static_cast<FlowTestCase405Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase405Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase405Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase405Actor*>(this)->ActorCallback< FlowTestCase405Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase405Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase405Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase405Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnitTestParameters params;
															#line 408 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	std::string hostname;
															#line 4353 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase405()
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase405Actor final : public Actor<Void>, public ActorCallback< FlowTestCase405Actor, 0, Void >, public ActorCallback< FlowTestCase405Actor, 1, Void >, public FastAllocated<FlowTestCase405Actor>, public FlowTestCase405ActorState<FlowTestCase405Actor> {
															#line 4358 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase405Actor>::operator new;
	using FastAllocated<FlowTestCase405Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17188406041539453184UL, 8716303579853442560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase405Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase405Actor, 1, Void >;
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase405Actor(UnitTestParameters const& params) 
															#line 4376 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase405ActorState<FlowTestCase405Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase405", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14378604134824018688UL, 2131460287571088384UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase405Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase405");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase405", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase405Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase405Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
static Future<Void> flowTestCase405( UnitTestParameters const& params ) {
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new FlowTestCase405Actor(params));
															#line 4410 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase405, "/HTTP/Server/HelloWorld")

#line 417 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 4416 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase418()
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class FlowTestCase418Actor>
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase418ActorState {
															#line 4423 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase418ActorState(UnitTestParameters const& params) 
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : params(params)
															#line 4430 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase418", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase418ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase418", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 419 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 420 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			fmt::print("Registering sim server\n");
															#line 421 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			hostname = "helloerror-" + deterministicRandom()->randomUniqueID().toString();
															#line 422 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer(hostname, "80", makeReference<HelloErrorRequestHandler>());
															#line 422 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<FlowTestCase418Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4453 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase418Actor*>(this)->actor_wait_state = 1;
															#line 422 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase418Actor, 0, Void >*>(static_cast<FlowTestCase418Actor*>(this)));
															#line 4458 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase418ActorState();
		static_cast<FlowTestCase418Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 423 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloWorldErrorReq));
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<FlowTestCase418Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4485 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase418Actor*>(this)->actor_wait_state = 2;
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase418Actor, 1, Void >*>(static_cast<FlowTestCase418Actor*>(this)));
															#line 4490 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 423 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloWorldErrorReq));
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (static_cast<FlowTestCase418Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4503 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase418Actor*>(this)->actor_wait_state = 2;
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase418Actor, 1, Void >*>(static_cast<FlowTestCase418Actor*>(this)));
															#line 4508 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase418Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase418Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase418Actor*>(this)->ActorCallback< FlowTestCase418Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase418Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase418Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase418Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Done Error\n");
															#line 428 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<FlowTestCase418Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase418ActorState(); static_cast<FlowTestCase418Actor*>(this)->destroy(); return 0; }
															#line 4594 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<FlowTestCase418Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase418ActorState();
		static_cast<FlowTestCase418Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Done Error\n");
															#line 428 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<FlowTestCase418Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase418ActorState(); static_cast<FlowTestCase418Actor*>(this)->destroy(); return 0; }
															#line 4608 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<FlowTestCase418Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase418ActorState();
		static_cast<FlowTestCase418Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase418Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase418Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase418Actor*>(this)->ActorCallback< FlowTestCase418Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase418Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase418Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase418Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnitTestParameters params;
															#line 421 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	std::string hostname;
															#line 4695 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase418()
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase418Actor final : public Actor<Void>, public ActorCallback< FlowTestCase418Actor, 0, Void >, public ActorCallback< FlowTestCase418Actor, 1, Void >, public FastAllocated<FlowTestCase418Actor>, public FlowTestCase418ActorState<FlowTestCase418Actor> {
															#line 4700 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase418Actor>::operator new;
	using FastAllocated<FlowTestCase418Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3191104566884708864UL, 16403897466596817664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase418Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase418Actor, 1, Void >;
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase418Actor(UnitTestParameters const& params) 
															#line 4718 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase418ActorState<FlowTestCase418Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase418", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12776014054332786176UL, 15656997579524801280UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase418Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase418");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase418", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase418Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase418Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
static Future<Void> flowTestCase418( UnitTestParameters const& params ) {
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new FlowTestCase418Actor(params));
															#line 4752 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase418, "/HTTP/Server/HelloError")

#line 430 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"

															#line 4758 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase431()
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
template <class FlowTestCase431Actor>
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase431ActorState {
															#line 4765 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase431ActorState(UnitTestParameters const& params) 
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		 : params(params)
															#line 4772 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase431", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase431ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase431", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 432 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 433 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			fmt::print("Registering sim server\n");
															#line 434 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			hostname = "hellobadmd5-" + deterministicRandom()->randomUniqueID().toString();
															#line 435 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer(hostname, "80", makeReference<HelloBadMD5RequestHandler>());
															#line 435 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<FlowTestCase431Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4795 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase431Actor*>(this)->actor_wait_state = 1;
															#line 435 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase431Actor, 0, Void >*>(static_cast<FlowTestCase431Actor*>(this)));
															#line 4800 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase431ActorState();
		static_cast<FlowTestCase431Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 4823 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		try {
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloBadMD5Req));
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<FlowTestCase431Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4829 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase431Actor*>(this)->actor_wait_state = 2;
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase431Actor, 1, Void >*>(static_cast<FlowTestCase431Actor*>(this)));
															#line 4834 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 436 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Registered sim server\n");
															#line 4849 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		try {
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(doRequestTest(hostname, "80", doHelloBadMD5Req));
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			if (static_cast<FlowTestCase431Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4855 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase431Actor*>(this)->actor_wait_state = 2;
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase431Actor, 1, Void >*>(static_cast<FlowTestCase431Actor*>(this)));
															#line 4860 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase431Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase431Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase431Actor*>(this)->ActorCallback< FlowTestCase431Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase431Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase431Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase431Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 446 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		fmt::print("Done Bad MD5\n");
															#line 447 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		if (!static_cast<FlowTestCase431Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase431ActorState(); static_cast<FlowTestCase431Actor*>(this)->destroy(); return 0; }
															#line 4952 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		new (&static_cast<FlowTestCase431Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase431ActorState();
		static_cast<FlowTestCase431Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 443 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
			ASSERT(e.code() == error_code_http_bad_response);
															#line 4965 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 441 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(false);
															#line 4980 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 441 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
		ASSERT(false);
															#line 4989 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase431Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase431Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase431Actor*>(this)->ActorCallback< FlowTestCase431Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase431Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase431Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase431Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	UnitTestParameters params;
															#line 434 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	std::string hostname;
															#line 5086 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase431()
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
class FlowTestCase431Actor final : public Actor<Void>, public ActorCallback< FlowTestCase431Actor, 0, Void >, public ActorCallback< FlowTestCase431Actor, 1, Void >, public FastAllocated<FlowTestCase431Actor>, public FlowTestCase431ActorState<FlowTestCase431Actor> {
															#line 5091 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase431Actor>::operator new;
	using FastAllocated<FlowTestCase431Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(578976731390409984UL, 6719882906050616064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase431Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase431Actor, 1, Void >;
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	FlowTestCase431Actor(UnitTestParameters const& params) 
															#line 5109 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase431ActorState<FlowTestCase431Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase431", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3446984188069465088UL, 2651875321762260736UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase431Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase431");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase431", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase431Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase431Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
static Future<Void> flowTestCase431( UnitTestParameters const& params ) {
															#line 431 "/Users/ec2-user/foundationdb/fdbrpc/HTTPServer.actor.cpp"
	return Future<Void>(new FlowTestCase431Actor(params));
															#line 5143 "/Users/ec2-user/foundationdb_build_output_macos_x86_64/fdbrpc/HTTPServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase431, "/HTTP/Server/HelloBadMD5")

