/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeyArrayResult;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.LocalityUtil;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.TenantManagement;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.test.Context;
import com.apple.foundationdb.test.DirectoryExtension;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.test.StackEntry;
import com.apple.foundationdb.test.StackOperation;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

public class StackTester {
    static final String DIRECTORY_PREFIX = "DIRECTORY_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processInstruction(Instruction instruction) {
        block84: {
            try {
                StackOperation stackOperation = StackOperation.valueOf(instruction.op);
                if (stackOperation == StackOperation.PUSH) {
                    Object object = instruction.tokens.get(1);
                    instruction.push(object);
                    break block84;
                }
                if (stackOperation == StackOperation.POP) {
                    instruction.pop();
                    break block84;
                }
                if (stackOperation == StackOperation.DUP) {
                    if (instruction.size() == 0) {
                        throw new RuntimeException("No stack bro!! (" + instruction.context.preStr + ")");
                    }
                    StackEntry stackEntry = instruction.pop();
                    instruction.push(stackEntry);
                    instruction.push(stackEntry);
                    break block84;
                }
                if (stackOperation == StackOperation.EMPTY_STACK) {
                    instruction.clear();
                    break block84;
                }
                if (stackOperation == StackOperation.SWAP) {
                    List<Object> list = instruction.popParams(1).join();
                    int n = StackUtils.getInt(list, 0);
                    instruction.swap(n);
                    break block84;
                }
                if (stackOperation == StackOperation.WAIT_FUTURE) {
                    StackEntry stackEntry = instruction.pop();
                    instruction.push(stackEntry.idx, StackUtils.serializeFuture(stackEntry.value));
                    break block84;
                }
                if (stackOperation == StackOperation.WAIT_EMPTY) {
                    List<Object> list = instruction.popParams(1).join();
                    instruction.context.db.run((Function)new WaitEmpty((byte[])list.get(0)));
                    instruction.push("WAITED_FOR_EMPTY".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.START_THREAD) {
                    List<Object> list = instruction.popParams(1).join();
                    instruction.context.addContext((byte[])list.get(0));
                    break block84;
                }
                if (stackOperation == StackOperation.NEW_TRANSACTION) {
                    instruction.context.newTransaction();
                    break block84;
                }
                if (stackOperation == StackOperation.USE_TRANSACTION) {
                    List<Object> list = instruction.popParams(1).join();
                    instruction.context.switchTransaction((byte[])list.get(0));
                    break block84;
                }
                if (stackOperation == StackOperation.SET) {
                    List<Object> list = instruction.popParams(2).join();
                    StackTester.executeMutation(instruction, transaction -> {
                        transaction.set((byte[])list.get(0), (byte[])list.get(1));
                        return null;
                    });
                    break block84;
                }
                if (stackOperation == StackOperation.CLEAR) {
                    List<Object> list = instruction.popParams(1).join();
                    StackTester.executeMutation(instruction, transaction -> {
                        transaction.clear((byte[])list.get(0));
                        return null;
                    });
                    break block84;
                }
                if (stackOperation == StackOperation.CLEAR_RANGE) {
                    List<Object> list = instruction.popParams(2).join();
                    StackTester.executeMutation(instruction, transaction -> {
                        transaction.clear((byte[])list.get(0), (byte[])list.get(1));
                        return null;
                    });
                    break block84;
                }
                if (stackOperation == StackOperation.CLEAR_RANGE_STARTS_WITH) {
                    List<Object> list = instruction.popParams(1).join();
                    StackTester.executeMutation(instruction, transaction -> {
                        transaction.clear(Range.startsWith((byte[])((byte[])list.get(0))));
                        return null;
                    });
                    break block84;
                }
                if (stackOperation == StackOperation.ATOMIC_OP) {
                    List<Object> list = instruction.popParams(3).join();
                    MutationType mutationType = MutationType.valueOf((String)((String)list.get(0)));
                    StackTester.executeMutation(instruction, transaction -> {
                        transaction.mutate(mutationType, (byte[])list.get(1), (byte[])list.get(2));
                        return null;
                    });
                    break block84;
                }
                if (stackOperation == StackOperation.COMMIT) {
                    instruction.push(instruction.tr.commit());
                    break block84;
                }
                if (stackOperation == StackOperation.READ_CONFLICT_RANGE) {
                    List<Object> list = instruction.popParams(2).join();
                    instruction.tr.addReadConflictRange((byte[])list.get(0), (byte[])list.get(1));
                    instruction.push("SET_CONFLICT_RANGE".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.WRITE_CONFLICT_RANGE) {
                    List<Object> list = instruction.popParams(2).join();
                    instruction.tr.addWriteConflictRange((byte[])list.get(0), (byte[])list.get(1));
                    instruction.push("SET_CONFLICT_RANGE".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.READ_CONFLICT_KEY) {
                    List<Object> list = instruction.popParams(1).join();
                    instruction.tr.addReadConflictKey((byte[])list.get(0));
                    instruction.push("SET_CONFLICT_KEY".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.WRITE_CONFLICT_KEY) {
                    List<Object> list = instruction.popParams(1).join();
                    instruction.tr.addWriteConflictKey((byte[])list.get(0));
                    instruction.push("SET_CONFLICT_KEY".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.DISABLE_WRITE_CONFLICT) {
                    instruction.tr.options().setNextWriteNoWriteConflictRange();
                    break block84;
                }
                if (stackOperation == StackOperation.RESET) {
                    instruction.context.resetTransaction();
                    break block84;
                }
                if (stackOperation == StackOperation.CANCEL) {
                    instruction.tr.cancel();
                    break block84;
                }
                if (stackOperation == StackOperation.GET) {
                    List<Object> list = instruction.popParams(1).join();
                    CompletableFuture completableFuture = (CompletableFuture)instruction.readTcx.read(readTransaction -> readTransaction.get((byte[])list.get(0)));
                    instruction.push(completableFuture);
                    break block84;
                }
                if (stackOperation == StackOperation.GET_ESTIMATED_RANGE_SIZE) {
                    List<Object> list = instruction.popParams(2).join();
                    Long l = (Long)instruction.readTr.getEstimatedRangeSizeBytes((byte[])list.get(0), (byte[])list.get(1)).join();
                    instruction.push("GOT_ESTIMATED_RANGE_SIZE".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_RANGE_SPLIT_POINTS) {
                    List<Object> list = instruction.popParams(3).join();
                    KeyArrayResult keyArrayResult = (KeyArrayResult)instruction.readTr.getRangeSplitPoints((byte[])list.get(0), (byte[])list.get(1), ((Long)list.get(2)).longValue()).join();
                    instruction.push("GOT_RANGE_SPLIT_POINTS".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_RANGE) {
                    List<Object> list = instruction.popParams(5).join();
                    byte[] byArray = (byte[])list.get(0);
                    byte[] byArray2 = (byte[])list.get(1);
                    int n = StackUtils.getInt(list.get(2));
                    boolean bl = StackUtils.getBoolean(list.get(3));
                    StreamingMode list4 = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(4), (Integer)StreamingMode.ITERATOR.code()));
                    List keyValue = (List)instruction.readTcx.read(readTransaction -> StackTester.executeRangeQuery((AsyncIterable<KeyValue>)readTransaction.getRange(byArray, byArray2, n, bl, streamingMode)));
                    instruction.push(Tuple.fromItems((Iterable)keyValue).pack());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_RANGE_SELECTOR) {
                    List<Object> list = instruction.popParams(10).join();
                    KeySelector keySelector = StackUtils.createSelector(list.get(0), list.get(1), list.get(2));
                    KeySelector keySelector2 = StackUtils.createSelector(list.get(3), list.get(4), list.get(5));
                    int n = StackUtils.getInt(list.get(6));
                    boolean bl = StackUtils.getBoolean(list.get(7));
                    StreamingMode tuple = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(8), (Integer)StreamingMode.ITERATOR.code()));
                    List list2 = (List)instruction.readTcx.read(readTransaction -> StackTester.executeRangeQuery((AsyncIterable<KeyValue>)readTransaction.getRange(keySelector, keySelector2, n, bl, streamingMode), (byte[])list.get(9)));
                    instruction.push(Tuple.fromItems((Iterable)list2).pack());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_RANGE_STARTS_WITH) {
                    List<Object> list = instruction.popParams(4).join();
                    byte[] byArray = (byte[])list.get(0);
                    int n = StackUtils.getInt(list.get(1));
                    boolean bl = StackUtils.getBoolean(list.get(2));
                    StreamingMode streamingMode = instruction.context.streamingModeFromCode(StackUtils.getInt(list.get(3), (Integer)StreamingMode.ITERATOR.code()));
                    List arrayList = (List)instruction.readTcx.read(readTransaction -> StackTester.executeRangeQuery((AsyncIterable<KeyValue>)readTransaction.getRange(Range.startsWith((byte[])byArray), n, bl, streamingMode)));
                    instruction.push(Tuple.fromItems((Iterable)arrayList).pack());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_KEY) {
                    List<Object> list = instruction.popParams(4).join();
                    KeySelector keySelector = StackUtils.createSelector(list.get(0), list.get(1), list.get(2));
                    byte[] byArray = (byte[])instruction.readTcx.read(readTransaction -> StackTester.filterKeyResult((byte[])readTransaction.getKey(keySelector).join(), (byte[])list.get(3)));
                    instruction.push(byArray);
                    break block84;
                }
                if (stackOperation == StackOperation.GET_READ_VERSION) {
                    instruction.context.lastVersion = (Long)instruction.readTr.getReadVersion().join();
                    instruction.push("GOT_READ_VERSION".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_COMMITTED_VERSION) {
                    instruction.context.lastVersion = instruction.tr.getCommittedVersion();
                    instruction.push("GOT_COMMITTED_VERSION".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_APPROXIMATE_SIZE) {
                    Long l = (Long)instruction.tr.getApproximateSize().join();
                    instruction.push("GOT_APPROXIMATE_SIZE".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.GET_VERSIONSTAMP) {
                    instruction.push(instruction.tr.getVersionstamp());
                    break block84;
                }
                if (stackOperation == StackOperation.SET_READ_VERSION) {
                    if (instruction.context.lastVersion == null) {
                        throw new IllegalArgumentException("Read version has not been read " + instruction.context.preStr);
                    }
                    instruction.tr.setReadVersion(instruction.context.lastVersion.longValue());
                    break block84;
                }
                if (stackOperation == StackOperation.ON_ERROR) {
                    List<Object> list = instruction.popParams(1).join();
                    int n = StackUtils.getInt(list, 0);
                    boolean bl = n == 1102 || n == 2015;
                    FDBException fDBException = new FDBException("Fake testing error", bl ? 1020 : n);
                    try {
                        Transaction transaction2 = (Transaction)instruction.tr.onError((Throwable)fDBException).join();
                        if (!instruction.replaceTransaction(transaction2)) {
                            transaction2.close();
                        }
                    }
                    catch (Throwable throwable) {
                        instruction.context.resetTransaction();
                        throw throwable;
                    }
                    if (bl) {
                        throw new FDBException("Fake testing error", n);
                    }
                    instruction.push(CompletableFuture.completedFuture(null));
                    break block84;
                }
                if (stackOperation == StackOperation.SUB) {
                    List<Object> list = instruction.popParams(2).join();
                    BigInteger bigInteger = StackUtils.getBigInteger(list.get(0));
                    BigInteger bigInteger2 = StackUtils.getBigInteger(list.get(1));
                    instruction.push(bigInteger.subtract(bigInteger2));
                    break block84;
                }
                if (stackOperation == StackOperation.CONCAT) {
                    List<Object> list = instruction.popParams(2).join();
                    if (list.get(0) instanceof String) {
                        instruction.push((String)list.get(0) + (String)list.get(1));
                    } else {
                        instruction.push(ByteArrayUtil.join((byte[][])new byte[][]{(byte[])list.get(0), (byte[])list.get(1)}));
                    }
                    break block84;
                }
                if (stackOperation == StackOperation.TUPLE_PACK) {
                    List<Object> list = instruction.popParams(1).join();
                    int n = StackUtils.getInt(list.get(0));
                    List<Object> list5 = instruction.popParams(n).join();
                    byte[] byArray = Tuple.fromItems(list5).pack();
                    instruction.push(byArray);
                    break block84;
                }
                if (stackOperation == StackOperation.TUPLE_PACK_WITH_VERSIONSTAMP) {
                    List<Object> list = instruction.popParams(2).join();
                    byte[] byArray = (byte[])list.get(0);
                    int n = StackUtils.getInt(list.get(1));
                    Tuple tuple = Tuple.fromItems((Iterable)instruction.popParams(n).join());
                    if (!tuple.hasIncompleteVersionstamp() && Math.random() < 0.5) {
                        instruction.push("ERROR: NONE".getBytes());
                        break block84;
                    }
                    try {
                        byte[] byArray3 = tuple.packWithVersionstamp(byArray);
                        instruction.push("OK".getBytes());
                        instruction.push(byArray3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage().startsWith("No incomplete")) {
                            instruction.push("ERROR: NONE".getBytes());
                            break block84;
                        }
                        instruction.push("ERROR: MULTIPLE".getBytes());
                    }
                    break block84;
                }
                if (stackOperation == StackOperation.TUPLE_UNPACK) {
                    List<Object> list = instruction.popParams(1).join();
                    Tuple tuple = Tuple.fromBytes((byte[])((byte[])list.get(0)));
                    for (Object e : tuple.getItems()) {
                        byte[] byArray = Tuple.from((Object[])new Object[]{e}).pack();
                        instruction.push(byArray);
                    }
                    break block84;
                }
                if (stackOperation == StackOperation.TUPLE_RANGE) {
                    List<Object> list = instruction.popParams(1).join();
                    int n = StackUtils.getInt(list, 0);
                    List<Object> list6 = instruction.popParams(n).join();
                    Range range = Tuple.fromItems(list6).range();
                    instruction.push(range.begin);
                    instruction.push(range.end);
                    break block84;
                }
                if (stackOperation == StackOperation.TUPLE_SORT) {
                    int n = StackUtils.getInt(instruction.popParam().join());
                    List<Object> list = instruction.popParams(n).join();
                    ArrayList<Tuple> arrayList = new ArrayList<Tuple>(n);
                    for (Object object : list) {
                        Tuple tuple = Tuple.fromBytes((byte[])((byte[])object));
                        arrayList.add(Tuple.fromList((List)tuple.getItems()));
                    }
                    Collections.sort(arrayList);
                    for (Tuple tuple : arrayList) {
                        instruction.push(tuple.pack());
                    }
                    break block84;
                }
                if (stackOperation == StackOperation.ENCODE_FLOAT) {
                    Object object = instruction.popParam().join();
                    byte[] byArray = (byte[])object;
                    float f = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
                    instruction.push(Float.valueOf(f));
                    break block84;
                }
                if (stackOperation == StackOperation.ENCODE_DOUBLE) {
                    Object object = instruction.popParam().join();
                    byte[] byArray = (byte[])object;
                    double d = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getDouble();
                    instruction.push(d);
                    break block84;
                }
                if (stackOperation == StackOperation.DECODE_FLOAT) {
                    Object object = instruction.popParam().join();
                    float f = ((Number)object).floatValue();
                    instruction.push(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putFloat(f).array());
                    break block84;
                }
                if (stackOperation == StackOperation.DECODE_DOUBLE) {
                    Object object = instruction.popParam().join();
                    double d = ((Number)object).doubleValue();
                    instruction.push(ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putDouble(d).array());
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_CREATE) {
                    byte[] byArray = (byte[])instruction.popParam().join();
                    instruction.push(TenantManagement.createTenant((Database)instruction.context.db, (byte[])byArray));
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_DELETE) {
                    byte[] byArray = (byte[])instruction.popParam().join();
                    instruction.push(TenantManagement.deleteTenant((Database)instruction.context.db, (byte[])byArray));
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_LIST) {
                    List<Object> list = instruction.popParams(3).join();
                    byte[] byArray = (byte[])list.get(0);
                    byte[] byArray4 = (byte[])list.get(1);
                    int n = StackUtils.getInt(list.get(2));
                    ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                    try (CloseableAsyncIterator closeableAsyncIterator = TenantManagement.listTenants((Database)instruction.context.db, (byte[])byArray, (byte[])byArray4, (int)n);){
                        while (closeableAsyncIterator.hasNext()) {
                            KeyValue keyValue = (KeyValue)closeableAsyncIterator.next();
                            String string = new String(keyValue.getValue());
                            assert (StackUtils.validTenantMetadata(string)) : "Invalid Tenant Metadata";
                            arrayList.add(keyValue.getKey());
                        }
                    }
                    instruction.push(Tuple.fromItems(arrayList).pack());
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_SET_ACTIVE) {
                    byte[] byArray = (byte[])instruction.popParam().join();
                    instruction.context.setTenant(Optional.of(byArray)).join();
                    instruction.push("SET_ACTIVE_TENANT".getBytes());
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_CLEAR_ACTIVE) {
                    instruction.context.setTenant(Optional.empty());
                    break block84;
                }
                if (stackOperation == StackOperation.TENANT_GET_ID) {
                    if (instruction.context.tenant.isPresent()) {
                        instruction.context.tenant.get().getId().join();
                        instruction.push("GOT_TENANT_ID".getBytes());
                    } else {
                        instruction.push("NO_ACTIVE_TENANT".getBytes());
                    }
                    break block84;
                }
                if (stackOperation == StackOperation.UNIT_TESTS) {
                    try {
                        instruction.context.db.options().setLocationCacheSize(100001L);
                        instruction.context.db.run(transaction -> {
                            FDB fDB = FDB.instance();
                            String string = "FoundationDB API already started at different version";
                            try {
                                FDB.selectAPIVersion((int)(fDB.getAPIVersion() + 1));
                                throw new IllegalStateException("Was not stopped from selecting two API versions");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (!illegalArgumentException.getMessage().equals(string)) {
                                    throw illegalArgumentException;
                                }
                                try {
                                    FDB.selectAPIVersion((int)(fDB.getAPIVersion() - 1));
                                    throw new IllegalStateException("Was not stopped from selecting two API versions");
                                }
                                catch (IllegalArgumentException illegalArgumentException2) {
                                    if (!illegalArgumentException2.getMessage().equals(string)) {
                                        throw illegalArgumentException2;
                                    }
                                    Database database = transaction.getDatabase();
                                    database.options().setLocationCacheSize(100001L);
                                    database.options().setMaxWatches(10001L);
                                    database.options().setDatacenterId("dc_id");
                                    database.options().setMachineId("machine_id");
                                    database.options().setSnapshotRywEnable();
                                    database.options().setSnapshotRywDisable();
                                    database.options().setTransactionLoggingMaxFieldLength(1000L);
                                    database.options().setTransactionTimeout(100000L);
                                    database.options().setTransactionTimeout(0L);
                                    database.options().setTransactionMaxRetryDelay(100L);
                                    database.options().setTransactionRetryLimit(10L);
                                    database.options().setTransactionRetryLimit(-1L);
                                    database.options().setTransactionCausalReadRisky();
                                    database.options().setTransactionIncludePortInAddress();
                                    database.options().setTransactionUsedDuringCommitProtectionDisable();
                                    database.options().setTransactionBypassUnreadable();
                                    database.options().setTransactionReportConflictingKeys();
                                    transaction.options().setPrioritySystemImmediate();
                                    transaction.options().setPriorityBatch();
                                    transaction.options().setCausalReadRisky();
                                    transaction.options().setCausalWriteRisky();
                                    transaction.options().setReadYourWritesDisable();
                                    transaction.options().setReadSystemKeys();
                                    transaction.options().setAccessSystemKeys();
                                    transaction.options().setTransactionLoggingMaxFieldLength(1000L);
                                    transaction.options().setTimeout(60000L);
                                    transaction.options().setRetryLimit(50L);
                                    transaction.options().setMaxRetryDelay(100L);
                                    transaction.options().setUsedDuringCommitProtectionDisable();
                                    transaction.options().setDebugTransactionIdentifier("my_transaction");
                                    transaction.options().setLogTransaction();
                                    transaction.options().setReadLockAware();
                                    transaction.options().setLockAware();
                                    transaction.options().setIncludePortInAddress();
                                    transaction.options().setReportConflictingKeys();
                                    transaction.options().setBypassUnreadable();
                                    if (!new FDBException("Fake", 1020).isRetryable() || new FDBException("Fake", 10).isRetryable()) {
                                        throw new RuntimeException("Unit test failed: Error predicate incorrect");
                                    }
                                    byte[] byArray = new byte[]{-1};
                                    transaction.get(byArray).join();
                                    return null;
                                }
                            }
                        });
                        StackTester.testWatches(instruction.context.db);
                        StackTester.testLocality(instruction.context.db);
                        StackTester.testTenantTupleNames(instruction.context.db);
                        break block84;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Unit tests failed: " + exception.getMessage());
                    }
                }
                if (stackOperation == StackOperation.LOG_STACK) {
                    List<Object> list = instruction.popParams(1).join();
                    byte[] byArray = (byte[])list.get(0);
                    HashMap<Integer, StackEntry> hashMap = new HashMap<Integer, StackEntry>();
                    while (instruction.size() > 0) {
                        hashMap.put(instruction.size() - 1, instruction.pop());
                        if (hashMap.size() != 100) continue;
                        StackTester.logStack(instruction.context.db, hashMap, byArray);
                        hashMap.clear();
                    }
                    StackTester.logStack(instruction.context.db, hashMap, byArray);
                    break block84;
                }
                throw new IllegalArgumentException("Unrecognized (or unimplemented) operation");
            }
            catch (FDBException fDBException) {
                StackUtils.pushError(instruction, fDBException);
            }
            catch (CompletionException completionException) {
                fDBException = StackUtils.getRootFDBException(completionException);
                if (fDBException == null) {
                    throw completionException;
                }
                StackUtils.pushError(instruction, fDBException);
            }
        }
    }

    private static void executeMutation(Instruction instruction, Function<Transaction, Void> function) {
        instruction.tcx.run(function);
        if (instruction.isDatabase || instruction.isTenant) {
            instruction.push("RESULT_NOT_PRESENT".getBytes());
        }
    }

    static byte[] filterKeyResult(byte[] byArray, byte[] byArray2) {
        if (ByteArrayUtil.startsWith((byte[])byArray, (byte[])byArray2)) {
            return byArray;
        }
        if (ByteArrayUtil.compareUnsigned((byte[])byArray, (byte[])byArray2) < 0) {
            return byArray2;
        }
        return ByteArrayUtil.strinc((byte[])byArray2);
    }

    private static List<byte[]> executeRangeQuery(AsyncIterable<KeyValue> asyncIterable) {
        return StackTester.executeRangeQuery(asyncIterable, null);
    }

    private static List<byte[]> executeRangeQuery(AsyncIterable<KeyValue> asyncIterable, byte[] byArray) {
        if (Math.random() < 0.5) {
            return StackTester.getRange(asyncIterable, byArray);
        }
        return StackTester.getRangeAsList(asyncIterable, byArray);
    }

    private static List<byte[]> getRange(AsyncIterable<KeyValue> asyncIterable, byte[] byArray) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (KeyValue keyValue : asyncIterable) {
            if (byArray != null && !ByteArrayUtil.startsWith((byte[])keyValue.getKey(), (byte[])byArray)) continue;
            linkedList.add(keyValue.getKey());
            linkedList.add(keyValue.getValue());
        }
        return linkedList;
    }

    private static List<byte[]> getRangeAsList(AsyncIterable<KeyValue> asyncIterable, byte[] byArray) {
        List list = (List)asyncIterable.asList().join();
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        for (KeyValue keyValue : list) {
            if (byArray != null && !ByteArrayUtil.startsWith((byte[])keyValue.getKey(), (byte[])byArray)) continue;
            linkedList.add(keyValue.getKey());
            linkedList.add(keyValue.getValue());
        }
        return linkedList;
    }

    private static void logStack(Database database, Map<Integer, StackEntry> map, byte[] byArray) {
        database.run(transaction -> {
            for (Map.Entry entry : map.entrySet()) {
                byte[] byArray2 = Tuple.from((Object[])new Object[]{entry.getKey(), ((StackEntry)entry.getValue()).idx}).pack(byArray);
                byte[] byArray3 = Tuple.from((Object[])new Object[]{StackUtils.serializeFuture(((StackEntry)entry.getValue()).value)}).pack();
                transaction.set(byArray2, byArray3.length < 40000 ? byArray3 : Arrays.copyOfRange(byArray3, 0, 40000));
            }
            return null;
        });
    }

    private static boolean checkWatches(List<CompletableFuture<Void>> list, Database database, boolean bl) {
        for (CompletableFuture<Void> completableFuture : list) {
            if (!completableFuture.isDone() && !bl) continue;
            try {
                completableFuture.join();
                if (bl) continue;
                throw new IllegalStateException("A watch triggered too early");
            }
            catch (FDBException fDBException) {
                try (Transaction transaction = database.createTransaction();){
                    transaction.onError((Throwable)fDBException).join();
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        return true;
    }

    private static void testWatches(Database database) {
        while (true) {
            database.run(transaction -> {
                transaction.set("foo".getBytes(), "f".getBytes());
                transaction.clear("bar".getBytes());
                return null;
            });
            List list = (List)database.run(transaction -> {
                LinkedList<CompletableFuture> linkedList = new LinkedList<CompletableFuture>();
                linkedList.add(transaction.watch("foo".getBytes()));
                linkedList.add(transaction.watch("bar".getBytes()));
                transaction.set("foo".getBytes(), "f".getBytes());
                return linkedList;
            });
            database.run(transaction -> {
                transaction.clear("bar".getBytes());
                return null;
            });
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (!StackTester.checkWatches(list, database, false)) continue;
            database.run(transaction -> {
                transaction.set("foo".getBytes(), "bar".getBytes());
                transaction.set("bar".getBytes(), "foo".getBytes());
                return null;
            });
            if (StackTester.checkWatches(list, database, true)) break;
        }
    }

    private static void testLocality(Database database) {
        database.run(transaction -> {
            transaction.options().setTimeout(60000L);
            transaction.options().setReadSystemKeys();
            transaction.getReadVersion().join();
            try (CloseableAsyncIterator closeableAsyncIterator = LocalityUtil.getBoundaryKeys((Transaction)transaction, (byte[])new byte[0], (byte[])new byte[]{-1, -1});){
                List list = (List)AsyncUtil.collectRemaining((AsyncIterator)closeableAsyncIterator).join();
                for (int i = 0; i < list.size() - 1; ++i) {
                    byte[] byArray = (byte[])list.get(i);
                    byte[] byArray2 = (byte[])transaction.getKey(KeySelector.lastLessThan((byte[])((byte[])list.get(i + 1)))).join();
                    List<String> list2 = Arrays.asList((String[])LocalityUtil.getAddressesForKey((Transaction)transaction, (byte[])byArray).join());
                    List<String> list3 = Arrays.asList((String[])LocalityUtil.getAddressesForKey((Transaction)transaction, (byte[])byArray2).join());
                    for (String string : list2) {
                        if (list3.contains(string)) continue;
                        throw new RuntimeException("Locality not internally consistent.");
                    }
                }
                Object var3_4 = null;
                return var3_4;
            }
        });
    }

    private static void testTenantTupleNames(Database database) {
        try {
            TenantManagement.createTenant((Database)database, (Tuple)Tuple.from((Object[])new Object[]{"tenant"})).join();
            Tenant tenant = database.openTenant(Tuple.from((Object[])new Object[]{"tenant"}));
            tenant.run(transaction -> {
                transaction.set(Tuple.from((Object[])new Object[]{"hello"}).pack(), Tuple.from((Object[])new Object[]{"world"}).pack());
                return null;
            });
            String string = (String)tenant.read(readTransaction -> {
                byte[] byArray = (byte[])readTransaction.get(Tuple.from((Object[])new Object[]{"hello"}).pack()).join();
                return Tuple.fromBytes((byte[])byArray).getString(0);
            });
            assert (string.equals("world"));
            tenant.run(transaction -> {
                transaction.clear(Tuple.from((Object[])new Object[]{"hello"}).pack());
                return null;
            });
            TenantManagement.deleteTenant((Database)database, (Tuple)Tuple.from((Object[])new Object[]{"tenant"})).join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("StackTester needs parameters <prefix> <optional_cluster_file>");
        }
        byte[] byArray = stringArray[0].getBytes();
        if (FDB.isAPIVersionSelected()) {
            throw new IllegalStateException("API version already set to " + FDB.instance().getAPIVersion());
        }
        try {
            FDB.instance();
            throw new IllegalStateException("Able to get API instance before selecting API version");
        }
        catch (FDBException fDBException) {
            if (fDBException.getCode() != 2200) {
                throw fDBException;
            }
            int n = Integer.parseInt(stringArray[1]);
            FDB fDB = FDB.selectAPIVersion((int)n);
            if (FDB.instance().getAPIVersion() != n) {
                throw new IllegalStateException("API version not correctly set to " + n);
            }
            Database database = stringArray.length == 2 ? fDB.open() : fDB.open(stringArray[2]);
            SynchronousContext synchronousContext = new SynchronousContext(database, byArray);
            synchronousContext.run();
            database.close();
            System.gc();
            return;
        }
    }

    private StackTester() {
    }

    static class SynchronousContext
    extends Context {
        DirectoryExtension directoryExtension = new DirectoryExtension();

        SynchronousContext(Database database, byte[] byArray) {
            super(database, byArray);
        }

        @Override
        Context createContext(byte[] byArray) {
            return new SynchronousContext(this.db, byArray);
        }

        void processOp(byte[] byArray) {
            Tuple tuple = Tuple.fromBytes((byte[])byArray);
            Instruction instruction = new Instruction(this, tuple);
            if (instruction.op.startsWith(StackTester.DIRECTORY_PREFIX)) {
                this.directoryExtension.processInstruction(instruction);
            } else {
                StackTester.processInstruction(instruction);
            }
            instruction.releaseTransaction();
        }

        @Override
        void executeOperations() {
            List list;
            while ((list = (List)this.db.read(readTransaction -> (List)readTransaction.getRange(this.nextKey, this.endKey).asList().join())).size() != 0) {
                for (KeyValue keyValue : list) {
                    this.nextKey = KeySelector.firstGreaterThan((byte[])keyValue.getKey());
                    this.processOp(keyValue.getValue());
                    ++this.instructionIndex;
                }
            }
        }
    }

    static class WaitEmpty
    implements Function<Transaction, Void> {
        private final byte[] prefix;

        WaitEmpty(byte[] byArray) {
            this.prefix = byArray;
        }

        @Override
        public Void apply(Transaction transaction) {
            List list = (List)transaction.getRange(Range.startsWith((byte[])this.prefix)).asList().join();
            if (list.size() > 0) {
                throw new FDBException("ERROR: Fake commit conflict", 1020);
            }
            return null;
        }
    }
}

