#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
/*
 * TaskBucketCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/UnitTest.h"
#include "flow/Error.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/TaskBucket.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SayHelloTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 49 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class _finishActor>
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActorState {
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : tr(tr),
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskBucket(taskBucket),
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   futureBucket(futureBucket),
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   task(task)
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (taskVersion > SayHelloTaskFunc::version)
															#line 85 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			{
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				uint32_t v = SayHelloTaskFunc::version;
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				TraceEvent("TaskBucketCorrectnessSayHello") .detail("CheckTaskVersion", "taskVersion is larger than the funcVersion") .detail("TaskVersion", taskVersion) .detail("FuncVersion", v);
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			done = futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]);
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskBucket->finish(tr, task);
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (BUGGIFY)
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(10);
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (BUGGIFY)
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(10);
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		key = StringRef("Hello_" + deterministicRandom()->randomUniqueID().toString());
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		value = Key();
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		auto itor = task->params.find("name"_sr);
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (itor != task->params.end())
															#line 258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			value = itor->value;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent("TaskBucketCorrectnessSayHello").detail("SayHelloTaskFunc", printable(itor->value));
															#line 264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(false);
															#line 270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		}
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!task->params["chained"_sr].compare("false"_sr))
															#line 274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = done->set(tr, taskBucket);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 3;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 2, Void >*>(static_cast<_finishActor*>(this)));
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			int subtaskCount = atoi(task->params["subtaskCount"_sr].toString().c_str());
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			int currTaskNumber = atoi(value.removePrefix("task_"_sr).toString().c_str());
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent("TaskBucketCorrectnessSayHello") .detail("SubtaskCount", subtaskCount) .detail("CurrTaskNumber", currTaskNumber);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (currTaskNumber < subtaskCount - 1)
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				vectorFuture = std::vector<Reference<TaskFuture>>();
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				auto new_task = makeReference<Task>(SayHelloTaskFunc::name, SayHelloTaskFunc::version, StringRef(), deterministicRandom()->randomInt(0, 2));
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["name"_sr] = StringRef(format("task_%d", currTaskNumber + 1));
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["chained"_sr] = task->params["chained"_sr];
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["subtaskCount"_sr] = task->params["subtaskCount"_sr];
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				Reference<TaskFuture> taskDone = futureBucket->future(tr);
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params[Task::reservedTaskParamKeyDone] = taskDone->key;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				taskBucket->addTask(tr, new_task);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				vectorFuture.push_back(taskDone);
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_3 = done->join(tr, taskBucket, vectorFuture);
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when2(__when_expr_3.get(), loopDepth); };
				static_cast<_finishActor*>(this)->actor_wait_state = 4;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 3, Void >*>(static_cast<_finishActor*>(this)));
															#line 327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_4 = done->set(tr, taskBucket);
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when3(__when_expr_4.get(), loopDepth); };
				static_cast<_finishActor*>(this)->actor_wait_state = 5;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 4, Void >*>(static_cast<_finishActor*>(this)));
															#line 341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(key, value);
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _finishActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _finishActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _finishActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _finishActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<Task> task;
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskFuture> done;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Key key;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Key value;
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	std::vector<Reference<TaskFuture>> vectorFuture;
															#line 732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public ActorCallback< _finishActor, 2, Void >, public ActorCallback< _finishActor, 3, Void >, public ActorCallback< _finishActor, 4, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16941228114576319488UL, 1787539023259225088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
friend struct ActorCallback< _finishActor, 2, Void >;
friend struct ActorCallback< _finishActor, 3, Void >;
friend struct ActorCallback< _finishActor, 4, Void >;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _finishActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _finishActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
};
StringRef SayHelloTaskFunc::name = "SayHello"_sr;
REGISTER_TASKFUNC(SayHelloTaskFunc);

struct SayHelloToEveryoneTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class _finishActor1>
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActor1State {
															#line 826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : tr(tr),
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskBucket(taskBucket),
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   futureBucket(futureBucket),
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   task(task)
															#line 839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Reference<TaskFuture> done = futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]);
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			vectorFuture = std::vector<Reference<TaskFuture>>();
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			int subtaskCount = 1;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!task->params["chained"_sr].compare("false"_sr))
															#line 860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				subtaskCount = atoi(task->params["subtaskCount"_sr].toString().c_str());
															#line 864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			for(int i = 0;i < subtaskCount;++i) {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				auto new_task = makeReference<Task>( SayHelloTaskFunc::name, SayHelloTaskFunc::version, StringRef(), deterministicRandom()->randomInt(0, 2));
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["name"_sr] = StringRef(format("task_%d", i));
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["chained"_sr] = task->params["chained"_sr];
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params["subtaskCount"_sr] = task->params["subtaskCount"_sr];
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				Reference<TaskFuture> taskDone = futureBucket->future(tr);
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				new_task->params[Task::reservedTaskParamKeyDone] = taskDone->key;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				taskBucket->addTask(tr, new_task);
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				vectorFuture.push_back(taskDone);
															#line 884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = done->join(tr, taskBucket, vectorFuture);
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, Void >*>(static_cast<_finishActor1*>(this)));
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Key key = StringRef("Hello_" + deterministicRandom()->randomUniqueID().toString());
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Value value = "Hello, Everyone!"_sr;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectnessSayHello").detail("SayHelloToEveryoneTaskFunc", printable(value));
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(key, value);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Key key = StringRef("Hello_" + deterministicRandom()->randomUniqueID().toString());
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Value value = "Hello, Everyone!"_sr;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectnessSayHello").detail("SayHelloToEveryoneTaskFunc", printable(value));
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(key, value);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<Task> task;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	std::vector<Reference<TaskFuture>> vectorFuture;
															#line 1146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, Void >, public ActorCallback< _finishActor1, 1, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 1151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16941228114576319488UL, 1787539023259225088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, Void >;
friend struct ActorCallback< _finishActor1, 1, Void >;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 1202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
};
StringRef SayHelloToEveryoneTaskFunc::name = "SayHelloToEveryone"_sr;
REGISTER_TASKFUNC(SayHelloToEveryoneTaskFunc);

struct SaidHelloTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 1228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class _finishActor2>
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActor2State {
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActor2State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : tr(tr),
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskBucket(taskBucket),
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   futureBucket(futureBucket),
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   task(task)
															#line 1247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor2State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskBucket->finish(tr, task);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor2*>(this)->actor_wait_state = 1;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 0, Void >*>(static_cast<_finishActor2*>(this)));
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Key key = StringRef("Hello_" + deterministicRandom()->randomUniqueID().toString());
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Value value = "Said hello to everyone!"_sr;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectnessSayHello").detail("SaidHelloTaskFunc", printable(value));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(key, value);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_finishActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor2State(); static_cast<_finishActor2*>(this)->destroy(); return 0; }
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Key key = StringRef("Hello_" + deterministicRandom()->randomUniqueID().toString());
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Value value = "Said hello to everyone!"_sr;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectnessSayHello").detail("SaidHelloTaskFunc", printable(value));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(key, value);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_finishActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor2State(); static_cast<_finishActor2*>(this)->destroy(); return 0; }
															#line 1320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor2*>(this)->actor_wait_state > 0) static_cast<_finishActor2*>(this)->actor_wait_state = 0;
		static_cast<_finishActor2*>(this)->ActorCallback< _finishActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<Task> task;
															#line 1411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _finishActor2 final : public Actor<Void>, public ActorCallback< _finishActor2, 0, Void >, public FastAllocated<_finishActor2>, public _finishActor2State<_finishActor2> {
															#line 1416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor2>::operator new;
	using FastAllocated<_finishActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16941228114576319488UL, 1787539023259225088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor2, 0, Void >;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_finishActor2(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActor2State<_finishActor2>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16767394040870899712UL, 11388961073437408512UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor2, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new _finishActor2(tr, taskBucket, futureBucket, task));
															#line 1465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
};
StringRef SaidHelloTaskFunc::name = "SaidHello"_sr;
REGISTER_TASKFUNC(SaidHelloTaskFunc);

// A workload which test the correctness of TaskBucket
struct TaskBucketCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "TaskBucketCorrectness";

	bool chained;
	int subtaskCount;

	TaskBucketCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		chained = getOption(options, "chained"_sr, false);
		subtaskCount = getOption(options, "subtaskCount"_sr, 20);
	}

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override { return _check(cx, this); }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 1491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via addInitTasks()
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class AddInitTasksActor>
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class AddInitTasksActorState {
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	AddInitTasksActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,bool const& chained,int const& subtaskCount) 
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : tr(tr),
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskBucket(taskBucket),
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   futureBucket(futureBucket),
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   chained(chained),
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   subtaskCount(subtaskCount),
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   addedInitKey("addedInitTasks"_sr)
															#line 1514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addInitTasks", reinterpret_cast<unsigned long>(this));

	}
	~AddInitTasksActorState() 
	{
		fdb_probe_actor_destroy("addInitTasks", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = tr->get(addedInitKey);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<AddInitTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddInitTasksActor*>(this)->actor_wait_state = 1;
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<AddInitTasksActor*>(this)));
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddInitTasksActorState();
		static_cast<AddInitTasksActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> const& res,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (res.present())
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<AddInitTasksActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddInitTasksActorState(); static_cast<AddInitTasksActor*>(this)->destroy(); return 0; }
															#line 1563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<AddInitTasksActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AddInitTasksActorState();
			static_cast<AddInitTasksActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(addedInitKey, "true"_sr);
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Reference<TaskFuture> allDone = futureBucket->future(tr);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		auto task = makeReference<Task>(SayHelloToEveryoneTaskFunc::name, SayHelloToEveryoneTaskFunc::version, allDone->key, deterministicRandom()->randomInt(0, 2));
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		task->params["chained"_sr] = chained ? "true"_sr : "false"_sr;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		task->params["subtaskCount"_sr] = StringRef(format("%d", subtaskCount));
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		taskBucket->addTask(tr, task);
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		auto taskDone = makeReference<Task>( SaidHelloTaskFunc::name, SaidHelloTaskFunc::version, StringRef(), deterministicRandom()->randomInt(0, 2));
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = allDone->onSetAddTask(tr, taskBucket, taskDone);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<AddInitTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddInitTasksActor*>(this)->actor_wait_state = 2;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddInitTasksActor, 1, Void >*>(static_cast<AddInitTasksActor*>(this)));
															#line 1592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> && res,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (res.present())
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<AddInitTasksActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddInitTasksActorState(); static_cast<AddInitTasksActor*>(this)->destroy(); return 0; }
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<AddInitTasksActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AddInitTasksActorState();
			static_cast<AddInitTasksActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		tr->set(addedInitKey, "true"_sr);
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		Reference<TaskFuture> allDone = futureBucket->future(tr);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		auto task = makeReference<Task>(SayHelloToEveryoneTaskFunc::name, SayHelloToEveryoneTaskFunc::version, allDone->key, deterministicRandom()->randomInt(0, 2));
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		task->params["chained"_sr] = chained ? "true"_sr : "false"_sr;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		task->params["subtaskCount"_sr] = StringRef(format("%d", subtaskCount));
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		taskBucket->addTask(tr, task);
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		auto taskDone = makeReference<Task>( SaidHelloTaskFunc::name, SaidHelloTaskFunc::version, StringRef(), deterministicRandom()->randomInt(0, 2));
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = allDone->onSetAddTask(tr, taskBucket, taskDone);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<AddInitTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddInitTasksActor*>(this)->actor_wait_state = 2;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddInitTasksActor, 1, Void >*>(static_cast<AddInitTasksActor*>(this)));
															#line 1634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddInitTasksActor*>(this)->actor_wait_state > 0) static_cast<AddInitTasksActor*>(this)->actor_wait_state = 0;
		static_cast<AddInitTasksActor*>(this)->ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<AddInitTasksActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddInitTasksActorState(); static_cast<AddInitTasksActor*>(this)->destroy(); return 0; }
															#line 1718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<AddInitTasksActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddInitTasksActorState();
		static_cast<AddInitTasksActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<AddInitTasksActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddInitTasksActorState(); static_cast<AddInitTasksActor*>(this)->destroy(); return 0; }
															#line 1730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<AddInitTasksActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddInitTasksActorState();
		static_cast<AddInitTasksActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddInitTasksActor*>(this)->actor_wait_state > 0) static_cast<AddInitTasksActor*>(this)->actor_wait_state = 0;
		static_cast<AddInitTasksActor*>(this)->ActorCallback< AddInitTasksActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddInitTasksActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddInitTasksActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddInitTasksActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	bool chained;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	int subtaskCount;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Key addedInitKey;
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addInitTasks()
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class AddInitTasksActor final : public Actor<Void>, public ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >, public ActorCallback< AddInitTasksActor, 1, Void >, public FastAllocated<AddInitTasksActor>, public AddInitTasksActorState<AddInitTasksActor> {
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddInitTasksActor>::operator new;
	using FastAllocated<AddInitTasksActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12720252805751411712UL, 15610914667348339968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< AddInitTasksActor, 1, Void >;
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	AddInitTasksActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,bool const& chained,int const& subtaskCount) 
															#line 1848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AddInitTasksActorState<AddInitTasksActor>(tr, taskBucket, futureBucket, chained, subtaskCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addInitTasks", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16213166417206981632UL, 6351378556067670528UL);
		ActorExecutionContextHelper __helper(static_cast<AddInitTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addInitTasks");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addInitTasks", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddInitTasksActor, 0, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddInitTasksActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] Future<Void> addInitTasks( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, bool const& chained, int const& subtaskCount ) {
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new AddInitTasksActor(tr, taskBucket, futureBucket, chained, subtaskCount));
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"

																#line 1886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class _startActor>
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _startActorState {
															#line 1892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_startActorState(Database const& cx,TaskBucketCorrectnessWorkload* const& self) 
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : cx(cx),
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   self(self),
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskSubspace("backup-agent"_sr),
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   taskBucket(new TaskBucket(taskSubspace.get("tasks"_sr))),
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   futureBucket(new FutureBucket(taskSubspace.get("futures"_sr)))
															#line 1909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				if (self->clientId == 0)
															#line 1925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
					TraceEvent("TaskBucketCorrectness").detail("ClearingDb", "...");
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_0 = taskBucket->clear(cx);
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent(SevError, "TaskBucketCorrectness").error(e);
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 1994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		;
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("AddingTasks", "...");
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) { return self->addInitTasks(tr, taskBucket, futureBucket, self->chained, self->subtaskCount); });
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("AddingTasks", "...");
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) { return self->addInitTasks(tr, taskBucket, futureBucket, self->chained, self->subtaskCount); });
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("RunningTasks", "...");
															#line 2129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("RunningTasks", "...");
															#line 2138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (self->clientId == 0)
															#line 2222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent("TaskBucketCorrectness").detail("NotTasksRemain", "...");
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_9 = TaskBucket::debugPrintRange(cx, StringRef(), StringRef());
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont6when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_2 = taskBucket->doOne(cx, futureBucket);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, bool >*>(static_cast<_startActor*>(this)));
															#line 2264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				TraceEvent(SevWarn, "TaskBucketCorrectness").error(e);
															#line 2303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(bool const& oneTaskDone,int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!oneTaskDone)
															#line 2333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_3 = taskBucket->isEmpty(cx);
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, bool >*>(static_cast<_startActor*>(this)));
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(bool && oneTaskDone,int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!oneTaskDone)
															#line 2358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_3 = taskBucket->isEmpty(cx);
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, bool >*>(static_cast<_startActor*>(this)));
															#line 2369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(bool const& oneTaskDone,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(oneTaskDone, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(bool && oneTaskDone,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(oneTaskDone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(bool const& isEmpty,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (isEmpty)
															#line 2464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(1.0);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1cont4when2(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 2489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(bool && isEmpty,int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (isEmpty)
															#line 2499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(1.0);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1cont4when2(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 2524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(bool const& isEmpty,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(isEmpty, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(bool && isEmpty,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(isEmpty), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = futureBucket->isEmpty(cx);
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, bool >*>(static_cast<_startActor*>(this)));
															#line 2622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = futureBucket->isEmpty(cx);
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, bool >*>(static_cast<_startActor*>(this)));
															#line 2638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont7(int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (isFutureEmpty)
															#line 2722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = TaskBucket::debugPrintRange( cx, taskSubspace.key(), StringRef(format("client_%d", self->clientId)));
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6when1(bool const& __isFutureEmpty,int loopDepth) 
	{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		isFutureEmpty = __isFutureEmpty;
															#line 2747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6when1(bool && __isFutureEmpty,int loopDepth) 
	{
		isFutureEmpty = std::move(__isFutureEmpty);
		loopDepth = a_body1cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("FutureIsNotEmpty", "...");
															#line 2832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		TraceEvent("TaskBucketCorrectness").detail("FutureIsNotEmpty", "...");
															#line 2841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Database cx;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	TaskBucketCorrectnessWorkload* self;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Subspace taskSubspace;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	bool isFutureEmpty;
															#line 3321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, bool >, public ActorCallback< _startActor, 3, bool >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, bool >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2784562316832415488UL, 16930265787566292992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, bool >;
friend struct ActorCallback< _startActor, 3, bool >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, bool >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_startActor(Database const& cx,TaskBucketCorrectnessWorkload* const& self) 
															#line 3353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, TaskBucketCorrectnessWorkload* const& self ) {
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"

																#line 3400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class _checkActor>
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _checkActorState {
															#line 3406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_checkActorState(Database const& cx,TaskBucketCorrectnessWorkload* const& self) 
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : cx(cx),
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   self(self)
															#line 3415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_0 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return self->checkSayHello(tr, self->subtaskCount); });
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, bool >*>(static_cast<_checkActor*>(this)));
															#line 3437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& ret,int loopDepth) 
	{
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && ret,int loopDepth) 
	{
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& ret,int loopDepth) 
	{
		loopDepth = a_body1cont1(ret, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && ret,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(ret), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Database cx;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	TaskBucketCorrectnessWorkload* self;
															#line 3559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, bool >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 3564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13003074633589716736UL, 12021538405634094592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, bool >;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	_checkActor(Database const& cx,TaskBucketCorrectnessWorkload* const& self) 
															#line 3581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, TaskBucketCorrectnessWorkload* const& self ) {
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 3613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"

																#line 3618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via checkSayHello()
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class CheckSayHelloActor>
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class CheckSayHelloActorState {
															#line 3624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	CheckSayHelloActorState(Reference<ReadYourWritesTransaction> const& tr,int const& subTaskCount) 
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : tr(tr),
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   subTaskCount(subTaskCount),
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		   data({ "Hello, Everyone!", "Said hello to everyone!" })
															#line 3635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkSayHello", reinterpret_cast<unsigned long>(this));

	}
	~CheckSayHelloActorState() 
	{
		fdb_probe_actor_destroy("checkSayHello", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			for(int i = 0;i < subTaskCount;i++) {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				data.insert(format("task_%d", i));
															#line 3652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(KeyRangeRef("Hello_\x00"_sr, "Hello_\xff"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (static_cast<CheckSayHelloActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckSayHelloActor*>(this)->actor_wait_state = 1;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckSayHelloActor, 0, RangeResult >*>(static_cast<CheckSayHelloActor*>(this)));
															#line 3663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckSayHelloActorState();
		static_cast<CheckSayHelloActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (values.size() != data.size())
															#line 3686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent(SevError, "CheckSayHello") .detail("CountNotMatchIs", values.size()) .detail("ShouldBe", data.size());
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			for( auto& s : values ) {
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				TraceEvent("CheckSayHello").detail("Item", printable(s)).detail("Value", printable(s.value));
															#line 3694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckSayHelloActorState();
			static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		for( auto& s : values ) {
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			data.erase(s.value.toString());
															#line 3708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		}
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (data.size() != 0)
															#line 3712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent(SevError, "CheckSayHello").detail("DataNotMatch", data.size());
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckSayHelloActorState();
			static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckSayHelloActorState();
		static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (values.size() != data.size())
															#line 3738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent(SevError, "CheckSayHello") .detail("CountNotMatchIs", values.size()) .detail("ShouldBe", data.size());
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			for( auto& s : values ) {
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
				TraceEvent("CheckSayHello").detail("Item", printable(s)).detail("Value", printable(s.value));
															#line 3746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckSayHelloActorState();
			static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		for( auto& s : values ) {
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			data.erase(s.value.toString());
															#line 3760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		}
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (data.size() != 0)
															#line 3764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		{
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			TraceEvent(SevError, "CheckSayHello").detail("DataNotMatch", data.size());
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckSayHelloActorState();
			static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		if (!static_cast<CheckSayHelloActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckSayHelloActorState(); static_cast<CheckSayHelloActor*>(this)->destroy(); return 0; }
															#line 3778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<CheckSayHelloActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckSayHelloActorState();
		static_cast<CheckSayHelloActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckSayHelloActor*>(this)->actor_wait_state > 0) static_cast<CheckSayHelloActor*>(this)->actor_wait_state = 0;
		static_cast<CheckSayHelloActor*>(this)->ActorCallback< CheckSayHelloActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckSayHelloActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkSayHello", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSayHelloActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSayHello", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckSayHelloActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkSayHello", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSayHelloActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSayHello", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckSayHelloActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkSayHello", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSayHelloActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSayHello", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	int subTaskCount;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	std::set<std::string> data;
															#line 3867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkSayHello()
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class CheckSayHelloActor final : public Actor<bool>, public ActorCallback< CheckSayHelloActor, 0, RangeResult >, public FastAllocated<CheckSayHelloActor>, public CheckSayHelloActorState<CheckSayHelloActor> {
															#line 3872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckSayHelloActor>::operator new;
	using FastAllocated<CheckSayHelloActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13923350127896134912UL, 13771545954237322240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckSayHelloActor, 0, RangeResult >;
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	CheckSayHelloActor(Reference<ReadYourWritesTransaction> const& tr,int const& subTaskCount) 
															#line 3889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckSayHelloActorState<CheckSayHelloActor>(tr, subTaskCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkSayHello", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1461363064300179200UL, 14960542804036945920UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSayHelloActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkSayHello");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkSayHello", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckSayHelloActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
[[nodiscard]] Future<bool> checkSayHello( Reference<ReadYourWritesTransaction> const& tr, int const& subTaskCount ) {
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<bool>(new CheckSayHelloActor(tr, subTaskCount));
															#line 3921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}

#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
};

WorkloadFactory<TaskBucketCorrectnessWorkload> TaskBucketCorrectnessWorkloadFactory;

void print_subspace_key(const Subspace& subspace, int id) {
	printf("%d==========%s===%d\n", id, printable(StringRef(subspace.key())).c_str(), subspace.key().size());
}

															#line 3933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase347()
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
template <class FlowTestCase347Actor>
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class FlowTestCase347ActorState {
															#line 3940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	FlowTestCase347ActorState(UnitTestParameters const& params) 
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
		 : params(params)
															#line 3947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase347", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase347ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase347", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test, 0);
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test.key().toString() == "");
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test1("abc"_sr);
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test1, 1);
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test1.key() == "abc"_sr);
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Tuple t = Tuple::makeTuple("user"_sr);
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test2(t);
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test2, 2);
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test2.key() == "\x01user\x00"_sr);
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test3(t, "abc"_sr);
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test3, 3);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test3.key() == "abc\x01user\x00"_sr);
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Tuple t1 = Tuple::makeTuple(1);
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test4(t1);
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test4, 4);
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test4.key() == "\x15\x01"_sr);
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			t.append(123);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test5(t, "abc"_sr);
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test5, 5);
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.key() == "abc\x01user\x00\x15\x7b"_sr);
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 6, printable(subspace_test5.pack(t)).c_str(), subspace_test5.pack(t).size());
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t) == "abc\x01user\x00\x15\x7b\x01user\x00\x15\x7b"_sr);
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 7, printable(subspace_test5.pack(t1)).c_str(), subspace_test5.pack(t1).size());
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t1) == "abc\x01user\x00\x15\x7b\x15\x01"_sr);
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test6(t);
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test7 = subspace_test6.get("subitem"_sr);
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test7, 8);
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test7.key() == "\x01user\x00\x15\x7b\x01subitem\x00"_sr);
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Tuple t2 = subspace_test6.unpack(subspace_test7.key());
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Subspace subspace_test8(t2);
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			print_subspace_key(subspace_test8, 9);
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test8.key() == "\x01subitem\x00"_sr);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			Tuple t3 = Tuple::makeTuple(""_sr);
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 10, printable(subspace_test5.pack(t3)).c_str(), subspace_test5.pack(t3).size());
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t3) == subspace_test5.pack(StringRef()));
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t3) == "abc\x01user\x00\x15\x7b\x01\x00"_sr);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 11, printable(subspace_test5.range(t3).begin).c_str(), subspace_test5.range(t3).begin.size());
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.range(t3).begin == subspace_test5.get(StringRef()).range().begin);
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 12, printable(subspace_test5.range(t3).end).c_str(), subspace_test5.range(t3).end.size());
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.range(t3).end == subspace_test5.get(StringRef()).range().end);
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StringRef def = "def"_sr;
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			StringRef ghi = "ghi"_sr;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			t3.append(def);
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			t3.append(ghi);
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 13, printable(subspace_test5.pack(t3)).c_str(), subspace_test5.pack(t3).size());
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t3) == subspace_test5.get(StringRef()).get(def).pack(ghi));
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.pack(t3) == "abc\x01user\x00\x15\x7b\x01\x00\x01" "def\x00\x01ghi\x00"_sr);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 14, printable(subspace_test5.range(t3).begin).c_str(), subspace_test5.range(t3).begin.size());
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.range(t3).begin == subspace_test5.get(StringRef()).get(def).get(ghi).range().begin);
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			printf("%d==========%s===%d\n", 15, printable(subspace_test5.range(t3).end).c_str(), subspace_test5.range(t3).end.size());
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			ASSERT(subspace_test5.range(t3).end == subspace_test5.get(StringRef()).get(def).get(ghi).range().end);
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
			if (!static_cast<FlowTestCase347Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase347ActorState(); static_cast<FlowTestCase347Actor*>(this)->destroy(); return 0; }
															#line 4066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase347Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase347ActorState();
			static_cast<FlowTestCase347Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase347ActorState();
		static_cast<FlowTestCase347Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	UnitTestParameters params;
															#line 4090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase347()
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
class FlowTestCase347Actor final : public Actor<Void>, public FastAllocated<FlowTestCase347Actor>, public FlowTestCase347ActorState<FlowTestCase347Actor> {
															#line 4095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase347Actor>::operator new;
	using FastAllocated<FlowTestCase347Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1716864771675249920UL, 6353879930912520448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	FlowTestCase347Actor(UnitTestParameters const& params) 
															#line 4111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase347ActorState<FlowTestCase347Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase347", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11371790371359773696UL, 15289892684144242432UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase347Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase347");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase347", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
static Future<Void> flowTestCase347( UnitTestParameters const& params ) {
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
	return Future<Void>(new FlowTestCase347Actor(params));
															#line 4143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TaskBucketCorrectness.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase347, "/fdbclient/TaskBucket/Subspace")

#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/TaskBucketCorrectness.actor.cpp"
