#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
/*
 * TargetedKill.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/MasterInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct TargetedKillWorkload : TestWorkload {
	static constexpr auto NAME = "TargetedKill";

	std::string machineToKill;
	bool enabled, killAllMachineProcesses;
	int numKillStorages;
	double killAt;
	bool reboot;
	double suspendDuration;

	TargetedKillWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		killAt = getOption(options, "killAt"_sr, 5.0);
		reboot = getOption(options, "reboot"_sr, false);
		suspendDuration = getOption(options, "suspendDuration"_sr, 1.0);
		machineToKill = getOption(options, "machineToKill"_sr, "master"_sr).toString();
		killAllMachineProcesses = getOption(options, "killWholeMachine"_sr, false);
		numKillStorages = getOption(options, "numKillStorages"_sr, 1);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (enabled)
			return assassin(cx, this);
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	Future<Void> killEndpoint(std::vector<WorkerDetails> workers,
	                          NetworkAddress address,
	                          Database cx,
	                          TargetedKillWorkload* self) {
		if (g_simulator == g_network) {
			g_simulator->killInterface(address, ISimulator::KillType::KillInstantly);
			return Void();
		}

		int killed = 0;
		RebootRequest rbReq;
		if (self->reboot) {
			rbReq.waitForDuration = self->suspendDuration;
		} else {
			rbReq.waitForDuration = std::numeric_limits<uint32_t>::max();
		}
		for (int i = 0; i < workers.size(); i++) {
			if (workers[i].interf.master.getEndpoint().getPrimaryAddress() == address ||
			    (self->killAllMachineProcesses &&
			     workers[i].interf.master.getEndpoint().getPrimaryAddress().ip == address.ip &&
			     workers[i].processClass != ProcessClass::TesterClass)) {
				TraceEvent("WorkerKill").detail("TargetedMachine", address).detail("Worker", workers[i].interf.id());
				workers[i].interf.clientInterface.reboot.send(rbReq);
				killed++;
			}
		}

		if (!killed)
			TraceEvent(SevWarn, "WorkerNotFoundAtEndpoint").detail("Address", address);
		else
			TraceEvent("WorkersKilledAtEndpoint").detail("Address", address).detail("KilledProcesses", killed);

		return Void();
	}

																#line 98 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
// This generated class is to be used only via assassin()
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
template <class AssassinActor>
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
class AssassinActorState {
															#line 104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
public:
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	AssassinActorState(Database const& cx,TargetedKillWorkload* const& self) 
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		 : cx(cx),
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		   self(self)
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("assassin", reinterpret_cast<unsigned long>(this));

	}
	~AssassinActorState() 
	{
		fdb_probe_actor_destroy("assassin", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->killAt);
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AssassinActor*>(this)->actor_wait_state = 1;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 0, Void >*>(static_cast<AssassinActor*>(this)));
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssassinActorState();
		static_cast<AssassinActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AssassinActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*>(static_cast<AssassinActor*>(this)));
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AssassinActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*>(static_cast<AssassinActor*>(this)));
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssassinActor*>(this)->actor_wait_state > 0) static_cast<AssassinActor*>(this)->actor_wait_state = 0;
		static_cast<AssassinActor*>(this)->ActorCallback< AssassinActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssassinActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssassinActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssassinActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_2 = getWorkers(self->dbInfo);
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AssassinActor*>(this)->actor_wait_state = 3;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >*>(static_cast<AssassinActor*>(this)));
															#line 272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		storageServers = __storageServers;
															#line 281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AssassinActor*>(this)->actor_wait_state > 0) static_cast<AssassinActor*>(this)->actor_wait_state = 0;
		static_cast<AssassinActor*>(this)->ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		machine = NetworkAddress();
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		ccAddr = NetworkAddress();
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		killed = 0;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		s = 0;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		j = 0;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (self->machineToKill == "master")
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			machine = self->dbInfo->get().master.address();
															#line 374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			loopDepth = a_body1cont4(loopDepth);
		}
		else
		{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			if (self->machineToKill == "commitproxy")
															#line 381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
				auto commitProxies = cx->getCommitProxies(UseProvisionalProxies::False);
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
				int o = deterministicRandom()->randomInt(0, commitProxies->size());
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
				for(int i = 0;i < commitProxies->size();i++) {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					CommitProxyInterface mpi = commitProxies->getInterface(o);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					machine = mpi.address();
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					if (machine != self->dbInfo->get().clusterInterface.getWorkers.getEndpoint().getPrimaryAddress())
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					o = ++o % commitProxies->size();
															#line 401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1cont6(loopDepth);
			}
			else
			{
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
				if (self->machineToKill == "grvproxy")
															#line 409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
				{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					auto grvProxies = cx->getGrvProxies(UseProvisionalProxies::False);
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					int o = deterministicRandom()->randomInt(0, grvProxies->size());
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					for(int i = 0;i < grvProxies->size();i++) {
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						GrvProxyInterface gpi = grvProxies->getInterface(o);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						machine = gpi.address();
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						if (machine != self->dbInfo->get().clusterInterface.getWorkers.getEndpoint().getPrimaryAddress())
															#line 423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
						{
							break;
						}
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						o = ++o % grvProxies->size();
															#line 429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
					}
					loopDepth = a_body1cont10(loopDepth);
				}
				else
				{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
					if (self->machineToKill == "tlog")
															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
					{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						auto tlogs = self->dbInfo->get().logSystemConfig.allPresentLogs();
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						int o = deterministicRandom()->randomInt(0, tlogs.size());
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						for(int i = 0;i < tlogs.size();i++) {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							TLogInterface tli = tlogs[o];
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							machine = tli.address();
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							if (machine != self->dbInfo->get().clusterInterface.getWorkers.getEndpoint().getPrimaryAddress())
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
							{
								break;
							}
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							o = ++o % tlogs.size();
															#line 457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
						}
						loopDepth = a_body1cont14(loopDepth);
					}
					else
					{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
						if (self->machineToKill == "storage" || self->machineToKill == "ss" || self->machineToKill == "storageserver")
															#line 465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
						{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							s = deterministicRandom()->randomInt(0, storageServers.size());
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							ccAddr = self->dbInfo->get().clusterInterface.getWorkers.getEndpoint().getPrimaryAddress();
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							j = 0;
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
							loopDepth = a_body1cont3loopHead1(loopDepth);
						}
						else
						{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
							if (self->machineToKill == "clustercontroller" || self->machineToKill == "cc")
															#line 480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
							{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
								machine = self->dbInfo->get().clusterInterface.getWorkers.getEndpoint().getPrimaryAddress();
															#line 484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
							}
							loopDepth = a_body1cont18(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		workers = __workers;
															#line 499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AssassinActor*>(this)->actor_wait_state > 0) static_cast<AssassinActor*>(this)->actor_wait_state = 0;
		static_cast<AssassinActor*>(this)->ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		TraceEvent("IsolatedMark").detail("TargetedMachine", machine).detail("Role", self->machineToKill);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->killEndpoint(workers, machine, cx, self);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<AssassinActor*>(this)->actor_wait_state = 5;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 4, Void >*>(static_cast<AssassinActor*>(this)));
															#line 587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (!(j < storageServers.size()))
															#line 633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		StorageServerInterface ssi = storageServers[s];
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		machine = ssi.address();
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (machine != ccAddr)
															#line 643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			TraceEvent("IsolatedMark").detail("TargetedMachine", machine).detail("Role", self->machineToKill);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->killEndpoint(workers, machine, cx, self);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			if (static_cast<AssassinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<AssassinActor*>(this)->actor_wait_state = 4;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AssassinActor, 3, Void >*>(static_cast<AssassinActor*>(this)));
															#line 656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont19(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		s = ++s % storageServers.size();
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		j++;
															#line 685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		killed++;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (killed == self->numKillStorages)
															#line 696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			if (!static_cast<AssassinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssassinActorState(); static_cast<AssassinActor*>(this)->destroy(); return 0; }
															#line 700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			new (&static_cast<AssassinActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AssassinActorState();
			static_cast<AssassinActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		killed++;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (killed == self->numKillStorages)
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
			if (!static_cast<AssassinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssassinActorState(); static_cast<AssassinActor*>(this)->destroy(); return 0; }
															#line 720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
			new (&static_cast<AssassinActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AssassinActorState();
			static_cast<AssassinActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AssassinActor*>(this)->actor_wait_state > 0) static_cast<AssassinActor*>(this)->actor_wait_state = 0;
		static_cast<AssassinActor*>(this)->ActorCallback< AssassinActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssassinActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AssassinActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AssassinActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont22(Void const& _,int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (!static_cast<AssassinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssassinActorState(); static_cast<AssassinActor*>(this)->destroy(); return 0; }
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		new (&static_cast<AssassinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssassinActorState();
		static_cast<AssassinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont22(Void && _,int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
		if (!static_cast<AssassinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssassinActorState(); static_cast<AssassinActor*>(this)->destroy(); return 0; }
															#line 821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		new (&static_cast<AssassinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssassinActorState();
		static_cast<AssassinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AssassinActor*>(this)->actor_wait_state > 0) static_cast<AssassinActor*>(this)->actor_wait_state = 0;
		static_cast<AssassinActor*>(this)->ActorCallback< AssassinActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssassinActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AssassinActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AssassinActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	Database cx;
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	TargetedKillWorkload* self;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	NetworkAddress machine;
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	NetworkAddress ccAddr;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	int killed;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	int s;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	int j;
															#line 922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
};
// This generated class is to be used only via assassin()
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
class AssassinActor final : public Actor<Void>, public ActorCallback< AssassinActor, 0, Void >, public ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >, public ActorCallback< AssassinActor, 3, Void >, public ActorCallback< AssassinActor, 4, Void >, public FastAllocated<AssassinActor>, public AssassinActorState<AssassinActor> {
															#line 927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
public:
	using FastAllocated<AssassinActor>::operator new;
	using FastAllocated<AssassinActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11379021629946374400UL, 16789456823599842048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssassinActor, 0, Void >;
friend struct ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >;
friend struct ActorCallback< AssassinActor, 3, Void >;
friend struct ActorCallback< AssassinActor, 4, Void >;
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	AssassinActor(Database const& cx,TargetedKillWorkload* const& self) 
															#line 948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AssassinActorState<AssassinActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assassin", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9815277529619797504UL, 6414346882375420416UL);
		ActorExecutionContextHelper __helper(static_cast<AssassinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assassin");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assassin", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssassinActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AssassinActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AssassinActor, 2, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AssassinActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AssassinActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
[[nodiscard]] Future<Void> assassin( Database const& cx, TargetedKillWorkload* const& self ) {
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
	return Future<Void>(new AssassinActor(cx, self));
															#line 984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TargetedKill.actor.g.cpp.py_gen"
}

#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/TargetedKill.actor.cpp"
};

WorkloadFactory<TargetedKillWorkload> TargetedKillWorkloadFactory;
