#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
/*
 * TagThrottle.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TagThrottle.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct TagThrottleApiWorkload : TestWorkload {
	bool autoThrottleEnabled;
	double testDuration;

	constexpr static auto NAME = "TagThrottleApi";

	TagThrottleApiWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		autoThrottleEnabled = SERVER_KNOBS->AUTO_TAG_THROTTLING_ENABLED;
	}

	Future<Void> setup(Database const& cx) override {
		DatabaseContext::debugUseTags = true;
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (SERVER_KNOBS->GLOBAL_TAG_THROTTLING || this->clientId != 0)
			return Void();
		return timeout(runThrottleApi(this, cx), testDuration, Void());
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	static Optional<TagThrottleType> randomTagThrottleType() {
		Optional<TagThrottleType> throttleType;
		switch (deterministicRandom()->randomInt(0, 3)) {
		case 0:
			throttleType = TagThrottleType::AUTO;
			break;
		case 1:
			throttleType = TagThrottleType::MANUAL;
			break;
		default:
			break;
		}

		return throttleType;
	}

																#line 73 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via throttleTag()
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class ThrottleTagActor>
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class ThrottleTagActorState {
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	ThrottleTagActorState(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : cx(cx),
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   manuallyThrottledTags(manuallyThrottledTags),
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   tag(TransactionTagRef(deterministicRandom()->randomChoice(DatabaseContext::debugTransactionTagChoices))),
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   priority(deterministicRandom()->randomChoice(allTransactionPriorities)),
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   rate(deterministicRandom()->random01() * 20),
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   duration(1 + deterministicRandom()->random01() * 19)
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("throttleTag", reinterpret_cast<unsigned long>(this));

	}
	~ThrottleTagActorState() 
	{
		fdb_probe_actor_destroy("throttleTag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			TagSet tagSet;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			tagSet.addTag(tag);
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			try {
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ThrottleApi::throttleTags(cx.getReference(), tagSet, rate, duration, TagThrottleType::MANUAL, priority, Optional<double>(), TagThrottledReason::MANUAL);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (static_cast<ThrottleTagActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ThrottleTagActor*>(this)->actor_wait_state = 1;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThrottleTagActor, 0, Void >*>(static_cast<ThrottleTagActor*>(this)));
															#line 124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThrottleTagActorState();
		static_cast<ThrottleTagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		manuallyThrottledTags->insert_or_assign( std::make_pair(tag, priority), TagThrottleInfo( tag, TagThrottleType::MANUAL, priority, rate, now() + duration, duration, TagThrottledReason::MANUAL));
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<ThrottleTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ThrottleTagActorState(); static_cast<ThrottleTagActor*>(this)->destroy(); return 0; }
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<ThrottleTagActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ThrottleTagActorState();
		static_cast<ThrottleTagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			err = e;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (e.code() == error_code_too_many_tag_throttles)
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT(manuallyThrottledTags->size() >= SERVER_KNOBS->MAX_MANUAL_THROTTLED_TRANSACTION_TAGS);
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (!static_cast<ThrottleTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ThrottleTagActorState(); static_cast<ThrottleTagActor*>(this)->destroy(); return 0; }
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				new (&static_cast<ThrottleTagActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ThrottleTagActorState();
				static_cast<ThrottleTagActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThrottleTagActor*>(this)->actor_wait_state > 0) static_cast<ThrottleTagActor*>(this)->actor_wait_state = 0;
		static_cast<ThrottleTagActor*>(this)->ActorCallback< ThrottleTagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThrottleTagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throttleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThrottleTagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throttleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThrottleTagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throttleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throttleTag", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* manuallyThrottledTags;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TransactionTag tag;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TransactionPriority priority;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	double rate;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	double duration;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Error err;
															#line 308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via throttleTag()
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class ThrottleTagActor final : public Actor<Void>, public ActorCallback< ThrottleTagActor, 0, Void >, public FastAllocated<ThrottleTagActor>, public ThrottleTagActorState<ThrottleTagActor> {
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<ThrottleTagActor>::operator new;
	using FastAllocated<ThrottleTagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1077672100261699584UL, 15338627918441267200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThrottleTagActor, 0, Void >;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	ThrottleTagActor(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ThrottleTagActorState<ThrottleTagActor>(cx, manuallyThrottledTags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throttleTag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7289814371064061440UL, 2327613492987618560UL);
		ActorExecutionContextHelper __helper(static_cast<ThrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throttleTag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throttleTag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThrottleTagActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> throttleTag( Database const& cx, std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags ) {
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new ThrottleTagActor(cx, manuallyThrottledTags));
															#line 362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via unthrottleTag()
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class UnthrottleTagActor>
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class UnthrottleTagActorState {
															#line 373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	UnthrottleTagActorState(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : cx(cx),
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   manuallyThrottledTags(manuallyThrottledTags),
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   tag(TransactionTagRef(deterministicRandom()->randomChoice(DatabaseContext::debugTransactionTagChoices)))
															#line 384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("unthrottleTag", reinterpret_cast<unsigned long>(this));

	}
	~UnthrottleTagActorState() 
	{
		fdb_probe_actor_destroy("unthrottleTag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			TagSet tagSet;
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			tagSet.addTag(tag);
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			throttleType = TagThrottleApiWorkload::randomTagThrottleType();
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			Optional<TransactionPriority> priority = deterministicRandom()->coinflip() ? Optional<TransactionPriority>() : deterministicRandom()->randomChoice(allTransactionPriorities);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			erased = false;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			maxExpiration = 0;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (!throttleType.present() || throttleType.get() == TagThrottleType::MANUAL)
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				for( auto p : allTransactionPriorities ) {
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (!priority.present() || priority.get() == p)
															#line 417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						auto itr = manuallyThrottledTags->find(std::make_pair(tag, p));
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						if (itr != manuallyThrottledTags->end())
															#line 423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							maxExpiration = std::max(maxExpiration, itr->second.expirationTime);
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							erased = true;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							manuallyThrottledTags->erase(itr);
															#line 431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						}
					}
				}
			}
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<bool> __when_expr_0 = ThrottleApi::unthrottleTags(cx.getReference(), tagSet, throttleType, priority);
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<UnthrottleTagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnthrottleTagActor*>(this)->actor_wait_state = 1;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnthrottleTagActor, 0, bool >*>(static_cast<UnthrottleTagActor*>(this)));
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnthrottleTagActorState();
		static_cast<UnthrottleTagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& removed,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (removed)
															#line 468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(erased || !throttleType.present() || throttleType.get() == TagThrottleType::AUTO);
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
		else
		{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(maxExpiration < now());
															#line 478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<UnthrottleTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnthrottleTagActorState(); static_cast<UnthrottleTagActor*>(this)->destroy(); return 0; }
															#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<UnthrottleTagActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnthrottleTagActorState();
		static_cast<UnthrottleTagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && removed,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (removed)
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(erased || !throttleType.present() || throttleType.get() == TagThrottleType::AUTO);
															#line 498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
		else
		{
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(maxExpiration < now());
															#line 504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<UnthrottleTagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnthrottleTagActorState(); static_cast<UnthrottleTagActor*>(this)->destroy(); return 0; }
															#line 508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<UnthrottleTagActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnthrottleTagActorState();
		static_cast<UnthrottleTagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& removed,int loopDepth) 
	{
		loopDepth = a_body1cont1(removed, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && removed,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(removed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnthrottleTagActor*>(this)->actor_wait_state > 0) static_cast<UnthrottleTagActor*>(this)->actor_wait_state = 0;
		static_cast<UnthrottleTagActor*>(this)->ActorCallback< UnthrottleTagActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< UnthrottleTagActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnthrottleTagActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnthrottleTagActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* manuallyThrottledTags;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TransactionTag tag;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Optional<TagThrottleType> throttleType;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	bool erased;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	double maxExpiration;
															#line 603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via unthrottleTag()
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class UnthrottleTagActor final : public Actor<Void>, public ActorCallback< UnthrottleTagActor, 0, bool >, public FastAllocated<UnthrottleTagActor>, public UnthrottleTagActorState<UnthrottleTagActor> {
															#line 608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<UnthrottleTagActor>::operator new;
	using FastAllocated<UnthrottleTagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5621446530731956736UL, 6442734190813257984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnthrottleTagActor, 0, bool >;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	UnthrottleTagActor(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UnthrottleTagActorState<UnthrottleTagActor>(cx, manuallyThrottledTags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unthrottleTag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8362077282007864064UL, 6918700573697231872UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unthrottleTag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unthrottleTag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnthrottleTagActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> unthrottleTag( Database const& cx, std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags ) {
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new UnthrottleTagActor(cx, manuallyThrottledTags));
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via getTags()
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class GetTagsActor>
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class GetTagsActorState {
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	GetTagsActorState(TagThrottleApiWorkload* const& self,Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo> const* const& manuallyThrottledTags) 
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : self(self),
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   cx(cx),
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   manuallyThrottledTags(manuallyThrottledTags)
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTags", reinterpret_cast<unsigned long>(this));

	}
	~GetTagsActorState() 
	{
		fdb_probe_actor_destroy("getTags", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<std::vector<TagThrottleInfo>> __when_expr_0 = ThrottleApi::getThrottledTags(cx.getReference(), CLIENT_KNOBS->TOO_MANY);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<GetTagsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTagsActor*>(this)->actor_wait_state = 1;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >*>(static_cast<GetTagsActor*>(this)));
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTagsActorState();
		static_cast<GetTagsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TagThrottleInfo> const& tags,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int manualThrottledTags = 0;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int activeAutoThrottledTags = 0;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : tags ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (tag.throttleType == TagThrottleType::AUTO)
															#line 730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT(self->autoThrottleEnabled);
															#line 734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
			else
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (tag.throttleType == TagThrottleType::MANUAL)
															#line 740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					ASSERT(manuallyThrottledTags->find(std::make_pair(tag.tag, tag.priority)) != manuallyThrottledTags->end());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					++manualThrottledTags;
															#line 746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
				else
				{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (tag.expirationTime > now())
															#line 752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						++activeAutoThrottledTags;
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(manualThrottledTags <= SERVER_KNOBS->MAX_MANUAL_THROTTLED_TRANSACTION_TAGS);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(activeAutoThrottledTags <= SERVER_KNOBS->MAX_AUTO_THROTTLED_TRANSACTION_TAGS);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int minManualThrottledTags = 0;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int maxManualThrottledTags = 0;
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : *manuallyThrottledTags ) {
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (tag.second.expirationTime > now())
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				++minManualThrottledTags;
															#line 777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			++maxManualThrottledTags;
															#line 781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(manualThrottledTags >= minManualThrottledTags && manualThrottledTags <= maxManualThrottledTags);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<GetTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTagsActorState(); static_cast<GetTagsActor*>(this)->destroy(); return 0; }
															#line 787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<GetTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTagsActorState();
		static_cast<GetTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TagThrottleInfo> && tags,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int manualThrottledTags = 0;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int activeAutoThrottledTags = 0;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : tags ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (tag.throttleType == TagThrottleType::AUTO)
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT(self->autoThrottleEnabled);
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
			else
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (tag.throttleType == TagThrottleType::MANUAL)
															#line 815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					ASSERT(manuallyThrottledTags->find(std::make_pair(tag.tag, tag.priority)) != manuallyThrottledTags->end());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					++manualThrottledTags;
															#line 821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
				else
				{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (tag.expirationTime > now())
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						++activeAutoThrottledTags;
															#line 831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(manualThrottledTags <= SERVER_KNOBS->MAX_MANUAL_THROTTLED_TRANSACTION_TAGS);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(activeAutoThrottledTags <= SERVER_KNOBS->MAX_AUTO_THROTTLED_TRANSACTION_TAGS);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int minManualThrottledTags = 0;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		int maxManualThrottledTags = 0;
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : *manuallyThrottledTags ) {
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (tag.second.expirationTime > now())
															#line 848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				++minManualThrottledTags;
															#line 852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			++maxManualThrottledTags;
															#line 856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		ASSERT(manualThrottledTags >= minManualThrottledTags && manualThrottledTags <= maxManualThrottledTags);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<GetTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTagsActorState(); static_cast<GetTagsActor*>(this)->destroy(); return 0; }
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<GetTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTagsActorState();
		static_cast<GetTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TagThrottleInfo> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TagThrottleInfo> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTagsActor*>(this)->actor_wait_state > 0) static_cast<GetTagsActor*>(this)->actor_wait_state = 0;
		static_cast<GetTagsActor*>(this)->ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >*,std::vector<TagThrottleInfo> const& value) 
	{
		fdb_probe_actor_enter("getTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >*,std::vector<TagThrottleInfo> && value) 
	{
		fdb_probe_actor_enter("getTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTags", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TagThrottleApiWorkload* self;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo> const* manuallyThrottledTags;
															#line 951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTags()
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class GetTagsActor final : public Actor<Void>, public ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >, public FastAllocated<GetTagsActor>, public GetTagsActorState<GetTagsActor> {
															#line 956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTagsActor>::operator new;
	using FastAllocated<GetTagsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11410705130560038656UL, 655498028211943168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	GetTagsActor(TagThrottleApiWorkload* const& self,Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo> const* const& manuallyThrottledTags) 
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetTagsActorState<GetTagsActor>(self, cx, manuallyThrottledTags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTags", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6249674245637647872UL, 18181639423417900800UL);
		ActorExecutionContextHelper __helper(static_cast<GetTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTags");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTags", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTagsActor, 0, std::vector<TagThrottleInfo> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> getTags( TagThrottleApiWorkload* const& self, Database const& cx, std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo> const* const& manuallyThrottledTags ) {
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new GetTagsActor(self, cx, manuallyThrottledTags));
															#line 1005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 1010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via getRecommendedTags()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class GetRecommendedTagsActor>
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class GetRecommendedTagsActorState {
															#line 1016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	GetRecommendedTagsActorState(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : self(self),
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   cx(cx)
															#line 1025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRecommendedTags", reinterpret_cast<unsigned long>(this));

	}
	~GetRecommendedTagsActorState() 
	{
		fdb_probe_actor_destroy("getRecommendedTags", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<std::vector<TagThrottleInfo>> __when_expr_0 = ThrottleApi::getRecommendedTags(cx.getReference(), CLIENT_KNOBS->TOO_MANY);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<GetRecommendedTagsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRecommendedTagsActor*>(this)->actor_wait_state = 1;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >*>(static_cast<GetRecommendedTagsActor*>(this)));
															#line 1047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRecommendedTagsActorState();
		static_cast<GetRecommendedTagsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TagThrottleInfo> const& tags,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : tags ) {
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(tag.throttleType == TagThrottleType::AUTO);
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<GetRecommendedTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRecommendedTagsActorState(); static_cast<GetRecommendedTagsActor*>(this)->destroy(); return 0; }
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<GetRecommendedTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRecommendedTagsActorState();
		static_cast<GetRecommendedTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TagThrottleInfo> && tags,int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		for( auto& tag : tags ) {
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			ASSERT(tag.throttleType == TagThrottleType::AUTO);
															#line 1090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		}
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<GetRecommendedTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRecommendedTagsActorState(); static_cast<GetRecommendedTagsActor*>(this)->destroy(); return 0; }
															#line 1094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<GetRecommendedTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRecommendedTagsActorState();
		static_cast<GetRecommendedTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TagThrottleInfo> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TagThrottleInfo> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRecommendedTagsActor*>(this)->actor_wait_state > 0) static_cast<GetRecommendedTagsActor*>(this)->actor_wait_state = 0;
		static_cast<GetRecommendedTagsActor*>(this)->ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >*,std::vector<TagThrottleInfo> const& value) 
	{
		fdb_probe_actor_enter("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRecommendedTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >*,std::vector<TagThrottleInfo> && value) 
	{
		fdb_probe_actor_enter("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRecommendedTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRecommendedTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRecommendedTags", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TagThrottleApiWorkload* self;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 1181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRecommendedTags()
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class GetRecommendedTagsActor final : public Actor<Void>, public ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >, public FastAllocated<GetRecommendedTagsActor>, public GetRecommendedTagsActorState<GetRecommendedTagsActor> {
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRecommendedTagsActor>::operator new;
	using FastAllocated<GetRecommendedTagsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5644984278682181888UL, 18203755510264250368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	GetRecommendedTagsActor(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 1203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetRecommendedTagsActorState<GetRecommendedTagsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRecommendedTags", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12239974780417389056UL, 14839766086862942976UL);
		ActorExecutionContextHelper __helper(static_cast<GetRecommendedTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRecommendedTags");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRecommendedTags", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRecommendedTagsActor, 0, std::vector<TagThrottleInfo> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> getRecommendedTags( TagThrottleApiWorkload* const& self, Database const& cx ) {
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new GetRecommendedTagsActor(self, cx));
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via unthrottleTagGroup()
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class UnthrottleTagGroupActor>
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class UnthrottleTagGroupActorState {
															#line 1246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	UnthrottleTagGroupActorState(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : cx(cx),
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   manuallyThrottledTags(manuallyThrottledTags),
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   throttleType(TagThrottleApiWorkload::randomTagThrottleType()),
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   priority(deterministicRandom()->coinflip() ? Optional<TransactionPriority>() : deterministicRandom()->randomChoice(allTransactionPriorities))
															#line 1259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("unthrottleTagGroup", reinterpret_cast<unsigned long>(this));

	}
	~UnthrottleTagGroupActorState() 
	{
		fdb_probe_actor_destroy("unthrottleTagGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<bool> __when_expr_0 = ThrottleApi::unthrottleAll(cx.getReference(), throttleType, priority);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<UnthrottleTagGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnthrottleTagGroupActor*>(this)->actor_wait_state = 1;
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnthrottleTagGroupActor, 0, bool >*>(static_cast<UnthrottleTagGroupActor*>(this)));
															#line 1281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnthrottleTagGroupActorState();
		static_cast<UnthrottleTagGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& unthrottled,int loopDepth) 
	{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!throttleType.present() || throttleType.get() == TagThrottleType::MANUAL)
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			bool unthrottleExpected = false;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			bool empty = manuallyThrottledTags->empty();
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			for(auto itr = manuallyThrottledTags->begin();itr != manuallyThrottledTags->end();) {
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (!priority.present() || priority.get() == itr->first.second)
															#line 1314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (itr->second.expirationTime > now())
															#line 1318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						unthrottleExpected = true;
															#line 1322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					}
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					itr = manuallyThrottledTags->erase(itr);
															#line 1326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
				else
				{
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					++itr;
															#line 1332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
			}
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (throttleType.present())
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT((unthrottled && !empty) || (!unthrottled && !unthrottleExpected));
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
			else
			{
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT(unthrottled || !unthrottleExpected);
															#line 1347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
		}
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<UnthrottleTagGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnthrottleTagGroupActorState(); static_cast<UnthrottleTagGroupActor*>(this)->destroy(); return 0; }
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<UnthrottleTagGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnthrottleTagGroupActorState();
		static_cast<UnthrottleTagGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && unthrottled,int loopDepth) 
	{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!throttleType.present() || throttleType.get() == TagThrottleType::MANUAL)
															#line 1364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			bool unthrottleExpected = false;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			bool empty = manuallyThrottledTags->empty();
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			for(auto itr = manuallyThrottledTags->begin();itr != manuallyThrottledTags->end();) {
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (!priority.present() || priority.get() == itr->first.second)
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (itr->second.expirationTime > now())
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						unthrottleExpected = true;
															#line 1382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					}
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					itr = manuallyThrottledTags->erase(itr);
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
				else
				{
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					++itr;
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				}
			}
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (throttleType.present())
															#line 1397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT((unthrottled && !empty) || (!unthrottled && !unthrottleExpected));
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
			else
			{
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				ASSERT(unthrottled || !unthrottleExpected);
															#line 1407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			}
		}
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<UnthrottleTagGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnthrottleTagGroupActorState(); static_cast<UnthrottleTagGroupActor*>(this)->destroy(); return 0; }
															#line 1412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<UnthrottleTagGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnthrottleTagGroupActorState();
		static_cast<UnthrottleTagGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& unthrottled,int loopDepth) 
	{
		loopDepth = a_body1cont1(unthrottled, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && unthrottled,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(unthrottled), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnthrottleTagGroupActor*>(this)->actor_wait_state > 0) static_cast<UnthrottleTagGroupActor*>(this)->actor_wait_state = 0;
		static_cast<UnthrottleTagGroupActor*>(this)->ActorCallback< UnthrottleTagGroupActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< UnthrottleTagGroupActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnthrottleTagGroupActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnthrottleTagGroupActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* manuallyThrottledTags;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Optional<TagThrottleType> throttleType;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Optional<TransactionPriority> priority;
															#line 1503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via unthrottleTagGroup()
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class UnthrottleTagGroupActor final : public Actor<Void>, public ActorCallback< UnthrottleTagGroupActor, 0, bool >, public FastAllocated<UnthrottleTagGroupActor>, public UnthrottleTagGroupActorState<UnthrottleTagGroupActor> {
															#line 1508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<UnthrottleTagGroupActor>::operator new;
	using FastAllocated<UnthrottleTagGroupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2871425614583483904UL, 15240346721837252352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnthrottleTagGroupActor, 0, bool >;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	UnthrottleTagGroupActor(Database const& cx,std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags) 
															#line 1525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UnthrottleTagGroupActorState<UnthrottleTagGroupActor>(cx, manuallyThrottledTags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13652351819250456832UL, 14478248668145699072UL);
		ActorExecutionContextHelper __helper(static_cast<UnthrottleTagGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unthrottleTagGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unthrottleTagGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnthrottleTagGroupActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> unthrottleTagGroup( Database const& cx, std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo>* const& manuallyThrottledTags ) {
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new UnthrottleTagGroupActor(cx, manuallyThrottledTags));
															#line 1557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 1562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via enableAutoThrottling()
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class EnableAutoThrottlingActor>
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class EnableAutoThrottlingActorState {
															#line 1568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	EnableAutoThrottlingActorState(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : self(self),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   cx(cx),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   db(cx.getReference())
															#line 1579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("enableAutoThrottling", reinterpret_cast<unsigned long>(this));

	}
	~EnableAutoThrottlingActorState() 
	{
		fdb_probe_actor_destroy("enableAutoThrottling", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 1594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ThrottleApi::enableAuto(db, true);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 1;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EnableAutoThrottlingActor, 0, Void >*>(static_cast<EnableAutoThrottlingActor*>(this)));
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				StrictFuture<Void> __when_expr_2 = ThrottleApi::enableAuto(db, false);
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
				static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 3;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EnableAutoThrottlingActor, 2, Void >*>(static_cast<EnableAutoThrottlingActor*>(this)));
															#line 1619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EnableAutoThrottlingActorState();
		static_cast<EnableAutoThrottlingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (!static_cast<EnableAutoThrottlingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EnableAutoThrottlingActorState(); static_cast<EnableAutoThrottlingActor*>(this)->destroy(); return 0; }
															#line 1643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		new (&static_cast<EnableAutoThrottlingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EnableAutoThrottlingActorState();
		static_cast<EnableAutoThrottlingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		self->autoThrottleEnabled = true;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 1657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(ThrottleApi::unthrottleAll(db, TagThrottleType::AUTO, Optional<TransactionPriority>()));
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 2;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EnableAutoThrottlingActor, 1, Void >*>(static_cast<EnableAutoThrottlingActor*>(this)));
															#line 1668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		self->autoThrottleEnabled = true;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 1684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(ThrottleApi::unthrottleAll(db, TagThrottleType::AUTO, Optional<TransactionPriority>()));
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 2;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EnableAutoThrottlingActor, 1, Void >*>(static_cast<EnableAutoThrottlingActor*>(this)));
															#line 1695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state > 0) static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 0;
		static_cast<EnableAutoThrottlingActor*>(this)->ActorCallback< EnableAutoThrottlingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EnableAutoThrottlingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state > 0) static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 0;
		static_cast<EnableAutoThrottlingActor*>(this)->ActorCallback< EnableAutoThrottlingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EnableAutoThrottlingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		self->autoThrottleEnabled = false;
															#line 1877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		self->autoThrottleEnabled = false;
															#line 1886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state > 0) static_cast<EnableAutoThrottlingActor*>(this)->actor_wait_state = 0;
		static_cast<EnableAutoThrottlingActor*>(this)->ActorCallback< EnableAutoThrottlingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EnableAutoThrottlingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EnableAutoThrottlingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TagThrottleApiWorkload* self;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Reference<DatabaseContext> db;
															#line 1972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via enableAutoThrottling()
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class EnableAutoThrottlingActor final : public Actor<Void>, public ActorCallback< EnableAutoThrottlingActor, 0, Void >, public ActorCallback< EnableAutoThrottlingActor, 1, Void >, public ActorCallback< EnableAutoThrottlingActor, 2, Void >, public FastAllocated<EnableAutoThrottlingActor>, public EnableAutoThrottlingActorState<EnableAutoThrottlingActor> {
															#line 1977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<EnableAutoThrottlingActor>::operator new;
	using FastAllocated<EnableAutoThrottlingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13993594216387020032UL, 6381453386159458560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EnableAutoThrottlingActor, 0, Void >;
friend struct ActorCallback< EnableAutoThrottlingActor, 1, Void >;
friend struct ActorCallback< EnableAutoThrottlingActor, 2, Void >;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	EnableAutoThrottlingActor(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   EnableAutoThrottlingActorState<EnableAutoThrottlingActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("enableAutoThrottling", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7446178621870287104UL, 11214114216238356480UL);
		ActorExecutionContextHelper __helper(static_cast<EnableAutoThrottlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("enableAutoThrottling");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("enableAutoThrottling", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EnableAutoThrottlingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EnableAutoThrottlingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EnableAutoThrottlingActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> enableAutoThrottling( TagThrottleApiWorkload* const& self, Database const& cx ) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new EnableAutoThrottlingActor(self, cx));
															#line 2030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"

																#line 2035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
// This generated class is to be used only via runThrottleApi()
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
template <class RunThrottleApiActor>
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class RunThrottleApiActorState {
															#line 2041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	RunThrottleApiActorState(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		 : self(self),
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   cx(cx),
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		   manuallyThrottledTags()
															#line 2052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runThrottleApi", reinterpret_cast<unsigned long>(this));

	}
	~RunThrottleApiActorState() 
	{
		fdb_probe_actor_destroy("runThrottleApi", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			;
															#line 2067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunThrottleApiActorState();
		static_cast<RunThrottleApiActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		double delayTime = deterministicRandom()->random01() * 5;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(delayTime);
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 1;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 0, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		action = deterministicRandom()->randomInt(0, 6);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (action == 0)
															#line 2117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->throttleTag(cx, &manuallyThrottledTags);
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 2;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 1, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (action == 1)
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->unthrottleTag(cx, &manuallyThrottledTags);
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 3;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 2, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (action == 2)
															#line 2153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					StrictFuture<Void> __when_expr_3 = self->getTags(self, cx, &manuallyThrottledTags);
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
					static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 4;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 3, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (action == 3)
															#line 2171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						StrictFuture<Void> __when_expr_4 = self->unthrottleTagGroup(cx, &manuallyThrottledTags);
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
						static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 5;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 4, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						if (action == 4)
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							StrictFuture<Void> __when_expr_5 = self->enableAutoThrottling(self, cx);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when5(__when_expr_5.get(), loopDepth); };
							static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 6;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 5, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							if (action == 5)
															#line 2207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								StrictFuture<Void> __when_expr_6 = self->getRecommendedTags(self, cx);
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
								if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when6(__when_expr_6.get(), loopDepth); };
								static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 7;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 6, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1loopBody1cont12(loopDepth);
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		action = deterministicRandom()->randomInt(0, 6);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
		if (action == 0)
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->throttleTag(cx, &manuallyThrottledTags);
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 2;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 1, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
			if (action == 1)
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
			{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->unthrottleTag(cx, &manuallyThrottledTags);
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 3;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 2, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
				if (action == 2)
															#line 2275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
				{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					StrictFuture<Void> __when_expr_3 = self->getTags(self, cx, &manuallyThrottledTags);
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
					static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 4;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 3, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
					if (action == 3)
															#line 2293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
					{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						StrictFuture<Void> __when_expr_4 = self->unthrottleTagGroup(cx, &manuallyThrottledTags);
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
						static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 5;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 4, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
						if (action == 4)
															#line 2311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
						{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							StrictFuture<Void> __when_expr_5 = self->enableAutoThrottling(self, cx);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when5(__when_expr_5.get(), loopDepth); };
							static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 6;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 5, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
							if (action == 5)
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
							{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								StrictFuture<Void> __when_expr_6 = self->getRecommendedTags(self, cx);
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
								if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when6(__when_expr_6.get(), loopDepth); };
								static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 7;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
								__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunThrottleApiActor, 6, Void >*>(static_cast<RunThrottleApiActor*>(this)));
															#line 2340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1loopBody1cont12(loopDepth);
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunThrottleApiActor*>(this)->actor_wait_state > 0) static_cast<RunThrottleApiActor*>(this)->actor_wait_state = 0;
		static_cast<RunThrottleApiActor*>(this)->ActorCallback< RunThrottleApiActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunThrottleApiActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunThrottleApiActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	TagThrottleApiWorkload* self;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	Database cx;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	std::map<std::pair<TransactionTag, TransactionPriority>, TagThrottleInfo> manuallyThrottledTags;
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	int action;
															#line 2996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runThrottleApi()
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
class RunThrottleApiActor final : public Actor<Void>, public ActorCallback< RunThrottleApiActor, 0, Void >, public ActorCallback< RunThrottleApiActor, 1, Void >, public ActorCallback< RunThrottleApiActor, 2, Void >, public ActorCallback< RunThrottleApiActor, 3, Void >, public ActorCallback< RunThrottleApiActor, 4, Void >, public ActorCallback< RunThrottleApiActor, 5, Void >, public ActorCallback< RunThrottleApiActor, 6, Void >, public FastAllocated<RunThrottleApiActor>, public RunThrottleApiActorState<RunThrottleApiActor> {
															#line 3001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunThrottleApiActor>::operator new;
	using FastAllocated<RunThrottleApiActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1045534116509024000UL, 10093396442252359680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunThrottleApiActor, 0, Void >;
friend struct ActorCallback< RunThrottleApiActor, 1, Void >;
friend struct ActorCallback< RunThrottleApiActor, 2, Void >;
friend struct ActorCallback< RunThrottleApiActor, 3, Void >;
friend struct ActorCallback< RunThrottleApiActor, 4, Void >;
friend struct ActorCallback< RunThrottleApiActor, 5, Void >;
friend struct ActorCallback< RunThrottleApiActor, 6, Void >;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	RunThrottleApiActor(TagThrottleApiWorkload* const& self,Database const& cx) 
															#line 3024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunThrottleApiActorState<RunThrottleApiActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runThrottleApi", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871943558192610816UL, 4006290416853475584UL);
		ActorExecutionContextHelper __helper(static_cast<RunThrottleApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runThrottleApi");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runThrottleApi", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunThrottleApiActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunThrottleApiActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunThrottleApiActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunThrottleApiActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunThrottleApiActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunThrottleApiActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunThrottleApiActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
[[nodiscard]] Future<Void> runThrottleApi( TagThrottleApiWorkload* const& self, Database const& cx ) {
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
	return Future<Void>(new RunThrottleApiActor(self, cx));
															#line 3062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TagThrottleApi.actor.g.cpp.py_gen"
}

#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/TagThrottleApi.actor.cpp"
};

WorkloadFactory<TagThrottleApiWorkload> TagThrottleApiWorkloadFactory;
